/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.samples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import org.jets3t.samples.SamplesUtils;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;

public class UrlSigningExample {
    private static final String myBucketName = "test";

    public static void main(String[] args) throws Exception {
        RestS3Service signedUrlHandler = new RestS3Service(null);
        S3Bucket bucket = new S3Bucket(myBucketName);
        S3Object object = new S3Object(bucket, "urlSigningTestObject.txt", "Hello World!");
        Calendar cal = Calendar.getInstance();
        cal.add(12, 5);
        Date expiryDate = cal.getTime();
        AWSCredentials awsCredentials = SamplesUtils.loadAWSCredentials();
        RestS3Service s3Service = new RestS3Service(awsCredentials);
        String unsignedGetUrl = s3Service.createUnsignedObjectUrl(bucket.getName(), object.getKey(), false, false, false);
        String putUrl = s3Service.createSignedPutUrl(bucket.getName(), object.getKey(), object.getMetadataMap(), expiryDate, false);
        String getUrl = s3Service.createSignedGetUrl(bucket.getName(), object.getKey(), expiryDate, false);
        String headUrl = s3Service.createSignedHeadUrl(bucket.getName(), object.getKey(), expiryDate, false);
        String deleteUrl = s3Service.createSignedDeleteUrl(bucket.getName(), object.getKey(), expiryDate, false);
        System.out.println("Unsigned URL: " + unsignedGetUrl);
        System.out.println("Signed PUT URL: " + putUrl);
        System.out.println("Signed GET URL: " + getUrl);
        System.out.println("Signed HEAD URL: " + headUrl);
        System.out.println("Signed DELETE URL: " + deleteUrl);
        System.out.println("Performing PUT with signed URL");
        S3Object putObject = signedUrlHandler.putObjectWithSignedUrl(putUrl, object);
        System.out.println("  Object has been uploaded to S3: " + putObject.getKey());
        System.out.println("Performing HEAD with signed URL");
        S3Object headObject = signedUrlHandler.getObjectDetailsWithSignedUrl(headUrl);
        System.out.println("  Size of object in S3: " + headObject.getContentLength());
        System.out.println("Performing GET with signed URL");
        S3Object getObject = signedUrlHandler.getObjectWithSignedUrl(getUrl);
        String contentData = new BufferedReader(new InputStreamReader(getObject.getDataInputStream())).readLine();
        System.out.println("  Content of object in S3: " + contentData);
        System.out.println("Performing DELETE with signed URL");
        signedUrlHandler.deleteObjectWithSignedUrl(deleteUrl);
        System.out.println("  Object deleted - the example is finished");
    }
}

