/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import com.joyent.manta.util.MantaUtils;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class MantaAccountHomeInfo {
    public static final String HOME_PATH_PRIVATE = "stor";
    public static final String HOME_PATH_PUBLIC = "public";
    private final String accountOwner;
    private final Path accountRoot;
    private final Path normalizedHomePath;
    private final Path accountPublicRoot;
    private final Path accountPrivateRoot;

    public MantaAccountHomeInfo(String username, String defaultPath) {
        String[] accountPathParts = MantaUtils.parseAccount((String)username);
        this.accountRoot = new Path(accountPathParts[0], EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder));
        this.accountOwner = this.accountRoot.getName();
        this.normalizedHomePath = this.buildNormalizedHomePath(defaultPath);
        this.accountPublicRoot = new Path(this.accountRoot, HOME_PATH_PUBLIC, EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
        this.accountPrivateRoot = new Path(this.accountRoot, HOME_PATH_PRIVATE, EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
    }

    private Path buildNormalizedHomePath(String rawHomePath) {
        String accountRootRegex;
        String defaultPath = (String)StringUtils.defaultIfBlank((CharSequence)rawHomePath, (CharSequence)"~");
        String subdirectoryRawPath = defaultPath.replaceFirst(accountRootRegex = String.format("^/?(%s|~~?)/?", this.accountRoot.getAbsolute()), "");
        if (StringUtils.isEmpty((CharSequence)subdirectoryRawPath)) {
            return this.accountRoot;
        }
        String[] subdirectoryPathSegments = StringUtils.split((String)subdirectoryRawPath, (char)'/');
        Path homePath = this.accountRoot;
        for (String pathSegment : subdirectoryPathSegments) {
            EnumSet<AbstractPath.Type> types = EnumSet.of(AbstractPath.Type.directory);
            if (homePath.getParent().equals((Object)this.accountRoot) && StringUtils.equalsAny((CharSequence)pathSegment, (CharSequence[])new CharSequence[]{HOME_PATH_PRIVATE, HOME_PATH_PUBLIC})) {
                types.add(AbstractPath.Type.volume);
            }
            homePath = new Path(homePath, pathSegment, types);
        }
        return homePath;
    }

    public String getAccountOwner() {
        return this.accountOwner;
    }

    public Path getAccountRoot() {
        return this.accountRoot;
    }

    public Path getNormalizedHomePath() {
        return this.normalizedHomePath;
    }

    public Path getAccountPublicRoot() {
        return this.accountPublicRoot;
    }

    public Path getAccountPrivateRoot() {
        return this.accountPrivateRoot;
    }
}

