/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="A file metadata object")
public class FileMetadata {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="fileName")
    private String fileName = null;
    @JsonProperty(value="parentId")
    private String parentId = null;
    @JsonProperty(value="fileSize")
    private Long fileSize = null;
    @JsonProperty(value="modified")
    private DateTime modified = null;
    @JsonProperty(value="created")
    private DateTime created = null;
    @JsonProperty(value="accessed")
    private DateTime accessed = null;
    @JsonProperty(value="attributes")
    private Integer attributes = null;
    @JsonProperty(value="flags")
    private Integer flags = null;
    @JsonProperty(value="lockId")
    private String lockId = null;

    public FileMetadata id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The file id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FileMetadata fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(value="The file name")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public FileMetadata parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(value="The file's parent folder id")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public FileMetadata fileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    @ApiModelProperty(value="The size")
    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public FileMetadata modified(DateTime modified) {
        this.modified = modified;
        return this;
    }

    @ApiModelProperty(value="The file's modified datetime in UTC")
    public DateTime getModified() {
        return this.modified;
    }

    public void setModified(DateTime modified) {
        this.modified = modified;
    }

    public FileMetadata created(DateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="The file's created datetime in UTC")
    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public FileMetadata accessed(DateTime accessed) {
        this.accessed = accessed;
        return this;
    }

    @ApiModelProperty(value="The file's last access datetime in UTC")
    public DateTime getAccessed() {
        return this.accessed;
    }

    public void setAccessed(DateTime accessed) {
        this.accessed = accessed;
    }

    public FileMetadata attributes(Integer attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(value="The file atributes")
    public Integer getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Integer attributes) {
        this.attributes = attributes;
    }

    public FileMetadata flags(Integer flags) {
        this.flags = flags;
        return this;
    }

    @ApiModelProperty(value="The file Flags (0 = None, 1 = Folder, 2 = Shared, 4 = Locked, 8 = Image, 16 = Streamable, 32 = Video, 64 = Doc, 128 = StreamableDoc, 256 = HasThumbnail, 512 = Hidden, 1024 = Favorite)")
    public Integer getFlags() {
        return this.flags;
    }

    public void setFlags(Integer flags) {
        this.flags = flags;
    }

    public FileMetadata lockId(String lockId) {
        this.lockId = lockId;
        return this;
    }

    @ApiModelProperty(value="Not used any more")
    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMetadata fileMetadata = (FileMetadata)o;
        return Objects.equals(this.id, fileMetadata.id) && Objects.equals(this.fileName, fileMetadata.fileName) && Objects.equals(this.parentId, fileMetadata.parentId) && Objects.equals(this.fileSize, fileMetadata.fileSize) && Objects.equals(this.modified, fileMetadata.modified) && Objects.equals(this.created, fileMetadata.created) && Objects.equals(this.accessed, fileMetadata.accessed) && Objects.equals(this.attributes, fileMetadata.attributes) && Objects.equals(this.flags, fileMetadata.flags) && Objects.equals(this.lockId, fileMetadata.lockId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fileName, this.parentId, this.fileSize, this.modified, this.created, this.accessed, this.attributes, this.flags, this.lockId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileMetadata {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    fileSize: ").append(this.toIndentedString(this.fileSize)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    accessed: ").append(this.toIndentedString(this.accessed)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    lockId: ").append(this.toIndentedString(this.lockId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

