/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Request model for updating a customer")
public class UpdateCustomerRequest {
    @JsonProperty(value="companyName")
    private String companyName = null;
    @JsonProperty(value="customerContractType")
    private CustomerContractTypeEnum customerContractType = null;
    @JsonProperty(value="quotaMax")
    private Long quotaMax = null;
    @JsonProperty(value="userMax")
    private Integer userMax = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = false;
    @JsonProperty(value="providerCustomerId")
    private String providerCustomerId = null;
    @JsonProperty(value="webhooksMax")
    private Long webhooksMax = null;
    @JsonProperty(value="lockStatus")
    private Boolean lockStatus = false;

    public UpdateCustomerRequest companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Schema(description="Company name")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public UpdateCustomerRequest customerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
        return this;
    }

    @Schema(required=true, description="Customer type")
    public CustomerContractTypeEnum getCustomerContractType() {
        return this.customerContractType;
    }

    public void setCustomerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
    }

    public UpdateCustomerRequest quotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
        return this;
    }

    @Schema(description="Maximal disc space which can be allocated by customer in bytes. -1 for unlimited")
    public Long getQuotaMax() {
        return this.quotaMax;
    }

    public void setQuotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
    }

    public UpdateCustomerRequest userMax(Integer userMax) {
        this.userMax = userMax;
        return this;
    }

    @Schema(description="Maximal number of users")
    public Integer getUserMax() {
        return this.userMax;
    }

    public void setUserMax(Integer userMax) {
        this.userMax = userMax;
    }

    public UpdateCustomerRequest isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @Schema(description="Customer is locked:  * `false` - unlocked  * `true` - locked    All users of this customer will be blocked and can not login anymore.")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UpdateCustomerRequest providerCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
        return this;
    }

    @Schema(description="Provider customer ID")
    public String getProviderCustomerId() {
        return this.providerCustomerId;
    }

    public void setProviderCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
    }

    public UpdateCustomerRequest webhooksMax(Long webhooksMax) {
        this.webhooksMax = webhooksMax;
        return this;
    }

    @Schema(description="&#128640; Since v4.19.0  Maximal number of webhooks")
    public Long getWebhooksMax() {
        return this.webhooksMax;
    }

    public void setWebhooksMax(Long webhooksMax) {
        this.webhooksMax = webhooksMax;
    }

    public UpdateCustomerRequest lockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.7.0  Customer lock status:  * `false` - unlocked  * `true` - locked    Please use `isLocked` instead.  All users of this customer will be blocked and can not login anymore.")
    public Boolean isLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCustomerRequest updateCustomerRequest = (UpdateCustomerRequest)o;
        return Objects.equals(this.companyName, updateCustomerRequest.companyName) && Objects.equals((Object)this.customerContractType, (Object)updateCustomerRequest.customerContractType) && Objects.equals(this.quotaMax, updateCustomerRequest.quotaMax) && Objects.equals(this.userMax, updateCustomerRequest.userMax) && Objects.equals(this.isLocked, updateCustomerRequest.isLocked) && Objects.equals(this.providerCustomerId, updateCustomerRequest.providerCustomerId) && Objects.equals(this.webhooksMax, updateCustomerRequest.webhooksMax) && Objects.equals(this.lockStatus, updateCustomerRequest.lockStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.companyName, this.customerContractType, this.quotaMax, this.userMax, this.isLocked, this.providerCustomerId, this.webhooksMax, this.lockStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateCustomerRequest {\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    customerContractType: ").append(this.toIndentedString((Object)this.customerContractType)).append("\n");
        sb.append("    quotaMax: ").append(this.toIndentedString(this.quotaMax)).append("\n");
        sb.append("    userMax: ").append(this.toIndentedString(this.userMax)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    providerCustomerId: ").append(this.toIndentedString(this.providerCustomerId)).append("\n");
        sb.append("    webhooksMax: ").append(this.toIndentedString(this.webhooksMax)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomerContractTypeEnum {
        DEMO("demo"),
        FREE("free"),
        PAY("pay");

        private String value;

        private CustomerContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomerContractTypeEnum fromValue(String text) {
            for (CustomerContractTypeEnum b : CustomerContractTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

