/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonObject;
import java.time.OffsetDateTime;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.types.Facet;

public class DriveItemVersion
extends Facet<DriveItemVersion> {
    private String id;
    private OneDriveIdentitySet lastModifiedBy;
    private OffsetDateTime lastModifiedDateTime;
    private Long size;
    private String contentUrl;

    public String getId() {
        return this.id;
    }

    public OneDriveIdentitySet getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public Long getSize() {
        return this.size;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    @Override
    protected void parseMember(JsonObject.Member member) {
        switch (member.getName()) {
            case "id": {
                this.id = member.getValue().asString();
                break;
            }
            case "lastModifiedBy": {
                this.lastModifiedBy = new OneDriveIdentitySet(member.getValue().asObject());
                break;
            }
            case "lastModifiedDateTime": {
                this.lastModifiedDateTime = OffsetDateTime.parse(member.getValue().asString());
                break;
            }
            case "size": {
                this.size = member.getValue().asLong();
                break;
            }
            case "@microsoft.graph.downloadUrl": {
                this.contentUrl = member.getValue().asString();
                break;
            }
            default: {
                super.parseMember(member);
            }
        }
    }
}

