/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.Site;

public final class Sites {
    public static Iterator<Site.Metadata> getSites(Site site) {
        return new SitesIterator(site.getApi(), Sites.createSitesUrl(site));
    }

    public static Iterator<Site.Metadata> getSites(OneDriveAPI api) {
        return new SitesIterator(api, Sites.createSitesUrl(api, ""));
    }

    public static Iterator<Site.Metadata> getSites(OneDriveAPI api, String search) {
        QueryStringBuilder qs = new QueryStringBuilder();
        qs.set("search", search);
        return new SitesIterator(api, Sites.createSitesUrl(api, qs, ""));
    }

    private static URL createSitesUrl(Site site) {
        return new URLTemplate(site.getAction("/sites")).build(site.getApi().getBaseURL());
    }

    private static URL createSitesUrl(OneDriveAPI api, String basePath) {
        return new URLTemplate(Sites.createSitesPath(basePath)).build(api.getBaseURL());
    }

    private static URL createSitesUrl(OneDriveAPI api, QueryStringBuilder qs, String basePath) {
        return new URLTemplate(Sites.createSitesPath(basePath)).build(api.getBaseURL(), qs, new Object[0]);
    }

    private static String createSitesPath(String basePath) {
        return basePath + "/sites";
    }

    private static class SitesIterator
    implements Iterator<Site.Metadata> {
        private final OneDriveAPI api;
        private final JsonObjectIterator iterator;

        public SitesIterator(OneDriveAPI api, URL url) {
            this.api = api;
            this.iterator = new JsonObjectIterator(api, url);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Site.Metadata next() {
            JsonObject jsonObject = this.iterator.next();
            String id = jsonObject.get("id").asString();
            return (Site.Metadata)Site.byId(this.api, id).new Site.Metadata().fromJson(jsonObject);
        }
    }
}

