/*
 * Decompiled with CFR 0.152.
 */
package io.mikael.urlbuilder.util;

import java.util.Arrays;

final class Rfc3986Util {
    private static final char[] SUB_DELIMITERS = new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='};

    Rfc3986Util() {
    }

    static boolean isFragmentSafe(char c) {
        return Rfc3986Util.isPChar(c) || c == '/' || c == '?';
    }

    static boolean isPChar(char c) {
        return Rfc3986Util.isUnreserved(c) || Rfc3986Util.isSubDelimeter(c) || c == ':' || c == '@';
    }

    static boolean isUnreserved(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
    }

    private static boolean isSubDelimeter(char c) {
        return Arrays.binarySearch(SUB_DELIMITERS, c) >= 0;
    }

    static {
        Arrays.sort(SUB_DELIMITERS);
    }
}

