/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import java.util.UUID;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.qm.meta.Include;

public class QMMProjectInfo {
    @Include
    private final String id;
    private final String name;
    private final String path;
    private final boolean isAnonymous;
    private final UUID uuid;

    public QMMProjectInfo(DBPProject project) {
        this.id = project.getId();
        this.name = project.getName();
        this.uuid = project.getProjectID();
        this.path = project.getAbsolutePath().toString();
        SMSession projectSession = project.getSessionContext().findSpaceSession(project);
        this.isAnonymous = projectSession == null || projectSession.getSessionPrincipal() == null;
    }

    private QMMProjectInfo(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.uuid = UUID.randomUUID();
        this.path = builder.path;
        this.isAnonymous = builder.isAnonymous;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String path;
        private boolean isAnonymous;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setAnonymous(boolean anonymous) {
            this.isAnonymous = anonymous;
            return this;
        }

        public QMMProjectInfo build() {
            return new QMMProjectInfo(this);
        }
    }
}

