/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.translate;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;

final class SQLTranslateContext {
    @NotNull
    private final SQLDialect sourceDialect;
    @NotNull
    private final SQLDialect targetDialect;
    @NotNull
    private final DBPPreferenceStore preferenceStore;
    @NotNull
    private final SQLSyntaxManager syntaxManager;

    public SQLTranslateContext(@NotNull SQLDialect sourceDialect, @NotNull SQLDialect targetDialect, @NotNull DBPPreferenceStore preferenceStore) {
        this.sourceDialect = sourceDialect;
        this.targetDialect = targetDialect;
        this.preferenceStore = preferenceStore;
        this.syntaxManager = new SQLSyntaxManager();
        this.syntaxManager.init(targetDialect, preferenceStore);
    }

    @NotNull
    public SQLDialect getSourceDialect() {
        return this.sourceDialect;
    }

    @NotNull
    public SQLDialect getTargetDialect() {
        return this.targetDialect;
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    @NotNull
    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }
}

