/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import org.eclipse.e4.core.di.IBinding;
import org.eclipse.e4.core.di.IInjector;

public class Binding
implements IBinding {
    private final Class<?> clazz;
    private final IInjector injector;
    private Class<?> implementationClazz;
    private String qualifierName;

    public Binding(Class<?> clazz, IInjector injector) {
        this.clazz = clazz;
        this.injector = injector;
    }

    private Binding(Binding source) {
        this.clazz = source.clazz;
        this.injector = source.injector;
        this.implementationClazz = source.implementationClazz;
        this.qualifierName = source.qualifierName;
    }

    @Override
    public IBinding named(String name) {
        Binding binding = new Binding(this);
        binding.qualifierName = name;
        this.injector.addBinding(binding);
        return binding;
    }

    @Override
    public IBinding implementedBy(Class<?> implClazz) {
        Binding binding = new Binding(this);
        binding.implementationClazz = implClazz;
        this.injector.addBinding(binding);
        return binding;
    }

    public Class<?> getDescribedClass() {
        return this.clazz;
    }

    public String getQualifierName() {
        return this.qualifierName;
    }

    public Class<?> getImplementationClass() {
        if (this.implementationClazz != null) {
            return this.implementationClazz;
        }
        return this.clazz;
    }
}

