/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.parts.TreeViewerTransfer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

class TreeViewerTransferDropListener
extends AbstractTransferDropTargetListener {
    public TreeViewerTransferDropListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TreeViewerTransfer.getInstance());
        this.setEnablementDeterminedByCommand(true);
    }

    @Override
    protected Request createTargetRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest("move");
        request.setEditParts(TreeViewerTransferDropListener.getTransferedEditParts());
        return request;
    }

    @Override
    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        ChangeBoundsRequest request = this.getTargetRequest();
        request.setType(this.isMove() ? "move" : "orphan");
        TreeViewerTransferDropListener.getTransferedEditParts().stream().forEach(ep -> command.add(ep.getCommand(request)));
        if (!this.isMove()) {
            request.setType("add children");
            if (this.getTargetEditPart() == null) {
                command.add(UnexecutableCommand.INSTANCE);
            } else {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
            }
        }
        return command;
    }

    protected String getCommandName() {
        if (this.isMove()) {
            return "move";
        }
        return "add children";
    }

    @Override
    protected Collection<EditPart> getExclusionSet() {
        List<? extends EditPart> selection = this.getViewer().getSelectedEditParts();
        ArrayList<EditPart> exclude = new ArrayList<EditPart>(selection);
        exclude.addAll(this.includeChildren(selection));
        return exclude;
    }

    private static List<? extends EditPart> getTransferedEditParts() {
        return (List)TreeViewerTransfer.getInstance().getObject();
    }

    @Override
    protected void handleDragOver() {
        if (TreeViewerTransfer.getInstance().getViewer() != this.getViewer()) {
            this.getCurrentEvent().detail = 0;
            return;
        }
        this.getCurrentEvent().feedback = 24;
        super.handleDragOver();
    }

    protected EditPart getSourceEditPart() {
        List<? extends EditPart> selection = TreeViewerTransferDropListener.getTransferedEditParts();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        return selection.get(0);
    }

    @Override
    protected ChangeBoundsRequest getTargetRequest() {
        return (ChangeBoundsRequest)super.getTargetRequest();
    }

    protected List<EditPart> includeChildren(List<? extends EditPart> list) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        for (EditPart editPart : list) {
            List<? extends EditPart> children = editPart.getChildren();
            result.addAll(children);
            result.addAll(this.includeChildren(children));
        }
        return result;
    }

    @Override
    public boolean isEnabled(DropTargetEvent event) {
        if (event.detail != 2) {
            return false;
        }
        return super.isEnabled(event);
    }

    protected boolean isMove() {
        EditPart source = this.getSourceEditPart();
        for (EditPart editPart : TreeViewerTransferDropListener.getTransferedEditParts()) {
            if (editPart.getParent() == source.getParent()) continue;
            return false;
        }
        return source.getParent() == this.getTargetEditPart();
    }

    @Override
    protected void updateTargetRequest() {
        ChangeBoundsRequest request = this.getTargetRequest();
        request.setLocation(this.getDropLocation());
        request.setType(this.getCommandName());
    }
}

