/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jkiss.dbeaver.Log;

public class SecurityProviderUtils {
    private static final Log log = Log.getLog(SecurityProviderUtils.class);
    private static String securityProvider = null;
    private static boolean registrationDone;

    public static void registerSecurityProvider() {
        if (!registrationDone) {
            try {
                if (securityProvider == null) {
                    SecurityProviderUtils.registerBouncyCastleSecurityProvider();
                    if (securityProvider == null) {
                        log.debug("BouncyCastle not registered, using the default JCE provider");
                    }
                }
            }
            finally {
                registrationDone = true;
            }
        }
    }

    private static boolean registerBouncyCastleSecurityProvider() {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            if (Security.getProvider(provider.getName()) == null) {
                Security.addProvider((Provider)provider);
            }
            if (securityProvider == null) {
                securityProvider = provider.getName();
                log.debug("BounceCastle bundle found. Use JCE provider " + provider.getName());
                return true;
            }
        }
        catch (Exception e) {
            log.warn("Registration of BC Security Provider unexpectedly failed", e);
        }
        return false;
    }
}

