/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.registry;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.gis.internal.GISViewerActivator;
import org.jkiss.dbeaver.ui.gis.registry.GeometryViewerDescriptor;
import org.jkiss.dbeaver.ui.gis.registry.LeafletTilesDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class GeometryViewerRegistry {
    private static final String GEOMETRY_REGISTRY_CONFIG_XML = "geometry_registry_config.xml";
    private static final Log log = Log.getLog(GeometryViewerRegistry.class);
    private static final String KEY_ROOT = "config";
    private static final String KEY_NON_VISIBLE_PREDEFINED_TILES = "notVisiblePredefinedTiles";
    private static final String KEY_USER_DEFINED_TILES = "userDefinedTiles";
    private static final String KEY_ID = "id";
    private static final String KEY_LABEL = "label";
    private static final String KEY_LAYERS_DEF = "layersDefinition";
    private static final String KEY_IS_VISIBLE = "isVisible";
    private static GeometryViewerRegistry instance;
    private final Map<String, GeometryViewerDescriptor> viewers = new HashMap<String, GeometryViewerDescriptor>();
    private final List<LeafletTilesDescriptor> predefinedTiles = new ArrayList<LeafletTilesDescriptor>();
    private final List<LeafletTilesDescriptor> userDefinedTiles = new ArrayList<LeafletTilesDescriptor>();
    private final Object tilesLock = new Object();
    @Nullable
    private LeafletTilesDescriptor defaultLeafletTiles;

    @NotNull
    public static synchronized GeometryViewerRegistry getInstance() {
        if (instance == null) {
            instance = new GeometryViewerRegistry(Platform.getExtensionRegistry());
            if (GeometryViewerRegistry.instance.defaultLeafletTiles == null) {
                instance.autoAssignDefaultLeafletTiles();
            }
        }
        return instance;
    }

    private GeometryViewerRegistry(@NotNull IExtensionRegistry registry) {
        try {
            IConfigurationElement ext;
            IConfigurationElement[] extElements;
            HashSet<String> notVisiblePredefinedTilesIds = new HashSet<String>();
            GeometryViewerRegistry.populateFromConfig(notVisiblePredefinedTilesIds, this.userDefinedTiles);
            IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.data.gis.geometryViewer");
            int n = extElements.length;
            int n2 = 0;
            while (n2 < n) {
                ext = iConfigurationElementArray[n2];
                GeometryViewerDescriptor type = new GeometryViewerDescriptor(ext);
                this.viewers.put(type.getId(), type);
                ++n2;
            }
            iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.data.gis.leaflet.tiles");
            n = extElements.length;
            n2 = 0;
            while (n2 < n) {
                ext = iConfigurationElementArray[n2];
                LeafletTilesDescriptor descriptor = LeafletTilesDescriptor.createPredefined(ext);
                if (notVisiblePredefinedTilesIds.contains(descriptor.getId())) {
                    descriptor = descriptor.withFlippedVisibility();
                }
                this.predefinedTiles.add(descriptor);
                ++n2;
            }
            String defTilesId = GISViewerActivator.getDefault().getPreferences().getString("gis.view.defaultLeafletTiles");
            if (!CommonUtils.isEmpty((String)defTilesId)) {
                this.defaultLeafletTiles = Stream.concat(this.predefinedTiles.stream(), this.userDefinedTiles.stream()).filter(tile -> tile.getId().equals(defTilesId)).findAny().orElse(null);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error initializing registry", e);
        }
    }

    private void autoAssignDefaultLeafletTiles() {
        Optional<LeafletTilesDescriptor> opt = Stream.concat(this.predefinedTiles.stream(), this.userDefinedTiles.stream()).filter(LeafletTilesDescriptor::isVisible).findFirst();
        this.setDefaultLeafletTilesNonSynchronized(opt.orElse(null));
    }

    private static void populateFromConfig(final @NotNull Collection<String> notVisiblePredefinedTilesIds, final @NotNull Collection<LeafletTilesDescriptor> userDefinedTiles) throws DBException {
        String content = DBWorkbench.getPlatform().getProductConfigurationController().loadConfigurationFile(GEOMETRY_REGISTRY_CONFIG_XML);
        if (CommonUtils.isEmpty((String)content)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringReader in = new StringReader(content);){
                SAXReader saxReader = new SAXReader((Reader)in);
                saxReader.parse((SAXListener)new SAXListener.BaseListener(){
                    private final StringBuilder buffer = new StringBuilder();
                    private String lastId;
                    private String lastLabel;
                    private String lastDefinition;
                    private String lastVisibility;

                    public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes attributes) {
                        this.buffer.setLength(0);
                        switch (localName) {
                            case "notVisiblePredefinedTiles": {
                                this.lastId = attributes.getValue(GeometryViewerRegistry.KEY_ID);
                                break;
                            }
                            case "userDefinedTiles": {
                                this.lastId = attributes.getValue(GeometryViewerRegistry.KEY_ID);
                                this.lastLabel = attributes.getValue(GeometryViewerRegistry.KEY_LABEL);
                                this.lastDefinition = attributes.getValue(GeometryViewerRegistry.KEY_LAYERS_DEF);
                                this.lastVisibility = attributes.getValue(GeometryViewerRegistry.KEY_IS_VISIBLE);
                                break;
                            }
                        }
                    }

                    public void saxEndElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName) {
                        switch (localName) {
                            case "notVisiblePredefinedTiles": {
                                if (!CommonUtils.isNotEmpty((String)this.lastId)) break;
                                notVisiblePredefinedTilesIds.add(this.lastId.trim());
                                break;
                            }
                            case "userDefinedTiles": {
                                String layersDefinitionText = this.getDefinitionText();
                                if (CommonUtils.isEmpty((String)this.lastId) || CommonUtils.isEmpty((String)this.lastLabel) || CommonUtils.isEmpty((String)layersDefinitionText)) {
                                    log.debug((Object)"Malformed user-defined tiles descriptor, skipping");
                                    return;
                                }
                                userDefinedTiles.add(LeafletTilesDescriptor.createUserDefined(this.lastLabel.trim(), layersDefinitionText, CommonUtils.getBoolean((String)this.lastVisibility, (boolean)true)));
                                break;
                            }
                        }
                    }

                    public void saxText(@NotNull SAXReader reader, @NotNull String data) {
                        this.buffer.append(data);
                    }

                    @Nullable
                    private String getDefinitionText() {
                        if (this.lastDefinition != null) {
                            return this.lastDefinition;
                        }
                        if (this.buffer.length() > 0) {
                            return this.buffer.toString();
                        }
                        return null;
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLException e) {
            log.error((Object)("Error reading " + GeometryViewerRegistry.class.getName() + " configuration"), e);
        }
    }

    public List<GeometryViewerDescriptor> getSupportedViewers(@NotNull DBPDataSource dataSource) {
        return this.viewers.values().stream().filter(v -> v.supportedBy(dataSource)).collect(Collectors.toList());
    }

    @Nullable
    public GeometryViewerDescriptor getViewer(@Nullable String id) {
        return this.viewers.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LeafletTilesDescriptor> getPredefinedLeafletTiles() {
        Object object = this.tilesLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.predefinedTiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LeafletTilesDescriptor> getUserDefinedLeafletTiles() {
        Object object = this.tilesLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.userDefinedTiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LeafletTilesDescriptor getDefaultLeafletTiles() {
        Object object = this.tilesLock;
        synchronized (object) {
            return this.defaultLeafletTiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultLeafletTiles(@Nullable LeafletTilesDescriptor defaultLeafletTiles) {
        Object object = this.tilesLock;
        synchronized (object) {
            this.setDefaultLeafletTilesNonSynchronized(defaultLeafletTiles);
        }
    }

    private void setDefaultLeafletTilesNonSynchronized(@Nullable LeafletTilesDescriptor defaultLeafletTiles) {
        try {
            this.defaultLeafletTiles = defaultLeafletTiles;
            String preference = defaultLeafletTiles == null ? "" : defaultLeafletTiles.getId();
            GISViewerActivator.getDefault().getPreferences().setValue("gis.view.defaultLeafletTiles", preference);
            GISViewerActivator.getDefault().getPreferences().save();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTiles(@NotNull Collection<LeafletTilesDescriptor> predefinedDescriptors, @NotNull Collection<LeafletTilesDescriptor> userDefinedDescriptors) {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
            log.warn((Object)"The user has no permission to save geometry tiles configuration");
            return;
        }
        Object object = this.tilesLock;
        synchronized (object) {
            this.predefinedTiles.clear();
            this.predefinedTiles.addAll(predefinedDescriptors);
            this.userDefinedTiles.clear();
            this.userDefinedTiles.addAll(userDefinedDescriptors);
            if (this.defaultLeafletTiles == null || !this.predefinedTiles.contains((Object)this.defaultLeafletTiles) && !this.userDefinedTiles.contains((Object)this.defaultLeafletTiles)) {
                this.autoAssignDefaultLeafletTiles();
            }
            this.flushConfig();
        }
    }

    private void flushConfig() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (StringWriter out = new StringWriter();){
                XMLBuilder xmlBuilder = new XMLBuilder((Writer)out, GeneralUtils.UTF8_ENCODING);
                xmlBuilder.setBeautify(true);
                Throwable throwable2 = null;
                Object var6_9 = null;
                try (XMLBuilder.Element ignored = xmlBuilder.startElement(KEY_ROOT);){
                    XMLBuilder.Element ignored2;
                    Object var14_24;
                    Throwable throwable3;
                    XMLBuilder.Element ignored1;
                    Throwable throwable4 = null;
                    Object var9_15 = null;
                    try {
                        ignored1 = xmlBuilder.startElement("userDefinedTilesDefinitions");
                        try {
                            for (LeafletTilesDescriptor descriptor : this.userDefinedTiles) {
                                throwable3 = null;
                                var14_24 = null;
                                try {
                                    ignored2 = xmlBuilder.startElement(KEY_USER_DEFINED_TILES);
                                    try {
                                        xmlBuilder.addAttribute(KEY_ID, descriptor.getId());
                                        xmlBuilder.addAttribute(KEY_LABEL, descriptor.getLabel());
                                        xmlBuilder.addAttribute(KEY_IS_VISIBLE, descriptor.isVisible());
                                        xmlBuilder.addTextData(descriptor.getLayersDefinition());
                                    }
                                    finally {
                                        if (ignored2 != null) {
                                            ignored2.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable5;
                                    } else if (throwable3 != throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    throw throwable3;
                                }
                            }
                        }
                        finally {
                            if (ignored1 != null) {
                                ignored1.close();
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable4 == null) {
                            throwable4 = throwable6;
                        } else if (throwable4 != throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        throw throwable4;
                    }
                    throwable4 = null;
                    var9_15 = null;
                    try {
                        ignored1 = xmlBuilder.startElement("notVisiblePredefinedTilesList");
                        try {
                            for (LeafletTilesDescriptor descriptor : this.predefinedTiles) {
                                if (descriptor.isVisible()) continue;
                                throwable3 = null;
                                var14_24 = null;
                                try {
                                    ignored2 = xmlBuilder.startElement(KEY_NON_VISIBLE_PREDEFINED_TILES);
                                    try {
                                        xmlBuilder.addAttribute(KEY_ID, descriptor.getId());
                                    }
                                    finally {
                                        if (ignored2 != null) {
                                            ignored2.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable7) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable7;
                                    } else if (throwable3 != throwable7) {
                                        throwable3.addSuppressed(throwable7);
                                    }
                                    throw throwable3;
                                }
                            }
                        }
                        finally {
                            if (ignored1 != null) {
                                ignored1.close();
                            }
                        }
                    }
                    catch (Throwable throwable8) {
                        if (throwable4 == null) {
                            throwable4 = throwable8;
                        } else if (throwable4 != throwable8) {
                            throwable4.addSuppressed(throwable8);
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable9) {
                    if (throwable2 == null) {
                        throwable2 = throwable9;
                    } else if (throwable2 != throwable9) {
                        throwable2.addSuppressed(throwable9);
                    }
                    throw throwable2;
                }
                xmlBuilder.flush();
                out.flush();
                DBWorkbench.getPlatform().getProductConfigurationController().saveConfigurationFile(GEOMETRY_REGISTRY_CONFIG_XML, out.getBuffer().toString());
            }
            catch (Throwable throwable10) {
                if (throwable == null) {
                    throwable = throwable10;
                } else if (throwable != throwable10) {
                    throwable.addSuppressed(throwable10);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            log.error((Object)("Error saving " + GeometryViewerRegistry.class.getName() + " configuration"));
        }
    }
}

