/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.util.List;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolBaseVacuumSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolWithStatus;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreToolBaseVacuum
extends PostgreToolWithStatus<DBSObject, PostgreToolBaseVacuumSettings> {
    public PostgreToolBaseVacuumSettings createToolSettings() {
        return new PostgreToolBaseVacuumSettings();
    }

    public void generateObjectQueries(DBCSession session, PostgreToolBaseVacuumSettings settings, List<DBEPersistAction> queries, DBSObject object) throws DBCException {
        Object sql = "VACUUM (";
        if (settings.isFull()) {
            sql = (String)sql + "FULL, ";
        }
        if (settings.isFreeze()) {
            sql = (String)sql + "FREEZE, ";
        }
        sql = (String)sql + "VERBOSE";
        if (settings.isAnalyzed()) {
            sql = (String)sql + ", ANALYZE";
        }
        if (settings.isDisableSkipping()) {
            sql = (String)sql + ", DISABLE_PAGE_SKIPPING";
        }
        if (settings.isSkipLocked()) {
            sql = (String)sql + ", SKIP_LOCKED";
        }
        if (settings.isIndexCleaning()) {
            sql = (String)sql + ", INDEX_CLEANUP";
        }
        if (settings.isTruncated()) {
            sql = (String)sql + ", TRUNCATE";
        }
        sql = (String)sql + ")";
        if (object instanceof PostgreTableBase) {
            PostgreTableBase postObject = (PostgreTableBase)object;
            sql = (String)sql + " " + postObject.getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        queries.add((DBEPersistAction)new SQLDatabasePersistAction((String)sql));
    }

    public boolean isRunInAutoCommit() {
        return true;
    }
}

