#!/usr/bin/env node
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 330:
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"name":"@bitwarden/cli","description":"A secure and free password manager for all of your devices.","version":"2025.9.0","keywords":["bitwarden","password","vault","password manager","cli"],"author":"Bitwarden Inc. <hello@bitwarden.com> (https://bitwarden.com)","homepage":"https://bitwarden.com","repository":{"type":"git","url":"https://github.com/bitwarden/clients"},"license":"SEE LICENSE IN LICENSE.txt","scripts":{"clean":"rimraf dist","build:oss":"webpack","build:oss:debug":"npm run build:oss && node --inspect ./build/bw.js","build:oss:watch":"webpack --watch","build:oss:prod":"cross-env NODE_ENV=production webpack","build:oss:prod:watch":"cross-env NODE_ENV=production webpack --watch","debug":"node --inspect ./build/bw.js","publish:npm":"npm run build:oss:prod && npm publish --access public","build:bit":"webpack -c ../../bitwarden_license/bit-cli/webpack.config.js","build:bit:debug":"npm run build:bit && node --inspect ./build/bw.js","build:bit:watch":"webpack --watch -c ../../bitwarden_license/bit-cli/webpack.config.js","build:bit:prod":"cross-env NODE_ENV=production npm run build:bit","build:bit:prod:watch":"cross-env NODE_ENV=production npm run build:bit:watch","dist:oss:win":"npm run build:oss:prod && npm run clean && npm run package:oss:win","dist:oss:mac":"npm run build:oss:prod && npm run clean && npm run package:oss:mac","dist:oss:mac-arm64":"npm run build:oss:prod && npm run clean && npm run package:oss:mac-arm64","dist:oss:lin":"npm run build:oss:prod && npm run clean && npm run package:oss:lin","dist:oss:lin-arm64":"npm run build:oss:prod && npm run clean && npm run package:oss:lin-arm64","dist:bit:win":"npm run build:bit:prod && npm run clean && npm run package:bit:win","dist:bit:mac":"npm run build:bit:prod && npm run clean && npm run package:bit:mac","dist:bit:mac-arm64":"npm run build:bit:prod && npm run clean && npm run package:bit:mac-arm64","dist:bit:lin":"npm run build:bit:prod && npm run clean && npm run package:bit:lin","dist:bit:lin-arm64":"npm run build:bit:prod && npm run clean && npm run package:bit:lin-arm64","package:oss:win":"pkg . --targets win-x64 --output ./dist/oss/windows/bw.exe","package:oss:mac":"pkg . --targets macos-x64 --output ./dist/oss/macos/bw","package:oss:mac-arm64":"pkg . --targets macos-arm64 --output ./dist/oss/macos-arm64/bw","package:oss:lin":"pkg . --targets linux-x64 --output ./dist/oss/linux/bw","package:oss:lin-arm64":"pkg . --targets linux-arm64 --output ./dist/oss/linux-arm64/bw","package:bit:win":"pkg . --targets win-x64 --output ./dist/bit/windows/bw.exe","package:bit:mac":"pkg . --targets macos-x64 --output ./dist/bit/macos/bw","package:bit:mac-arm64":"pkg . --targets macos-arm64 --output ./dist/bit/macos-arm64/bw","package:bit:lin":"pkg . --targets linux-x64 --output ./dist/bit/linux/bw","package:bit:lin-arm64":"pkg . --targets linux-arm64 --output ./dist/bit/linux-arm64/bw","test":"jest","test:watch":"jest --watch","test:watch:all":"jest --watchAll"},"bin":{"bw":"build/bw.js"},"pkg":{"assets":["./build/**/*"]},"dependencies":{"@koa/multer":"4.0.0","@koa/router":"13.1.0","big-integer":"1.6.52","browser-hrtime":"1.1.8","chalk":"4.1.2","commander":"11.1.0","core-js":"3.45.0","form-data":"4.0.4","https-proxy-agent":"7.0.6","inquirer":"8.2.6","jsdom":"26.1.0","jszip":"3.10.1","koa":"2.16.1","koa-bodyparser":"4.4.1","koa-json":"2.0.2","lowdb":"1.0.0","lunr":"2.3.9","multer":"1.4.5-lts.2","node-fetch":"2.6.12","node-forge":"1.3.1","open":"10.1.2","papaparse":"5.5.3","proper-lockfile":"4.1.2","rxjs":"7.8.1","semver":"7.7.2","tldts":"7.0.1","zxcvbn":"4.4.2"}}');

/***/ }),

/***/ 414:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $Pc: () => (/* binding */ __wbg_new_8a6f238a6ece86ea),
/* harmony export */   $Uh: () => (/* binding */ __wbg_debug_e17b51583ca6a632),
/* harmony export */   AeT: () => (/* binding */ __wbg_getaccesstoken_f04940224cf7da60),
/* harmony export */   BFX: () => (/* binding */ __wbg_setmode_5dc300b865044b65),
/* harmony export */   BGI: () => (/* binding */ __wbindgen_jsval_eq),
/* harmony export */   BZb: () => (/* binding */ __wbindgen_object_clone_ref),
/* harmony export */   CB9: () => (/* binding */ __wbg_crypto_574e78ad8b13b65f),
/* harmony export */   CF8: () => (/* binding */ __wbg_signal_aaf9ad74119f20a4),
/* harmony export */   DMD: () => (/* binding */ __wbindgen_bigint_get_as_i64),
/* harmony export */   Dn4: () => (/* binding */ __wbg_next_6574e1a8a62d1055),
/* harmony export */   FHK: () => (/* binding */ __wbg_buffer_609cc3eee51ed158),
/* harmony export */   FPO: () => (/* binding */ __wbg_getwithrefkey_1dc361bd10053bfe),
/* harmony export */   Fxh: () => (/* binding */ __wbg_msCrypto_a61aeb35a24c1329),
/* harmony export */   GQG: () => (/* binding */ __wbg_then_44b73946d2fb3e7d),
/* harmony export */   Geh: () => (/* binding */ init_sdk),
/* harmony export */   GuA: () => (/* binding */ __wbindgen_is_string),
/* harmony export */   HBq: () => (/* binding */ __wbg_set_65595bdd868b3009),
/* harmony export */   HSm: () => (/* binding */ __wbg_has_a5ea9117f258a0ec),
/* harmony export */   HtP: () => (/* binding */ __wbg_newwithlength_a381634e90c276d4),
/* harmony export */   HvI: () => (/* binding */ __wbg_ipcclientsubscription_new),
/* harmony export */   Hzn: () => (/* binding */ __wbg_instanceof_Response_f2cc20d9f7dfd644),
/* harmony export */   IEs: () => (/* binding */ PureCrypto),
/* harmony export */   IZ7: () => (/* binding */ __wbg_randomFillSync_ac0988aba3254290),
/* harmony export */   KhK: () => (/* binding */ __wbg_parse_def2e24ef1252aff),
/* harmony export */   KwY: () => (/* binding */ __wbg_versions_c01dfd4722a88165),
/* harmony export */   L1P: () => (/* binding */ __wbg_setvariant_d1d41b778dfe9c17),
/* harmony export */   L3p: () => (/* binding */ __wbg_instanceof_Map_f3469ce2244d2430),
/* harmony export */   LCp: () => (/* binding */ __wbindgen_cb_drop),
/* harmony export */   LMq: () => (/* binding */ __wbg_value_cd1ffa7b1ab794f1),
/* harmony export */   M2: () => (/* binding */ __wbg_new_78feb108b6472713),
/* harmony export */   Moj: () => (/* binding */ __wbg_headers_9cb51cfd2ac780a4),
/* harmony export */   NJs: () => (/* binding */ __wbg_set_3f1d0b984ed272ed),
/* harmony export */   NhE: () => (/* binding */ __wbindgen_boolean_get),
/* harmony export */   Nhd: () => (/* binding */ __wbg_setbody_5923b78a95eedf29),
/* harmony export */   Oyk: () => (/* binding */ __wbg_String_8f0eb39a4a4c2f66),
/* harmony export */   PPV: () => (/* binding */ __wbg_getTime_46267b1c24877e30),
/* harmony export */   PRY: () => (/* binding */ __wbindgen_is_function),
/* harmony export */   PUO: () => (/* binding */ FieldType),
/* harmony export */   Py0: () => (/* binding */ __wbindgen_memory),
/* harmony export */   QRK: () => (/* binding */ __wbindgen_number_new),
/* harmony export */   Qg3: () => (/* binding */ __wbindgen_bigint_from_u64),
/* harmony export */   Qnr: () => (/* binding */ __wbindgen_throw),
/* harmony export */   RG9: () => (/* binding */ __wbg_new_e25e5aab09ff45db),
/* harmony export */   RKd: () => (/* binding */ __wbg_info_033d8b8a0838f1d3),
/* harmony export */   RKz: () => (/* binding */ __wbg_get_b9b93047fe3cf45b),
/* harmony export */   RR8: () => (/* binding */ __wbg_new_018dcc2d6c8c2f6a),
/* harmony export */   RbT: () => (/* binding */ __wbindgen_closure_wrapper3340),
/* harmony export */   RjG: () => (/* binding */ __wbindgen_error_new),
/* harmony export */   Ry: () => (/* binding */ __wbg_length_e2d2a49132c1b256),
/* harmony export */   S9O: () => (/* binding */ __wbindgen_array_push),
/* harmony export */   SJf: () => (/* binding */ __wbg_instanceof_Uint8Array_17156bcf118086a9),
/* harmony export */   St$: () => (/* binding */ __wbg_incomingmessage_new),
/* harmony export */   TBZ: () => (/* binding */ __wbg_list_df32641beacaaebd),
/* harmony export */   TOc: () => (/* binding */ __wbg_subarray_aa9065fa9dc5df96),
/* harmony export */   Tbm: () => (/* binding */ __wbg_append_8c7dd8d641a5f01b),
/* harmony export */   Tp3: () => (/* binding */ __wbg_url_ae10c34ca209681d),
/* harmony export */   Tt0: () => (/* binding */ __wbg_send_9b8fc6bb517867dd),
/* harmony export */   U8c: () => (/* binding */ __wbindgen_jsval_loose_eq),
/* harmony export */   Uh8: () => (/* binding */ __wbg_remove_e7bec9398552d33f),
/* harmony export */   VYZ: () => (/* binding */ __wbg_list_249d074235c8a7bc),
/* harmony export */   VrZ: () => (/* binding */ __wbg_newnoargs_105ed471475aaf50),
/* harmony export */   VvB: () => (/* binding */ __wbg_remove_79e92e6446a637d0),
/* harmony export */   WYM: () => (/* binding */ __wbg_error_7534b8e9a36f1ab4),
/* harmony export */   WqA: () => (/* binding */ __wbg_append_b2d1fc16de2a0e81),
/* harmony export */   XKx: () => (/* binding */ __wbg_addEventListener_dc3da056b615f634),
/* harmony export */   Xb8: () => (/* binding */ __wbg_done_769e5ede4b31c67b),
/* harmony export */   Y6F: () => (/* binding */ __wbg_stringify_f7ed6987935b4a24),
/* harmony export */   Yb6: () => (/* binding */ __wbg_isSafeInteger_343e2beeeece1bb0),
/* harmony export */   YkQ: () => (/* binding */ __wbindgen_is_bigint),
/* harmony export */   Z87: () => (/* binding */ __wbg_error_80de38b3f7cc3c3c),
/* harmony export */   ZD9: () => (/* binding */ __wbg_warn_aaf1f4664a035bd6),
/* harmony export */   Zrx: () => (/* binding */ __wbg_get_5b8e3d66d3028864),
/* harmony export */   _hX: () => (/* binding */ __wbg_setmethod_3c5280fe5d890842),
/* harmony export */   _mG: () => (/* binding */ __wbg_get_a216d449efda5b83),
/* harmony export */   _mt: () => (/* binding */ __wbg_queueMicrotask_97d92b4fcc8a61c5),
/* harmony export */   a4S: () => (/* binding */ __wbg_settype_39ed370d3edd403c),
/* harmony export */   aIY: () => (/* binding */ __wbg_new_5e0be73521bc8c17),
/* harmony export */   aht: () => (/* binding */ __wbg_clearTimeout_b1115618e821c3b2),
/* harmony export */   awm: () => (/* binding */ __wbg_set_47094df6bd728b0f),
/* harmony export */   bkt: () => (/* binding */ __wbindgen_object_drop_ref),
/* harmony export */   bz7: () => (/* binding */ __wbg_setTimeout_ca12ead8b48245e2),
/* harmony export */   c6u: () => (/* binding */ __wbg_new_23a2665fac83c611),
/* harmony export */   cVx: () => (/* binding */ __wbg_append_299d5d48292c0495),
/* harmony export */   ce0: () => (/* binding */ __wbindgen_bigint_from_i64),
/* harmony export */   d_N: () => (/* binding */ __wbg_append_b44785ebeb668479),
/* harmony export */   dzD: () => (/* binding */ __wbg_get_67b2ba62fc30de12),
/* harmony export */   eIr: () => (/* binding */ __wbg_length_a446193dc22c12f8),
/* harmony export */   eW0: () => (/* binding */ __wbg_iterator_9a24c88df860dc65),
/* harmony export */   fb$: () => (/* binding */ __wbg_static_accessor_SELF_37c5d418e4bf5819),
/* harmony export */   gGA: () => (/* binding */ __wbg_instanceof_ArrayBuffer_e14585432e3737fc),
/* harmony export */   gHg: () => (/* binding */ __wbg_entries_3265d4158b33e5dc),
/* harmony export */   gMQ: () => (/* binding */ __wbg_abort_775ef1d17fc65868),
/* harmony export */   gRe: () => (/* binding */ __wbg_fetch_509096533071c657),
/* harmony export */   gae: () => (/* binding */ BitwardenClient),
/* harmony export */   gtG: () => (/* binding */ __wbg_text_7805bea50de2af49),
/* harmony export */   hI8: () => (/* binding */ __wbg_newwithbyteoffsetandlength_d97e637ebe145a9a),
/* harmony export */   heb: () => (/* binding */ __wbg_newwithstrandinit_06c535e0a867c635),
/* harmony export */   iAh: () => (/* binding */ __wbg_set_8fc6bf8a5b1071d1),
/* harmony export */   iEd: () => (/* binding */ __wbg_set_cbe909a733eef6b5),
/* harmony export */   ii7: () => (/* binding */ __wbg_static_accessor_GLOBAL_88a902d13a557d07),
/* harmony export */   k2R: () => (/* binding */ __wbg_queueMicrotask_d3219def82552485),
/* harmony export */   kK3: () => (/* binding */ __wbg_status_f6360336ca686bf0),
/* harmony export */   l0x: () => (/* binding */ __wbg_setsignal_75b21ef3a81de905),
/* harmony export */   lIU: () => (/* binding */ __wbg_set_wasm),
/* harmony export */   lU$: () => (/* binding */ __wbg_node_905d3e251edff8a2),
/* harmony export */   mEh: () => (/* binding */ __wbg_require_60cc747a6bc5215a),
/* harmony export */   mMK: () => (/* binding */ __wbindgen_array_new),
/* harmony export */   n8S: () => (/* binding */ __wbg_abort_410ec47a64ac6117),
/* harmony export */   p8e: () => (/* binding */ __wbg_set_37837023f3d740e8),
/* harmony export */   qNE: () => (/* binding */ __wbindgen_string_get),
/* harmony export */   qe7: () => (/* binding */ __wbg_newwithu8arraysequenceandoptions_068570c487f69127),
/* harmony export */   qmw: () => (/* binding */ __wbindgen_as_number),
/* harmony export */   qvD: () => (/* binding */ __wbindgen_is_object),
/* harmony export */   rQI: () => (/* binding */ __wbg_log_cad59bb680daec67),
/* harmony export */   rk2: () => (/* binding */ __wbg_setheaders_834c0bdb6a8949ad),
/* harmony export */   rl: () => (/* binding */ __wbindgen_debug_string),
/* harmony export */   s5K: () => (/* binding */ __wbg_getRandomValues_38097e921c2494c3),
/* harmony export */   sWe: () => (/* binding */ __wbindgen_number_get),
/* harmony export */   tTc: () => (/* binding */ __wbg_setname_c0e2d6f348c746f4),
/* harmony export */   tZf: () => (/* binding */ __wbg_push_737cfc8c1432c2c6),
/* harmony export */   tff: () => (/* binding */ __wbg_collectionviewnodeitem_new),
/* harmony export */   tuz: () => (/* binding */ __wbindgen_closure_wrapper6060),
/* harmony export */   typ: () => (/* binding */ __wbg_getRandomValues_b8f5dbd5f3995a9e),
/* harmony export */   uhv: () => (/* binding */ __wbindgen_closure_wrapper5705),
/* harmony export */   uod: () => (/* binding */ __wbg_isArray_a1eab7e0d067391b),
/* harmony export */   uw1: () => (/* binding */ __wbg_setcredentials_c3a22f1cd105a2c6),
/* harmony export */   vUM: () => (/* binding */ __wbindgen_is_undefined),
/* harmony export */   vUh: () => (/* binding */ __wbg_new_f24b6d53abe5bc82),
/* harmony export */   vVD: () => (/* binding */ __wbg_new_a12002a7f91c75be),
/* harmony export */   va5: () => (/* binding */ __wbg_new_405e22f390576ce2),
/* harmony export */   w6e: () => (/* binding */ __wbg_static_accessor_GLOBAL_THIS_56578be7e9f832b0),
/* harmony export */   w9h: () => (/* binding */ __wbg_call_7cccdd69e0791ae2),
/* harmony export */   wHY: () => (/* binding */ __wbg_call_672a4d21634d4a24),
/* harmony export */   wJz: () => (/* binding */ __wbg_resolve_4851785c9c5f573d),
/* harmony export */   wd3: () => (/* binding */ __wbg_new_c68d7209be747379),
/* harmony export */   x$X: () => (/* binding */ __wbg_stack_0ed75d68575b0f3c),
/* harmony export */   x0C: () => (/* binding */ __wbg_static_accessor_WINDOW_5de37043a91a9c40),
/* harmony export */   x2q: () => (/* binding */ __wbg_process_dc0fbacc7c1c06f7),
/* harmony export */   xV_: () => (/* binding */ __wbg_then_48b406749878a531),
/* harmony export */   yU8: () => (/* binding */ __wbg_new0_f788a2397c7ca929),
/* harmony export */   ycJ: () => (/* binding */ __wbindgen_string_new),
/* harmony export */   you: () => (/* binding */ __wbg_fetch_3afbdcc7ddbf16fe),
/* harmony export */   yqB: () => (/* binding */ __wbg_next_25feadfc0913fea9),
/* harmony export */   z09: () => (/* binding */ __wbg_new_9fd39a253424609a),
/* harmony export */   zEy: () => (/* binding */ __wbindgen_in)
/* harmony export */ });
/* unused harmony exports set_log_level, generate_ssh_key, import_ssh_key, isTestError, isCollectionDecryptError, isDeriveKeyConnectorError, isEnrollAdminPasswordResetError, isCryptoClientError, isStatefulCryptoError, isEncryptionSettingsError, isCryptoError, isExportError, isUsernameError, isPasswordError, isPassphraseError, ipcRegisterDiscoverHandler, ipcRequestDiscover, isChannelError, isDeserializeError, isRequestError, isTypedReceiveError, isReceiveError, isSubscribeError, isSshKeyExportError, isSshKeyImportError, isKeyGenerationError, isCallError, isDecryptError, isEncryptError, isTotpError, isGetFolderError, isEditFolderError, isCreateFolderError, isCipherError, isDecryptFileError, isEncryptFileError, CardLinkedIdType, CipherRepromptType, CipherType, IdentityLinkedIdType, LogLevel, LoginLinkedIdType, SecureNoteType, UriMatchType, AttachmentsClient, AuthClient, CiphersClient, CollectionViewNodeItem, CollectionViewTree, CollectionsClient, CryptoClient, ExporterClient, FoldersClient, GeneratorClient, IncomingMessage, IpcClient, IpcClientSubscription, IpcCommunicationBackend, OutgoingMessage, PlatformClient, SendAccessClient, StateClient, TotpClient, VaultClient */
/* module decorator */ module = __webpack_require__.hmd(module);
let wasm;
function __wbg_set_wasm(val) {
  wasm = val;
}

const heap = new Array(128).fill(undefined);

heap.push(undefined, null, true, false);

function getObject(idx) {
  return heap[idx];
}

let WASM_VECTOR_LEN = 0;

let cachedUint8ArrayMemory0 = null;

function getUint8ArrayMemory0() {
  if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
    cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
  }
  return cachedUint8ArrayMemory0;
}

const lTextEncoder =
  typeof TextEncoder === "undefined" ? (0, module.require)("util").TextEncoder : TextEncoder;

let cachedTextEncoder = new lTextEncoder("utf-8");

const encodeString =
  typeof cachedTextEncoder.encodeInto === "function"
    ? function (arg, view) {
        return cachedTextEncoder.encodeInto(arg, view);
      }
    : function (arg, view) {
        const buf = cachedTextEncoder.encode(arg);
        view.set(buf);
        return {
          read: arg.length,
          written: buf.length,
        };
      };

function passStringToWasm0(arg, malloc, realloc) {
  if (realloc === undefined) {
    const buf = cachedTextEncoder.encode(arg);
    const ptr = malloc(buf.length, 1) >>> 0;
    getUint8ArrayMemory0()
      .subarray(ptr, ptr + buf.length)
      .set(buf);
    WASM_VECTOR_LEN = buf.length;
    return ptr;
  }

  let len = arg.length;
  let ptr = malloc(len, 1) >>> 0;

  const mem = getUint8ArrayMemory0();

  let offset = 0;

  for (; offset < len; offset++) {
    const code = arg.charCodeAt(offset);
    if (code > 0x7f) break;
    mem[ptr + offset] = code;
  }

  if (offset !== len) {
    if (offset !== 0) {
      arg = arg.slice(offset);
    }
    ptr = realloc(ptr, len, (len = offset + arg.length * 3), 1) >>> 0;
    const view = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
    const ret = encodeString(arg, view);

    offset += ret.written;
    ptr = realloc(ptr, len, offset, 1) >>> 0;
  }

  WASM_VECTOR_LEN = offset;
  return ptr;
}

let cachedDataViewMemory0 = null;

function getDataViewMemory0() {
  if (
    cachedDataViewMemory0 === null ||
    cachedDataViewMemory0.buffer.detached === true ||
    (cachedDataViewMemory0.buffer.detached === undefined &&
      cachedDataViewMemory0.buffer !== wasm.memory.buffer)
  ) {
    cachedDataViewMemory0 = new DataView(wasm.memory.buffer);
  }
  return cachedDataViewMemory0;
}

const lTextDecoder =
  typeof TextDecoder === "undefined" ? (0, module.require)("util").TextDecoder : TextDecoder;

let cachedTextDecoder = new lTextDecoder("utf-8", { ignoreBOM: true, fatal: true });

cachedTextDecoder.decode();

function getStringFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
}

let heap_next = heap.length;

function addHeapObject(obj) {
  if (heap_next === heap.length) heap.push(heap.length + 1);
  const idx = heap_next;
  heap_next = heap[idx];

  heap[idx] = obj;
  return idx;
}

function handleError(f, args) {
  try {
    return f.apply(this, args);
  } catch (e) {
    wasm.__wbindgen_exn_store(addHeapObject(e));
  }
}

function dropObject(idx) {
  if (idx < 132) return;
  heap[idx] = heap_next;
  heap_next = idx;
}

function takeObject(idx) {
  const ret = getObject(idx);
  dropObject(idx);
  return ret;
}

function getArrayU8FromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return getUint8ArrayMemory0().subarray(ptr / 1, ptr / 1 + len);
}

function isLikeNone(x) {
  return x === undefined || x === null;
}

const CLOSURE_DTORS =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((state) => {
        wasm.__wbindgen_export_4.get(state.dtor)(state.a, state.b);
      });

function makeMutClosure(arg0, arg1, dtor, f) {
  const state = { a: arg0, b: arg1, cnt: 1, dtor };
  const real = (...args) => {
    // First up with a closure we increment the internal reference
    // count. This ensures that the Rust closure environment won't
    // be deallocated while we're invoking it.
    state.cnt++;
    const a = state.a;
    state.a = 0;
    try {
      return f(a, state.b, ...args);
    } finally {
      if (--state.cnt === 0) {
        wasm.__wbindgen_export_4.get(state.dtor)(a, state.b);
        CLOSURE_DTORS.unregister(state);
      } else {
        state.a = a;
      }
    }
  };
  real.original = state;
  CLOSURE_DTORS.register(real, state, state);
  return real;
}

function debugString(val) {
  // primitive types
  const type = typeof val;
  if (type == "number" || type == "boolean" || val == null) {
    return `${val}`;
  }
  if (type == "string") {
    return `"${val}"`;
  }
  if (type == "symbol") {
    const description = val.description;
    if (description == null) {
      return "Symbol";
    } else {
      return `Symbol(${description})`;
    }
  }
  if (type == "function") {
    const name = val.name;
    if (typeof name == "string" && name.length > 0) {
      return `Function(${name})`;
    } else {
      return "Function";
    }
  }
  // objects
  if (Array.isArray(val)) {
    const length = val.length;
    let debug = "[";
    if (length > 0) {
      debug += debugString(val[0]);
    }
    for (let i = 1; i < length; i++) {
      debug += ", " + debugString(val[i]);
    }
    debug += "]";
    return debug;
  }
  // Test for built-in
  const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
  let className;
  if (builtInMatches && builtInMatches.length > 1) {
    className = builtInMatches[1];
  } else {
    // Failed to match the standard '[object ClassName]'
    return toString.call(val);
  }
  if (className == "Object") {
    // we're a user defined class or Object
    // JSON.stringify avoids problems with cycles, and is generally much
    // easier than looping through ownProperties of `val`.
    try {
      return "Object(" + JSON.stringify(val) + ")";
    } catch (_) {
      return "Object";
    }
  }
  // errors
  if (val instanceof Error) {
    return `${val.name}: ${val.message}\n${val.stack}`;
  }
  // TODO we could test for more things here, like `Set`s and `Map`s.
  return className;
}
/**
 * @param {LogLevel} level
 */
function set_log_level(level) {
  wasm.set_log_level(level);
}

/**
 * @param {LogLevel | null} [log_level]
 */
function init_sdk(log_level) {
  wasm.init_sdk(isLikeNone(log_level) ? 5 : log_level);
}

function passArray8ToWasm0(arg, malloc) {
  const ptr = malloc(arg.length * 1, 1) >>> 0;
  getUint8ArrayMemory0().set(arg, ptr / 1);
  WASM_VECTOR_LEN = arg.length;
  return ptr;
}
/**
 * Generate a new SSH key pair
 *
 * # Arguments
 * - `key_algorithm` - The algorithm to use for the key pair
 *
 * # Returns
 * - `Ok(SshKey)` if the key was successfully generated
 * - `Err(KeyGenerationError)` if the key could not be generated
 * @param {KeyAlgorithm} key_algorithm
 * @returns {SshKeyView}
 */
function generate_ssh_key(key_algorithm) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.generate_ssh_key(retptr, addHeapObject(key_algorithm));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}

/**
 * Convert a PCKS8 or OpenSSH encrypted or unencrypted private key
 * to an OpenSSH private key with public key and fingerprint
 *
 * # Arguments
 * - `imported_key` - The private key to convert
 * - `password` - The password to use for decrypting the key
 *
 * # Returns
 * - `Ok(SshKey)` if the key was successfully coneverted
 * - `Err(PasswordRequired)` if the key is encrypted and no password was provided
 * - `Err(WrongPassword)` if the password provided is incorrect
 * - `Err(ParsingError)` if the key could not be parsed
 * - `Err(UnsupportedKeyType)` if the key type is not supported
 * @param {string} imported_key
 * @param {string | null} [password]
 * @returns {SshKeyView}
 */
function import_ssh_key(imported_key, password) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    const ptr0 = passStringToWasm0(imported_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    var ptr1 = isLikeNone(password)
      ? 0
      : passStringToWasm0(password, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    wasm.import_ssh_key(retptr, ptr0, len0, ptr1, len1);
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}

let stack_pointer = 128;

function addBorrowedObject(obj) {
  if (stack_pointer == 1) throw new Error("out of js stack");
  heap[--stack_pointer] = obj;
  return stack_pointer;
}
/**
 * @param {any} error
 * @returns {boolean}
 */
function isTestError(error) {
  try {
    const ret = wasm.isTestError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCollectionDecryptError(error) {
  try {
    const ret = wasm.isCollectionDecryptError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isDeriveKeyConnectorError(error) {
  try {
    const ret = wasm.isDeriveKeyConnectorError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isEnrollAdminPasswordResetError(error) {
  try {
    const ret = wasm.isEnrollAdminPasswordResetError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCryptoClientError(error) {
  try {
    const ret = wasm.isCryptoClientError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isStatefulCryptoError(error) {
  try {
    const ret = wasm.isStatefulCryptoError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isEncryptionSettingsError(error) {
  try {
    const ret = wasm.isEncryptionSettingsError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCryptoError(error) {
  try {
    const ret = wasm.isCryptoError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

function passArrayJsValueToWasm0(array, malloc) {
  const ptr = malloc(array.length * 4, 4) >>> 0;
  const mem = getDataViewMemory0();
  for (let i = 0; i < array.length; i++) {
    mem.setUint32(ptr + 4 * i, addHeapObject(array[i]), true);
  }
  WASM_VECTOR_LEN = array.length;
  return ptr;
}

function getArrayJsValueFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  const mem = getDataViewMemory0();
  const result = [];
  for (let i = ptr; i < ptr + 4 * len; i += 4) {
    result.push(takeObject(mem.getUint32(i, true)));
  }
  return result;
}
/**
 * @param {any} error
 * @returns {boolean}
 */
function isExportError(error) {
  try {
    const ret = wasm.isExportError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isUsernameError(error) {
  try {
    const ret = wasm.isUsernameError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isPasswordError(error) {
  try {
    const ret = wasm.isPasswordError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isPassphraseError(error) {
  try {
    const ret = wasm.isPassphraseError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

function _assertClass(instance, klass) {
  if (!(instance instanceof klass)) {
    throw new Error(`expected instance of ${klass.name}`);
  }
}
/**
 * Registers a DiscoverHandler so that the client can respond to DiscoverRequests.
 * @param {IpcClient} ipc_client
 * @param {DiscoverResponse} response
 * @returns {Promise<void>}
 */
function ipcRegisterDiscoverHandler(ipc_client, response) {
  _assertClass(ipc_client, IpcClient);
  const ret = wasm.ipcRegisterDiscoverHandler(ipc_client.__wbg_ptr, addHeapObject(response));
  return takeObject(ret);
}

/**
 * Sends a DiscoverRequest to the specified destination and returns the response.
 * @param {IpcClient} ipc_client
 * @param {Endpoint} destination
 * @param {AbortSignal | null} [abort_signal]
 * @returns {Promise<DiscoverResponse>}
 */
function ipcRequestDiscover(ipc_client, destination, abort_signal) {
  _assertClass(ipc_client, IpcClient);
  const ret = wasm.ipcRequestDiscover(
    ipc_client.__wbg_ptr,
    addHeapObject(destination),
    isLikeNone(abort_signal) ? 0 : addHeapObject(abort_signal),
  );
  return takeObject(ret);
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isChannelError(error) {
  try {
    const ret = wasm.isChannelError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isDeserializeError(error) {
  try {
    const ret = wasm.isDeserializeError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isRequestError(error) {
  try {
    const ret = wasm.isRequestError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isTypedReceiveError(error) {
  try {
    const ret = wasm.isTypedReceiveError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isReceiveError(error) {
  try {
    const ret = wasm.isReceiveError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isSubscribeError(error) {
  try {
    const ret = wasm.isSubscribeError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isSshKeyExportError(error) {
  try {
    const ret = wasm.isSshKeyExportError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isSshKeyImportError(error) {
  try {
    const ret = wasm.isSshKeyImportError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isKeyGenerationError(error) {
  try {
    const ret = wasm.isKeyGenerationError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCallError(error) {
  try {
    const ret = wasm.isCallError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isDecryptError(error) {
  try {
    const ret = wasm.isDecryptError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isEncryptError(error) {
  try {
    const ret = wasm.isEncryptError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isTotpError(error) {
  try {
    const ret = wasm.isTotpError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isGetFolderError(error) {
  try {
    const ret = wasm.isGetFolderError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isEditFolderError(error) {
  try {
    const ret = wasm.isEditFolderError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCreateFolderError(error) {
  try {
    const ret = wasm.isCreateFolderError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isCipherError(error) {
  try {
    const ret = wasm.isCipherError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isDecryptFileError(error) {
  try {
    const ret = wasm.isDecryptFileError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

/**
 * @param {any} error
 * @returns {boolean}
 */
function isEncryptFileError(error) {
  try {
    const ret = wasm.isEncryptFileError(addBorrowedObject(error));
    return ret !== 0;
  } finally {
    heap[stack_pointer++] = undefined;
  }
}

function __wbg_adapter_54(arg0, arg1) {
  wasm._dyn_core__ops__function__FnMut_____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__h091423ccfc08366e(
    arg0,
    arg1,
  );
}

function __wbg_adapter_59(arg0, arg1, arg2) {
  wasm._dyn_core__ops__function__FnMut__A____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__hb3d7232059e1cc02(
    arg0,
    arg1,
    addHeapObject(arg2),
  );
}

function __wbg_adapter_323(arg0, arg1, arg2, arg3) {
  wasm.wasm_bindgen__convert__closures__invoke2_mut__h54a8613170fef18e(
    arg0,
    arg1,
    addHeapObject(arg2),
    addHeapObject(arg3),
  );
}

/**
 * @enum {300 | 301 | 302 | 303 | 304 | 305}
 */
const CardLinkedIdType = Object.freeze({
  CardholderName: 300,
  300: "CardholderName",
  ExpMonth: 301,
  301: "ExpMonth",
  ExpYear: 302,
  302: "ExpYear",
  Code: 303,
  303: "Code",
  Brand: 304,
  304: "Brand",
  Number: 305,
  305: "Number",
});
/**
 * @enum {0 | 1}
 */
const CipherRepromptType = Object.freeze({
  None: 0,
  0: "None",
  Password: 1,
  1: "Password",
});
/**
 * @enum {1 | 2 | 3 | 4 | 5}
 */
const CipherType = Object.freeze({
  Login: 1,
  1: "Login",
  SecureNote: 2,
  2: "SecureNote",
  Card: 3,
  3: "Card",
  Identity: 4,
  4: "Identity",
  SshKey: 5,
  5: "SshKey",
});
/**
 * Represents the type of a [FieldView].
 * @enum {0 | 1 | 2 | 3}
 */
const FieldType = Object.freeze({
  /**
   * Text field
   */
  Text: 0,
  0: "Text",
  /**
   * Hidden text field
   */
  Hidden: 1,
  1: "Hidden",
  /**
   * Boolean field
   */
  Boolean: 2,
  2: "Boolean",
  /**
   * Linked field
   */
  Linked: 3,
  3: "Linked",
});
/**
 * @enum {400 | 401 | 402 | 403 | 404 | 405 | 406 | 407 | 408 | 409 | 410 | 411 | 412 | 413 | 414 | 415 | 416 | 417 | 418}
 */
const IdentityLinkedIdType = Object.freeze({
  Title: 400,
  400: "Title",
  MiddleName: 401,
  401: "MiddleName",
  Address1: 402,
  402: "Address1",
  Address2: 403,
  403: "Address2",
  Address3: 404,
  404: "Address3",
  City: 405,
  405: "City",
  State: 406,
  406: "State",
  PostalCode: 407,
  407: "PostalCode",
  Country: 408,
  408: "Country",
  Company: 409,
  409: "Company",
  Email: 410,
  410: "Email",
  Phone: 411,
  411: "Phone",
  Ssn: 412,
  412: "Ssn",
  Username: 413,
  413: "Username",
  PassportNumber: 414,
  414: "PassportNumber",
  LicenseNumber: 415,
  415: "LicenseNumber",
  FirstName: 416,
  416: "FirstName",
  LastName: 417,
  417: "LastName",
  FullName: 418,
  418: "FullName",
});
/**
 * @enum {0 | 1 | 2 | 3 | 4}
 */
const LogLevel = Object.freeze({
  Trace: 0,
  0: "Trace",
  Debug: 1,
  1: "Debug",
  Info: 2,
  2: "Info",
  Warn: 3,
  3: "Warn",
  Error: 4,
  4: "Error",
});
/**
 * @enum {100 | 101}
 */
const LoginLinkedIdType = Object.freeze({
  Username: 100,
  100: "Username",
  Password: 101,
  101: "Password",
});
/**
 * @enum {0}
 */
const SecureNoteType = Object.freeze({
  Generic: 0,
  0: "Generic",
});
/**
 * @enum {0 | 1 | 2 | 3 | 4 | 5}
 */
const UriMatchType = Object.freeze({
  Domain: 0,
  0: "Domain",
  Host: 1,
  1: "Host",
  StartsWith: 2,
  2: "StartsWith",
  Exact: 3,
  3: "Exact",
  RegularExpression: 4,
  4: "RegularExpression",
  Never: 5,
  5: "Never",
});

const __wbindgen_enum_RequestCredentials = ["omit", "same-origin", "include"];

const __wbindgen_enum_RequestMode = ["same-origin", "no-cors", "cors", "navigate"];

const AttachmentsClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_attachmentsclient_free(ptr >>> 0, 1));

class AttachmentsClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(AttachmentsClient.prototype);
    obj.__wbg_ptr = ptr;
    AttachmentsClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    AttachmentsClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_attachmentsclient_free(ptr, 0);
  }
  /**
   * @param {Cipher} cipher
   * @param {AttachmentView} attachment
   * @param {Uint8Array} encrypted_buffer
   * @returns {Uint8Array}
   */
  decrypt_buffer(cipher, attachment, encrypted_buffer) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(encrypted_buffer, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.attachmentsclient_decrypt_buffer(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher),
        addHeapObject(attachment),
        ptr0,
        len0,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const AuthClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_authclient_free(ptr >>> 0, 1));
/**
 * Subclient containing auth functionality.
 */
class AuthClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(AuthClient.prototype);
    obj.__wbg_ptr = ptr;
    AuthClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    AuthClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_authclient_free(ptr, 0);
  }
  /**
   * Client for send access functionality
   * @returns {SendAccessClient}
   */
  send_access() {
    const ret = wasm.authclient_send_access(this.__wbg_ptr);
    return SendAccessClient.__wrap(ret);
  }
}

const BitwardenClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_bitwardenclient_free(ptr >>> 0, 1));

class BitwardenClient {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    BitwardenClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_bitwardenclient_free(ptr, 0);
  }
  /**
   * @param {any} token_provider
   * @param {ClientSettings | null} [settings]
   */
  constructor(token_provider, settings) {
    const ret = wasm.bitwardenclient_new(
      addHeapObject(token_provider),
      isLikeNone(settings) ? 0 : addHeapObject(settings),
    );
    this.__wbg_ptr = ret >>> 0;
    BitwardenClientFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * Test method, echoes back the input
   * @param {string} msg
   * @returns {string}
   */
  echo(msg) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(msg, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.bitwardenclient_echo(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      deferred2_0 = r0;
      deferred2_1 = r1;
      return getStringFromWasm0(r0, r1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
  /**
   * @returns {string}
   */
  version() {
    let deferred1_0;
    let deferred1_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.bitwardenclient_version(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      deferred1_0 = r0;
      deferred1_1 = r1;
      return getStringFromWasm0(r0, r1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @param {string} msg
   */
  throw(msg) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(msg, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.bitwardenclient_throw(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Test method, calls http endpoint
   * @param {string} url
   * @returns {Promise<string>}
   */
  http_get(url) {
    const ptr0 = passStringToWasm0(url, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.bitwardenclient_http_get(this.__wbg_ptr, ptr0, len0);
    return takeObject(ret);
  }
  /**
   * Auth related operations.
   * @returns {AuthClient}
   */
  auth() {
    const ret = wasm.bitwardenclient_auth(this.__wbg_ptr);
    return AuthClient.__wrap(ret);
  }
  /**
   * @returns {CryptoClient}
   */
  crypto() {
    const ret = wasm.bitwardenclient_crypto(this.__wbg_ptr);
    return CryptoClient.__wrap(ret);
  }
  /**
   * @returns {VaultClient}
   */
  vault() {
    const ret = wasm.bitwardenclient_vault(this.__wbg_ptr);
    return VaultClient.__wrap(ret);
  }
  /**
   * Constructs a specific client for platform-specific functionality
   * @returns {PlatformClient}
   */
  platform() {
    const ret = wasm.bitwardenclient_platform(this.__wbg_ptr);
    return PlatformClient.__wrap(ret);
  }
  /**
   * Constructs a specific client for generating passwords and passphrases
   * @returns {GeneratorClient}
   */
  generator() {
    const ret = wasm.bitwardenclient_generator(this.__wbg_ptr);
    return GeneratorClient.__wrap(ret);
  }
  /**
   * @returns {ExporterClient}
   */
  exporters() {
    const ret = wasm.bitwardenclient_exporters(this.__wbg_ptr);
    return ExporterClient.__wrap(ret);
  }
}

const CiphersClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ciphersclient_free(ptr >>> 0, 1));

class CiphersClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CiphersClient.prototype);
    obj.__wbg_ptr = ptr;
    CiphersClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CiphersClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ciphersclient_free(ptr, 0);
  }
  /**
   * @param {CipherView} cipher_view
   * @returns {EncryptionContext}
   */
  encrypt(cipher_view) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_encrypt(retptr, this.__wbg_ptr, addHeapObject(cipher_view));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Encrypt a cipher with the provided key. This should only be used when rotating encryption
   * keys in the Web client.
   *
   * Until key rotation is fully implemented in the SDK, this method must be provided the new
   * symmetric key in base64 format. See PM-23084
   *
   * If the cipher has a CipherKey, it will be re-encrypted with the new key.
   * If the cipher does not have a CipherKey and CipherKeyEncryption is enabled, one will be
   * generated using the new key. Otherwise, the cipher's data will be encrypted with the new
   * key directly.
   * @param {CipherView} cipher_view
   * @param {string} new_key_b64
   * @returns {EncryptionContext}
   */
  encrypt_cipher_for_rotation(cipher_view, new_key_b64) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(new_key_b64, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.ciphersclient_encrypt_cipher_for_rotation(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher_view),
        ptr0,
        len0,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Cipher} cipher
   * @returns {CipherView}
   */
  decrypt(cipher) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_decrypt(retptr, this.__wbg_ptr, addHeapObject(cipher));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Cipher[]} ciphers
   * @returns {CipherListView[]}
   */
  decrypt_list(ciphers) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.ciphersclient_decrypt_list(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Decrypt cipher list with failures
   * Returns both successfully decrypted ciphers and any that failed to decrypt
   * @param {Cipher[]} ciphers
   * @returns {DecryptCipherListResult}
   */
  decrypt_list_with_failures(ciphers) {
    const ptr0 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.ciphersclient_decrypt_list_with_failures(this.__wbg_ptr, ptr0, len0);
    return takeObject(ret);
  }
  /**
   * @param {CipherView} cipher_view
   * @returns {Fido2CredentialView[]}
   */
  decrypt_fido2_credentials(cipher_view) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_decrypt_fido2_credentials(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher_view),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v1 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Temporary method used to re-encrypt FIDO2 credentials for a cipher view.
   * Necessary until the TS clients utilize the SDK entirely for FIDO2 credentials management.
   * TS clients create decrypted FIDO2 credentials that need to be encrypted manually when
   * encrypting the rest of the CipherView.
   * TODO: Remove once TS passkey provider implementation uses SDK - PM-8313
   * @param {CipherView} cipher_view
   * @param {Fido2CredentialFullView[]} fido2_credentials
   * @returns {CipherView}
   */
  set_fido2_credentials(cipher_view, fido2_credentials) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(fido2_credentials, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.ciphersclient_set_fido2_credentials(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher_view),
        ptr0,
        len0,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {CipherView} cipher_view
   * @param {OrganizationId} organization_id
   * @returns {CipherView}
   */
  move_to_organization(cipher_view, organization_id) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_move_to_organization(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher_view),
        addHeapObject(organization_id),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {CipherView} cipher_view
   * @returns {string}
   */
  decrypt_fido2_private_key(cipher_view) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.ciphersclient_decrypt_fido2_private_key(
        retptr,
        this.__wbg_ptr,
        addHeapObject(cipher_view),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
}

const CollectionViewNodeItemFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_collectionviewnodeitem_free(ptr >>> 0, 1));

class CollectionViewNodeItem {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CollectionViewNodeItem.prototype);
    obj.__wbg_ptr = ptr;
    CollectionViewNodeItemFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CollectionViewNodeItemFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_collectionviewnodeitem_free(ptr, 0);
  }
  /**
   * @returns {CollectionView}
   */
  get_item() {
    const ret = wasm.collectionviewnodeitem_get_item(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {CollectionView | undefined}
   */
  get_parent() {
    const ret = wasm.collectionviewnodeitem_get_parent(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {CollectionView[]}
   */
  get_children() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.collectionviewnodeitem_get_children(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {Map<any, any>}
   */
  get_ancestors() {
    const ret = wasm.collectionviewnodeitem_get_ancestors(this.__wbg_ptr);
    return takeObject(ret);
  }
}

const CollectionViewTreeFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_collectionviewtree_free(ptr >>> 0, 1));

class CollectionViewTree {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CollectionViewTree.prototype);
    obj.__wbg_ptr = ptr;
    CollectionViewTreeFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CollectionViewTreeFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_collectionviewtree_free(ptr, 0);
  }
  /**
   * @param {CollectionView} collection_view
   * @returns {CollectionViewNodeItem | undefined}
   */
  get_item_by_id(collection_view) {
    const ret = wasm.collectionviewtree_get_item_by_id(
      this.__wbg_ptr,
      addHeapObject(collection_view),
    );
    return ret === 0 ? undefined : CollectionViewNodeItem.__wrap(ret);
  }
  /**
   * @returns {CollectionViewNodeItem[]}
   */
  get_root_items() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.collectionviewtree_get_root_items(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {CollectionViewNodeItem[]}
   */
  get_flat_items() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.collectionviewtree_get_flat_items(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const CollectionsClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_collectionsclient_free(ptr >>> 0, 1));

class CollectionsClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CollectionsClient.prototype);
    obj.__wbg_ptr = ptr;
    CollectionsClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CollectionsClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_collectionsclient_free(ptr, 0);
  }
  /**
   * @param {Collection} collection
   * @returns {CollectionView}
   */
  decrypt(collection) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.collectionsclient_decrypt(retptr, this.__wbg_ptr, addHeapObject(collection));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Collection[]} collections
   * @returns {CollectionView[]}
   */
  decrypt_list(collections) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(collections, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.collectionsclient_decrypt_list(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   *
   * Returns the vector of CollectionView objects in a tree structure based on its implemented
   * path().
   * @param {CollectionView[]} collections
   * @returns {CollectionViewTree}
   */
  get_collection_tree(collections) {
    const ptr0 = passArrayJsValueToWasm0(collections, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.collectionsclient_get_collection_tree(this.__wbg_ptr, ptr0, len0);
    return CollectionViewTree.__wrap(ret);
  }
}

const CryptoClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_cryptoclient_free(ptr >>> 0, 1));
/**
 * A client for the crypto operations.
 */
class CryptoClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CryptoClient.prototype);
    obj.__wbg_ptr = ptr;
    CryptoClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CryptoClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_cryptoclient_free(ptr, 0);
  }
  /**
   * Initialization method for the user crypto. Needs to be called before any other crypto
   * operations.
   * @param {InitUserCryptoRequest} req
   * @returns {Promise<void>}
   */
  initialize_user_crypto(req) {
    const ret = wasm.cryptoclient_initialize_user_crypto(this.__wbg_ptr, addHeapObject(req));
    return takeObject(ret);
  }
  /**
   * Initialization method for the organization crypto. Needs to be called after
   * `initialize_user_crypto` but before any other crypto operations.
   * @param {InitOrgCryptoRequest} req
   * @returns {Promise<void>}
   */
  initialize_org_crypto(req) {
    const ret = wasm.cryptoclient_initialize_org_crypto(this.__wbg_ptr, addHeapObject(req));
    return takeObject(ret);
  }
  /**
   * Generates a new key pair and encrypts the private key with the provided user key.
   * Crypto initialization not required.
   * @param {string} user_key
   * @returns {MakeKeyPairResponse}
   */
  make_key_pair(user_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(user_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.cryptoclient_make_key_pair(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Verifies a user's asymmetric keys by decrypting the private key with the provided user
   * key. Returns if the private key is decryptable and if it is a valid matching key.
   * Crypto initialization not required.
   * @param {VerifyAsymmetricKeysRequest} request
   * @returns {VerifyAsymmetricKeysResponse}
   */
  verify_asymmetric_keys(request) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.cryptoclient_verify_asymmetric_keys(retptr, this.__wbg_ptr, addHeapObject(request));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Makes a new signing key pair and signs the public key for the user
   * @returns {UserCryptoV2KeysResponse}
   */
  make_keys_for_user_crypto_v2() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.cryptoclient_make_keys_for_user_crypto_v2(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Creates a rotated set of account keys for the current state
   * @returns {UserCryptoV2KeysResponse}
   */
  get_v2_rotated_account_keys() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.cryptoclient_get_v2_rotated_account_keys(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const ExporterClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_exporterclient_free(ptr >>> 0, 1));

class ExporterClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(ExporterClient.prototype);
    obj.__wbg_ptr = ptr;
    ExporterClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    ExporterClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_exporterclient_free(ptr, 0);
  }
  /**
   * @param {Folder[]} folders
   * @param {Cipher[]} ciphers
   * @param {ExportFormat} format
   * @returns {string}
   */
  export_vault(folders, ciphers, format) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(folders, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.exporterclient_export_vault(
        retptr,
        this.__wbg_ptr,
        ptr0,
        len0,
        ptr1,
        len1,
        addHeapObject(format),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * @param {Collection[]} collections
   * @param {Cipher[]} ciphers
   * @param {ExportFormat} format
   * @returns {string}
   */
  export_organization_vault(collections, ciphers, format) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(collections, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.exporterclient_export_organization_vault(
        retptr,
        this.__wbg_ptr,
        ptr0,
        len0,
        ptr1,
        len1,
        addHeapObject(format),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * Credential Exchange Format (CXF)
   *
   * *Warning:* Expect this API to be unstable, and it will change in the future.
   *
   * For use with Apple using [ASCredentialExportManager](https://developer.apple.com/documentation/authenticationservices/ascredentialexportmanager).
   * Ideally, the input should be immediately serialized from [ASImportableAccount](https://developer.apple.com/documentation/authenticationservices/asimportableaccount).
   * @param {Account} account
   * @param {Cipher[]} ciphers
   * @returns {string}
   */
  export_cxf(account, ciphers) {
    let deferred3_0;
    let deferred3_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(ciphers, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.exporterclient_export_cxf(retptr, this.__wbg_ptr, addHeapObject(account), ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr2 = r0;
      var len2 = r1;
      if (r3) {
        ptr2 = 0;
        len2 = 0;
        throw takeObject(r2);
      }
      deferred3_0 = ptr2;
      deferred3_1 = len2;
      return getStringFromWasm0(ptr2, len2);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred3_0, deferred3_1, 1);
    }
  }
  /**
   * Credential Exchange Format (CXF)
   *
   * *Warning:* Expect this API to be unstable, and it will change in the future.
   *
   * For use with Apple using [ASCredentialExportManager](https://developer.apple.com/documentation/authenticationservices/ascredentialexportmanager).
   * Ideally, the input should be immediately serialized from [ASImportableAccount](https://developer.apple.com/documentation/authenticationservices/asimportableaccount).
   * @param {string} payload
   * @returns {Cipher[]}
   */
  import_cxf(payload) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(payload, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.exporterclient_import_cxf(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const FoldersClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_foldersclient_free(ptr >>> 0, 1));
/**
 * Wrapper for folder specific functionality.
 */
class FoldersClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(FoldersClient.prototype);
    obj.__wbg_ptr = ptr;
    FoldersClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    FoldersClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_foldersclient_free(ptr, 0);
  }
  /**
   * Encrypt a [FolderView] to a [Folder].
   * @param {FolderView} folder_view
   * @returns {Folder}
   */
  encrypt(folder_view) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.foldersclient_encrypt(retptr, this.__wbg_ptr, addHeapObject(folder_view));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Encrypt a [Folder] to [FolderView].
   * @param {Folder} folder
   * @returns {FolderView}
   */
  decrypt(folder) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.foldersclient_decrypt(retptr, this.__wbg_ptr, addHeapObject(folder));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Decrypt a list of [Folder]s to a list of [FolderView]s.
   * @param {Folder[]} folders
   * @returns {FolderView[]}
   */
  decrypt_list(folders) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArrayJsValueToWasm0(folders, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.foldersclient_decrypt_list(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v2 = getArrayJsValueFromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 4, 4);
      return v2;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Get all folders from state and decrypt them to a list of [FolderView].
   * @returns {Promise<FolderView[]>}
   */
  list() {
    const ret = wasm.foldersclient_list(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * Get a specific [Folder] by its ID from state and decrypt it to a [FolderView].
   * @param {string} folder_id
   * @returns {Promise<FolderView>}
   */
  get(folder_id) {
    const ptr0 = passStringToWasm0(folder_id, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.foldersclient_get(this.__wbg_ptr, ptr0, len0);
    return takeObject(ret);
  }
  /**
   * Create a new [Folder] and save it to the server.
   * @param {FolderAddEditRequest} request
   * @returns {Promise<FolderView>}
   */
  create(request) {
    const ret = wasm.foldersclient_create(this.__wbg_ptr, addHeapObject(request));
    return takeObject(ret);
  }
  /**
   * Edit the [Folder] and save it to the server.
   * @param {string} folder_id
   * @param {FolderAddEditRequest} request
   * @returns {Promise<FolderView>}
   */
  edit(folder_id, request) {
    const ptr0 = passStringToWasm0(folder_id, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.foldersclient_edit(this.__wbg_ptr, ptr0, len0, addHeapObject(request));
    return takeObject(ret);
  }
}

const GeneratorClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_generatorclient_free(ptr >>> 0, 1));

class GeneratorClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(GeneratorClient.prototype);
    obj.__wbg_ptr = ptr;
    GeneratorClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    GeneratorClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_generatorclient_free(ptr, 0);
  }
  /**
   * Generates a random password.
   *
   * The character sets and password length can be customized using the `input` parameter.
   *
   * # Examples
   *
   * ```
   * use bitwarden_core::Client;
   * use bitwarden_generators::{GeneratorClientsExt, PassphraseError, PasswordGeneratorRequest};
   *
   * async fn test() -> Result<(), PassphraseError> {
   *     let input = PasswordGeneratorRequest {
   *         lowercase: true,
   *         uppercase: true,
   *         numbers: true,
   *         length: 20,
   *         ..Default::default()
   *     };
   *     let password = Client::new(None).generator().password(input).unwrap();
   *     println!("{}", password);
   *     Ok(())
   * }
   * ```
   * @param {PasswordGeneratorRequest} input
   * @returns {string}
   */
  password(input) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.generatorclient_password(retptr, this.__wbg_ptr, addHeapObject(input));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
  /**
   * Generates a random passphrase.
   * A passphrase is a combination of random words separated by a character.
   * An example of passphrase is `correct horse battery staple`.
   *
   * The number of words and their case, the word separator, and the inclusion of
   * a number in the passphrase can be customized using the `input` parameter.
   *
   * # Examples
   *
   * ```
   * use bitwarden_core::Client;
   * use bitwarden_generators::{GeneratorClientsExt, PassphraseError, PassphraseGeneratorRequest};
   *
   * async fn test() -> Result<(), PassphraseError> {
   *     let input = PassphraseGeneratorRequest {
   *         num_words: 4,
   *         ..Default::default()
   *     };
   *     let passphrase = Client::new(None).generator().passphrase(input).unwrap();
   *     println!("{}", passphrase);
   *     Ok(())
   * }
   * ```
   * @param {PassphraseGeneratorRequest} input
   * @returns {string}
   */
  passphrase(input) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.generatorclient_passphrase(retptr, this.__wbg_ptr, addHeapObject(input));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
}

const IncomingMessageFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_incomingmessage_free(ptr >>> 0, 1));

class IncomingMessage {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(IncomingMessage.prototype);
    obj.__wbg_ptr = ptr;
    IncomingMessageFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IncomingMessageFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_incomingmessage_free(ptr, 0);
  }
  /**
   * @returns {Uint8Array}
   */
  get payload() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_incomingmessage_payload(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} arg0
   */
  set payload(arg0) {
    const ptr0 = passArray8ToWasm0(arg0, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_incomingmessage_payload(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @returns {Endpoint}
   */
  get destination() {
    const ret = wasm.__wbg_get_incomingmessage_destination(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {Endpoint} arg0
   */
  set destination(arg0) {
    wasm.__wbg_set_incomingmessage_destination(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {Endpoint}
   */
  get source() {
    const ret = wasm.__wbg_get_incomingmessage_source(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {Endpoint} arg0
   */
  set source(arg0) {
    wasm.__wbg_set_incomingmessage_source(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {string | undefined}
   */
  get topic() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_incomingmessage_topic(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      let v1;
      if (r0 !== 0) {
        v1 = getStringFromWasm0(r0, r1).slice();
        wasm.__wbindgen_free(r0, r1 * 1, 1);
      }
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string | null} [arg0]
   */
  set topic(arg0) {
    var ptr0 = isLikeNone(arg0)
      ? 0
      : passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_incomingmessage_topic(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @param {Uint8Array} payload
   * @param {Endpoint} destination
   * @param {Endpoint} source
   * @param {string | null} [topic]
   */
  constructor(payload, destination, source, topic) {
    const ptr0 = passArray8ToWasm0(payload, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    var ptr1 = isLikeNone(topic)
      ? 0
      : passStringToWasm0(topic, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    const ret = wasm.incomingmessage_new(
      ptr0,
      len0,
      addHeapObject(destination),
      addHeapObject(source),
      ptr1,
      len1,
    );
    this.__wbg_ptr = ret >>> 0;
    IncomingMessageFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * Try to parse the payload as JSON.
   * @returns {any} The parsed JSON value, or undefined if the payload is not valid JSON.
   */
  parse_payload_as_json() {
    const ret = wasm.incomingmessage_parse_payload_as_json(this.__wbg_ptr);
    return takeObject(ret);
  }
}

const IpcClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ipcclient_free(ptr >>> 0, 1));
/**
 * JavaScript wrapper around the IPC client. For more information, see the
 * [IpcClient] documentation.
 */
class IpcClient {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IpcClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ipcclient_free(ptr, 0);
  }
  /**
   * @param {IpcCommunicationBackend} communication_provider
   */
  constructor(communication_provider) {
    _assertClass(communication_provider, IpcCommunicationBackend);
    const ret = wasm.ipcclient_new(communication_provider.__wbg_ptr);
    this.__wbg_ptr = ret >>> 0;
    IpcClientFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * @returns {Promise<void>}
   */
  start() {
    const ret = wasm.ipcclient_start(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {Promise<boolean>}
   */
  isRunning() {
    const ret = wasm.ipcclient_isRunning(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {OutgoingMessage} message
   * @returns {Promise<void>}
   */
  send(message) {
    _assertClass(message, OutgoingMessage);
    var ptr0 = message.__destroy_into_raw();
    const ret = wasm.ipcclient_send(this.__wbg_ptr, ptr0);
    return takeObject(ret);
  }
  /**
   * @returns {Promise<IpcClientSubscription>}
   */
  subscribe() {
    const ret = wasm.ipcclient_subscribe(this.__wbg_ptr);
    return takeObject(ret);
  }
}

const IpcClientSubscriptionFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ipcclientsubscription_free(ptr >>> 0, 1));
/**
 * JavaScript wrapper around the IPC client subscription. For more information, see the
 * [IpcClientSubscription](crate::IpcClientSubscription) documentation.
 */
class IpcClientSubscription {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(IpcClientSubscription.prototype);
    obj.__wbg_ptr = ptr;
    IpcClientSubscriptionFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IpcClientSubscriptionFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ipcclientsubscription_free(ptr, 0);
  }
  /**
   * @param {AbortSignal | null} [abort_signal]
   * @returns {Promise<IncomingMessage>}
   */
  receive(abort_signal) {
    const ret = wasm.ipcclientsubscription_receive(
      this.__wbg_ptr,
      isLikeNone(abort_signal) ? 0 : addHeapObject(abort_signal),
    );
    return takeObject(ret);
  }
}

const IpcCommunicationBackendFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_ipccommunicationbackend_free(ptr >>> 0, 1));
/**
 * JavaScript implementation of the `CommunicationBackend` trait for IPC communication.
 */
class IpcCommunicationBackend {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    IpcCommunicationBackendFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ipccommunicationbackend_free(ptr, 0);
  }
  /**
   * Creates a new instance of the JavaScript communication backend.
   * @param {IpcCommunicationBackendSender} sender
   */
  constructor(sender) {
    const ret = wasm.ipccommunicationbackend_new(addHeapObject(sender));
    this.__wbg_ptr = ret >>> 0;
    IpcCommunicationBackendFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * Used by JavaScript to provide an incoming message to the IPC framework.
   * @param {IncomingMessage} message
   */
  receive(message) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      _assertClass(message, IncomingMessage);
      var ptr0 = message.__destroy_into_raw();
      wasm.ipccommunicationbackend_receive(retptr, this.__wbg_ptr, ptr0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const OutgoingMessageFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_outgoingmessage_free(ptr >>> 0, 1));

class OutgoingMessage {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(OutgoingMessage.prototype);
    obj.__wbg_ptr = ptr;
    OutgoingMessageFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    OutgoingMessageFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_outgoingmessage_free(ptr, 0);
  }
  /**
   * @returns {Uint8Array}
   */
  get payload() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_outgoingmessage_payload(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} arg0
   */
  set payload(arg0) {
    const ptr0 = passArray8ToWasm0(arg0, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_outgoingmessage_payload(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @returns {Endpoint}
   */
  get destination() {
    const ret = wasm.__wbg_get_incomingmessage_destination(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {Endpoint} arg0
   */
  set destination(arg0) {
    wasm.__wbg_set_incomingmessage_destination(this.__wbg_ptr, addHeapObject(arg0));
  }
  /**
   * @returns {string | undefined}
   */
  get topic() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.__wbg_get_outgoingmessage_topic(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      let v1;
      if (r0 !== 0) {
        v1 = getStringFromWasm0(r0, r1).slice();
        wasm.__wbindgen_free(r0, r1 * 1, 1);
      }
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string | null} [arg0]
   */
  set topic(arg0) {
    var ptr0 = isLikeNone(arg0)
      ? 0
      : passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_outgoingmessage_topic(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @param {Uint8Array} payload
   * @param {Endpoint} destination
   * @param {string | null} [topic]
   */
  constructor(payload, destination, topic) {
    const ptr0 = passArray8ToWasm0(payload, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    var ptr1 = isLikeNone(topic)
      ? 0
      : passStringToWasm0(topic, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    const ret = wasm.outgoingmessage_new(ptr0, len0, addHeapObject(destination), ptr1, len1);
    this.__wbg_ptr = ret >>> 0;
    OutgoingMessageFinalization.register(this, this.__wbg_ptr, this);
    return this;
  }
  /**
   * Create a new message and encode the payload as JSON.
   * @param {any} payload
   * @param {Endpoint} destination
   * @param {string | null} [topic]
   * @returns {OutgoingMessage}
   */
  static new_json_payload(payload, destination, topic) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      var ptr0 = isLikeNone(topic)
        ? 0
        : passStringToWasm0(topic, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      var len0 = WASM_VECTOR_LEN;
      wasm.outgoingmessage_new_json_payload(
        retptr,
        addHeapObject(payload),
        addHeapObject(destination),
        ptr0,
        len0,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return OutgoingMessage.__wrap(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const PlatformClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_platformclient_free(ptr >>> 0, 1));

class PlatformClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(PlatformClient.prototype);
    obj.__wbg_ptr = ptr;
    PlatformClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    PlatformClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_platformclient_free(ptr, 0);
  }
  /**
   * @returns {StateClient}
   */
  state() {
    const ret = wasm.bitwardenclient_platform(this.__wbg_ptr);
    return StateClient.__wrap(ret);
  }
  /**
   * Load feature flags into the client
   * @param {FeatureFlags} flags
   */
  load_flags(flags) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.platformclient_load_flags(retptr, this.__wbg_ptr, addHeapObject(flags));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const PureCryptoFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_purecrypto_free(ptr >>> 0, 1));
/**
 * This module represents a stopgap solution to provide access to primitive crypto functions for JS
 * clients. It is not intended to be used outside of the JS clients and this pattern should not be
 * proliferated. It is necessary because we want to use SDK crypto prior to the SDK being fully
 * responsible for state and keys.
 */
class PureCrypto {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    PureCryptoFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_purecrypto_free(ptr, 0);
  }
  /**
   * DEPRECATED: Use `symmetric_decrypt_string` instead.
   * Cleanup ticket: <https://bitwarden.atlassian.net/browse/PM-21247>
   * @param {string} enc_string
   * @param {Uint8Array} key
   * @returns {string}
   */
  static symmetric_decrypt(enc_string, key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(enc_string, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * @param {string} enc_string
   * @param {Uint8Array} key
   * @returns {string}
   */
  static symmetric_decrypt_string(enc_string, key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(enc_string, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt_string(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * @param {string} enc_string
   * @param {Uint8Array} key
   * @returns {Uint8Array}
   */
  static symmetric_decrypt_bytes(enc_string, key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(enc_string, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt_bytes(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * DEPRECATED: Use `symmetric_decrypt_filedata` instead.
   * Cleanup ticket: <https://bitwarden.atlassian.net/browse/PM-21247>
   * @param {Uint8Array} enc_bytes
   * @param {Uint8Array} key
   * @returns {Uint8Array}
   */
  static symmetric_decrypt_array_buffer(enc_bytes, key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(enc_bytes, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt_array_buffer(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} enc_bytes
   * @param {Uint8Array} key
   * @returns {Uint8Array}
   */
  static symmetric_decrypt_filedata(enc_bytes, key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(enc_bytes, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_decrypt_filedata(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string} plain
   * @param {Uint8Array} key
   * @returns {string}
   */
  static symmetric_encrypt_string(plain, key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(plain, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_encrypt_string(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * DEPRECATED: Only used by send keys
   * @param {Uint8Array} plain
   * @param {Uint8Array} key
   * @returns {string}
   */
  static symmetric_encrypt_bytes(plain, key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(plain, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_encrypt_bytes(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * @param {Uint8Array} plain
   * @param {Uint8Array} key
   * @returns {Uint8Array}
   */
  static symmetric_encrypt_filedata(plain, key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(plain, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_symmetric_encrypt_filedata(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string} encrypted_user_key
   * @param {string} master_password
   * @param {string} email
   * @param {Kdf} kdf
   * @returns {Uint8Array}
   */
  static decrypt_user_key_with_master_password(encrypted_user_key, master_password, email, kdf) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(
        encrypted_user_key,
        wasm.__wbindgen_malloc,
        wasm.__wbindgen_realloc,
      );
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passStringToWasm0(
        master_password,
        wasm.__wbindgen_malloc,
        wasm.__wbindgen_realloc,
      );
      const len1 = WASM_VECTOR_LEN;
      const ptr2 = passStringToWasm0(email, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len2 = WASM_VECTOR_LEN;
      wasm.purecrypto_decrypt_user_key_with_master_password(
        retptr,
        ptr0,
        len0,
        ptr1,
        len1,
        ptr2,
        len2,
        addHeapObject(kdf),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v4 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v4;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} user_key
   * @param {string} master_password
   * @param {string} email
   * @param {Kdf} kdf
   * @returns {string}
   */
  static encrypt_user_key_with_master_password(user_key, master_password, email, kdf) {
    let deferred5_0;
    let deferred5_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(user_key, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passStringToWasm0(
        master_password,
        wasm.__wbindgen_malloc,
        wasm.__wbindgen_realloc,
      );
      const len1 = WASM_VECTOR_LEN;
      const ptr2 = passStringToWasm0(email, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len2 = WASM_VECTOR_LEN;
      wasm.purecrypto_encrypt_user_key_with_master_password(
        retptr,
        ptr0,
        len0,
        ptr1,
        len1,
        ptr2,
        len2,
        addHeapObject(kdf),
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr4 = r0;
      var len4 = r1;
      if (r3) {
        ptr4 = 0;
        len4 = 0;
        throw takeObject(r2);
      }
      deferred5_0 = ptr4;
      deferred5_1 = len4;
      return getStringFromWasm0(ptr4, len4);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred5_0, deferred5_1, 1);
    }
  }
  /**
   * @returns {Uint8Array}
   */
  static make_user_key_aes256_cbc_hmac() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.purecrypto_make_user_key_aes256_cbc_hmac(retptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {Uint8Array}
   */
  static make_user_key_xchacha20_poly1305() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.purecrypto_make_user_key_xchacha20_poly1305(retptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var v1 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Wraps (encrypts) a symmetric key using a symmetric wrapping key, returning the wrapped key
   * as an EncString.
   * @param {Uint8Array} key_to_be_wrapped
   * @param {Uint8Array} wrapping_key
   * @returns {string}
   */
  static wrap_symmetric_key(key_to_be_wrapped, wrapping_key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(key_to_be_wrapped, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(wrapping_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_wrap_symmetric_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * Unwraps (decrypts) a wrapped symmetric key using a symmetric wrapping key, returning the
   * unwrapped key as a serialized byte array.
   * @param {string} wrapped_key
   * @param {Uint8Array} wrapping_key
   * @returns {Uint8Array}
   */
  static unwrap_symmetric_key(wrapped_key, wrapping_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(wrapped_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(wrapping_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_unwrap_symmetric_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Wraps (encrypts) an SPKI DER encoded encapsulation (public) key using a symmetric wrapping
   * key. Note: Usually, a public key is - by definition - public, so this should not be
   * used. The specific use-case for this function is to enable rotateable key sets, where
   * the "public key" is not public, with the intent of preventing the server from being able
   * to overwrite the user key unlocked by the rotateable keyset.
   * @param {Uint8Array} encapsulation_key
   * @param {Uint8Array} wrapping_key
   * @returns {string}
   */
  static wrap_encapsulation_key(encapsulation_key, wrapping_key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(encapsulation_key, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(wrapping_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_wrap_encapsulation_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * Unwraps (decrypts) a wrapped SPKI DER encoded encapsulation (public) key using a symmetric
   * wrapping key.
   * @param {string} wrapped_key
   * @param {Uint8Array} wrapping_key
   * @returns {Uint8Array}
   */
  static unwrap_encapsulation_key(wrapped_key, wrapping_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(wrapped_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(wrapping_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_unwrap_decapsulation_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Wraps (encrypts) a PKCS8 DER encoded decapsulation (private) key using a symmetric wrapping
   * key,
   * @param {Uint8Array} decapsulation_key
   * @param {Uint8Array} wrapping_key
   * @returns {string}
   */
  static wrap_decapsulation_key(decapsulation_key, wrapping_key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(decapsulation_key, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(wrapping_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_wrap_decapsulation_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * Unwraps (decrypts) a wrapped PKCS8 DER encoded decapsulation (private) key using a symmetric
   * wrapping key.
   * @param {string} wrapped_key
   * @param {Uint8Array} wrapping_key
   * @returns {Uint8Array}
   */
  static unwrap_decapsulation_key(wrapped_key, wrapping_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(wrapped_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(wrapping_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_unwrap_decapsulation_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Encapsulates (encrypts) a symmetric key using an asymmetric encapsulation key (public key)
   * in SPKI format, returning the encapsulated key as a string. Note: This is unsigned, so
   * the sender's authenticity cannot be verified by the recipient.
   * @param {Uint8Array} shared_key
   * @param {Uint8Array} encapsulation_key
   * @returns {string}
   */
  static encapsulate_key_unsigned(shared_key, encapsulation_key) {
    let deferred4_0;
    let deferred4_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(shared_key, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(encapsulation_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_encapsulate_key_unsigned(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr3 = r0;
      var len3 = r1;
      if (r3) {
        ptr3 = 0;
        len3 = 0;
        throw takeObject(r2);
      }
      deferred4_0 = ptr3;
      deferred4_1 = len3;
      return getStringFromWasm0(ptr3, len3);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred4_0, deferred4_1, 1);
    }
  }
  /**
   * Decapsulates (decrypts) a symmetric key using an decapsulation key (private key) in PKCS8
   * DER format. Note: This is unsigned, so the sender's authenticity cannot be verified by the
   * recipient.
   * @param {string} encapsulated_key
   * @param {Uint8Array} decapsulation_key
   * @returns {Uint8Array}
   */
  static decapsulate_key_unsigned(encapsulated_key, decapsulation_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(
        encapsulated_key,
        wasm.__wbindgen_malloc,
        wasm.__wbindgen_realloc,
      );
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(decapsulation_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_decapsulate_key_unsigned(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Given a wrapped signing key and the symmetric key it is wrapped with, this returns
   * the corresponding verifying key.
   * @param {string} signing_key
   * @param {Uint8Array} wrapping_key
   * @returns {Uint8Array}
   */
  static verifying_key_for_signing_key(signing_key, wrapping_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(signing_key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(wrapping_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_verifying_key_for_signing_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Returns the algorithm used for the given verifying key.
   * @param {Uint8Array} verifying_key
   * @returns {SignatureAlgorithm}
   */
  static key_algorithm_for_verifying_key(verifying_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(verifying_key, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.purecrypto_key_algorithm_for_verifying_key(retptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * For a given signing identity (verifying key), this function verifies that the signing
   * identity claimed ownership of the public key. This is a one-sided claim and merely shows
   * that the signing identity has the intent to receive messages encrypted to the public
   * key.
   * @param {Uint8Array} signed_public_key
   * @param {Uint8Array} verifying_key
   * @returns {Uint8Array}
   */
  static verify_and_unwrap_signed_public_key(signed_public_key, verifying_key) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(signed_public_key, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(verifying_key, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_verify_and_unwrap_signed_public_key(retptr, ptr0, len0, ptr1, len1);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * Derive output of the KDF for a [bitwarden_crypto::Kdf] configuration.
   * @param {Uint8Array} password
   * @param {Uint8Array} salt
   * @param {Kdf} kdf
   * @returns {Uint8Array}
   */
  static derive_kdf_material(password, salt, kdf) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passArray8ToWasm0(password, wasm.__wbindgen_malloc);
      const len0 = WASM_VECTOR_LEN;
      const ptr1 = passArray8ToWasm0(salt, wasm.__wbindgen_malloc);
      const len1 = WASM_VECTOR_LEN;
      wasm.purecrypto_derive_kdf_material(retptr, ptr0, len0, ptr1, len1, addHeapObject(kdf));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      var v3 = getArrayU8FromWasm0(r0, r1).slice();
      wasm.__wbindgen_free(r0, r1 * 1, 1);
      return v3;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const SendAccessClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_sendaccessclient_free(ptr >>> 0, 1));

class SendAccessClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(SendAccessClient.prototype);
    obj.__wbg_ptr = ptr;
    SendAccessClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    SendAccessClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_sendaccessclient_free(ptr, 0);
  }
  /**
   * Request an access token for the provided send
   * @param {string} request
   * @returns {Promise<string>}
   */
  request_send_access_token(request) {
    const ptr0 = passStringToWasm0(request, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.sendaccessclient_request_send_access_token(this.__wbg_ptr, ptr0, len0);
    return takeObject(ret);
  }
}

const StateClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_stateclient_free(ptr >>> 0, 1));

class StateClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(StateClient.prototype);
    obj.__wbg_ptr = ptr;
    StateClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    StateClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_stateclient_free(ptr, 0);
  }
  /**
   * @param {Repository<Cipher>} store
   */
  register_cipher_repository(store) {
    wasm.stateclient_register_cipher_repository(this.__wbg_ptr, addHeapObject(store));
  }
  /**
   * @param {Repository<Folder>} store
   */
  register_folder_repository(store) {
    wasm.stateclient_register_folder_repository(this.__wbg_ptr, addHeapObject(store));
  }
}

const TotpClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_totpclient_free(ptr >>> 0, 1));

class TotpClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(TotpClient.prototype);
    obj.__wbg_ptr = ptr;
    TotpClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    TotpClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_totpclient_free(ptr, 0);
  }
  /**
   * Generates a TOTP code from a provided key
   *
   * # Arguments
   * - `key` - Can be:
   *     - A base32 encoded string
   *     - OTP Auth URI
   *     - Steam URI
   * - `time_ms` - Optional timestamp in milliseconds
   * @param {string} key
   * @param {number | null} [time_ms]
   * @returns {TotpResponse}
   */
  generate_totp(key, time_ms) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      const ptr0 = passStringToWasm0(key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len0 = WASM_VECTOR_LEN;
      wasm.totpclient_generate_totp(
        retptr,
        this.__wbg_ptr,
        ptr0,
        len0,
        !isLikeNone(time_ms),
        isLikeNone(time_ms) ? 0 : time_ms,
      );
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
}

const VaultClientFinalization =
  typeof FinalizationRegistry === "undefined"
    ? { register: () => {}, unregister: () => {} }
    : new FinalizationRegistry((ptr) => wasm.__wbg_vaultclient_free(ptr >>> 0, 1));

class VaultClient {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(VaultClient.prototype);
    obj.__wbg_ptr = ptr;
    VaultClientFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }

  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    VaultClientFinalization.unregister(this);
    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_vaultclient_free(ptr, 0);
  }
  /**
   * Attachment related operations.
   * @returns {AttachmentsClient}
   */
  attachments() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return AttachmentsClient.__wrap(ret);
  }
  /**
   * Cipher related operations.
   * @returns {CiphersClient}
   */
  ciphers() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return CiphersClient.__wrap(ret);
  }
  /**
   * Folder related operations.
   * @returns {FoldersClient}
   */
  folders() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return FoldersClient.__wrap(ret);
  }
  /**
   * TOTP related operations.
   * @returns {TotpClient}
   */
  totp() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return TotpClient.__wrap(ret);
  }
  /**
   * Collection related operations.
   * @returns {CollectionsClient}
   */
  collections() {
    const ret = wasm.vaultclient_attachments(this.__wbg_ptr);
    return CollectionsClient.__wrap(ret);
  }
}

function __wbg_String_8f0eb39a4a4c2f66(arg0, arg1) {
  const ret = String(getObject(arg1));
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbg_abort_410ec47a64ac6117(arg0, arg1) {
  getObject(arg0).abort(getObject(arg1));
}

function __wbg_abort_775ef1d17fc65868(arg0) {
  getObject(arg0).abort();
}

function __wbg_addEventListener_dc3da056b615f634(arg0, arg1, arg2, arg3) {
  getObject(arg0).addEventListener(getStringFromWasm0(arg1, arg2), getObject(arg3));
}

function __wbg_append_299d5d48292c0495() {
  return handleError(function (arg0, arg1, arg2, arg3, arg4) {
    getObject(arg0).append(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
  }, arguments);
}

function __wbg_append_8c7dd8d641a5f01b() {
  return handleError(function (arg0, arg1, arg2, arg3, arg4) {
    getObject(arg0).append(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
  }, arguments);
}

function __wbg_append_b2d1fc16de2a0e81() {
  return handleError(function (arg0, arg1, arg2, arg3, arg4, arg5) {
    getObject(arg0).append(
      getStringFromWasm0(arg1, arg2),
      getObject(arg3),
      getStringFromWasm0(arg4, arg5),
    );
  }, arguments);
}

function __wbg_append_b44785ebeb668479() {
  return handleError(function (arg0, arg1, arg2, arg3) {
    getObject(arg0).append(getStringFromWasm0(arg1, arg2), getObject(arg3));
  }, arguments);
}

function __wbg_buffer_609cc3eee51ed158(arg0) {
  const ret = getObject(arg0).buffer;
  return addHeapObject(ret);
}

function __wbg_call_672a4d21634d4a24() {
  return handleError(function (arg0, arg1) {
    const ret = getObject(arg0).call(getObject(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_call_7cccdd69e0791ae2() {
  return handleError(function (arg0, arg1, arg2) {
    const ret = getObject(arg0).call(getObject(arg1), getObject(arg2));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_clearTimeout_b1115618e821c3b2(arg0) {
  const ret = clearTimeout(takeObject(arg0));
  return addHeapObject(ret);
}

function __wbg_collectionviewnodeitem_new(arg0) {
  const ret = CollectionViewNodeItem.__wrap(arg0);
  return addHeapObject(ret);
}

function __wbg_crypto_574e78ad8b13b65f(arg0) {
  const ret = getObject(arg0).crypto;
  return addHeapObject(ret);
}

function __wbg_debug_e17b51583ca6a632(arg0, arg1, arg2, arg3) {
  console.debug(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_done_769e5ede4b31c67b(arg0) {
  const ret = getObject(arg0).done;
  return ret;
}

function __wbg_entries_3265d4158b33e5dc(arg0) {
  const ret = Object.entries(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_error_7534b8e9a36f1ab4(arg0, arg1) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg0;
    deferred0_1 = arg1;
    console.error(getStringFromWasm0(arg0, arg1));
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_error_80de38b3f7cc3c3c(arg0, arg1, arg2, arg3) {
  console.error(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_fetch_3afbdcc7ddbf16fe(arg0) {
  const ret = fetch(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_fetch_509096533071c657(arg0, arg1) {
  const ret = getObject(arg0).fetch(getObject(arg1));
  return addHeapObject(ret);
}

function __wbg_getRandomValues_38097e921c2494c3() {
  return handleError(function (arg0, arg1) {
    globalThis.crypto.getRandomValues(getArrayU8FromWasm0(arg0, arg1));
  }, arguments);
}

function __wbg_getRandomValues_b8f5dbd5f3995a9e() {
  return handleError(function (arg0, arg1) {
    getObject(arg0).getRandomValues(getObject(arg1));
  }, arguments);
}

function __wbg_getTime_46267b1c24877e30(arg0) {
  const ret = getObject(arg0).getTime();
  return ret;
}

function __wbg_get_5b8e3d66d3028864() {
  return handleError(function (arg0, arg1, arg2) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg1;
      deferred0_1 = arg2;
      const ret = getObject(arg0).get(getStringFromWasm0(arg1, arg2));
      return addHeapObject(ret);
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  }, arguments);
}

function __wbg_get_67b2ba62fc30de12() {
  return handleError(function (arg0, arg1) {
    const ret = Reflect.get(getObject(arg0), getObject(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_get_a216d449efda5b83() {
  return handleError(function (arg0, arg1, arg2) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg1;
      deferred0_1 = arg2;
      const ret = getObject(arg0).get(getStringFromWasm0(arg1, arg2));
      return addHeapObject(ret);
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  }, arguments);
}

function __wbg_get_b9b93047fe3cf45b(arg0, arg1) {
  const ret = getObject(arg0)[arg1 >>> 0];
  return addHeapObject(ret);
}

function __wbg_getaccesstoken_f04940224cf7da60(arg0) {
  const ret = getObject(arg0).get_access_token();
  return addHeapObject(ret);
}

function __wbg_getwithrefkey_1dc361bd10053bfe(arg0, arg1) {
  const ret = getObject(arg0)[getObject(arg1)];
  return addHeapObject(ret);
}

function __wbg_has_a5ea9117f258a0ec() {
  return handleError(function (arg0, arg1) {
    const ret = Reflect.has(getObject(arg0), getObject(arg1));
    return ret;
  }, arguments);
}

function __wbg_headers_9cb51cfd2ac780a4(arg0) {
  const ret = getObject(arg0).headers;
  return addHeapObject(ret);
}

function __wbg_incomingmessage_new(arg0) {
  const ret = IncomingMessage.__wrap(arg0);
  return addHeapObject(ret);
}

function __wbg_info_033d8b8a0838f1d3(arg0, arg1, arg2, arg3) {
  console.info(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_instanceof_ArrayBuffer_e14585432e3737fc(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof ArrayBuffer;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_instanceof_Map_f3469ce2244d2430(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof Map;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_instanceof_Response_f2cc20d9f7dfd644(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof Response;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_instanceof_Uint8Array_17156bcf118086a9(arg0) {
  let result;
  try {
    result = getObject(arg0) instanceof Uint8Array;
  } catch (_) {
    result = false;
  }
  const ret = result;
  return ret;
}

function __wbg_ipcclientsubscription_new(arg0) {
  const ret = IpcClientSubscription.__wrap(arg0);
  return addHeapObject(ret);
}

function __wbg_isArray_a1eab7e0d067391b(arg0) {
  const ret = Array.isArray(getObject(arg0));
  return ret;
}

function __wbg_isSafeInteger_343e2beeeece1bb0(arg0) {
  const ret = Number.isSafeInteger(getObject(arg0));
  return ret;
}

function __wbg_iterator_9a24c88df860dc65() {
  const ret = Symbol.iterator;
  return addHeapObject(ret);
}

function __wbg_length_a446193dc22c12f8(arg0) {
  const ret = getObject(arg0).length;
  return ret;
}

function __wbg_length_e2d2a49132c1b256(arg0) {
  const ret = getObject(arg0).length;
  return ret;
}

function __wbg_list_249d074235c8a7bc() {
  return handleError(function (arg0) {
    const ret = getObject(arg0).list();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_list_df32641beacaaebd() {
  return handleError(function (arg0) {
    const ret = getObject(arg0).list();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_log_cad59bb680daec67(arg0, arg1, arg2, arg3) {
  console.log(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbg_msCrypto_a61aeb35a24c1329(arg0) {
  const ret = getObject(arg0).msCrypto;
  return addHeapObject(ret);
}

function __wbg_new0_f788a2397c7ca929() {
  const ret = new Date();
  return addHeapObject(ret);
}

function __wbg_new_018dcc2d6c8c2f6a() {
  return handleError(function () {
    const ret = new Headers();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_new_23a2665fac83c611(arg0, arg1) {
  try {
    var state0 = { a: arg0, b: arg1 };
    var cb0 = (arg0, arg1) => {
      const a = state0.a;
      state0.a = 0;
      try {
        return __wbg_adapter_323(a, state0.b, arg0, arg1);
      } finally {
        state0.a = a;
      }
    };
    const ret = new Promise(cb0);
    return addHeapObject(ret);
  } finally {
    state0.a = state0.b = 0;
  }
}

function __wbg_new_405e22f390576ce2() {
  const ret = new Object();
  return addHeapObject(ret);
}

function __wbg_new_5e0be73521bc8c17() {
  const ret = new Map();
  return addHeapObject(ret);
}

function __wbg_new_78feb108b6472713() {
  const ret = new Array();
  return addHeapObject(ret);
}

function __wbg_new_8a6f238a6ece86ea() {
  const ret = new Error();
  return addHeapObject(ret);
}

function __wbg_new_9fd39a253424609a() {
  return handleError(function () {
    const ret = new FormData();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_new_a12002a7f91c75be(arg0) {
  const ret = new Uint8Array(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_new_c68d7209be747379(arg0, arg1) {
  const ret = new Error(getStringFromWasm0(arg0, arg1));
  return addHeapObject(ret);
}

function __wbg_new_e25e5aab09ff45db() {
  return handleError(function () {
    const ret = new AbortController();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_new_f24b6d53abe5bc82(arg0, arg1) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg0;
    deferred0_1 = arg1;
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_newnoargs_105ed471475aaf50(arg0, arg1) {
  const ret = new Function(getStringFromWasm0(arg0, arg1));
  return addHeapObject(ret);
}

function __wbg_newwithbyteoffsetandlength_d97e637ebe145a9a(arg0, arg1, arg2) {
  const ret = new Uint8Array(getObject(arg0), arg1 >>> 0, arg2 >>> 0);
  return addHeapObject(ret);
}

function __wbg_newwithlength_a381634e90c276d4(arg0) {
  const ret = new Uint8Array(arg0 >>> 0);
  return addHeapObject(ret);
}

function __wbg_newwithstrandinit_06c535e0a867c635() {
  return handleError(function (arg0, arg1, arg2) {
    const ret = new Request(getStringFromWasm0(arg0, arg1), getObject(arg2));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_newwithu8arraysequenceandoptions_068570c487f69127() {
  return handleError(function (arg0, arg1) {
    const ret = new Blob(getObject(arg0), getObject(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_next_25feadfc0913fea9(arg0) {
  const ret = getObject(arg0).next;
  return addHeapObject(ret);
}

function __wbg_next_6574e1a8a62d1055() {
  return handleError(function (arg0) {
    const ret = getObject(arg0).next();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_node_905d3e251edff8a2(arg0) {
  const ret = getObject(arg0).node;
  return addHeapObject(ret);
}

function __wbg_parse_def2e24ef1252aff() {
  return handleError(function (arg0, arg1) {
    const ret = JSON.parse(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_process_dc0fbacc7c1c06f7(arg0) {
  const ret = getObject(arg0).process;
  return addHeapObject(ret);
}

function __wbg_push_737cfc8c1432c2c6(arg0, arg1) {
  const ret = getObject(arg0).push(getObject(arg1));
  return ret;
}

function __wbg_queueMicrotask_97d92b4fcc8a61c5(arg0) {
  queueMicrotask(getObject(arg0));
}

function __wbg_queueMicrotask_d3219def82552485(arg0) {
  const ret = getObject(arg0).queueMicrotask;
  return addHeapObject(ret);
}

function __wbg_randomFillSync_ac0988aba3254290() {
  return handleError(function (arg0, arg1) {
    getObject(arg0).randomFillSync(takeObject(arg1));
  }, arguments);
}

function __wbg_remove_79e92e6446a637d0() {
  return handleError(function (arg0, arg1, arg2) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg1;
      deferred0_1 = arg2;
      const ret = getObject(arg0).remove(getStringFromWasm0(arg1, arg2));
      return addHeapObject(ret);
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  }, arguments);
}

function __wbg_remove_e7bec9398552d33f() {
  return handleError(function (arg0, arg1, arg2) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg1;
      deferred0_1 = arg2;
      const ret = getObject(arg0).remove(getStringFromWasm0(arg1, arg2));
      return addHeapObject(ret);
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  }, arguments);
}

function __wbg_require_60cc747a6bc5215a() {
  return handleError(function () {
    const ret = module.require;
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_resolve_4851785c9c5f573d(arg0) {
  const ret = Promise.resolve(getObject(arg0));
  return addHeapObject(ret);
}

function __wbg_send_9b8fc6bb517867dd() {
  return handleError(function (arg0, arg1) {
    const ret = getObject(arg0).send(OutgoingMessage.__wrap(arg1));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_setTimeout_ca12ead8b48245e2(arg0, arg1) {
  const ret = setTimeout(getObject(arg0), arg1);
  return addHeapObject(ret);
}

function __wbg_set_37837023f3d740e8(arg0, arg1, arg2) {
  getObject(arg0)[arg1 >>> 0] = takeObject(arg2);
}

function __wbg_set_3f1d0b984ed272ed(arg0, arg1, arg2) {
  getObject(arg0)[takeObject(arg1)] = takeObject(arg2);
}

function __wbg_set_47094df6bd728b0f() {
  return handleError(function (arg0, arg1, arg2, arg3) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg1;
      deferred0_1 = arg2;
      const ret = getObject(arg0).set(getStringFromWasm0(arg1, arg2), takeObject(arg3));
      return addHeapObject(ret);
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  }, arguments);
}

function __wbg_set_65595bdd868b3009(arg0, arg1, arg2) {
  getObject(arg0).set(getObject(arg1), arg2 >>> 0);
}

function __wbg_set_8fc6bf8a5b1071d1(arg0, arg1, arg2) {
  const ret = getObject(arg0).set(getObject(arg1), getObject(arg2));
  return addHeapObject(ret);
}

function __wbg_set_cbe909a733eef6b5() {
  return handleError(function (arg0, arg1, arg2, arg3) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg1;
      deferred0_1 = arg2;
      const ret = getObject(arg0).set(getStringFromWasm0(arg1, arg2), takeObject(arg3));
      return addHeapObject(ret);
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  }, arguments);
}

function __wbg_setbody_5923b78a95eedf29(arg0, arg1) {
  getObject(arg0).body = getObject(arg1);
}

function __wbg_setcredentials_c3a22f1cd105a2c6(arg0, arg1) {
  getObject(arg0).credentials = __wbindgen_enum_RequestCredentials[arg1];
}

function __wbg_setheaders_834c0bdb6a8949ad(arg0, arg1) {
  getObject(arg0).headers = getObject(arg1);
}

function __wbg_setmethod_3c5280fe5d890842(arg0, arg1, arg2) {
  getObject(arg0).method = getStringFromWasm0(arg1, arg2);
}

function __wbg_setmode_5dc300b865044b65(arg0, arg1) {
  getObject(arg0).mode = __wbindgen_enum_RequestMode[arg1];
}

function __wbg_setname_c0e2d6f348c746f4(arg0, arg1, arg2) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg1;
    deferred0_1 = arg2;
    getObject(arg0).name = getStringFromWasm0(arg1, arg2);
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_setsignal_75b21ef3a81de905(arg0, arg1) {
  getObject(arg0).signal = getObject(arg1);
}

function __wbg_settype_39ed370d3edd403c(arg0, arg1, arg2) {
  getObject(arg0).type = getStringFromWasm0(arg1, arg2);
}

function __wbg_setvariant_d1d41b778dfe9c17(arg0, arg1, arg2) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg1;
    deferred0_1 = arg2;
    getObject(arg0).variant = getStringFromWasm0(arg1, arg2);
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}

function __wbg_signal_aaf9ad74119f20a4(arg0) {
  const ret = getObject(arg0).signal;
  return addHeapObject(ret);
}

function __wbg_stack_0ed75d68575b0f3c(arg0, arg1) {
  const ret = getObject(arg1).stack;
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbg_static_accessor_GLOBAL_88a902d13a557d07() {
  const ret = typeof global === "undefined" ? null : global;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_static_accessor_GLOBAL_THIS_56578be7e9f832b0() {
  const ret = typeof globalThis === "undefined" ? null : globalThis;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_static_accessor_SELF_37c5d418e4bf5819() {
  const ret = typeof self === "undefined" ? null : self;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_static_accessor_WINDOW_5de37043a91a9c40() {
  const ret = typeof window === "undefined" ? null : window;
  return isLikeNone(ret) ? 0 : addHeapObject(ret);
}

function __wbg_status_f6360336ca686bf0(arg0) {
  const ret = getObject(arg0).status;
  return ret;
}

function __wbg_stringify_f7ed6987935b4a24() {
  return handleError(function (arg0) {
    const ret = JSON.stringify(getObject(arg0));
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_subarray_aa9065fa9dc5df96(arg0, arg1, arg2) {
  const ret = getObject(arg0).subarray(arg1 >>> 0, arg2 >>> 0);
  return addHeapObject(ret);
}

function __wbg_text_7805bea50de2af49() {
  return handleError(function (arg0) {
    const ret = getObject(arg0).text();
    return addHeapObject(ret);
  }, arguments);
}

function __wbg_then_44b73946d2fb3e7d(arg0, arg1) {
  const ret = getObject(arg0).then(getObject(arg1));
  return addHeapObject(ret);
}

function __wbg_then_48b406749878a531(arg0, arg1, arg2) {
  const ret = getObject(arg0).then(getObject(arg1), getObject(arg2));
  return addHeapObject(ret);
}

function __wbg_url_ae10c34ca209681d(arg0, arg1) {
  const ret = getObject(arg1).url;
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbg_value_cd1ffa7b1ab794f1(arg0) {
  const ret = getObject(arg0).value;
  return addHeapObject(ret);
}

function __wbg_versions_c01dfd4722a88165(arg0) {
  const ret = getObject(arg0).versions;
  return addHeapObject(ret);
}

function __wbg_warn_aaf1f4664a035bd6(arg0, arg1, arg2, arg3) {
  console.warn(getObject(arg0), getObject(arg1), getObject(arg2), getObject(arg3));
}

function __wbindgen_array_new() {
  const ret = [];
  return addHeapObject(ret);
}

function __wbindgen_array_push(arg0, arg1) {
  getObject(arg0).push(takeObject(arg1));
}

function __wbindgen_as_number(arg0) {
  const ret = +getObject(arg0);
  return ret;
}

function __wbindgen_bigint_from_i64(arg0) {
  const ret = arg0;
  return addHeapObject(ret);
}

function __wbindgen_bigint_from_u64(arg0) {
  const ret = BigInt.asUintN(64, arg0);
  return addHeapObject(ret);
}

function __wbindgen_bigint_get_as_i64(arg0, arg1) {
  const v = getObject(arg1);
  const ret = typeof v === "bigint" ? v : undefined;
  getDataViewMemory0().setBigInt64(arg0 + 8 * 1, isLikeNone(ret) ? BigInt(0) : ret, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
}

function __wbindgen_boolean_get(arg0) {
  const v = getObject(arg0);
  const ret = typeof v === "boolean" ? (v ? 1 : 0) : 2;
  return ret;
}

function __wbindgen_cb_drop(arg0) {
  const obj = takeObject(arg0).original;
  if (obj.cnt-- == 1) {
    obj.a = 0;
    return true;
  }
  const ret = false;
  return ret;
}

function __wbindgen_closure_wrapper3340(arg0, arg1, arg2) {
  const ret = makeMutClosure(arg0, arg1, 275, __wbg_adapter_54);
  return addHeapObject(ret);
}

function __wbindgen_closure_wrapper5705(arg0, arg1, arg2) {
  const ret = makeMutClosure(arg0, arg1, 300, __wbg_adapter_54);
  return addHeapObject(ret);
}

function __wbindgen_closure_wrapper6060(arg0, arg1, arg2) {
  const ret = makeMutClosure(arg0, arg1, 325, __wbg_adapter_59);
  return addHeapObject(ret);
}

function __wbindgen_debug_string(arg0, arg1) {
  const ret = debugString(getObject(arg1));
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbindgen_error_new(arg0, arg1) {
  const ret = new Error(getStringFromWasm0(arg0, arg1));
  return addHeapObject(ret);
}

function __wbindgen_in(arg0, arg1) {
  const ret = getObject(arg0) in getObject(arg1);
  return ret;
}

function __wbindgen_is_bigint(arg0) {
  const ret = typeof getObject(arg0) === "bigint";
  return ret;
}

function __wbindgen_is_function(arg0) {
  const ret = typeof getObject(arg0) === "function";
  return ret;
}

function __wbindgen_is_object(arg0) {
  const val = getObject(arg0);
  const ret = typeof val === "object" && val !== null;
  return ret;
}

function __wbindgen_is_string(arg0) {
  const ret = typeof getObject(arg0) === "string";
  return ret;
}

function __wbindgen_is_undefined(arg0) {
  const ret = getObject(arg0) === undefined;
  return ret;
}

function __wbindgen_jsval_eq(arg0, arg1) {
  const ret = getObject(arg0) === getObject(arg1);
  return ret;
}

function __wbindgen_jsval_loose_eq(arg0, arg1) {
  const ret = getObject(arg0) == getObject(arg1);
  return ret;
}

function __wbindgen_memory() {
  const ret = wasm.memory;
  return addHeapObject(ret);
}

function __wbindgen_number_get(arg0, arg1) {
  const obj = getObject(arg1);
  const ret = typeof obj === "number" ? obj : undefined;
  getDataViewMemory0().setFloat64(arg0 + 8 * 1, isLikeNone(ret) ? 0 : ret, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
}

function __wbindgen_number_new(arg0) {
  const ret = arg0;
  return addHeapObject(ret);
}

function __wbindgen_object_clone_ref(arg0) {
  const ret = getObject(arg0);
  return addHeapObject(ret);
}

function __wbindgen_object_drop_ref(arg0) {
  takeObject(arg0);
}

function __wbindgen_string_get(arg0, arg1) {
  const obj = getObject(arg1);
  const ret = typeof obj === "string" ? obj : undefined;
  var ptr1 = isLikeNone(ret)
    ? 0
    : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  var len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}

function __wbindgen_string_new(arg0, arg1) {
  const ret = getStringFromWasm0(arg0, arg1);
  return addHeapObject(ret);
}

function __wbindgen_throw(arg0, arg1) {
  throw new Error(getStringFromWasm0(arg0, arg1));
}


/***/ }),

/***/ 857:
/***/ ((module) => {

module.exports = require("url");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			loaded: false,
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/ensure chunk */
/******/ 	(() => {
/******/ 		__webpack_require__.f = {};
/******/ 		// This file contains only the entry chunk.
/******/ 		// The chunk loading function for additional chunks
/******/ 		__webpack_require__.e = (chunkId) => {
/******/ 			return Promise.all(Object.keys(__webpack_require__.f).reduce((promises, key) => {
/******/ 				__webpack_require__.f[key](chunkId, promises);
/******/ 				return promises;
/******/ 			}, []));
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/get javascript chunk filename */
/******/ 	(() => {
/******/ 		// This function allow to reference async chunks
/******/ 		__webpack_require__.u = (chunkId) => {
/******/ 			// return url for filenames based on template
/******/ 			return "" + chunkId + ".js";
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/harmony module decorator */
/******/ 	(() => {
/******/ 		__webpack_require__.hmd = (module) => {
/******/ 			module = Object.create(module);
/******/ 			if (!module.children) module.children = [];
/******/ 			Object.defineProperty(module, 'exports', {
/******/ 				enumerable: true,
/******/ 				set: () => {
/******/ 					throw new Error('ES Modules may not assign module.exports or exports.*, Use ESM export syntax, instead: ' + module.id);
/******/ 				}
/******/ 			});
/******/ 			return module;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/wasm loading */
/******/ 	(() => {
/******/ 		__webpack_require__.v = (exports, wasmModuleId, wasmModuleHash, importsObj) => {
/******/ 		
/******/ 			return new Promise(function (resolve, reject) {
/******/ 				try {
/******/ 					var { readFile } = require('fs');
/******/ 					var { join } = require('path');
/******/ 		
/******/ 					readFile(join(__dirname, "" + wasmModuleHash + ".module.wasm"), function(err, buffer){
/******/ 						if (err) return reject(err);
/******/ 		
/******/ 						// Fake fetch response
/******/ 						resolve({
/******/ 							arrayBuffer() { return buffer; }
/******/ 						});
/******/ 					});
/******/ 				} catch (err) { reject(err); }
/******/ 			})
/******/ 				.then((x) => (x.arrayBuffer()))
/******/ 				.then((bytes) => (WebAssembly.instantiate(bytes, importsObj)))
/******/ 				.then((res) => (Object.assign(exports, res.instance.exports)));
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/require chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded chunks
/******/ 		// "1" means "loaded", otherwise not loaded yet
/******/ 		var installedChunks = {
/******/ 			570: 1
/******/ 		};
/******/ 		
/******/ 		// no on chunks loaded
/******/ 		
/******/ 		var installChunk = (chunk) => {
/******/ 			var moreModules = chunk.modules, chunkIds = chunk.ids, runtime = chunk.runtime;
/******/ 			for(var moduleId in moreModules) {
/******/ 				if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 					__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 				}
/******/ 			}
/******/ 			if(runtime) runtime(__webpack_require__);
/******/ 			for(var i = 0; i < chunkIds.length; i++)
/******/ 				installedChunks[chunkIds[i]] = 1;
/******/ 		
/******/ 		};
/******/ 		
/******/ 		// require() chunk loading for javascript
/******/ 		__webpack_require__.f.require = (chunkId, promises) => {
/******/ 			// "1" is the signal for "already loaded"
/******/ 			if(!installedChunks[chunkId]) {
/******/ 				if(true) { // all chunks have JS
/******/ 					installChunk(require("./" + __webpack_require__.u(chunkId)));
/******/ 				} else installedChunks[chunkId] = 1;
/******/ 			}
/******/ 		};
/******/ 		
/******/ 		// no external install chunk
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};

// NAMESPACE OBJECT: ../../libs/tools/generator/core/src/engine/index.ts
var engine_namespaceObject = {};
__webpack_require__.r(engine_namespaceObject);
__webpack_require__.d(engine_namespaceObject, {
  Lq: () => (EmailCalculator),
  Mt: () => (EmailRandomizer),
  sF: () => (forwarder_context_ForwarderContext),
  q4: () => (key_service_randomizer_KeyServiceRandomizer),
  Zx: () => (PasswordRandomizer),
  zT: () => (SdkPasswordRandomizer),
  QS: () => (UsernameRandomizer)
});

// NAMESPACE OBJECT: ../../libs/tools/generator/core/src/strategies/index.ts
var strategies_namespaceObject = {};
__webpack_require__.r(strategies_namespaceObject);
__webpack_require__.d(strategies_namespaceObject, {
  B: () => (CatchallGeneratorStrategy),
  KQ: () => (EffUsernameGeneratorStrategy),
  ji: () => (ForwarderGeneratorStrategy),
  jK: () => (PassphraseGeneratorStrategy),
  gb: () => (PasswordGeneratorStrategy),
  Vm: () => (SubaddressGeneratorStrategy)
});

;// external "core-js/proposals/explicit-resource-management"
const explicit_resource_management_namespaceObject = require("core-js/proposals/explicit-resource-management");
;// external "commander"
const external_commander_namespaceObject = require("commander");
;// external "chalk"
const external_chalk_namespaceObject = require("chalk");
;// external "rxjs"
const external_rxjs_namespaceObject = require("rxjs");
;// ../../libs/common/src/auth/enums/authentication-status.ts
/**
 * The authentication status of the user
 *
 * See `AuthService.authStatusFor$` for details on how we determine the user's `AuthenticationStatus`
 */
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var authentication_status_AuthenticationStatus;
(function (AuthenticationStatus) {
    /**
     * User is not authenticated
     *  - The user does not have an active account userId and/or an access token in state
     */
    AuthenticationStatus[AuthenticationStatus["LoggedOut"] = 0] = "LoggedOut";
    /**
     * User is authenticated but not decrypted
     *  - The user has an access token, but no user key in state
     *  - Vault data cannot be decrypted (because there is no user key)
     */
    AuthenticationStatus[AuthenticationStatus["Locked"] = 1] = "Locked";
    /**
     * User is authenticated and decrypted
     *  - The user has an access token and a user key in state
     *  - Vault data can be decrypted (via user key)
     */
    AuthenticationStatus[AuthenticationStatus["Unlocked"] = 2] = "Unlocked";
})(authentication_status_AuthenticationStatus || (authentication_status_AuthenticationStatus = {}));

;// ../../libs/common/src/models/response/base.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
class BaseResponse {
    constructor(response) {
        this.response = response;
    }
    getResponseProperty(propertyName, response = null, exactName = false) {
        if (propertyName == null || propertyName === "") {
            throw new Error("propertyName must not be null/empty.");
        }
        if (response == null && this.response != null) {
            response = this.response;
        }
        if (response == null) {
            return null;
        }
        if (!exactName && response[propertyName] === undefined) {
            let otherCasePropertyName = null;
            if (propertyName.charAt(0) === propertyName.charAt(0).toUpperCase()) {
                otherCasePropertyName = propertyName.charAt(0).toLowerCase();
            }
            else {
                otherCasePropertyName = propertyName.charAt(0).toUpperCase();
            }
            if (propertyName.length > 1) {
                otherCasePropertyName += propertyName.slice(1);
            }
            propertyName = otherCasePropertyName;
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toLowerCase();
            }
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toUpperCase();
            }
        }
        return response[propertyName];
    }
}

;// ../../libs/common/src/models/response/error.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class ErrorResponse extends BaseResponse {
    constructor(response, status, identityResponse) {
        super(response);
        let errorModel = null;
        if (response != null) {
            const responseErrorModel = this.getResponseProperty("ErrorModel");
            if (responseErrorModel && identityResponse) {
                errorModel = responseErrorModel;
            }
            else {
                errorModel = response;
            }
        }
        if (status === 429) {
            this.message = "Rate limit exceeded. Try again later.";
        }
        else if (errorModel) {
            this.message = this.getResponseProperty("Message", errorModel);
            this.validationErrors = this.getResponseProperty("ValidationErrors", errorModel);
        }
        this.statusCode = status;
    }
    getSingleMessage() {
        if (this.validationErrors == null) {
            return this.message;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            if (this.validationErrors[key].length) {
                return this.validationErrors[key][0];
            }
        }
        return this.message;
    }
    getAllMessages() {
        const messages = [];
        if (this.validationErrors == null) {
            return messages;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            this.validationErrors[key].forEach((item) => {
                let prefix = "";
                if (key.indexOf("[") > -1 && key.indexOf("]") > -1) {
                    const lastSep = key.lastIndexOf(".");
                    prefix = key.substr(0, lastSep > -1 ? lastSep : key.length) + ": ";
                }
                messages.push(prefix + item);
            });
        }
        return messages;
    }
}

;// ./src/models/response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

function getErrorMessage(error) {
    if (typeof error === "string") {
        return error;
    }
    if (error instanceof ErrorResponse) {
        const message = error.getSingleMessage();
        if (message) {
            return message;
        }
    }
    if (error instanceof Error) {
        return String(error);
    }
    if (error) {
        const errorWithMessage = error; // To placate TypeScript.
        if (errorWithMessage.message && typeof errorWithMessage.message === "string") {
            return errorWithMessage.message;
        }
    }
    return JSON.stringify(error);
}
class bw_Response {
    static error(error, data) {
        const res = new bw_Response();
        res.success = false;
        res.message = getErrorMessage(error);
        res.data = data;
        return res;
    }
    static notFound() {
        return bw_Response.error("Not found.");
    }
    static noEditPermission() {
        return bw_Response.error("You do not have permission to edit this item");
    }
    static badRequest(message) {
        return bw_Response.error(message);
    }
    static multipleResults(ids) {
        let msg = "More than one result was found. Try getting a specific object by `id` instead. " +
            "The following objects were found:";
        ids.forEach((id) => {
            msg += "\n" + id;
        });
        return bw_Response.error(msg, ids);
    }
    static success(data) {
        const res = new bw_Response();
        res.success = true;
        res.data = data;
        return res;
    }
}

;// ./src/models/response/message.response.ts
class MessageResponse {
    constructor(title, message) {
        this.noColor = false;
        this.object = "message";
        this.title = title;
        this.message = message;
    }
}

;// ./src/auth/commands/lock.command.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class LockCommand {
    constructor(vaultTimeoutService) {
        this.vaultTimeoutService = vaultTimeoutService;
    }
    run() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.vaultTimeoutService.lock();
            process.env.BW_SESSION = null;
            const res = new MessageResponse("Your vault is locked.", null);
            return bw_Response.success(res);
        });
    }
}

;// external "http"
const external_http_namespaceObject = require("http");
;// external "inquirer"
const external_inquirer_namespaceObject = require("inquirer");
;// ../../libs/auth/src/common/models/domain/rotateable-key-set.ts
/**
 * A set of keys where a `UserKey` is protected by an encrypted public/private key-pair.
 * The `UserKey` is used to encrypt/decrypt data, while the public/private key-pair is
 * used to rotate the `UserKey`.
 *
 * The `PrivateKey` is protected by an `ExternalKey`, such as a `DeviceKey`, or `PrfKey`,
 * and the `PublicKey` is protected by the `UserKey`. This setup allows:
 *
 *   - Access to `UserKey` by knowing the `ExternalKey`
 *   - Rotation to a `NewUserKey` by knowing the current `UserKey`,
 *     without needing access to the `ExternalKey`
 */
class RotateableKeySet {
    constructor(
    /** PublicKey encrypted UserKey */
    encryptedUserKey, 
    /** UserKey encrypted PublicKey */
    encryptedPublicKey, 
    /** ExternalKey encrypted PrivateKey */
    encryptedPrivateKey) {
        this.encryptedUserKey = encryptedUserKey;
        this.encryptedPublicKey = encryptedPublicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// ../../libs/common/src/auth/enums/authentication-type.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var AuthenticationType;
(function (AuthenticationType) {
    AuthenticationType[AuthenticationType["Password"] = 0] = "Password";
    AuthenticationType[AuthenticationType["Sso"] = 1] = "Sso";
    AuthenticationType[AuthenticationType["UserApiKey"] = 2] = "UserApiKey";
    AuthenticationType[AuthenticationType["AuthRequest"] = 3] = "AuthRequest";
    AuthenticationType[AuthenticationType["WebAuthn"] = 4] = "WebAuthn";
})(AuthenticationType || (AuthenticationType = {}));

;// ../../libs/common/src/auth/models/request/identity-token/token-two-factor.request.ts
class TokenTwoFactorRequest {
    constructor(provider = null, token = null, remember = false) {
        this.provider = provider;
        this.token = token;
        this.remember = remember;
    }
}

;// external "path"
const external_path_namespaceObject = require("path");
;// external "buffer/"
const _namespaceObject = require("buffer/");
;// external "tldts"
const external_tldts_namespaceObject = require("tldts");
;// ../../libs/common/src/platform/misc/utils.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
/* eslint-disable no-useless-escape */




// FIXME: Remove when updating file. Eslint update
// eslint-disable-next-line @typescript-eslint/no-require-imports
const nodeURL = typeof self === "undefined" ? __webpack_require__(857) : null;
class utils_Utils {
    static init() {
        if (utils_Utils.inited) {
            return;
        }
        utils_Utils.inited = true;
        utils_Utils.isNode =
            typeof process !== "undefined" &&
                process.release != null &&
                process.release.name === "node";
        utils_Utils.isBrowser = typeof window !== "undefined";
        utils_Utils.isMobileBrowser = utils_Utils.isBrowser && this.isMobile(window);
        utils_Utils.isAppleMobileBrowser = utils_Utils.isBrowser && this.isAppleMobile(window);
        if (utils_Utils.isNode) {
            utils_Utils.global = global;
        }
        else if (utils_Utils.isBrowser) {
            utils_Utils.global = window;
        }
        else {
            // If it's not browser or node then it must be a service worker
            utils_Utils.global = self;
        }
    }
    static fromB64ToArray(str) {
        if (str == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "base64"));
        }
        else {
            const binaryString = utils_Utils.global.atob(str);
            const bytes = new Uint8Array(binaryString.length);
            for (let i = 0; i < binaryString.length; i++) {
                bytes[i] = binaryString.charCodeAt(i);
            }
            return bytes;
        }
    }
    static fromUrlB64ToArray(str) {
        return utils_Utils.fromB64ToArray(utils_Utils.fromUrlB64ToB64(str));
    }
    static fromHexToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "hex"));
        }
        else {
            const bytes = new Uint8Array(str.length / 2);
            for (let i = 0; i < str.length; i += 2) {
                bytes[i / 2] = parseInt(str.substr(i, 2), 16);
            }
            return bytes;
        }
    }
    static fromUtf8ToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "utf8"));
        }
        else {
            const strUtf8 = unescape(encodeURIComponent(str));
            const arr = new Uint8Array(strUtf8.length);
            for (let i = 0; i < strUtf8.length; i++) {
                arr[i] = strUtf8.charCodeAt(i);
            }
            return arr;
        }
    }
    static fromByteStringToArray(str) {
        if (str == null) {
            return null;
        }
        const arr = new Uint8Array(str.length);
        for (let i = 0; i < str.length; i++) {
            arr[i] = str.charCodeAt(i);
        }
        return arr;
    }
    static fromBufferToB64(buffer) {
        if (buffer == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("base64");
        }
        else {
            let binary = "";
            const bytes = new Uint8Array(buffer);
            for (let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            return utils_Utils.global.btoa(binary);
        }
    }
    static fromBufferToUrlB64(buffer) {
        return utils_Utils.fromB64toUrlB64(utils_Utils.fromBufferToB64(buffer));
    }
    static fromB64toUrlB64(b64Str) {
        return b64Str.replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
    }
    static fromBufferToUtf8(buffer) {
        return _namespaceObject.Buffer.from(buffer).toString("utf8");
    }
    static fromBufferToByteString(buffer) {
        return String.fromCharCode.apply(null, new Uint8Array(buffer));
    }
    // ref: https://stackoverflow.com/a/40031979/1090359
    static fromBufferToHex(buffer) {
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("hex");
        }
        else {
            const bytes = new Uint8Array(buffer);
            return Array.prototype.map
                .call(bytes, (x) => ("00" + x.toString(16)).slice(-2))
                .join("");
        }
    }
    /**
     * Converts a hex string to an ArrayBuffer.
     * Note: this doesn't need any Node specific code as parseInt() / ArrayBuffer / Uint8Array
     * work the same in Node and the browser.
     * @param {string} hexString - A string of hexadecimal characters.
     * @returns {ArrayBuffer} The ArrayBuffer representation of the hex string.
     */
    static hexStringToArrayBuffer(hexString) {
        // Check if the hexString has an even length, as each hex digit represents half a byte (4 bits),
        // and it takes two hex digits to represent a full byte (8 bits).
        if (hexString.length % 2 !== 0) {
            throw "HexString has to be an even length";
        }
        // Create an ArrayBuffer with a length that is half the length of the hex string,
        // because each pair of hex digits will become a single byte.
        const arrayBuffer = new ArrayBuffer(hexString.length / 2);
        // Create a Uint8Array view on top of the ArrayBuffer (each position represents a byte)
        // as ArrayBuffers cannot be edited directly.
        const uint8Array = new Uint8Array(arrayBuffer);
        // Loop through the bytes
        for (let i = 0; i < uint8Array.length; i++) {
            // Extract two hex characters (1 byte)
            const hexByte = hexString.substr(i * 2, 2);
            // Convert hexByte into a decimal value from base 16. (ex: ff --> 255)
            const byteValue = parseInt(hexByte, 16);
            // Place the byte value into the uint8Array
            uint8Array[i] = byteValue;
        }
        return arrayBuffer;
    }
    static fromUrlB64ToB64(urlB64Str) {
        let output = urlB64Str.replace(/-/g, "+").replace(/_/g, "/");
        switch (output.length % 4) {
            case 0:
                break;
            case 2:
                output += "==";
                break;
            case 3:
                output += "=";
                break;
            default:
                throw new Error("Illegal base64url string!");
        }
        return output;
    }
    static fromUrlB64ToUtf8(urlB64Str) {
        return utils_Utils.fromB64ToUtf8(utils_Utils.fromUrlB64ToB64(urlB64Str));
    }
    static fromUtf8ToB64(utfStr) {
        if (utils_Utils.isNode) {
            return Buffer.from(utfStr, "utf8").toString("base64");
        }
        else {
            return _namespaceObject.Buffer.from(utfStr, "utf8").toString("base64");
        }
    }
    static fromUtf8ToUrlB64(utfStr) {
        return utils_Utils.fromBufferToUrlB64(utils_Utils.fromUtf8ToArray(utfStr));
    }
    static fromB64ToUtf8(b64Str) {
        if (utils_Utils.isNode) {
            return Buffer.from(b64Str, "base64").toString("utf8");
        }
        else {
            return _namespaceObject.Buffer.from(b64Str, "base64").toString("utf8");
        }
    }
    // ref: http://stackoverflow.com/a/2117523/1090359
    /** @deprecated Use newGuid from @bitwarden/guid instead */
    static newGuid() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
            const r = (Math.random() * 16) | 0;
            const v = c === "x" ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    /** @deprecated Use isGuid from @bitwarden/guid instead */
    static isGuid(id) {
        return RegExp(utils_Utils.guidRegex, "i").test(id);
    }
    static getHostname(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        if (uriString.startsWith("file:")) {
            return null;
        }
        // Does uriString contain invalid characters
        // TODO Needs to possibly be extended, although '!' is a reserved character
        if (uriString.indexOf("!") > 0) {
            return null;
        }
        try {
            const hostname = (0,external_tldts_namespaceObject.getHostname)(uriString, { validHosts: this.validHosts });
            if (hostname != null) {
                return hostname;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getHost(uriString) {
        const url = utils_Utils.getUrl(uriString);
        try {
            return url != null && url.host !== "" ? url.host : null;
        }
        catch (_a) {
            return null;
        }
    }
    static getDomain(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        try {
            const parseResult = (0,external_tldts_namespaceObject.parse)(uriString, {
                validHosts: this.validHosts,
                allowPrivateDomains: true,
            });
            if (parseResult != null && parseResult.hostname != null) {
                if (parseResult.hostname === "localhost" || parseResult.isIp) {
                    return parseResult.hostname;
                }
                if (parseResult.domain != null) {
                    return parseResult.domain;
                }
                return null;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getQueryParams(uriString) {
        const url = utils_Utils.getUrl(uriString);
        if (url == null || url.search == null || url.search === "") {
            return null;
        }
        const map = new Map();
        const pairs = (url.search[0] === "?" ? url.search.substr(1) : url.search).split("&");
        pairs.forEach((pair) => {
            const parts = pair.split("=");
            if (parts.length < 1) {
                return;
            }
            map.set(decodeURIComponent(parts[0]).toLowerCase(), parts[1] == null ? "" : decodeURIComponent(parts[1]));
        });
        return map;
    }
    static getSortFunction(i18nService, prop) {
        return (a, b) => {
            if (a[prop] == null && b[prop] != null) {
                return -1;
            }
            if (a[prop] != null && b[prop] == null) {
                return 1;
            }
            if (a[prop] == null && b[prop] == null) {
                return 0;
            }
            // The `as unknown as string` here is unfortunate because typescript doesn't property understand that the return of T[prop] will be a string
            return i18nService.collator
                ? i18nService.collator.compare(a[prop], b[prop])
                : a[prop].localeCompare(b[prop]);
        };
    }
    static isNullOrWhitespace(str) {
        return str == null || typeof str !== "string" || str.trim() === "";
    }
    static isNullOrEmpty(str) {
        return str == null || typeof str !== "string" || str == "";
    }
    static isPromise(obj) {
        return (obj != undefined && typeof obj["then"] === "function" && typeof obj["catch"] === "function");
    }
    static nameOf(name) {
        return name;
    }
    static assign(target, source) {
        return Object.assign(target, source);
    }
    static iterateEnum(obj) {
        return Object.keys(obj).filter((k) => Number.isNaN(+k)).map((k) => obj[k]);
    }
    static getUrl(uriString) {
        if (this.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        return utils_Utils.getUrlObject(uriString);
    }
    static camelToPascalCase(s) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    }
    /**
     * There are a few ways to calculate text color for contrast, this one seems to fit accessibility guidelines best.
     * https://stackoverflow.com/a/3943023/6869691
     *
     * @param {string} bgColor
     * @param {number} [threshold] see stackoverflow link above
     * @param {boolean} [svgTextFill]
     * Indicates if this method is performed on an SVG <text> 'fill' attribute (e.g. <text fill="black"></text>).
     * This check is necessary because the '!important' tag cannot be used in a 'fill' attribute.
     */
    static pickTextColorBasedOnBgColor(bgColor, threshold = 186, svgTextFill = false) {
        const bgColorHexNums = bgColor.charAt(0) === "#" ? bgColor.substring(1, 7) : bgColor;
        const r = parseInt(bgColorHexNums.substring(0, 2), 16); // hexToR
        const g = parseInt(bgColorHexNums.substring(2, 4), 16); // hexToG
        const b = parseInt(bgColorHexNums.substring(4, 6), 16); // hexToB
        const blackColor = svgTextFill ? "black" : "black !important";
        const whiteColor = svgTextFill ? "white" : "white !important";
        return r * 0.299 + g * 0.587 + b * 0.114 > threshold ? blackColor : whiteColor;
    }
    static stringToColor(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = str.charCodeAt(i) + ((hash << 5) - hash);
        }
        let color = "#";
        for (let i = 0; i < 3; i++) {
            const value = (hash >> (i * 8)) & 0xff;
            color += ("00" + value.toString(16)).substr(-2);
        }
        return color;
    }
    /**
     * @throws Will throw an error if the ContainerService has not been attached to the window object
     */
    static getContainerService() {
        if (this.global.bitwardenContainerService == null) {
            throw new Error("global bitwardenContainerService not initialized.");
        }
        return this.global.bitwardenContainerService;
    }
    static validateHexColor(color) {
        return /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/.test(color);
    }
    /**
     * Converts map to a Record<string, V> with the same data. Inverse of recordToMap
     * Useful in toJSON methods, since Maps are not serializable
     * @param map
     * @returns
     */
    static mapToRecord(map) {
        if (map == null) {
            return null;
        }
        if (!(map instanceof Map)) {
            return map;
        }
        return Object.fromEntries(map);
    }
    /**
     * Converts record to a Map<string, V> with the same data. Inverse of mapToRecord
     * Useful in fromJSON methods, since Maps are not serializable
     *
     * Warning: If the record has string keys that are numbers, they will be converted to numbers in the map
     * @param record
     * @returns
     */
    static recordToMap(record) {
        if (record == null) {
            return null;
        }
        else if (record instanceof Map) {
            return record;
        }
        const entries = Object.entries(record);
        if (entries.length === 0) {
            return new Map();
        }
        if (isNaN(Number(entries[0][0]))) {
            return new Map(entries);
        }
        else {
            return new Map(entries.map((e) => [Number(e[0]), e[1]]));
        }
    }
    /** Applies Object.assign, but converts the type nicely using Type-Fest Merge<Destination, Source> */
    static merge(destination, source) {
        return Object.assign(destination, source);
    }
    /**
     * encodeURIComponent escapes all characters except the following:
     * alphabetic, decimal digits, - _ . ! ~ * ' ( )
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent#encoding_for_rfc3986
     */
    static encodeRFC3986URIComponent(str) {
        return encodeURIComponent(str).replace(/[!'()*]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
    }
    /**
     * Normalizes a path for defense against attacks like traversals
     * @param denormalizedPath
     * @returns
     */
    static normalizePath(denormalizedPath) {
        return external_path_namespaceObject.normalize(decodeURIComponent(denormalizedPath)).replace(/^(\.\.(\/|\\|$))+/, "");
    }
    static isMobile(win) {
        let mobile = false;
        ((a) => {
            if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
                /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
                mobile = true;
            }
        })(win.navigator.userAgent || win.navigator.vendor || win.opera);
        return mobile || win.navigator.userAgent.match(/iPad/i) != null;
    }
    static delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    /**
     * Generate an observable from a function that returns a promise.
     * Similar to the rxjs function {@link from} with one big exception:
     * {@link from} will not re-execute the function when observers resubscribe.
     * {@link Util.asyncToObservable} will execute `generator` for every
     * subscribe, making it ideal if the value ever needs to be refreshed.
     * */
    static asyncToObservable(generator) {
        return (0,external_rxjs_namespaceObject.of)(undefined).pipe((0,external_rxjs_namespaceObject.switchMap)(() => generator()));
    }
    /**
     * Return the number of days remaining before a target date arrives.
     * Returns 0 if the day has already passed.
     */
    static daysRemaining(targetDate) {
        const diffTime = targetDate.getTime() - Date.now();
        const msPerDay = 86400000;
        return Math.max(0, Math.floor(diffTime / msPerDay));
    }
    static isAppleMobile(win) {
        return (win.navigator.userAgent.match(/iPhone/i) != null ||
            win.navigator.userAgent.match(/iPad/i) != null);
    }
    static getUrlObject(uriString) {
        // All the methods below require a protocol to properly parse a URL string
        // Assume http if no other protocol is present
        const hasProtocol = uriString.indexOf("://") > -1;
        if (!hasProtocol && uriString.indexOf(".") > -1) {
            uriString = "http://" + uriString;
        }
        else if (!hasProtocol) {
            return null;
        }
        try {
            if (nodeURL != null) {
                return new nodeURL.URL(uriString);
            }
            return new URL(uriString);
            // FIXME: Remove when updating file. Eslint update
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
        }
        catch (e) {
            // Ignore error
        }
        return null;
    }
}
utils_Utils.inited = false;
utils_Utils.isNode = false;
utils_Utils.isBrowser = true;
utils_Utils.isMobileBrowser = false;
utils_Utils.isAppleMobileBrowser = false;
utils_Utils.global = null;
// Transpiled version of /\p{Emoji_Presentation}/gu using https://mothereff.in/regexpu. Used for compatability in older browsers.
utils_Utils.regexpEmojiPresentation = /(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])/g;
utils_Utils.validHosts = ["localhost"];
utils_Utils.originalMinimumPasswordLength = 8;
utils_Utils.minimumPasswordLength = 12;
utils_Utils.DomainMatchBlacklist = new Map([
    ["google.com", new Set(["script.google.com"])],
]);
/** @deprecated Use guidRegex from @bitwarden/guid instead */
utils_Utils.guidRegex = /^[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/;
utils_Utils.init();

;// ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-response.request.ts

class WebAuthnLoginResponseRequest {
    constructor(credential) {
        this.id = credential.id;
        this.rawId = utils_Utils.fromBufferToUrlB64(credential.rawId);
        this.type = credential.type;
        // WARNING: do not add PRF information here by mapping
        // credential.getClientExtensionResults() into the extensions property,
        // as it will be sent to the server (leaking credentials).
        this.extensions = {}; // Extensions are handled client-side
    }
}

;// ../../libs/common/src/auth/services/webauthn-login/request/webauthn-login-assertion-response.request.ts


class WebAuthnLoginAssertionResponseRequest extends WebAuthnLoginResponseRequest {
    constructor(credential) {
        super(credential);
        if (!(credential.response instanceof AuthenticatorAssertionResponse)) {
            throw new Error("Invalid authenticator response");
        }
        this.response = {
            authenticatorData: utils_Utils.fromBufferToUrlB64(credential.response.authenticatorData),
            signature: utils_Utils.fromBufferToUrlB64(credential.response.signature),
            clientDataJSON: utils_Utils.fromBufferToUrlB64(credential.response.clientDataJSON),
            userHandle: utils_Utils.fromBufferToUrlB64(credential.response.userHandle),
        };
    }
    static fromJSON(json) {
        return Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json);
    }
}

;// ../../libs/common/src/platform/enums/encryption-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var encryption_type_enum_EncryptionType;
(function (EncryptionType) {
    // Symmetric encryption types
    EncryptionType[EncryptionType["AesCbc256_B64"] = 0] = "AesCbc256_B64";
    // Type 1 was the unused and removed AesCbc128_HmacSha256_B64
    EncryptionType[EncryptionType["AesCbc256_HmacSha256_B64"] = 2] = "AesCbc256_HmacSha256_B64";
    // Cose is the encoding for the key used, but contained can be:
    // - XChaCha20Poly1305
    EncryptionType[EncryptionType["CoseEncrypt0"] = 7] = "CoseEncrypt0";
    // Asymmetric encryption types. These never occur in the same places that the symmetric ones would
    // and can be split out into a separate enum.
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_B64"] = 3] = "Rsa2048_OaepSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_B64"] = 4] = "Rsa2048_OaepSha1_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_HmacSha256_B64"] = 5] = "Rsa2048_OaepSha256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_HmacSha256_B64"] = 6] = "Rsa2048_OaepSha1_HmacSha256_B64";
})(encryption_type_enum_EncryptionType || (encryption_type_enum_EncryptionType = {}));
function encryptionTypeToString(encryptionType) {
    if (encryptionType in encryption_type_enum_EncryptionType) {
        return encryption_type_enum_EncryptionType[encryptionType];
    }
    else {
        return "Unknown encryption type " + encryptionType;
    }
}
/** The expected number of parts to a serialized EncString of the given encryption type.
 * For example, an EncString of type AesCbc256_B64 will have 2 parts
 *
 * Example of annotated serialized EncStrings:
 * 0.iv|data
 * 2.iv|data|mac
 * 3.data
 * 4.data
 *
 * @see EncString
 * @see EncryptionType
 * @see EncString.parseEncryptedString
 */
const EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE = {
    [encryption_type_enum_EncryptionType.AesCbc256_B64]: 2,
    [encryption_type_enum_EncryptionType.AesCbc256_HmacSha256_B64]: 3,
    [encryption_type_enum_EncryptionType.Rsa2048_OaepSha256_B64]: 1,
    [encryption_type_enum_EncryptionType.Rsa2048_OaepSha1_B64]: 1,
    [encryption_type_enum_EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64]: 2,
    [encryption_type_enum_EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64]: 2,
    [encryption_type_enum_EncryptionType.CoseEncrypt0]: 1,
};

;// ../../libs/common/src/platform/enums/file-upload-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var FileUploadType;
(function (FileUploadType) {
    FileUploadType[FileUploadType["Direct"] = 0] = "Direct";
    FileUploadType[FileUploadType["Azure"] = 1] = "Azure";
})(FileUploadType || (FileUploadType = {}));

;// ../../libs/common/src/platform/enums/hash-purpose.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var HashPurpose;
(function (HashPurpose) {
    HashPurpose[HashPurpose["ServerAuthorization"] = 1] = "ServerAuthorization";
    HashPurpose[HashPurpose["LocalAuthorization"] = 2] = "LocalAuthorization";
})(HashPurpose || (HashPurpose = {}));

;// ../../libs/storage-core/src/html-storage-location.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var HtmlStorageLocation;
(function (HtmlStorageLocation) {
    HtmlStorageLocation["Local"] = "local";
    HtmlStorageLocation["Memory"] = "memory";
    HtmlStorageLocation["Session"] = "session";
})(HtmlStorageLocation || (HtmlStorageLocation = {}));

;// ../../libs/storage-core/src/storage.service.ts
class StorageService {
}

;// ../../libs/storage-core/src/memory-storage.service.ts
var memory_storage_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class MemoryStorageService extends StorageService {
    constructor() {
        super(...arguments);
        this.store = new Map();
        this.updatesSubject = new external_rxjs_namespaceObject.Subject();
    }
    get valuesRequireDeserialization() {
        return false;
    }
    get updates$() {
        return this.updatesSubject.asObservable();
    }
    get(key) {
        if (this.store.has(key)) {
            const obj = this.store.get(key);
            return Promise.resolve(obj);
        }
        return Promise.resolve(null);
    }
    has(key) {
        return memory_storage_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.get(key)) != null;
        });
    }
    save(key, obj) {
        if (obj == null) {
            return this.remove(key);
        }
        // TODO: Remove once foreground/background contexts are separated in browser
        // Needed to ensure ownership of all memory by the context running the storage service
        const toStore = structuredClone(obj);
        this.store.set(key, toStore);
        this.updatesSubject.next({ key, updateType: "save" });
        return Promise.resolve();
    }
    remove(key) {
        this.store.delete(key);
        this.updatesSubject.next({ key, updateType: "remove" });
        return Promise.resolve();
    }
}

;// ../../libs/storage-core/src/serialized-memory-storage.service.ts
var serialized_memory_storage_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class SerializedMemoryStorageService extends StorageService {
    constructor() {
        super(...arguments);
        this.store = {};
        this.updatesSubject = new external_rxjs_namespaceObject.Subject();
    }
    get valuesRequireDeserialization() {
        return true;
    }
    get updates$() {
        return this.updatesSubject.asObservable();
    }
    get(key) {
        const json = this.store[key];
        if (json) {
            const obj = JSON.parse(json);
            return Promise.resolve(obj);
        }
        return Promise.resolve(null);
    }
    has(key) {
        return serialized_memory_storage_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.get(key)) != null;
        });
    }
    save(key, obj) {
        if (obj == null) {
            return this.remove(key);
        }
        // TODO: Remove once foreground/background contexts are separated in browser
        // Needed to ensure ownership of all memory by the context running the storage service
        this.store[key] = JSON.stringify(obj);
        this.updatesSubject.next({ key, updateType: "save" });
        return Promise.resolve();
    }
    remove(key) {
        delete this.store[key];
        this.updatesSubject.next({ key, updateType: "remove" });
        return Promise.resolve();
    }
}

;// ../../libs/storage-core/src/storage-location.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var StorageLocationEnum;
(function (StorageLocationEnum) {
    StorageLocationEnum["Both"] = "both";
    StorageLocationEnum["Disk"] = "disk";
    StorageLocationEnum["Memory"] = "memory";
})(StorageLocationEnum || (StorageLocationEnum = {}));

;// ../../libs/storage-core/src/storage-service.provider.ts
/**
 * A provider for getting client specific computed storage locations and services.
 */
class StorageServiceProvider {
    constructor(diskStorageService, memoryStorageService) {
        this.diskStorageService = diskStorageService;
        this.memoryStorageService = memoryStorageService;
    }
    /**
     * Computes the location and corresponding service for a given client.
     *
     * **NOTE** The default implementation does not respect client overrides and if clients
     * have special overrides they are responsible for implementing this service.
     * @param defaultLocation The default location to use if no client specific override is preferred.
     * @param overrides Client specific overrides
     * @returns The computed storage location and corresponding storage service to use to get/store state.
     * @throws If there is no configured storage service for the given inputs.
     */
    get(defaultLocation, overrides) {
        switch (defaultLocation) {
            case "disk":
                return [defaultLocation, this.diskStorageService];
            case "memory":
                return [defaultLocation, this.memoryStorageService];
            default:
                throw new Error(`Unexpected location: ${defaultLocation}`);
        }
    }
}

;// ../../libs/storage-core/src/index.ts








// Renamed to just "StorageService", to be removed when references are updated



;// ../../libs/common/src/platform/enums/html-storage-location.enum.ts


;// ../../libs/common/src/platform/enums/key-suffix-options.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var KeySuffixOptions;
(function (KeySuffixOptions) {
    KeySuffixOptions["Auto"] = "auto";
    KeySuffixOptions["Pin"] = "pin";
})(KeySuffixOptions || (KeySuffixOptions = {}));

;// ../../libs/logging/src/log-level.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var LogLevel;
(function (LogLevel) {
    LogLevel[LogLevel["Debug"] = 0] = "Debug";
    LogLevel[LogLevel["Info"] = 1] = "Info";
    LogLevel[LogLevel["Warning"] = 2] = "Warning";
    LogLevel[LogLevel["Error"] = 3] = "Error";
})(LogLevel || (LogLevel = {}));

;// ../../libs/logging/src/console-log.service.ts

class console_log_service_ConsoleLogService {
    constructor(isDev, filter = null) {
        this.isDev = isDev;
        this.filter = filter;
        this.timersMap = new Map();
    }
    debug(message, ...optionalParams) {
        if (!this.isDev) {
            return;
        }
        this.write(LogLevel.Debug, message, ...optionalParams);
    }
    info(message, ...optionalParams) {
        this.write(LogLevel.Info, message, ...optionalParams);
    }
    warning(message, ...optionalParams) {
        this.write(LogLevel.Warning, message, ...optionalParams);
    }
    error(message, ...optionalParams) {
        this.write(LogLevel.Error, message, ...optionalParams);
    }
    write(level, message, ...optionalParams) {
        if (this.filter != null && this.filter(level)) {
            return;
        }
        switch (level) {
            case LogLevel.Debug:
                // eslint-disable-next-line
                console.log(message, ...optionalParams);
                break;
            case LogLevel.Info:
                // eslint-disable-next-line
                console.log(message, ...optionalParams);
                break;
            case LogLevel.Warning:
                // eslint-disable-next-line
                console.warn(message, ...optionalParams);
                break;
            case LogLevel.Error:
                // eslint-disable-next-line
                console.error(message, ...optionalParams);
                break;
            default:
                break;
        }
    }
    measure(start, trackGroup, track, name, properties) {
        const measureName = `[${track}]: ${name}`;
        const measure = performance.measure(measureName, {
            start: start,
            detail: {
                devtools: {
                    dataType: "track-entry",
                    track,
                    trackGroup,
                    properties,
                },
            },
        });
        this.info(`${measureName} took ${measure.duration}`, properties);
        return measure;
    }
    mark(name) {
        const mark = performance.mark(name, {
            detail: {
                devtools: {
                    dataType: "marker",
                },
            },
        });
        this.info(mark.name, new Date().toISOString());
        return mark;
    }
}

;// ../../libs/logging/src/index.ts




;// ../../libs/common/src/platform/enums/log-level-type.enum.ts


;// ../../libs/common/src/platform/enums/storage-location.enum.ts


;// ../../libs/common/src/platform/enums/theme-type.enum.ts
/**
 * @deprecated prefer the `ThemeTypes` constants and `Theme` type over unsafe enum types
 **/
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ThemeType;
(function (ThemeType) {
    ThemeType["System"] = "system";
    ThemeType["Light"] = "light";
    ThemeType["Dark"] = "dark";
})(ThemeType || (ThemeType = {}));
const ThemeTypes = {
    System: "system",
    Light: "light",
    Dark: "dark",
};

;// ../../libs/common/src/platform/enums/index.ts









;// ../../libs/common/src/platform/models/domain/symmetric-crypto-key.ts


/**
 *  A symmetric crypto key represents a symmetric key usable for symmetric encryption and decryption operations.
 *  The specific algorithm used is private to the key, and should only be exposed to encrypt service implementations.
 *  This can be done via `inner()`.
 */
class SymmetricCryptoKey {
    /**
     * @param key The key in one of the permitted serialization formats
     */
    constructor(key) {
        if (key == null) {
            throw new Error("Must provide key");
        }
        if (key.byteLength === 32) {
            this.innerKey = {
                type: encryption_type_enum_EncryptionType.AesCbc256_B64,
                encryptionKey: key,
            };
            this.keyB64 = this.toBase64();
        }
        else if (key.byteLength === 64) {
            this.innerKey = {
                type: encryption_type_enum_EncryptionType.AesCbc256_HmacSha256_B64,
                encryptionKey: key.slice(0, 32),
                authenticationKey: key.slice(32),
            };
            this.keyB64 = this.toBase64();
        }
        else if (key.byteLength > 64) {
            this.innerKey = {
                type: encryption_type_enum_EncryptionType.CoseEncrypt0,
                encryptionKey: key,
            };
            this.keyB64 = this.toBase64();
        }
        else {
            throw new Error(`Unsupported encType/key length ${key.byteLength}`);
        }
    }
    toJSON() {
        // The whole object is constructed from the initial key, so just store the B64 key
        return { keyB64: this.keyB64 };
    }
    /**
     * It is preferred not to work with the raw key where possible.
     * Only use this method if absolutely necessary.
     *
     * @returns The inner key instance that can be directly used for encryption primitives
     */
    inner() {
        return this.innerKey;
    }
    /**
     * @returns The serialized key in base64 format
     */
    toBase64() {
        return utils_Utils.fromBufferToB64(this.toEncoded());
    }
    /**
     * Serializes the key to a format that can be written to state or shared
     * The currently permitted format is:
     * - AesCbc256_B64: 32 bytes (the raw key)
     * - AesCbc256_HmacSha256_B64: 64 bytes (32 bytes encryption key, 32 bytes authentication key, concatenated)
     *
     * @returns The serialized key that can be written to state or encrypted and then written to state / shared
     */
    toEncoded() {
        if (this.innerKey.type === encryption_type_enum_EncryptionType.AesCbc256_B64) {
            return this.innerKey.encryptionKey;
        }
        else if (this.innerKey.type === encryption_type_enum_EncryptionType.AesCbc256_HmacSha256_B64) {
            const encodedKey = new Uint8Array(64);
            encodedKey.set(this.innerKey.encryptionKey, 0);
            encodedKey.set(this.innerKey.authenticationKey, 32);
            return encodedKey;
        }
        else if (this.innerKey.type === encryption_type_enum_EncryptionType.CoseEncrypt0) {
            return this.innerKey.encryptionKey;
        }
        else {
            throw new Error("Unsupported encryption type.");
        }
    }
    /**
     * @param s The serialized key in base64 format
     * @returns A SymmetricCryptoKey instance
     */
    static fromString(s) {
        if (s == null) {
            return null;
        }
        const arrayBuffer = utils_Utils.fromB64ToArray(s);
        return new SymmetricCryptoKey(arrayBuffer);
    }
    static fromJSON(obj) {
        return SymmetricCryptoKey.fromString(obj === null || obj === void 0 ? void 0 : obj.keyB64);
    }
}

;// ../../libs/auth/src/common/models/domain/login-credentials.ts




class PasswordLoginCredentials {
    constructor(email, masterPassword, twoFactor, masterPasswordPoliciesFromOrgInvite) {
        this.email = email;
        this.masterPassword = masterPassword;
        this.twoFactor = twoFactor;
        this.masterPasswordPoliciesFromOrgInvite = masterPasswordPoliciesFromOrgInvite;
        this.type = AuthenticationType.Password;
    }
}
class SsoLoginCredentials {
    constructor(code, codeVerifier, redirectUrl, orgId, 
    /**
     * Optional email address for SSO login.
     * Used for looking up 2FA token on clients that support remembering 2FA token.
     */
    email, twoFactor) {
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUrl = redirectUrl;
        this.orgId = orgId;
        this.email = email;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.Sso;
    }
}
class UserApiLoginCredentials {
    constructor(clientId, clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.type = AuthenticationType.UserApiKey;
    }
}
class AuthRequestLoginCredentials {
    constructor(email, accessCode, authRequestId, decryptedUserKey, decryptedMasterKey, decryptedMasterKeyHash, twoFactor) {
        this.email = email;
        this.accessCode = accessCode;
        this.authRequestId = authRequestId;
        this.decryptedUserKey = decryptedUserKey;
        this.decryptedMasterKey = decryptedMasterKey;
        this.decryptedMasterKeyHash = decryptedMasterKeyHash;
        this.twoFactor = twoFactor;
        this.type = AuthenticationType.AuthRequest;
    }
    static fromJSON(json) {
        return Object.assign(new AuthRequestLoginCredentials(json.email, json.accessCode, json.authRequestId, null, null, json.decryptedMasterKeyHash, json.twoFactor
            ? new TokenTwoFactorRequest(json.twoFactor.provider, json.twoFactor.token, json.twoFactor.remember)
            : json.twoFactor), {
            decryptedUserKey: SymmetricCryptoKey.fromJSON(json.decryptedUserKey),
            decryptedMasterKey: SymmetricCryptoKey.fromJSON(json.decryptedMasterKey),
        });
    }
}
class WebAuthnLoginCredentials {
    constructor(token, deviceResponse, prfKey) {
        this.token = token;
        this.deviceResponse = deviceResponse;
        this.prfKey = prfKey;
        this.type = AuthenticationType.WebAuthn;
    }
    static fromJSON(json) {
        return new WebAuthnLoginCredentials(json.token, Object.assign(Object.create(WebAuthnLoginAssertionResponseRequest.prototype), json.deviceResponse), SymmetricCryptoKey.fromJSON(json.prfKey));
    }
}

;// ../../libs/auth/src/common/models/domain/user-decryption-options.ts
/**
 * Key Connector decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class KeyConnectorUserDecryptionOption {
    /**
     * Initializes a new instance of the KeyConnectorUserDecryptionOption from a response object.
     * @param response The key connector user decryption option response object.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a;
        if (response == null) {
            return undefined;
        }
        const options = new KeyConnectorUserDecryptionOption();
        options.keyConnectorUrl = (_a = response === null || response === void 0 ? void 0 : response.keyConnectorUrl) !== null && _a !== void 0 ? _a : null;
        return options;
    }
    /**
     * Initializes a new instance of a KeyConnectorUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the KeyConnectorUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new KeyConnectorUserDecryptionOption(), obj);
    }
}
/**
 * Trusted device decryption options. Intended to be sent to the client for use after authentication.
 * @see {@link UserDecryptionOptions}
 */
class TrustedDeviceUserDecryptionOption {
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a response object.
     * @param response The trusted device user decryption option response object.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `response` is nullish.
     */
    static fromResponse(response) {
        var _a, _b, _c, _d;
        if (response == null) {
            return undefined;
        }
        const options = new TrustedDeviceUserDecryptionOption();
        options.hasAdminApproval = (_a = response === null || response === void 0 ? void 0 : response.hasAdminApproval) !== null && _a !== void 0 ? _a : false;
        options.hasLoginApprovingDevice = (_b = response === null || response === void 0 ? void 0 : response.hasLoginApprovingDevice) !== null && _b !== void 0 ? _b : false;
        options.hasManageResetPasswordPermission = (_c = response === null || response === void 0 ? void 0 : response.hasManageResetPasswordPermission) !== null && _c !== void 0 ? _c : false;
        options.isTdeOffboarding = (_d = response === null || response === void 0 ? void 0 : response.isTdeOffboarding) !== null && _d !== void 0 ? _d : false;
        return options;
    }
    /**
     * Initializes a new instance of the TrustedDeviceUserDecryptionOption from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the TrustedDeviceUserDecryptionOption or undefined if `obj` is nullish.
     */
    static fromJSON(obj) {
        if (obj == null) {
            return undefined;
        }
        return Object.assign(new TrustedDeviceUserDecryptionOption(), obj);
    }
}
/**
 * Represents the decryption options the user has configured on the server. This is intended to be sent
 * to the client on authentication, and can be used to determine how to decrypt the user's vault.
 */
class UserDecryptionOptions {
    /**
     * Initializes a new instance of the UserDecryptionOptions from a response object.
     * @param response user decryption options response object
     * @returns A new instance of the UserDecryptionOptions.
     * @throws If the response is nullish, this method will throw an error. User decryption options
     * are required for client initialization.
     */
    // TODO: Change response type to `UserDecryptionOptionsResponse` after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
    static fromResponse(response) {
        if (response == null) {
            throw new Error("User Decryption Options are required for client initialization.");
        }
        const decryptionOptions = new UserDecryptionOptions();
        if (response.userDecryptionOptions) {
            // If the response has userDecryptionOptions, this means it's on a post-TDE server version and can interrogate
            // the new decryption options.
            const responseOptions = response.userDecryptionOptions;
            decryptionOptions.hasMasterPassword = responseOptions.hasMasterPassword;
            decryptionOptions.trustedDeviceOption = TrustedDeviceUserDecryptionOption.fromResponse(responseOptions.trustedDeviceOption);
            decryptionOptions.keyConnectorOption = KeyConnectorUserDecryptionOption.fromResponse(responseOptions.keyConnectorOption);
        }
        else {
            // If the response does not have userDecryptionOptions, this means it's on a pre-TDE server version and so
            // we must base our decryption options on the presence of the keyConnectorUrl.
            // Note that the presence of keyConnectorUrl implies that the user does not have a master password, as in pre-TDE
            // server versions, a master password short-circuited the addition of the keyConnectorUrl to the response.
            // TODO: remove this check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            const usingKeyConnector = response.keyConnectorUrl != null;
            decryptionOptions.hasMasterPassword = !usingKeyConnector;
            if (usingKeyConnector) {
                decryptionOptions.keyConnectorOption = new KeyConnectorUserDecryptionOption();
                decryptionOptions.keyConnectorOption.keyConnectorUrl = response.keyConnectorUrl;
            }
        }
        return decryptionOptions;
    }
    /**
     * Initializes a new instance of the UserDecryptionOptions from a JSON object.
     * @param obj JSON object to deserialize.
     * @returns A new instance of the UserDecryptionOptions. Will initialize even if the JSON object is nullish.
     */
    static fromJSON(obj) {
        const decryptionOptions = Object.assign(new UserDecryptionOptions(), obj);
        decryptionOptions.trustedDeviceOption = TrustedDeviceUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.trustedDeviceOption);
        decryptionOptions.keyConnectorOption = KeyConnectorUserDecryptionOption.fromJSON(obj === null || obj === void 0 ? void 0 : obj.keyConnectorOption);
        return decryptionOptions;
    }
}

;// ../../libs/auth/src/common/models/domain/index.ts




;// ../../libs/auth/src/common/models/spec/fake-user-decryption-options.ts

// To discourage creating new user decryption options, we don't expose a constructor.
// These helpers are for testing purposes only.
/** Testing helper for creating new instances of `UserDecryptionOptions` */
class FakeUserDecryptionOptions extends UserDecryptionOptions {
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/** Testing helper for creating new instances of `KeyConnectorUserDecryptionOption` */
class FakeKeyConnectorUserDecryptionOption extends KeyConnectorUserDecryptionOption {
    constructor(keyConnectorUrl) {
        super();
        this.keyConnectorUrl = keyConnectorUrl;
    }
}
/** Testing helper for creating new instances of `TrustedDeviceUserDecryptionOption` */
class FakeTrustedDeviceUserDecryptionOption extends TrustedDeviceUserDecryptionOption {
    constructor(hasAdminApproval, hasLoginApprovingDevice, hasManageResetPasswordPermission, isTdeOffboarding) {
        super();
        this.hasAdminApproval = hasAdminApproval;
        this.hasLoginApprovingDevice = hasLoginApprovingDevice;
        this.hasManageResetPasswordPermission = hasManageResetPasswordPermission;
        this.isTdeOffboarding = isTdeOffboarding;
    }
}

;// ../../libs/auth/src/common/models/spec/index.ts


;// ../../libs/auth/src/common/models/index.ts



;// ../../libs/serialization/src/deserialization-helpers.ts
/**
 *
 * @param elementDeserializer
 * @returns
 */
function array(elementDeserializer) {
    return (array) => {
        if (array == null) {
            return null;
        }
        return array.map((element) => elementDeserializer(element));
    };
}
/**
 *
 * @param valueDeserializer
 */
function record(valueDeserializer) {
    return (jsonValue) => {
        if (jsonValue == null) {
            return null;
        }
        const output = {};
        Object.entries(jsonValue).forEach(([key, value]) => {
            output[key] = valueDeserializer(value);
        });
        return output;
    };
}

;// ../../libs/state/src/core/key-definition.ts

/**
 * KeyDefinitions describe the precise location to store data for a given piece of state.
 * The StateDefinition is used to describe the domain of the state, and the KeyDefinition
 * sub-divides that domain into specific keys.
 */
class KeyDefinition {
    /**
     * Creates a new instance of a KeyDefinition
     * @param stateDefinition The state definition for which this key belongs to.
     * @param key The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link KeyDefinition}. All options are required.
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, key, options) {
        var _a;
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs < 0) {
            throw new Error(`'cleanupDelayMs' must be greater than or equal to 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
        // Normalize optional debug options
        const { enableUpdateLogging = false, enableRetrievalLogging = false } = (_a = options.debug) !== null && _a !== void 0 ? _a : {};
        this.debug = {
            enableUpdateLogging,
            enableRetrievalLogging,
        };
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : ((_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000);
    }
    /**
     * Creates a {@link KeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link KeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string.
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}

;// ../../libs/guid/src/index.ts
const guidRegex = /^[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i;
function newGuid() {
    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
        const r = (Math.random() * 16) | 0;
        const v = c === "x" ? r : (r & 0x3) | 0x8;
        return v.toString(16);
    });
}
function isGuid(id) {
    return guidRegex.test(id);
}

;// ../../libs/state/src/core/user-key-definition.ts
var _a;
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


const USER_KEY_DEFINITION_MARKER = Symbol("UserKeyDefinition");
class UserKeyDefinition {
    constructor(stateDefinition, key, options) {
        var _b;
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        this[_a] = true;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs < 0) {
            throw new Error(`'cleanupDelayMs' must be greater than or equal to 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
        // Filter out repeat values
        this.clearOn = Array.from(new Set(options.clearOn));
        // Normalize optional debug options
        const { enableUpdateLogging = false, enableRetrievalLogging = false } = (_b = options.debug) !== null && _b !== void 0 ? _b : {};
        this.debug = {
            enableUpdateLogging,
            enableRetrievalLogging,
        };
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _b;
        return this.options.cleanupDelayMs < 0 ? 0 : ((_b = this.options.cleanupDelayMs) !== null && _b !== void 0 ? _b : 1000);
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array
     * **unless that array is null, in which case it will return an empty list.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: array((e) => options.deserializer(e)) }));
    }
    /**
     * Creates a {@link UserKeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the UserKeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link UserKeyDefinition}.
     * @returns A {@link UserKeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string **unless that record is null, in which case it will return an record.**
     *
     * @example
     * ```typescript
     * const MY_KEY = UserKeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new UserKeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: record((v) => options.deserializer(v)) }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    buildKey(userId) {
        if (!isGuid(userId)) {
            throw new Error(`You cannot build a user key without a valid UserId, building for key ${this.fullName}`);
        }
        return `user_${userId}_${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
_a = USER_KEY_DEFINITION_MARKER;

;// ../../libs/state/src/core/user-state.ts
const activeMarker = Symbol("active");

;// ../../libs/state/src/core/state-definition.ts
/**
 * Defines the base location and instruction of where this state is expected to be located.
 */
class StateDefinition {
    /**
     * Creates a new instance of {@link StateDefinition}, the creation of which is owned by the platform team.
     * @param name The name of the state, this needs to be unique from all other {@link StateDefinition}'s.
     * @param defaultStorageLocation The location of where this state should be stored.
     */
    constructor(name, defaultStorageLocation, storageLocationOverrides) {
        this.name = name;
        this.defaultStorageLocation = defaultStorageLocation;
        this.storageLocationOverrides = storageLocationOverrides !== null && storageLocationOverrides !== void 0 ? storageLocationOverrides : {};
    }
}

;// ../../libs/state/src/core/state-definitions.ts

/**
 * `StateDefinition`s comes with some rules, to facilitate a quick review from
 * platform of this file, ensure you follow these rules, the ones marked with (tested)
 * have unit tests that you can run locally.
 *
 * 1. (tested) Names should not be null or undefined
 * 2. (tested) Name and storage location should be unique
 * 3. (tested) Name and storage location can't differ from another export by only casing
 * 4. (tested) Name should be longer than 3 characters. It should be descriptive, but brief.
 * 5. (tested) Name should not contain spaces or underscores
 * 6. Name should be human readable
 * 7. Name should be in camelCase format (unit tests ensure the first character is lowercase)
 * 8. Teams should only use state definitions they have created
 * 9. StateDefinitions should only be used for keys relating to the state name they chose
 *
 */
// Admin Console
const ORGANIZATIONS_DISK = new StateDefinition("organizations", "disk");
const POLICIES_DISK = new StateDefinition("policies", "disk");
const PROVIDERS_DISK = new StateDefinition("providers", "disk");
const ORGANIZATION_MANAGEMENT_PREFERENCES_DISK = new StateDefinition("organizationManagementPreferences", "disk", {
    web: "disk-local",
});
const DELETE_MANAGED_USER_WARNING = new StateDefinition("showDeleteManagedUserWarning", "disk", {
    web: "disk-local",
});
// Billing
const BILLING_DISK = new StateDefinition("billing", "disk");
// Auth
const ACCOUNT_DISK = new StateDefinition("account", "disk");
const ACCOUNT_MEMORY = new StateDefinition("account", "memory");
const AUTH_REQUEST_DISK_LOCAL = new StateDefinition("authRequestLocal", "disk", {
    web: "disk-local",
});
const AVATAR_DISK = new StateDefinition("avatar", "disk", { web: "disk-local" });
const DEVICE_TRUST_DISK_LOCAL = new StateDefinition("deviceTrust", "disk", {
    web: "disk-local",
    browser: "disk-backup-local-storage",
});
const KDF_CONFIG_DISK = new StateDefinition("kdfConfig", "disk");
const KEY_CONNECTOR_DISK = new StateDefinition("keyConnector", "disk");
const LOGIN_EMAIL_DISK = new StateDefinition("loginEmail", "disk", {
    web: "disk-local",
});
const LOGIN_EMAIL_MEMORY = new StateDefinition("loginEmail", "memory");
const LOGIN_STRATEGY_MEMORY = new StateDefinition("loginStrategy", "memory");
const MASTER_PASSWORD_DISK = new StateDefinition("masterPassword", "disk");
const MASTER_PASSWORD_MEMORY = new StateDefinition("masterPassword", "memory");
const PIN_DISK = new StateDefinition("pinUnlock", "disk");
const PIN_MEMORY = new StateDefinition("pinUnlock", "memory");
const ROUTER_DISK = new StateDefinition("router", "disk");
const SSO_DISK = new StateDefinition("ssoLogin", "disk");
const TOKEN_DISK = new StateDefinition("token", "disk");
const TOKEN_DISK_LOCAL = new StateDefinition("tokenDiskLocal", "disk", {
    web: "disk-local",
});
const TOKEN_MEMORY = new StateDefinition("token", "memory");
const TWO_FACTOR_MEMORY = new StateDefinition("twoFactor", "memory");
const USER_DECRYPTION_OPTIONS_DISK = new StateDefinition("userDecryptionOptions", "disk");
const ORGANIZATION_INVITE_DISK = new StateDefinition("organizationInvite", "disk");
const VAULT_TIMEOUT_SETTINGS_DISK_LOCAL = new StateDefinition("vaultTimeoutSettings", "disk", {
    web: "disk-local",
});
// Autofill
const BADGE_SETTINGS_DISK = new StateDefinition("badgeSettings", "disk");
const USER_NOTIFICATION_SETTINGS_DISK = new StateDefinition("userNotificationSettings", "disk");
const DOMAIN_SETTINGS_DISK = new StateDefinition("domainSettings", "disk");
const AUTOFILL_SETTINGS_DISK = new StateDefinition("autofillSettings", "disk");
const AUTOFILL_SETTINGS_DISK_LOCAL = new StateDefinition("autofillSettingsLocal", "disk", {
    web: "disk-local",
});
const AUTOTYPE_SETTINGS_DISK = new StateDefinition("autotypeSettings", "disk");
// Components
const NEW_WEB_LAYOUT_BANNER_DISK = new StateDefinition("newWebLayoutBanner", "disk", {
    web: "disk-local",
});
// Platform
const APPLICATION_ID_DISK = new StateDefinition("applicationId", "disk", {
    web: "disk-local",
});
const BADGE_MEMORY = new StateDefinition("badge", "memory", {
    browser: "memory-large-object",
});
const BIOMETRIC_SETTINGS_DISK = new StateDefinition("biometricSettings", "disk");
const CLEAR_EVENT_DISK = new StateDefinition("clearEvent", "disk");
const CONFIG_DISK = new StateDefinition("config", "disk", {
    web: "disk-local",
});
const CRYPTO_DISK = new StateDefinition("crypto", "disk");
const CRYPTO_MEMORY = new StateDefinition("crypto", "memory");
const DESKTOP_SETTINGS_DISK = new StateDefinition("desktopSettings", "disk");
const ENVIRONMENT_DISK = new StateDefinition("environment", "disk");
const ENVIRONMENT_MEMORY = new StateDefinition("environment", "memory");
const POPUP_VIEW_MEMORY = new StateDefinition("popupView", "memory", {
    browser: "memory-large-object",
});
const SYNC_DISK = new StateDefinition("sync", "disk", { web: "memory" });
const THEMING_DISK = new StateDefinition("theming", "disk", { web: "disk-local" });
const TRANSLATION_DISK = new StateDefinition("translation", "disk", { web: "disk-local" });
const ANIMATION_DISK = new StateDefinition("animation", "disk");
const TASK_SCHEDULER_DISK = new StateDefinition("taskScheduler", "disk");
const EXTENSION_INITIAL_INSTALL_DISK = new StateDefinition("extensionInitialInstall", "disk");
const WEB_PUSH_SUBSCRIPTION = new StateDefinition("webPushSubscription", "disk", {
    web: "disk-local",
});
// Design System
const POPUP_STYLE_DISK = new StateDefinition("popupStyle", "disk");
// Secrets Manager
const SM_ONBOARDING_DISK = new StateDefinition("smOnboarding", "disk", {
    web: "disk-local",
});
// Tools
const EXTENSION_DISK = new StateDefinition("extension", "disk");
const GENERATOR_DISK = new StateDefinition("generator", "disk");
const GENERATOR_MEMORY = new StateDefinition("generator", "memory");
const BROWSER_SEND_MEMORY = new StateDefinition("sendBrowser", "memory");
const EVENT_COLLECTION_DISK = new StateDefinition("eventCollection", "disk");
const SEND_DISK = new StateDefinition("encryptedSend", "disk", {
    web: "memory",
});
const SEND_MEMORY = new StateDefinition("decryptedSend", "memory", {
    browser: "memory-large-object",
});
const SEND_ACCESS_AUTH_MEMORY = new StateDefinition("sendAccessAuth", "memory");
// Vault
const COLLECTION_DISK = new StateDefinition("collection", "disk", {
    web: "memory",
});
const COLLECTION_MEMORY = new StateDefinition("decryptedCollections", "memory", {
    browser: "memory-large-object",
});
const FOLDER_DISK = new StateDefinition("folder", "disk", { web: "memory" });
const FOLDER_MEMORY = new StateDefinition("decryptedFolders", "memory", {
    browser: "memory-large-object",
});
const VAULT_FILTER_DISK = new StateDefinition("vaultFilter", "disk", {
    web: "disk-local",
});
const VAULT_ONBOARDING = new StateDefinition("vaultOnboarding", "disk", {
    web: "disk-local",
});
const VAULT_SETTINGS_DISK = new StateDefinition("vaultSettings", "disk", {
    web: "disk-local",
});
const VAULT_BROWSER_MEMORY = new StateDefinition("vaultBrowser", "memory", {
    browser: "memory-large-object",
});
const VAULT_SEARCH_MEMORY = new StateDefinition("vaultSearch", "memory", {
    browser: "memory-large-object",
});
const CIPHERS_DISK = new StateDefinition("ciphers", "disk", { web: "memory" });
const CIPHERS_DISK_LOCAL = new StateDefinition("ciphersLocal", "disk", {
    web: "disk-local",
});
const CIPHERS_MEMORY = new StateDefinition("ciphersMemory", "memory", {
    browser: "memory-large-object",
});
const PREMIUM_BANNER_DISK_LOCAL = new StateDefinition("premiumBannerReprompt", "disk", {
    web: "disk-local",
});
const BANNERS_DISMISSED_DISK = new StateDefinition("bannersDismissed", "disk");
const VAULT_APPEARANCE = new StateDefinition("vaultAppearance", "disk");
const SECURITY_TASKS_DISK = new StateDefinition("securityTasks", "disk");
const AT_RISK_PASSWORDS_PAGE_DISK = new StateDefinition("atRiskPasswordsPage", "disk");
const NOTIFICATION_DISK = new StateDefinition("notifications", "disk");
const NUDGES_DISK = new StateDefinition("nudges", "disk", { web: "disk-local" });
const SETUP_EXTENSION_DISMISSED_DISK = new StateDefinition("setupExtensionDismissed", "disk", {
    web: "disk-local",
});
const VAULT_BROWSER_INTRO_CAROUSEL = new StateDefinition("vaultBrowserIntroCarousel", "disk");

;// ../../libs/state/src/core/index.ts













;// ../../libs/state/src/state-migrations/migration-builder.ts
var migration_builder_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class MigrationBuilder {
    /** Create a new MigrationBuilder with an empty buffer of migrations to perform.
     *
     * Add migrations to the buffer with {@link with} and {@link rollback}.
     * @returns A new MigrationBuilder.
     */
    static create() {
        return new MigrationBuilder([]);
    }
    constructor(migrations) {
        this.migrations = migrations;
    }
    /** Add a migrator to the MigrationBuilder. Types are updated such that the chained MigrationBuilder must currently be
     * at state version equal to the from version of the migrator. Return as MigrationBuilder<TTo> where TTo is the to
     * version of the migrator, so that the next migrator can be chained.
     *
     * @param migrate A migrator class or a tuple of a migrator class, the from version, and the to version. A tuple is
     * required to instantiate version numbers unless a default constructor is defined.
     * @returns A new MigrationBuilder with the to version of the migrator as the current version.
     */
    with(...migrate) {
        return this.addMigrator(migrate, "up");
    }
    /** Add a migrator to rollback on the MigrationBuilder's list of migrations. As with {@link with}, types of
     * MigrationBuilder and Migrator must align. However, this time the migration is reversed so TCurrent of the
     * MigrationBuilder must be equal to the to version of the migrator. Return as MigrationBuilder<TFrom> where TFrom
     * is the from version of the migrator, so that the next migrator can be chained.
     *
     * @param migrate A migrator class or a tuple of a migrator class, the from version, and the to version. A tuple is
     * required to instantiate version numbers unless a default constructor is defined.
     * @returns A new MigrationBuilder with the from version of the migrator as the current version.
     */
    rollback(...migrate) {
        if (migrate.length === 3) {
            migrate = [migrate[0], migrate[2], migrate[1]];
        }
        return this.addMigrator(migrate, "down");
    }
    /** Execute the migrations as defined in the MigrationBuilder's migrator buffer */
    migrate(helper) {
        return this.migrations.reduce((promise, migrator) => promise.then(() => migration_builder_awaiter(this, void 0, void 0, function* () {
            yield this.runMigrator(migrator.migrator, helper, migrator.direction);
        })), Promise.resolve());
    }
    addMigrator(migrate, direction = "up") {
        const newMigration = migrate.length === 1
            ? { migrator: new migrate[0](), direction }
            : { migrator: new migrate[0](migrate[1], migrate[2]), direction };
        return new MigrationBuilder([...this.migrations, newMigration]);
    }
    runMigrator(migrator, helper, direction) {
        return migration_builder_awaiter(this, void 0, void 0, function* () {
            const shouldMigrate = yield migrator.shouldMigrate(helper, direction);
            helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) should migrate: ${shouldMigrate} - ${direction}`);
            if (shouldMigrate) {
                const method = direction === "up" ? migrator.migrate : migrator.rollback;
                yield method.bind(migrator)(helper);
                helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) migrated - ${direction}`);
                yield migrator.updateVersion(helper, direction);
                helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) updated version - ${direction}`);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrator.ts
var migrator_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const IRREVERSIBLE = new Error("Irreversible migration");
class Migrator {
    constructor(fromVersion, toVersion) {
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        if (fromVersion == null || toVersion == null) {
            throw new Error("Invalid migration");
        }
        if (fromVersion > toVersion) {
            throw new Error("Invalid migration");
        }
    }
    shouldMigrate(helper, direction) {
        const startVersion = direction === "up" ? this.fromVersion : this.toVersion;
        return Promise.resolve(helper.currentVersion === startVersion);
    }
    updateVersion(helper, direction) {
        return migrator_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            yield helper.set("stateVersion", endVersion);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/10-move-ever-had-user-key-to-state-providers.ts
var _10_move_ever_had_user_key_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_EVER_HAD_USER_KEY = {
    key: "everHadUserKey",
    stateDefinition: {
        name: "crypto",
    },
};
class EverHadUserKeyMigrator extends Migrator {
    migrate(helper) {
        return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.everHadUserKey;
                    yield helper.setToUser(userId, USER_EVER_HAD_USER_KEY, value !== null && value !== void 0 ? value : false);
                    if (value != null) {
                        delete account.profile.everHadUserKey;
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, USER_EVER_HAD_USER_KEY);
                    if (account) {
                        account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                            everHadUserKey: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_EVER_HAD_USER_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/11-move-org-keys-to-state-providers.ts
var _11_move_org_keys_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENCRYPTED_ORGANIZATION_KEYS = {
    key: "organizationKeys",
    stateDefinition: {
        name: "crypto",
    },
};
class OrganizationKeyMigrator extends Migrator {
    migrate(helper) {
        return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ENCRYPTED_ORGANIZATION_KEYS, value);
                        delete account.keys.organizationKeys;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, USER_ENCRYPTED_ORGANIZATION_KEYS);
                    if (account && value) {
                        account.keys = Object.assign((_a = account.keys) !== null && _a !== void 0 ? _a : {}, {
                            organizationKeys: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ENCRYPTED_ORGANIZATION_KEYS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/12-move-environment-state-to-providers.ts
var _12_move_environment_state_to_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ENVIRONMENT_STATE = { name: "environment" };
const REGION_KEY = { key: "region", stateDefinition: ENVIRONMENT_STATE };
const URLS_KEY = { key: "urls", stateDefinition: ENVIRONMENT_STATE };
class MoveEnvironmentStateToProviders extends Migrator {
    migrate(helper) {
        return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            // Move global data
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.region) != null) {
                yield helper.setToGlobal(REGION_KEY, legacyGlobal.region);
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.environmentUrls) != null) {
                yield helper.setToGlobal(URLS_KEY, legacyGlobal.environmentUrls);
            }
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _12_move_environment_state_to_providers_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b, _c, _d, _e;
                // Move account data
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.region) != null) {
                    yield helper.setToUser(userId, REGION_KEY, account.settings.region);
                }
                if (((_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? void 0 : _c.environmentUrls) != null) {
                    yield helper.setToUser(userId, URLS_KEY, account.settings.environmentUrls);
                }
                // Delete old account data
                (_d = account === null || account === void 0 ? void 0 : account.settings) === null || _d === void 0 ? true : delete _d.region;
                (_e = account === null || account === void 0 ? void 0 : account.settings) === null || _e === void 0 ? true : delete _e.environmentUrls;
                yield helper.set(userId, account);
            })));
            // Delete legacy global data
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.region;
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.environmentUrls;
            yield helper.set("global", legacyGlobal);
        });
    }
    rollback(helper) {
        return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
            let legacyGlobal = yield helper.get("global");
            let updatedLegacyGlobal = false;
            const globalRegion = yield helper.getFromGlobal(REGION_KEY);
            if (globalRegion) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.region = globalRegion;
                yield helper.setToGlobal(REGION_KEY, null);
            }
            const globalUrls = yield helper.getFromGlobal(URLS_KEY);
            if (globalUrls) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.environmentUrls = globalUrls;
                yield helper.setToGlobal(URLS_KEY, null);
            }
            if (updatedLegacyGlobal) {
                yield helper.set("global", legacyGlobal);
            }
            function rollbackUser(userId, account) {
                return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const userRegion = yield helper.getFromUser(userId, REGION_KEY);
                    if (userRegion) {
                        if (!account) {
                            account = {};
                        }
                        if (!account.settings) {
                            account.settings = {};
                        }
                        updatedAccount = true;
                        account.settings.region = userRegion;
                        yield helper.setToUser(userId, REGION_KEY, null);
                    }
                    const userUrls = yield helper.getFromUser(userId, URLS_KEY);
                    if (userUrls) {
                        if (!account) {
                            account = {};
                        }
                        if (!account.settings) {
                            account.settings = {};
                        }
                        updatedAccount = true;
                        account.settings.environmentUrls = userUrls;
                        yield helper.setToUser(userId, URLS_KEY, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/13-move-provider-keys-to-state-providers.ts
var _13_move_provider_keys_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENCRYPTED_PROVIDER_KEYS = {
    key: "providerKeys",
    stateDefinition: {
        name: "crypto",
    },
};
class ProviderKeyMigrator extends Migrator {
    migrate(helper) {
        return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.providerKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ENCRYPTED_PROVIDER_KEYS, value);
                        delete account.keys.providerKeys;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _13_move_provider_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, USER_ENCRYPTED_PROVIDER_KEYS);
                    if (account && value) {
                        account.keys = Object.assign((_a = account.keys) !== null && _a !== void 0 ? _a : {}, {
                            providerKeys: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ENCRYPTED_PROVIDER_KEYS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/14-move-biometric-client-key-half-state-to-providers.ts
var _14_move_biometric_client_key_half_state_to_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// Biometric text, no auto prompt text, fingerprint validated, and prompt cancelled are refreshed on every app start, so we don't need to migrate them
const CLIENT_KEY_HALF = {
    key: "clientKeyHalf",
    stateDefinition: { name: "biometricSettings" },
};
class MoveBiometricClientKeyHalfToStateProviders extends Migrator {
    migrate(helper) {
        return _14_move_biometric_client_key_half_state_to_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _14_move_biometric_client_key_half_state_to_providers_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b, _c;
                // Move account data
                if (((_b = account === null || account === void 0 ? void 0 : account.keys) === null || _b === void 0 ? void 0 : _b.biometricEncryptionClientKeyHalf) != null) {
                    yield helper.setToUser(userId, CLIENT_KEY_HALF, account.keys.biometricEncryptionClientKeyHalf);
                    // Delete old account data
                    (_c = account === null || account === void 0 ? void 0 : account.keys) === null || _c === void 0 ? true : delete _c.biometricEncryptionClientKeyHalf;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _14_move_biometric_client_key_half_state_to_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _14_move_biometric_client_key_half_state_to_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    let updatedAccount = false;
                    const userKeyHalf = yield helper.getFromUser(userId, CLIENT_KEY_HALF);
                    if (userKeyHalf) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.keys) !== null && _a !== void 0 ? _a : (account.keys = {});
                        updatedAccount = true;
                        account.keys.biometricEncryptionClientKeyHalf = userKeyHalf;
                        yield helper.setToUser(userId, CLIENT_KEY_HALF, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/15-move-folder-state-to-state-provider.ts
var _15_move_folder_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENCRYPTED_FOLDERS = {
    key: "folders",
    stateDefinition: {
        name: "folder",
    },
};
class FolderMigrator extends Migrator {
    migrate(helper) {
        return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.folders) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ENCRYPTED_FOLDERS, value);
                        delete account.data.folders;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _15_move_folder_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, USER_ENCRYPTED_FOLDERS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            folders: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ENCRYPTED_FOLDERS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/16-move-last-sync-to-state-provider.ts
var _16_move_last_sync_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const LAST_SYNC_KEY = {
    key: "lastSync",
    stateDefinition: {
        name: "sync",
    },
};
class LastSyncMigrator extends Migrator {
    migrate(helper) {
        return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.lastSync;
                    yield helper.setToUser(userId, LAST_SYNC_KEY, value !== null && value !== void 0 ? value : null);
                    if (value != null) {
                        delete account.profile.lastSync;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _16_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, LAST_SYNC_KEY);
                    if (account) {
                        account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                            lastSync: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, LAST_SYNC_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/17-move-enable-passkeys-to-state-providers.ts
var _17_move_enable_passkeys_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENABLE_PASSKEYS = {
    key: "enablePasskeys",
    stateDefinition: {
        name: "vaultSettings",
    },
};
class EnablePasskeysMigrator extends Migrator {
    migrate(helper) {
        return _17_move_enable_passkeys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            if ((global === null || global === void 0 ? void 0 : global.enablePasskeys) != null) {
                yield helper.setToGlobal(USER_ENABLE_PASSKEYS, global.enablePasskeys);
                global === null || global === void 0 ? true : delete global.enablePasskeys;
                yield helper.set("global", global);
            }
        });
    }
    rollback(helper) {
        return _17_move_enable_passkeys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let global = yield helper.get("global");
            const globalEnablePasskeys = yield helper.getFromGlobal(USER_ENABLE_PASSKEYS);
            if (globalEnablePasskeys != null) {
                global = Object.assign(global !== null && global !== void 0 ? global : {}, { enablePasskeys: globalEnablePasskeys });
                yield helper.set("global", global);
                yield helper.setToGlobal(USER_ENABLE_PASSKEYS, undefined);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/18-move-autofill-settings-to-state-providers.ts
var _18_move_autofill_settings_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// FIXME: Remove when updating file. Eslint update
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const AutofillOverlayVisibility = {
    Off: 0,
    OnButtonClick: 1,
    OnFieldFocus: 2,
};
const autofillSettingsStateDefinition = {
    stateDefinition: {
        name: "autofillSettings",
    },
};
class AutofillSettingsKeyMigrator extends Migrator {
    migrate(helper) {
        return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // global state (e.g. "autoFillOverlayVisibility -> inlineMenuVisibility")
            const globalState = yield helper.get("global");
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.autoFillOverlayVisibility) != null) {
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "autofillSettingsLocal",
                    },
                    key: "inlineMenuVisibility",
                }, globalState.autoFillOverlayVisibility);
                // delete `autoFillOverlayVisibility` from state global
                delete globalState.autoFillOverlayVisibility;
                yield helper.set("global", globalState);
            }
            // account state (e.g. account settings -> state provider framework keys)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updateAccount = false;
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.autoFillOnPageLoadDefault) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadDefault" }), accountSettings.autoFillOnPageLoadDefault);
                        delete account.settings.autoFillOnPageLoadDefault;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.enableAutoFillOnPageLoad) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoad" }), accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.enableAutoFillOnPageLoad);
                        delete account.settings.enableAutoFillOnPageLoad;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dismissedAutoFillOnPageLoadCallout) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadCalloutIsDismissed" }), accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dismissedAutoFillOnPageLoadCallout);
                        delete account.settings.dismissedAutoFillOnPageLoadCallout;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.disableAutoTotpCopy) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autoCopyTotp" }), 
                        // invert the value to match the new naming convention
                        !(accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.disableAutoTotpCopy));
                        delete account.settings.disableAutoTotpCopy;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.activateAutoFillOnPageLoadFromPolicy) != null) {
                        yield helper.setToUser(userId, {
                            stateDefinition: {
                                name: "autofillSettingsLocal",
                            },
                            key: "activateAutofillOnPageLoadFromPolicy",
                        }, accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.activateAutoFillOnPageLoadFromPolicy);
                        delete account.settings.activateAutoFillOnPageLoadFromPolicy;
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // global state (e.g. "inlineMenuVisibility -> autoFillOverlayVisibility")
            const globalState = (yield helper.get("global")) || {};
            const inlineMenuVisibility = yield helper.getFromGlobal({
                stateDefinition: {
                    name: "autofillSettingsLocal",
                },
                key: "inlineMenuVisibility",
            });
            if (inlineMenuVisibility) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { autoFillOverlayVisibility: inlineMenuVisibility }));
                // remove the global state provider framework key for `inlineMenuVisibility`
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "autofillSettingsLocal",
                    },
                    key: "inlineMenuVisibility",
                }, null);
            }
            // account state (e.g. state provider framework keys -> account settings)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _18_move_autofill_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updateAccount = false;
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const autoFillOnPageLoadDefault = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadDefault" }));
                    const enableAutoFillOnPageLoad = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoad" }));
                    const dismissedAutoFillOnPageLoadCallout = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadCalloutIsDismissed" }));
                    const autoCopyTotp = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autoCopyTotp" }));
                    const activateAutoFillOnPageLoadFromPolicy = yield helper.getFromUser(userId, {
                        stateDefinition: {
                            name: "autofillSettingsLocal",
                        },
                        key: "activateAutofillOnPageLoadFromPolicy",
                    });
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (autoFillOnPageLoadDefault != null) {
                        settings = Object.assign(Object.assign({}, settings), { autoFillOnPageLoadDefault });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadDefault" }), null);
                        updateAccount = true;
                    }
                    if (enableAutoFillOnPageLoad != null) {
                        settings = Object.assign(Object.assign({}, settings), { enableAutoFillOnPageLoad });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoad" }), null);
                        updateAccount = true;
                    }
                    if (dismissedAutoFillOnPageLoadCallout != null) {
                        settings = Object.assign(Object.assign({}, settings), { dismissedAutoFillOnPageLoadCallout });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autofillOnPageLoadCalloutIsDismissed" }), null);
                        updateAccount = true;
                    }
                    if (autoCopyTotp != null) {
                        // invert the value to match the new naming convention
                        settings = Object.assign(Object.assign({}, settings), { disableAutoTotpCopy: !autoCopyTotp });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsStateDefinition), { key: "autoCopyTotp" }), null);
                        updateAccount = true;
                    }
                    if (activateAutoFillOnPageLoadFromPolicy != null) {
                        settings = Object.assign(Object.assign({}, settings), { activateAutoFillOnPageLoadFromPolicy });
                        yield helper.setToUser(userId, {
                            stateDefinition: {
                                name: "autofillSettingsLocal",
                            },
                            key: "activateAutofillOnPageLoadFromPolicy",
                        }, null);
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        // commit updated settings to state
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/19-migrate-require-password-on-start.ts
var _19_migrate_require_password_on_start_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// Biometric text, no auto prompt text, fingerprint validated, and prompt cancelled are refreshed on every app start, so we don't need to migrate them
const REQUIRE_PASSWORD_ON_START = {
    key: "requirePasswordOnStart",
    stateDefinition: { name: "biometricSettings" },
};
class RequirePasswordOnStartMigrator extends Migrator {
    migrate(helper) {
        return _19_migrate_require_password_on_start_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _19_migrate_require_password_on_start_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b;
                // Move account data
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.requirePasswordOnStart) != null) {
                    yield helper.setToUser(userId, REQUIRE_PASSWORD_ON_START, account.settings.requirePasswordOnStart);
                    // Delete old account data
                    delete account.settings.requirePasswordOnStart;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _19_migrate_require_password_on_start_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _19_migrate_require_password_on_start_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const requirePassword = yield helper.getFromUser(userId, REQUIRE_PASSWORD_ON_START);
                    if (requirePassword) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.requirePasswordOnStart = requirePassword;
                        yield helper.setToUser(userId, REQUIRE_PASSWORD_ON_START, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/20-move-private-key-to-state-providers.ts
var _20_move_private_key_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENCRYPTED_PRIVATE_KEY = {
    key: "privateKey",
    stateDefinition: {
        name: "crypto",
    },
};
class PrivateKeyMigrator extends Migrator {
    migrate(helper) {
        return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.privateKey) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ENCRYPTED_PRIVATE_KEY, value);
                        delete account.keys.privateKey;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _20_move_private_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, USER_ENCRYPTED_PRIVATE_KEY);
                    if (account && value) {
                        account.keys = Object.assign((_a = account.keys) !== null && _a !== void 0 ? _a : {}, {
                            privateKey: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ENCRYPTED_PRIVATE_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/21-move-collections-state-to-state-provider.ts
var _21_move_collections_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_ENCRYPTED_COLLECTIONS = {
    key: "collections",
    stateDefinition: {
        name: "collection",
    },
};
class CollectionMigrator extends Migrator {
    migrate(helper) {
        return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.collections) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ENCRYPTED_COLLECTIONS, value);
                        delete account.data.collections;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _21_move_collections_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, USER_ENCRYPTED_COLLECTIONS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            collections: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ENCRYPTED_COLLECTIONS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/22-move-collapsed-groupings-to-state-provider.ts
var _22_move_collapsed_groupings_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const COLLAPSED_GROUPINGS = {
    key: "collapsedGroupings",
    stateDefinition: {
        name: "vaultFilter",
    },
};
class CollapsedGroupingsMigrator extends Migrator {
    migrate(helper) {
        return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.collapsedGroupings;
                    if (value != null) {
                        yield helper.setToUser(userId, COLLAPSED_GROUPINGS, value);
                        delete account.settings.collapsedGroupings;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _22_move_collapsed_groupings_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, COLLAPSED_GROUPINGS);
                    if (account) {
                        account.settings = Object.assign((_a = account.settings) !== null && _a !== void 0 ? _a : {}, {
                            collapsedGroupings: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, COLLAPSED_GROUPINGS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/23-move-biometric-prompts-to-state-providers.ts
var _23_move_biometric_prompts_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// prompt cancelled is refreshed on every app start/quit/unlock, so we don't need to migrate it
const DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT = {
    key: "dismissedBiometricRequirePasswordOnStartCallout",
    stateDefinition: { name: "biometricSettings" },
};
const PROMPT_AUTOMATICALLY = {
    key: "promptAutomatically",
    stateDefinition: { name: "biometricSettings" },
};
class MoveBiometricPromptsToStateProviders extends Migrator {
    migrate(helper) {
        return _23_move_biometric_prompts_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _23_move_biometric_prompts_to_state_providers_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b, _c, _d, _e;
                if (account == null) {
                    return;
                }
                // Move account data
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.dismissedBiometricRequirePasswordOnStartCallout) != null) {
                    yield helper.setToUser(userId, DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT, account.settings.dismissedBiometricRequirePasswordOnStartCallout);
                }
                if (((_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? void 0 : _c.disableAutoBiometricsPrompt) != null) {
                    yield helper.setToUser(userId, PROMPT_AUTOMATICALLY, !account.settings.disableAutoBiometricsPrompt);
                }
                // Delete old account data
                (_d = account === null || account === void 0 ? void 0 : account.settings) === null || _d === void 0 ? true : delete _d.dismissedBiometricRequirePasswordOnStartCallout;
                (_e = account === null || account === void 0 ? void 0 : account.settings) === null || _e === void 0 ? true : delete _e.disableAutoBiometricsPrompt;
                yield helper.set(userId, account);
            })));
        });
    }
    rollback(helper) {
        return _23_move_biometric_prompts_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _23_move_biometric_prompts_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    let updatedAccount = false;
                    const userDismissed = yield helper.getFromUser(userId, DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT);
                    if (userDismissed) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        updatedAccount = true;
                        account.settings.dismissedBiometricRequirePasswordOnStartCallout = userDismissed;
                        yield helper.setToUser(userId, DISMISSED_BIOMETRIC_REQUIRE_PASSWORD_ON_START_CALLOUT, null);
                    }
                    const userPromptAutomatically = yield helper.getFromUser(userId, PROMPT_AUTOMATICALLY);
                    if (userPromptAutomatically != null) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_b = account.settings) !== null && _b !== void 0 ? _b : (account.settings = {});
                        updatedAccount = true;
                        account.settings.disableAutoBiometricsPrompt = !userPromptAutomatically;
                        yield helper.setToUser(userId, PROMPT_AUTOMATICALLY, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/24-move-sm-onboarding-key-to-state-providers.ts
var _24_move_sm_onboarding_key_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const SM_ONBOARDING_TASKS = {
    key: "tasks",
    stateDefinition: { name: "smOnboarding" },
};
class SmOnboardingTasksMigrator extends Migrator {
    migrate(helper) {
        return _24_move_sm_onboarding_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _24_move_sm_onboarding_key_to_state_providers_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b;
                // Move account data
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.smOnboardingTasks) != null) {
                    yield helper.setToUser(userId, SM_ONBOARDING_TASKS, account.settings.smOnboardingTasks);
                    // Delete old account data
                    delete account.settings.smOnboardingTasks;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _24_move_sm_onboarding_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _24_move_sm_onboarding_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const smOnboardingTasks = yield helper.getFromUser(userId, SM_ONBOARDING_TASKS);
                    if (smOnboardingTasks) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.smOnboardingTasks = smOnboardingTasks;
                        yield helper.setToUser(userId, SM_ONBOARDING_TASKS, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/25-move-clear-clipboard-to-autofill-settings-state-provider.ts
var _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// FIXME: Remove when updating file. Eslint update
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const ClearClipboardDelay = {
    Never: null,
    TenSeconds: 10,
    TwentySeconds: 20,
    ThirtySeconds: 30,
    OneMinute: 60,
    TwoMinutes: 120,
    FiveMinutes: 300,
};
const autofillSettingsLocalStateDefinition = {
    stateDefinition: {
        name: "autofillSettingsLocal",
    },
};
class ClearClipboardDelayMigrator extends Migrator {
    migrate(helper) {
        return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. account settings -> state provider framework keys)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.clearClipboard) !== undefined) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsLocalStateDefinition), { key: "clearClipboardDelay" }), accountSettings.clearClipboard);
                        delete account.settings.clearClipboard;
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. state provider framework keys -> account settings)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _25_move_clear_clipboard_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const clearClipboardDelay = yield helper.getFromUser(userId, Object.assign(Object.assign({}, autofillSettingsLocalStateDefinition), { key: "clearClipboardDelay" }));
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (clearClipboardDelay !== undefined) {
                        settings = Object.assign(Object.assign({}, settings), { clearClipboard: clearClipboardDelay });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, autofillSettingsLocalStateDefinition), { key: "clearClipboardDelay" }), null);
                        // commit updated settings to state
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/26-revert-move-last-sync-to-state-provider.ts
var _26_revert_move_last_sync_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY = {
    key: "lastSync",
    stateDefinition: {
        name: "sync",
    },
};
class RevertLastSyncMigrator extends Migrator {
    rollback(helper) {
        return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.lastSync;
                    yield helper.setToUser(userId, _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY, value !== null && value !== void 0 ? value : null);
                    if (value != null) {
                        delete account.profile.lastSync;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
    migrate(helper) {
        return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _26_revert_move_last_sync_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY);
                    if (account) {
                        account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                            lastSync: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _26_revert_move_last_sync_to_state_provider_LAST_SYNC_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/27-move-badge-settings-to-state-providers.ts
var _27_move_badge_settings_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const enableBadgeCounterKeyDefinition = {
    stateDefinition: {
        name: "badgeSettings",
    },
    key: "enableBadgeCounter",
};
class BadgeSettingsMigrator extends Migrator {
    migrate(helper) {
        return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. account settings -> state provider framework keys)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.disableBadgeCounter) != undefined) {
                        yield helper.setToUser(userId, enableBadgeCounterKeyDefinition, !accountSettings.disableBadgeCounter);
                        delete account.settings.disableBadgeCounter;
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            // account state (e.g. state provider framework keys -> account settings)
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _27_move_badge_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const enableBadgeCounter = yield helper.getFromUser(userId, enableBadgeCounterKeyDefinition);
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (enableBadgeCounter != undefined) {
                        settings = Object.assign(Object.assign({}, settings), { disableBadgeCounter: !enableBadgeCounter });
                        yield helper.setToUser(userId, enableBadgeCounterKeyDefinition, null);
                        // commit updated settings to state
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/28-move-biometric-unlock-to-state-providers.ts
var _28_move_biometric_unlock_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const BIOMETRIC_UNLOCK_ENABLED = {
    key: "biometricUnlockEnabled",
    stateDefinition: { name: "biometricSettings" },
};
class MoveBiometricUnlockToStateProviders extends Migrator {
    migrate(helper) {
        return _28_move_biometric_unlock_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _28_move_biometric_unlock_to_state_providers_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b, _c;
                if (account == null) {
                    return;
                }
                // Move account data
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.biometricUnlock) != null) {
                    yield helper.setToUser(userId, BIOMETRIC_UNLOCK_ENABLED, account.settings.biometricUnlock);
                }
                // Delete old account data
                (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? true : delete _c.biometricUnlock;
                yield helper.set(userId, account);
            })));
        });
    }
    rollback(helper) {
        return _28_move_biometric_unlock_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _28_move_biometric_unlock_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const biometricUnlock = yield helper.getFromUser(userId, BIOMETRIC_UNLOCK_ENABLED);
                    if (biometricUnlock != null) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.biometricUnlock = biometricUnlock;
                        yield helper.setToUser(userId, BIOMETRIC_UNLOCK_ENABLED, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/29-move-user-notification-settings-to-state-provider.ts
var _29_move_user_notification_settings_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class UserNotificationSettingsKeyMigrator extends Migrator {
    migrate(helper) {
        return _29_move_user_notification_settings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = yield helper.get("global");
            // disableAddLoginNotification -> enableAddedLoginPrompt
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableAddLoginNotification) != null) {
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableAddedLoginPrompt",
                }, !globalState.disableAddLoginNotification);
                // delete `disableAddLoginNotification` from state global
                delete globalState.disableAddLoginNotification;
                yield helper.set("global", globalState);
            }
            // disableChangedPasswordNotification -> enableChangedPasswordPrompt
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableChangedPasswordNotification) != null) {
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableChangedPasswordPrompt",
                }, !globalState.disableChangedPasswordNotification);
                // delete `disableChangedPasswordNotification` from state global
                delete globalState.disableChangedPasswordNotification;
                yield helper.set("global", globalState);
            }
        });
    }
    rollback(helper) {
        return _29_move_user_notification_settings_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = (yield helper.get("global")) || {};
            const enableAddedLoginPrompt = yield helper.getFromGlobal({
                stateDefinition: {
                    name: "userNotificationSettings",
                },
                key: "enableAddedLoginPrompt",
            });
            const enableChangedPasswordPrompt = yield helper.getFromGlobal({
                stateDefinition: {
                    name: "userNotificationSettings",
                },
                key: "enableChangedPasswordPrompt",
            });
            // enableAddedLoginPrompt -> disableAddLoginNotification
            if (enableAddedLoginPrompt) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableAddLoginNotification: !enableAddedLoginPrompt }));
                // remove the global state provider framework key for `enableAddedLoginPrompt`
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableAddedLoginPrompt",
                }, null);
            }
            // enableChangedPasswordPrompt -> disableChangedPasswordNotification
            if (enableChangedPasswordPrompt) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableChangedPasswordNotification: !enableChangedPasswordPrompt }));
                // remove the global state provider framework key for `enableChangedPasswordPrompt`
                yield helper.setToGlobal({
                    stateDefinition: {
                        name: "userNotificationSettings",
                    },
                    key: "enableChangedPasswordPrompt",
                }, null);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/30-move-policy-state-to-state-provider.ts
var _30_move_policy_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var _30_move_policy_state_to_state_provider_PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["PersonalOwnership"] = 5] = "PersonalOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
})(_30_move_policy_state_to_state_provider_PolicyType || (_30_move_policy_state_to_state_provider_PolicyType = {}));
const POLICIES_KEY = {
    key: "policies",
    stateDefinition: {
        name: "policies",
    },
};
class PolicyMigrator extends Migrator {
    migrate(helper) {
        return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.policies) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, POLICIES_KEY, value);
                        delete account.data.policies;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _30_move_policy_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, POLICIES_KEY);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            policies: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, POLICIES_KEY, null);
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => rollbackAccount(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/31-move-enable-context-menu-to-autofill-settings-state-provider.ts
var _31_move_enable_context_menu_to_autofill_settings_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const enableContextMenuKeyDefinition = {
    stateDefinition: {
        name: "autofillSettings",
    },
    key: "enableContextMenu",
};
class EnableContextMenuMigrator extends Migrator {
    migrate(helper) {
        return _31_move_enable_context_menu_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = yield helper.get("global");
            // disableContextMenuItem -> enableContextMenu
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableContextMenuItem) != null) {
                yield helper.setToGlobal(enableContextMenuKeyDefinition, !globalState.disableContextMenuItem);
                // delete `disableContextMenuItem` from state global
                delete globalState.disableContextMenuItem;
                yield helper.set("global", globalState);
            }
        });
    }
    rollback(helper) {
        return _31_move_enable_context_menu_to_autofill_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalState = (yield helper.get("global")) || {};
            const enableContextMenu = yield helper.getFromGlobal(enableContextMenuKeyDefinition);
            // enableContextMenu -> disableContextMenuItem
            if (enableContextMenu != null) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableContextMenuItem: !enableContextMenu }));
                // remove the global state provider framework key for `enableContextMenu`
                yield helper.setToGlobal(enableContextMenuKeyDefinition, null);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/32-move-preferred-language.ts
var _32_move_preferred_language_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const LOCALE_KEY = {
    key: "locale",
    stateDefinition: {
        name: "translation",
    },
};
class PreferredLanguageMigrator extends Migrator {
    migrate(helper) {
        return _32_move_preferred_language_awaiter(this, void 0, void 0, function* () {
            // global state
            const global = yield helper.get("global");
            if (!(global === null || global === void 0 ? void 0 : global.locale)) {
                return;
            }
            yield helper.setToGlobal(LOCALE_KEY, global.locale);
            delete global.locale;
            yield helper.set("global", global);
        });
    }
    rollback(helper) {
        return _32_move_preferred_language_awaiter(this, void 0, void 0, function* () {
            var _a;
            const locale = yield helper.getFromGlobal(LOCALE_KEY);
            if (!locale) {
                return;
            }
            const global = (_a = (yield helper.get("global"))) !== null && _a !== void 0 ? _a : {};
            global.locale = locale;
            yield helper.set("global", global);
            yield helper.setToGlobal(LOCALE_KEY, null);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/33-move-app-id-to-state-providers.ts
var _33_move_app_id_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const APP_ID_STORAGE_KEY = "appId";
const ANONYMOUS_APP_ID_STORAGE_KEY = "anonymousAppId";
const APP_ID_KEY = {
    key: APP_ID_STORAGE_KEY,
    stateDefinition: { name: "applicationId" },
};
const ANONYMOUS_APP_ID_KEY = {
    key: ANONYMOUS_APP_ID_STORAGE_KEY,
    stateDefinition: { name: "applicationId" },
};
class AppIdMigrator extends Migrator {
    migrate(helper) {
        return _33_move_app_id_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const appId = yield helper.get(APP_ID_STORAGE_KEY);
            const anonymousAppId = yield helper.get(ANONYMOUS_APP_ID_STORAGE_KEY);
            if (appId != null) {
                yield helper.setToGlobal(APP_ID_KEY, appId);
                yield helper.set(APP_ID_STORAGE_KEY, null);
            }
            if (anonymousAppId != null) {
                yield helper.setToGlobal(ANONYMOUS_APP_ID_KEY, anonymousAppId);
                yield helper.set(ANONYMOUS_APP_ID_STORAGE_KEY, null);
            }
        });
    }
    rollback(helper) {
        return _33_move_app_id_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const appId = yield helper.getFromGlobal(APP_ID_KEY);
            const anonymousAppId = yield helper.getFromGlobal(ANONYMOUS_APP_ID_KEY);
            if (appId != null) {
                yield helper.set(APP_ID_STORAGE_KEY, appId);
                yield helper.setToGlobal(APP_ID_KEY, null);
            }
            if (anonymousAppId != null) {
                yield helper.set(ANONYMOUS_APP_ID_STORAGE_KEY, anonymousAppId);
                yield helper.setToGlobal(ANONYMOUS_APP_ID_KEY, null);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/34-move-domain-settings-to-state-providers.ts
var _34_move_domain_settings_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// FIXME: Remove when updating file. Eslint update
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const UriMatchStrategy = {
    Domain: 0,
    Host: 1,
    StartsWith: 2,
    Exact: 3,
    RegularExpression: 4,
    Never: 5,
};
const defaultUriMatchStrategyDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "defaultUriMatchStrategy",
};
const equivalentDomainsDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "equivalentDomains",
};
const neverDomainsDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "neverDomains",
};
class DomainSettingsMigrator extends Migrator {
    migrate(helper) {
        return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let updateAccount = false;
            // global state ("neverDomains")
            const globalState = yield helper.get("global");
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.neverDomains) != null) {
                yield helper.setToGlobal(neverDomainsDefinition, globalState.neverDomains);
                // delete `neverDomains` from state global
                delete globalState.neverDomains;
                yield helper.set("global", globalState);
            }
            // account state ("defaultUriMatch" and "settings.equivalentDomains")
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // migrate account state
            function migrateAccount(userId, account) {
                return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.defaultUriMatch) != undefined) {
                        yield helper.setToUser(userId, defaultUriMatchStrategyDefinition, accountSettings.defaultUriMatch);
                        delete account.settings.defaultUriMatch;
                        updateAccount = true;
                    }
                    if (((_a = accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.settings) === null || _a === void 0 ? void 0 : _a.equivalentDomains) != undefined) {
                        yield helper.setToUser(userId, equivalentDomainsDefinition, accountSettings.settings.equivalentDomains);
                        delete account.settings.settings.equivalentDomains;
                        delete account.settings.settings;
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        // update the state account settings with the migrated values deleted
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let updateAccount = false;
            // global state ("neverDomains")
            const globalState = (yield helper.get("global")) || {};
            const neverDomains = yield helper.getFromGlobal(neverDomainsDefinition);
            if (neverDomains != null) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { neverDomains: neverDomains }));
                // remove the global state provider framework key for `neverDomains`
                yield helper.setToGlobal(neverDomainsDefinition, null);
            }
            // account state ("defaultUriMatchStrategy" and "equivalentDomains")
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            // rollback account state
            function rollbackAccount(userId, account) {
                return _34_move_domain_settings_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let settings = (account === null || account === void 0 ? void 0 : account.settings) || {};
                    const defaultUriMatchStrategy = yield helper.getFromUser(userId, defaultUriMatchStrategyDefinition);
                    const equivalentDomains = yield helper.getFromUser(userId, equivalentDomainsDefinition);
                    // update new settings and remove the account state provider framework keys for the rolled back values
                    if (defaultUriMatchStrategy != null) {
                        settings = Object.assign(Object.assign({}, settings), { defaultUriMatch: defaultUriMatchStrategy });
                        yield helper.setToUser(userId, defaultUriMatchStrategyDefinition, null);
                        updateAccount = true;
                    }
                    if (equivalentDomains != null) {
                        settings = Object.assign(Object.assign({}, settings), { settings: { equivalentDomains } });
                        yield helper.setToUser(userId, equivalentDomainsDefinition, null);
                        updateAccount = true;
                    }
                    // commit updated settings to state
                    if (updateAccount) {
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/35-move-theme-to-state-providers.ts
var _35_move_theme_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const THEME_SELECTION = {
    key: "selection",
    stateDefinition: { name: "theming" },
};
class MoveThemeToStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _35_move_theme_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyGlobalState = yield helper.get("global");
            const theme = legacyGlobalState === null || legacyGlobalState === void 0 ? void 0 : legacyGlobalState.theme;
            if (theme != null) {
                yield helper.setToGlobal(THEME_SELECTION, theme);
                delete legacyGlobalState.theme;
                yield helper.set("global", legacyGlobalState);
            }
        });
    }
    rollback(helper) {
        return _35_move_theme_to_state_providers_awaiter(this, void 0, void 0, function* () {
            var _a;
            const theme = yield helper.getFromGlobal(THEME_SELECTION);
            if (theme != null) {
                const legacyGlobal = (_a = (yield helper.get("global"))) !== null && _a !== void 0 ? _a : {};
                legacyGlobal.theme = theme;
                yield helper.set("global", legacyGlobal);
                yield helper.removeFromGlobal(THEME_SELECTION);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/36-move-show-card-and-identity-to-state-provider.ts
var _36_move_show_card_and_identity_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const vaultSettingsStateDefinition = {
    stateDefinition: {
        name: "vaultSettings",
    },
};
class VaultSettingsKeyMigrator extends Migrator {
    migrate(helper) {
        return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            function migrateAccount(userId, account) {
                return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updateAccount = false;
                    const accountSettings = account === null || account === void 0 ? void 0 : account.settings;
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dontShowCardsCurrentTab) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showCardsCurrentTab" }), !accountSettings.dontShowCardsCurrentTab);
                        delete account.settings.dontShowCardsCurrentTab;
                        updateAccount = true;
                    }
                    if ((accountSettings === null || accountSettings === void 0 ? void 0 : accountSettings.dontShowIdentitiesCurrentTab) != null) {
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showIdentitiesCurrentTab" }), !accountSettings.dontShowIdentitiesCurrentTab);
                        delete account.settings.dontShowIdentitiesCurrentTab;
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
        });
    }
    rollback(helper) {
        return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            function rollbackAccount(userId, account) {
                return _36_move_show_card_and_identity_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    let updateAccount = false;
                    let settings = (_a = account === null || account === void 0 ? void 0 : account.settings) !== null && _a !== void 0 ? _a : {};
                    const showCardsCurrentTab = yield helper.getFromUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showCardsCurrentTab" }));
                    const showIdentitiesCurrentTab = yield helper.getFromUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showIdentitiesCurrentTab" }));
                    if (showCardsCurrentTab != null) {
                        // invert the value to match the new naming convention
                        settings = Object.assign(Object.assign({}, settings), { dontShowCardsCurrentTab: !showCardsCurrentTab });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showCardsCurrentTab" }), null);
                        updateAccount = true;
                    }
                    if (showIdentitiesCurrentTab != null) {
                        // invert the value to match the new naming convention
                        settings = Object.assign(Object.assign({}, settings), { dontShowIdentitiesCurrentTab: !showIdentitiesCurrentTab });
                        yield helper.setToUser(userId, Object.assign(Object.assign({}, vaultSettingsStateDefinition), { key: "showIdentitiesCurrentTab" }), null);
                        updateAccount = true;
                    }
                    if (updateAccount) {
                        yield helper.set(userId, Object.assign(Object.assign({}, account), { settings }));
                    }
                });
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/37-move-avatar-color-to-state-providers.ts
var _37_move_avatar_color_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const AVATAR_COLOR_STATE = { name: "avatar" };
const AVATAR_COLOR_KEY = {
    key: "avatarColor",
    stateDefinition: AVATAR_COLOR_STATE,
};
class AvatarColorMigrator extends Migrator {
    migrate(helper) {
        return _37_move_avatar_color_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _37_move_avatar_color_to_state_providers_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b, _c;
                // Move account avatarColor
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.avatarColor) != null) {
                    yield helper.setToUser(userId, AVATAR_COLOR_KEY, account.settings.avatarColor);
                    // Delete old account avatarColor property
                    (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? true : delete _c.avatarColor;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _37_move_avatar_color_to_state_providers_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _37_move_avatar_color_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const userAvatarColor = yield helper.getFromUser(userId, AVATAR_COLOR_KEY);
                    if (userAvatarColor) {
                        if (!account) {
                            account = {};
                        }
                        updatedAccount = true;
                        account.settings.avatarColor = userAvatarColor;
                        yield helper.setToUser(userId, AVATAR_COLOR_KEY, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/38-migrate-token-svc-to-state-provider.ts
var _38_migrate_token_svc_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL = {
    key: "emailTwoFactorTokenRecord",
    stateDefinition: {
        name: "tokenDiskLocal",
    },
};
const TOKEN_STATE_DEF_LIKE = {
    name: "token",
};
const ACCESS_TOKEN_DISK = {
    key: "accessToken", // matches KeyDefinition.key
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
const REFRESH_TOKEN_DISK = {
    key: "refreshToken",
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
const API_KEY_CLIENT_ID_DISK = {
    key: "apiKeyClientId",
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
const API_KEY_CLIENT_SECRET_DISK = {
    key: "apiKeyClientSecret",
    stateDefinition: TOKEN_STATE_DEF_LIKE,
};
class TokenServiceStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
            // Move global data
            const globalData = yield helper.get("global");
            // Create new global record for 2FA token that we can accumulate data in
            const emailTwoFactorTokenRecord = {};
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account, globalTwoFactorToken, emailTwoFactorTokenRecord) {
                return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c, _d, _e;
                    let updatedAccount = false;
                    // migrate 2FA token from global to user state
                    // Due to the existing implmentation, n users on the same device share the same global state value for 2FA token.
                    // So, we will just migrate it to all users to keep it valid for whichever was the user that set it previously.
                    // Note: don't bother migrating 2FA Token if user account or email is undefined
                    const email = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.email;
                    if (globalTwoFactorToken != undefined && account != undefined && email != undefined) {
                        emailTwoFactorTokenRecord[email] = globalTwoFactorToken;
                        // Note: don't set updatedAccount to true here as we aren't updating
                        // the legacy user state, just migrating a global state to a new user state
                    }
                    // Migrate access token
                    const existingAccessToken = (_b = account === null || account === void 0 ? void 0 : account.tokens) === null || _b === void 0 ? void 0 : _b.accessToken;
                    if (existingAccessToken != null) {
                        // Only migrate data that exists
                        if (helper.type !== "web-disk-local") {
                            // only migrate access token to session storage - never local.
                            yield helper.setToUser(userId, ACCESS_TOKEN_DISK, existingAccessToken);
                        }
                        delete account.tokens.accessToken;
                        updatedAccount = true;
                    }
                    // Migrate refresh token
                    const existingRefreshToken = (_c = account === null || account === void 0 ? void 0 : account.tokens) === null || _c === void 0 ? void 0 : _c.refreshToken;
                    if (existingRefreshToken != null) {
                        if (helper.type !== "web-disk-local") {
                            // only migrate refresh token to session storage - never local.
                            yield helper.setToUser(userId, REFRESH_TOKEN_DISK, existingRefreshToken);
                        }
                        delete account.tokens.refreshToken;
                        updatedAccount = true;
                    }
                    // Migrate API key client id
                    const existingApiKeyClientId = (_d = account === null || account === void 0 ? void 0 : account.profile) === null || _d === void 0 ? void 0 : _d.apiKeyClientId;
                    if (existingApiKeyClientId != null) {
                        if (helper.type !== "web-disk-local") {
                            // only migrate client id to session storage - never local.
                            yield helper.setToUser(userId, API_KEY_CLIENT_ID_DISK, existingApiKeyClientId);
                        }
                        delete account.profile.apiKeyClientId;
                        updatedAccount = true;
                    }
                    // Migrate API key client secret
                    const existingApiKeyClientSecret = (_e = account === null || account === void 0 ? void 0 : account.keys) === null || _e === void 0 ? void 0 : _e.apiKeyClientSecret;
                    if (existingApiKeyClientSecret != null) {
                        if (helper.type !== "web-disk-local") {
                            // only migrate client secret to session storage - never local.
                            yield helper.setToUser(userId, API_KEY_CLIENT_SECRET_DISK, existingApiKeyClientSecret);
                        }
                        delete account.keys.apiKeyClientSecret;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        // Save the migrated account only if it was updated
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([
                ...accounts.map(({ userId, account }) => migrateAccount(userId, account, globalData === null || globalData === void 0 ? void 0 : globalData.twoFactorToken, emailTwoFactorTokenRecord)),
            ]);
            // Save the global 2FA token record
            yield helper.setToGlobal(EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL, emailTwoFactorTokenRecord);
            // Delete global data
            globalData === null || globalData === void 0 ? true : delete globalData.twoFactorToken;
            yield helper.set("global", globalData);
        });
    }
    rollback(helper) {
        return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
            var _a;
            const accounts = yield helper.getAccounts();
            // Since we migrated the global 2FA token to all users, we need to rollback the 2FA token for all users
            // but we only need to set it to the global state once
            // Go through accounts and find the first user that has a non-null email and 2FA token
            let migratedTwoFactorToken = null;
            for (const { account } of accounts) {
                const email = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.email;
                if (email == null) {
                    continue;
                }
                const emailTwoFactorTokenRecord = yield helper.getFromGlobal(EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL);
                migratedTwoFactorToken = emailTwoFactorTokenRecord[email];
                if (migratedTwoFactorToken != null) {
                    break;
                }
            }
            if (migratedTwoFactorToken != null) {
                let legacyGlobal = yield helper.get("global");
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                legacyGlobal.twoFactorToken = migratedTwoFactorToken;
                yield helper.set("global", legacyGlobal);
            }
            // delete global 2FA token record
            yield helper.setToGlobal(EMAIL_TWO_FACTOR_TOKEN_RECORD_DISK_LOCAL, null);
            function rollbackAccount(userId, account) {
                return _38_migrate_token_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updatedLegacyAccount = false;
                    // Rollback access token
                    const migratedAccessToken = yield helper.getFromUser(userId, ACCESS_TOKEN_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.tokens) && migratedAccessToken != null) {
                        account.tokens.accessToken = migratedAccessToken;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, ACCESS_TOKEN_DISK, null);
                    // Rollback refresh token
                    const migratedRefreshToken = yield helper.getFromUser(userId, REFRESH_TOKEN_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.tokens) && migratedRefreshToken != null) {
                        account.tokens.refreshToken = migratedRefreshToken;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, REFRESH_TOKEN_DISK, null);
                    // Rollback API key client id
                    const migratedApiKeyClientId = yield helper.getFromUser(userId, API_KEY_CLIENT_ID_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.profile) && migratedApiKeyClientId != null) {
                        account.profile.apiKeyClientId = migratedApiKeyClientId;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, API_KEY_CLIENT_ID_DISK, null);
                    // Rollback API key client secret
                    const migratedApiKeyClientSecret = yield helper.getFromUser(userId, API_KEY_CLIENT_SECRET_DISK);
                    if ((account === null || account === void 0 ? void 0 : account.keys) && migratedApiKeyClientSecret != null) {
                        account.keys.apiKeyClientSecret = migratedApiKeyClientSecret;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, API_KEY_CLIENT_SECRET_DISK, null);
                    if (updatedLegacyAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/39-move-billing-account-profile-to-state-providers.ts
var _39_move_billing_account_profile_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const BILLING_ACCOUNT_PROFILE_KEY_DEFINITION = {
    key: "accountProfile",
    stateDefinition: {
        name: "billing",
    },
};
class MoveBillingAccountProfileMigrator extends Migrator {
    migrate(helper) {
        return _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            const migrateAccount = (userId, account) => _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d;
                const hasPremiumPersonally = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumPersonally;
                const hasPremiumFromOrganization = (_b = account === null || account === void 0 ? void 0 : account.profile) === null || _b === void 0 ? void 0 : _b.hasPremiumFromOrganization;
                if (hasPremiumPersonally != null || hasPremiumFromOrganization != null) {
                    yield helper.setToUser(userId, BILLING_ACCOUNT_PROFILE_KEY_DEFINITION, {
                        hasPremiumPersonally: hasPremiumPersonally,
                        hasPremiumFromOrganization: hasPremiumFromOrganization,
                    });
                    (_c = account === null || account === void 0 ? void 0 : account.profile) === null || _c === void 0 ? true : delete _c.hasPremiumPersonally;
                    (_d = account === null || account === void 0 ? void 0 : account.profile) === null || _d === void 0 ? true : delete _d.hasPremiumFromOrganization;
                    yield helper.set(userId, account);
                }
            });
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            const rollbackAccount = (userId, account) => _39_move_billing_account_profile_to_state_providers_awaiter(this, void 0, void 0, function* () {
                var _a;
                const value = yield helper.getFromUser(userId, BILLING_ACCOUNT_PROFILE_KEY_DEFINITION);
                if (account && value) {
                    account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                        hasPremiumPersonally: value === null || value === void 0 ? void 0 : value.hasPremiumPersonally,
                        hasPremiumFromOrganization: value === null || value === void 0 ? void 0 : value.hasPremiumFromOrganization,
                    });
                    yield helper.set(userId, account);
                }
                yield helper.setToUser(userId, BILLING_ACCOUNT_PROFILE_KEY_DEFINITION, null);
            });
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/4-remove-ever-been-unlocked.ts
var _4_remove_ever_been_unlocked_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class RemoveEverBeenUnlockedMigrator extends Migrator {
    migrate(helper) {
        return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function removeEverBeenUnlocked(userId, account) {
                return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    if (((_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.everBeenUnlocked) != null) {
                        delete account.profile.everBeenUnlocked;
                        return helper.set(userId, account);
                    }
                });
            }
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.all(accounts.map(({ userId, account }) => removeEverBeenUnlocked(userId, account)));
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/40-move-organization-state-to-state-provider.ts
var _40_move_organization_state_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// Local declarations of `OrganizationData` and the types of it's properties.
// Duplicated to remain frozen in time when migration occurs.
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(OrganizationUserStatusType || (OrganizationUserStatusType = {}));
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    OrganizationUserType[OrganizationUserType["Manager"] = 3] = "Manager";
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(OrganizationUserType || (OrganizationUserType = {}));
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
})(ProviderType || (ProviderType = {}));
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProductType;
(function (ProductType) {
    ProductType[ProductType["Free"] = 0] = "Free";
    ProductType[ProductType["Families"] = 1] = "Families";
    ProductType[ProductType["Teams"] = 2] = "Teams";
    ProductType[ProductType["Enterprise"] = 3] = "Enterprise";
    ProductType[ProductType["TeamsStarter"] = 4] = "TeamsStarter";
})(ProductType || (ProductType = {}));
const USER_ORGANIZATIONS = {
    key: "organizations",
    stateDefinition: {
        name: "organizations",
    },
};
class OrganizationMigrator extends Migrator {
    migrate(helper) {
        return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.organizations;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_ORGANIZATIONS, value);
                        delete account.data.organizations;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _40_move_organization_state_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, USER_ORGANIZATIONS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            organizations: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_ORGANIZATIONS, null);
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => rollbackAccount(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/41-move-event-collection-to-state-provider.ts
var _41_move_event_collection_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const EVENT_COLLECTION = {
    stateDefinition: {
        name: "eventCollection",
    },
    key: "eventCollection",
};
class EventCollectionMigrator extends Migrator {
    migrate(helper) {
        return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.eventCollection;
                    if (value != null) {
                        yield helper.setToUser(userId, EVENT_COLLECTION, value);
                        delete account.data.eventCollection;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _41_move_event_collection_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, EVENT_COLLECTION);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            eventCollection: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, EVENT_COLLECTION, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/42-move-enable-favicon-to-domain-settings-state-provider.ts
var _42_move_enable_favicon_to_domain_settings_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ShowFaviconDefinition = {
    stateDefinition: {
        name: "domainSettings",
    },
    key: "showFavicons",
};
class EnableFaviconMigrator extends Migrator {
    migrate(helper) {
        return _42_move_enable_favicon_to_domain_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // global state ("disableFavicon" -> "showFavicons")
            const globalState = yield helper.get("global");
            if ((globalState === null || globalState === void 0 ? void 0 : globalState.disableFavicon) != null) {
                yield helper.setToGlobal(ShowFaviconDefinition, !globalState.disableFavicon);
                // delete `disableFavicon` from state global
                delete globalState.disableFavicon;
                yield helper.set("global", globalState);
            }
        });
    }
    rollback(helper) {
        return _42_move_enable_favicon_to_domain_settings_state_provider_awaiter(this, void 0, void 0, function* () {
            // global state ("showFavicons" -> "disableFavicon")
            const globalState = (yield helper.get("global")) || {};
            const showFavicons = yield helper.getFromGlobal(ShowFaviconDefinition);
            if (showFavicons != null) {
                yield helper.set("global", Object.assign(Object.assign({}, globalState), { disableFavicon: !showFavicons }));
                // remove the global state provider framework key for `showFavicons`
                yield helper.setToGlobal(ShowFaviconDefinition, null);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/43-move-auto-confirm-finger-prints-to-state-provider.ts
var _43_move_auto_confirm_finger_prints_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ORGANIZATION_MANAGEMENT_PREFERENCES = {
    name: "organizationManagementPreferences",
};
const AUTO_CONFIRM_FINGERPRINTS = {
    key: "autoConfirmFingerPrints",
    stateDefinition: ORGANIZATION_MANAGEMENT_PREFERENCES,
};
class AutoConfirmFingerPrintsMigrator extends Migrator {
    migrate(helper) {
        return _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map((_a) => _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b, _c;
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.autoConfirmFingerPrints) != null) {
                    yield helper.setToUser(userId, AUTO_CONFIRM_FINGERPRINTS, account.settings.autoConfirmFingerPrints);
                    (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? true : delete _c.autoConfirmFingerPrints;
                    yield helper.set(userId, account);
                }
            })));
        });
    }
    rollback(helper) {
        return _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId, account) {
                return _43_move_auto_confirm_finger_prints_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const autoConfirmFingerPrints = yield helper.getFromUser(userId, AUTO_CONFIRM_FINGERPRINTS);
                    if (autoConfirmFingerPrints) {
                        if (!account) {
                            account = {};
                        }
                        updatedAccount = true;
                        account.settings.autoConfirmFingerPrints = autoConfirmFingerPrints;
                        yield helper.setToUser(userId, AUTO_CONFIRM_FINGERPRINTS, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/44-move-user-decryption-options-to-state-provider.ts
var _44_move_user_decryption_options_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const USER_DECRYPTION_OPTIONS = {
    key: "decryptionOptions",
    stateDefinition: {
        name: "userDecryptionOptions",
    },
};
class UserDecryptionOptionsMigrator extends Migrator {
    migrate(helper) {
        return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = account === null || account === void 0 ? void 0 : account.decryptionOptions;
                    if (value != null) {
                        yield helper.setToUser(userId, USER_DECRYPTION_OPTIONS, value);
                        delete account.decryptionOptions;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _44_move_user_decryption_options_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, USER_DECRYPTION_OPTIONS);
                    if (account) {
                        account.decryptionOptions = Object.assign(account.decryptionOptions, value);
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, USER_DECRYPTION_OPTIONS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/45-merge-environment-state.ts
var _45_merge_environment_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _45_merge_environment_state_ENVIRONMENT_STATE = { name: "environment" };
const ENVIRONMENT_REGION = {
    key: "region",
    stateDefinition: _45_merge_environment_state_ENVIRONMENT_STATE,
};
const ENVIRONMENT_URLS = {
    key: "urls",
    stateDefinition: _45_merge_environment_state_ENVIRONMENT_STATE,
};
const ENVIRONMENT_ENVIRONMENT = {
    key: "environment",
    stateDefinition: _45_merge_environment_state_ENVIRONMENT_STATE,
};
class MergeEnvironmentState extends Migrator {
    migrate(helper) {
        return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
                    const region = yield helper.getFromUser(userId, ENVIRONMENT_REGION);
                    const urls = yield helper.getFromUser(userId, ENVIRONMENT_URLS);
                    if (region == null && urls == null) {
                        return;
                    }
                    yield helper.setToUser(userId, ENVIRONMENT_ENVIRONMENT, {
                        region,
                        urls,
                    });
                    yield helper.removeFromUser(userId, ENVIRONMENT_REGION);
                    yield helper.removeFromUser(userId, ENVIRONMENT_URLS);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            const region = yield helper.getFromGlobal(ENVIRONMENT_REGION);
            const urls = yield helper.getFromGlobal(ENVIRONMENT_URLS);
            if (region == null && urls == null) {
                return;
            }
            yield helper.setToGlobal(ENVIRONMENT_ENVIRONMENT, {
                region,
                urls,
            });
            yield helper.removeFromGlobal(ENVIRONMENT_REGION);
            yield helper.removeFromGlobal(ENVIRONMENT_URLS);
        });
    }
    rollback(helper) {
        return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _45_merge_environment_state_awaiter(this, void 0, void 0, function* () {
                    const state = (yield helper.getFromUser(userId, ENVIRONMENT_ENVIRONMENT));
                    yield helper.setToUser(userId, ENVIRONMENT_REGION, state === null || state === void 0 ? void 0 : state.region);
                    yield helper.setToUser(userId, ENVIRONMENT_URLS, state === null || state === void 0 ? void 0 : state.urls);
                    yield helper.removeFromUser(userId, ENVIRONMENT_ENVIRONMENT);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
            const state = (yield helper.getFromGlobal(ENVIRONMENT_ENVIRONMENT));
            yield helper.setToGlobal(ENVIRONMENT_REGION, state === null || state === void 0 ? void 0 : state.region);
            yield helper.setToGlobal(ENVIRONMENT_URLS, state === null || state === void 0 ? void 0 : state.urls);
            yield helper.removeFromGlobal(ENVIRONMENT_ENVIRONMENT);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/46-delete-orphaned-biometric-prompt-data.ts
var _46_delete_orphaned_biometric_prompt_data_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const PROMPT_CANCELLED = {
    key: "promptCancelled",
    stateDefinition: { name: "biometricSettings" },
};
class DeleteBiometricPromptCancelledData extends Migrator {
    migrate(helper) {
        return _46_delete_orphaned_biometric_prompt_data_awaiter(this, void 0, void 0, function* () {
            yield Promise.all((yield helper.getAccounts()).map((_a) => _46_delete_orphaned_biometric_prompt_data_awaiter(this, [_a], void 0, function* ({ userId }) {
                if (helper.getFromUser(userId, PROMPT_CANCELLED) != null) {
                    yield helper.removeFromUser(userId, PROMPT_CANCELLED);
                }
            })));
        });
    }
    rollback(helper) {
        return _46_delete_orphaned_biometric_prompt_data_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/47-move-desktop-settings.ts
var _47_move_desktop_settings_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const DESKTOP_SETTINGS_STATE = { name: "desktopSettings" };
const WINDOW_KEY = { key: "window", stateDefinition: DESKTOP_SETTINGS_STATE };
const CLOSE_TO_TRAY_KEY = {
    key: "closeToTray",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const MINIMIZE_TO_TRAY_KEY = {
    key: "minimizeToTray",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const START_TO_TRAY_KEY = {
    key: "startToTray",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const TRAY_ENABLED_KEY = {
    key: "trayEnabled",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const OPEN_AT_LOGIN_KEY = {
    key: "openAtLogin",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const ALWAYS_SHOW_DOCK_KEY = {
    key: "alwaysShowDock",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
const ALWAYS_ON_TOP_KEY = {
    key: "alwaysOnTop",
    stateDefinition: DESKTOP_SETTINGS_STATE,
};
class MoveDesktopSettingsMigrator extends Migrator {
    migrate(helper) {
        return _47_move_desktop_settings_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            let updatedGlobal = false;
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.window) !== undefined) {
                yield helper.setToGlobal(WINDOW_KEY, legacyGlobal.window);
                updatedGlobal = true;
                delete legacyGlobal.window;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableCloseToTray) != null) {
                yield helper.setToGlobal(CLOSE_TO_TRAY_KEY, legacyGlobal.enableCloseToTray);
                updatedGlobal = true;
                delete legacyGlobal.enableCloseToTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableMinimizeToTray) != null) {
                yield helper.setToGlobal(MINIMIZE_TO_TRAY_KEY, legacyGlobal.enableMinimizeToTray);
                updatedGlobal = true;
                delete legacyGlobal.enableMinimizeToTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableStartToTray) != null) {
                yield helper.setToGlobal(START_TO_TRAY_KEY, legacyGlobal.enableStartToTray);
                updatedGlobal = true;
                delete legacyGlobal.enableStartToTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableTray) != null) {
                yield helper.setToGlobal(TRAY_ENABLED_KEY, legacyGlobal.enableTray);
                updatedGlobal = true;
                delete legacyGlobal.enableTray;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.openAtLogin) != null) {
                yield helper.setToGlobal(OPEN_AT_LOGIN_KEY, legacyGlobal.openAtLogin);
                updatedGlobal = true;
                delete legacyGlobal.openAtLogin;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.alwaysShowDock) != null) {
                yield helper.setToGlobal(ALWAYS_SHOW_DOCK_KEY, legacyGlobal.alwaysShowDock);
                updatedGlobal = true;
                delete legacyGlobal.alwaysShowDock;
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableAlwaysOnTop) != null) {
                yield helper.setToGlobal(ALWAYS_ON_TOP_KEY, legacyGlobal.enableAlwaysOnTop);
                updatedGlobal = true;
                delete legacyGlobal.enableAlwaysOnTop;
            }
            if (updatedGlobal) {
                yield helper.set("global", legacyGlobal);
            }
            function migrateAccount(userId, account) {
                return _47_move_desktop_settings_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    // We only migrate the global setting for this, if we find it on the account object
                    // just delete it.
                    if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.enableAlwaysOnTop) != null) {
                        delete account.settings.enableAlwaysOnTop;
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
}

;// ../../libs/state/src/state-migrations/migrations/48-move-ddg-to-state-provider.ts
var _48_move_ddg_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const DDG_KEY = {
    key: "enableDuckDuckGoBrowserIntegration",
    stateDefinition: {
        name: "autofillSettings",
    },
};
class MoveDdgToStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _48_move_ddg_to_state_provider_awaiter(this, void 0, void 0, function* () {
            // global state
            const global = yield helper.get("global");
            if ((global === null || global === void 0 ? void 0 : global.enableDuckDuckGoBrowserIntegration) == null) {
                return;
            }
            yield helper.setToGlobal(DDG_KEY, global.enableDuckDuckGoBrowserIntegration);
            delete global.enableDuckDuckGoBrowserIntegration;
            yield helper.set("global", global);
        });
    }
    rollback(helper) {
        return _48_move_ddg_to_state_provider_awaiter(this, void 0, void 0, function* () {
            var _a;
            const enableDdg = yield helper.getFromGlobal(DDG_KEY);
            if (!enableDdg) {
                return;
            }
            const global = (_a = (yield helper.get("global"))) !== null && _a !== void 0 ? _a : {};
            global.enableDuckDuckGoBrowserIntegration = enableDdg;
            yield helper.set("global", global);
            yield helper.removeFromGlobal(DDG_KEY);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/49-move-account-server-configs.ts
var _49_move_account_server_configs_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _49_move_account_server_configs_CONFIG_DISK = { name: "config" };
const USER_SERVER_CONFIG = {
    stateDefinition: _49_move_account_server_configs_CONFIG_DISK,
    key: "serverConfig",
};
class AccountServerConfigMigrator extends Migrator {
    migrate(helper) {
        return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.serverConfig) != null) {
                        yield helper.setToUser(userId, USER_SERVER_CONFIG, account.settings.serverConfig);
                        delete account.settings.serverConfig;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _49_move_account_server_configs_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const serverConfig = yield helper.getFromUser(userId, USER_SERVER_CONFIG);
                    if (serverConfig) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.settings) !== null && _a !== void 0 ? _a : (account.settings = {});
                        account.settings.serverConfig = serverConfig;
                        yield helper.setToUser(userId, USER_SERVER_CONFIG, null);
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/5-add-key-type-to-org-keys.ts
var _5_add_key_type_to_org_keys_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class AddKeyTypeToOrgKeysMigrator extends Migrator {
    migrate(helper) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateOrgKey(userId, account) {
                return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const encryptedOrgKeys = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (encryptedOrgKeys == null) {
                        return;
                    }
                    const newOrgKeys = {};
                    Object.entries(encryptedOrgKeys).forEach(([orgId, encKey]) => {
                        newOrgKeys[orgId] = {
                            type: "organization",
                            key: encKey,
                        };
                    });
                    account.keys.organizationKeys.encrypted = newOrgKeys;
                    yield helper.set(userId, account);
                });
            }
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.all(accounts.map(({ userId, account }) => updateOrgKey(userId, account)));
        });
    }
    rollback(helper) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateOrgKey(userId, account) {
                return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const encryptedOrgKeys = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (encryptedOrgKeys == null) {
                        return;
                    }
                    const newOrgKeys = {};
                    Object.entries(encryptedOrgKeys).forEach(([orgId, encKey]) => {
                        newOrgKeys[orgId] = encKey.key;
                    });
                    account.keys.organizationKeys.encrypted = newOrgKeys;
                    yield helper.set(userId, account);
                });
            }
            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.all(accounts.map((_a) => _5_add_key_type_to_org_keys_awaiter(this, [_a], void 0, function* ({ userId, account }) { return updateOrgKey(userId, account); })));
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/50-move-key-connector-to-state-provider.ts
var _50_move_key_connector_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const usesKeyConnectorKeyDefinition = {
    key: "usesKeyConnector",
    stateDefinition: {
        name: "keyConnector",
    },
};
const convertAccountToKeyConnectorKeyDefinition = {
    key: "convertAccountToKeyConnector",
    stateDefinition: {
        name: "keyConnector",
    },
};
class KeyConnectorMigrator extends Migrator {
    migrate(helper) {
        return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const usesKeyConnector = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.usesKeyConnector;
                    const convertAccountToKeyConnector = (_b = account === null || account === void 0 ? void 0 : account.profile) === null || _b === void 0 ? void 0 : _b.convertAccountToKeyConnector;
                    if (usesKeyConnector == null && convertAccountToKeyConnector == null) {
                        return;
                    }
                    if (usesKeyConnector != null) {
                        yield helper.setToUser(userId, usesKeyConnectorKeyDefinition, usesKeyConnector);
                        delete account.profile.usesKeyConnector;
                    }
                    if (convertAccountToKeyConnector != null) {
                        yield helper.setToUser(userId, convertAccountToKeyConnectorKeyDefinition, convertAccountToKeyConnector);
                        delete account.profile.convertAccountToKeyConnector;
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _50_move_key_connector_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const usesKeyConnector = yield helper.getFromUser(userId, usesKeyConnectorKeyDefinition);
                    const convertAccountToKeyConnector = yield helper.getFromUser(userId, convertAccountToKeyConnectorKeyDefinition);
                    if (usesKeyConnector == null && convertAccountToKeyConnector == null) {
                        return;
                    }
                    if (usesKeyConnector != null) {
                        account.profile.usesKeyConnector = usesKeyConnector;
                        yield helper.setToUser(userId, usesKeyConnectorKeyDefinition, null);
                    }
                    if (convertAccountToKeyConnector != null) {
                        account.profile.convertAccountToKeyConnector = convertAccountToKeyConnector;
                        yield helper.setToUser(userId, convertAccountToKeyConnectorKeyDefinition, null);
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/51-move-remembered-email-to-state-providers.ts
var _51_move_remembered_email_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const LOGIN_EMAIL_STATE = { name: "loginEmail" };
const STORED_EMAIL = {
    key: "storedEmail",
    stateDefinition: LOGIN_EMAIL_STATE,
};
class RememberedEmailMigrator extends Migrator {
    migrate(helper) {
        return _51_move_remembered_email_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            // Move global data
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.rememberedEmail) != null) {
                yield helper.setToGlobal(STORED_EMAIL, legacyGlobal.rememberedEmail);
            }
            // Delete legacy global data
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.rememberedEmail;
            yield helper.set("global", legacyGlobal);
        });
    }
    rollback(helper) {
        return _51_move_remembered_email_to_state_providers_awaiter(this, void 0, void 0, function* () {
            let legacyGlobal = yield helper.get("global");
            let updatedLegacyGlobal = false;
            const globalStoredEmail = yield helper.getFromGlobal(STORED_EMAIL);
            if (globalStoredEmail) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.rememberedEmail = globalStoredEmail;
                yield helper.setToGlobal(STORED_EMAIL, null);
            }
            if (updatedLegacyGlobal) {
                yield helper.set("global", legacyGlobal);
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/52-delete-installed-version.ts
var _52_delete_installed_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class DeleteInstalledVersion extends Migrator {
    migrate(helper) {
        return _52_delete_installed_version_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.installedVersion) != null) {
                delete legacyGlobal.installedVersion;
                yield helper.set("global", legacyGlobal);
            }
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
}

;// ../../libs/state/src/state-migrations/migrations/53-migrate-device-trust-svc-to-state-providers.ts
var _53_migrate_device_trust_svc_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const DEVICE_KEY = {
    key: "deviceKey", // matches KeyDefinition.key in DeviceTrustService
    stateDefinition: {
        name: "deviceTrust", // matches StateDefinition.name in StateDefinitions
    },
};
const SHOULD_TRUST_DEVICE = {
    key: "shouldTrustDevice",
    stateDefinition: {
        name: "deviceTrust",
    },
};
class DeviceTrustServiceStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _53_migrate_device_trust_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _53_migrate_device_trust_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    let updatedAccount = false;
                    // Migrate deviceKey
                    const existingDeviceKey = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.deviceKey;
                    if (existingDeviceKey != null) {
                        // Only migrate data that exists
                        yield helper.setToUser(userId, DEVICE_KEY, existingDeviceKey);
                        delete account.keys.deviceKey;
                        updatedAccount = true;
                    }
                    // Migrate shouldTrustDevice
                    const existingShouldTrustDevice = (_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.trustDeviceChoiceForDecryption;
                    if (existingShouldTrustDevice != null) {
                        yield helper.setToUser(userId, SHOULD_TRUST_DEVICE, existingShouldTrustDevice);
                        delete account.settings.trustDeviceChoiceForDecryption;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        // Save the migrated account
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _53_migrate_device_trust_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _53_migrate_device_trust_svc_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    // Rollback deviceKey
                    const migratedDeviceKey = yield helper.getFromUser(userId, DEVICE_KEY);
                    if ((account === null || account === void 0 ? void 0 : account.keys) && migratedDeviceKey != null) {
                        account.keys.deviceKey = migratedDeviceKey;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, DEVICE_KEY, null);
                    // Rollback shouldTrustDevice
                    const migratedShouldTrustDevice = yield helper.getFromUser(userId, SHOULD_TRUST_DEVICE);
                    if ((account === null || account === void 0 ? void 0 : account.settings) && migratedShouldTrustDevice != null) {
                        account.settings.trustDeviceChoiceForDecryption = migratedShouldTrustDevice;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, SHOULD_TRUST_DEVICE, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/54-move-encrypted-sends.ts
var _54_move_encrypted_sends_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var SendType;
(function (SendType) {
    SendType[SendType["Text"] = 0] = "Text";
    SendType[SendType["File"] = 1] = "File";
})(SendType || (SendType = {}));
const ENCRYPTED_SENDS = {
    stateDefinition: {
        name: "send",
    },
    key: "sends",
};
/**
 * Only encrypted sends are stored on disk. Only the encrypted items need to be
 * migrated from the previous sends state data.
 */
class SendMigrator extends Migrator {
    migrate(helper) {
        return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
                    var _a, _b;
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.sends) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, ENCRYPTED_SENDS, value);
                        delete account.data.sends;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _54_move_encrypted_sends_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, ENCRYPTED_SENDS);
                    if (account) {
                        account.data = Object.assign((_a = account.data) !== null && _a !== void 0 ? _a : {}, {
                            sends: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, ENCRYPTED_SENDS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/55-move-master-key-state-to-provider.ts
var _55_move_master_key_state_to_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const FORCE_SET_PASSWORD_REASON_DEFINITION = {
    key: "forceSetPasswordReason",
    stateDefinition: {
        name: "masterPassword",
    },
};
const MASTER_KEY_HASH_DEFINITION = {
    key: "masterKeyHash",
    stateDefinition: {
        name: "masterPassword",
    },
};
const MASTER_KEY_ENCRYPTED_USER_KEY_DEFINITION = {
    key: "masterKeyEncryptedUserKey",
    stateDefinition: {
        name: "masterPassword",
    },
};
class MoveMasterKeyStateToProviderMigrator extends Migrator {
    migrate(helper) {
        return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c;
                    const forceSetPasswordReason = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.forceSetPasswordReason;
                    if (forceSetPasswordReason != null) {
                        yield helper.setToUser(userId, FORCE_SET_PASSWORD_REASON_DEFINITION, forceSetPasswordReason);
                        delete account.profile.forceSetPasswordReason;
                        yield helper.set(userId, account);
                    }
                    const masterKeyHash = (_b = account === null || account === void 0 ? void 0 : account.profile) === null || _b === void 0 ? void 0 : _b.keyHash;
                    if (masterKeyHash != null) {
                        yield helper.setToUser(userId, MASTER_KEY_HASH_DEFINITION, masterKeyHash);
                        delete account.profile.keyHash;
                        yield helper.set(userId, account);
                    }
                    const masterKeyEncryptedUserKey = (_c = account === null || account === void 0 ? void 0 : account.keys) === null || _c === void 0 ? void 0 : _c.masterKeyEncryptedUserKey;
                    if (masterKeyEncryptedUserKey != null) {
                        yield helper.setToUser(userId, MASTER_KEY_ENCRYPTED_USER_KEY_DEFINITION, masterKeyEncryptedUserKey);
                        delete account.keys.masterKeyEncryptedUserKey;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _55_move_master_key_state_to_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c;
                    const forceSetPasswordReason = yield helper.getFromUser(userId, FORCE_SET_PASSWORD_REASON_DEFINITION);
                    const masterKeyHash = yield helper.getFromUser(userId, MASTER_KEY_HASH_DEFINITION);
                    const masterKeyEncryptedUserKey = yield helper.getFromUser(userId, MASTER_KEY_ENCRYPTED_USER_KEY_DEFINITION);
                    if (account != null) {
                        if (forceSetPasswordReason != null) {
                            account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                                forceSetPasswordReason,
                            });
                        }
                        if (masterKeyHash != null) {
                            account.profile = Object.assign((_b = account.profile) !== null && _b !== void 0 ? _b : {}, {
                                keyHash: masterKeyHash,
                            });
                        }
                        if (masterKeyEncryptedUserKey != null) {
                            account.keys = Object.assign((_c = account.keys) !== null && _c !== void 0 ? _c : {}, {
                                masterKeyEncryptedUserKey,
                            });
                        }
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, FORCE_SET_PASSWORD_REASON_DEFINITION, null);
                    yield helper.setToUser(userId, MASTER_KEY_HASH_DEFINITION, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/56-move-auth-requests.ts
var _56_move_auth_requests_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ADMIN_AUTH_REQUEST_KEY = {
    stateDefinition: {
        name: "authRequestLocal",
    },
    key: "adminAuthRequest",
};
const ACCEPT_AUTH_REQUESTS_KEY = {
    stateDefinition: {
        name: "authRequestLocal",
    },
    key: "acceptAuthRequests",
};
class AuthRequestMigrator extends Migrator {
    migrate(helper) {
        return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    let updatedAccount = false;
                    // Migrate admin auth request
                    const existingAdminAuthRequest = account === null || account === void 0 ? void 0 : account.adminAuthRequest;
                    if (existingAdminAuthRequest != null) {
                        yield helper.setToUser(userId, ADMIN_AUTH_REQUEST_KEY, existingAdminAuthRequest);
                        delete account.adminAuthRequest;
                        updatedAccount = true;
                    }
                    // Migrate approve login requests
                    const existingApproveLoginRequests = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.approveLoginRequests;
                    if (existingApproveLoginRequests != null) {
                        yield helper.setToUser(userId, ACCEPT_AUTH_REQUESTS_KEY, existingApproveLoginRequests);
                        delete account.settings.approveLoginRequests;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        // Save the migrated account
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _56_move_auth_requests_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    let updatedAccount = false;
                    // Rollback admin auth request
                    const migratedAdminAuthRequest = yield helper.getFromUser(userId, ADMIN_AUTH_REQUEST_KEY);
                    if (migratedAdminAuthRequest != null) {
                        account.adminAuthRequest = migratedAdminAuthRequest;
                        updatedAccount = true;
                    }
                    yield helper.setToUser(userId, ADMIN_AUTH_REQUEST_KEY, null);
                    // Rollback approve login requests
                    const migratedAcceptAuthRequest = yield helper.getFromUser(userId, ACCEPT_AUTH_REQUESTS_KEY);
                    if (migratedAcceptAuthRequest != null) {
                        account.settings = Object.assign((_a = account.settings) !== null && _a !== void 0 ? _a : {}, {
                            approveLoginRequests: migratedAcceptAuthRequest,
                        });
                        updatedAccount = true;
                    }
                    yield helper.setToUser(userId, ACCEPT_AUTH_REQUESTS_KEY, null);
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/57-move-cipher-service-to-state-provider.ts
var _57_move_cipher_service_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL = {
    key: "localData",
    stateDefinition: {
        name: "ciphersLocal",
    },
};
const _57_move_cipher_service_to_state_provider_CIPHERS_DISK = {
    key: "ciphers",
    stateDefinition: {
        name: "ciphers",
    },
};
class CipherServiceMigrator extends Migrator {
    migrate(helper) {
        return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c;
                    let updatedAccount = false;
                    //Migrate localData
                    const localData = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.localData;
                    if (localData != null) {
                        yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL, localData);
                        delete account.data.localData;
                        updatedAccount = true;
                    }
                    //Migrate ciphers
                    const ciphers = (_c = (_b = account === null || account === void 0 ? void 0 : account.data) === null || _b === void 0 ? void 0 : _b.ciphers) === null || _c === void 0 ? void 0 : _c.encrypted;
                    if (ciphers != null) {
                        yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK, ciphers);
                        delete account.data.ciphers;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _57_move_cipher_service_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    //rollback localData
                    const localData = yield helper.getFromUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL);
                    if (account.data && localData != null) {
                        account.data.localData = localData;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK_LOCAL, null);
                    //rollback ciphers
                    const ciphers = yield helper.getFromUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK);
                    if (account.data && ciphers != null) {
                        (_a = account.data).ciphers || (_a.ciphers = { encrypted: null });
                        account.data.ciphers.encrypted = ciphers;
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _57_move_cipher_service_to_state_provider_CIPHERS_DISK, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/58-remove-refresh-token-migrated-state-provider-flag.ts
var _58_remove_refresh_token_migrated_state_provider_flag_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const REFRESH_TOKEN_MIGRATED_TO_SECURE_STORAGE = {
    key: "refreshTokenMigratedToSecureStorage", // matches KeyDefinition.key
    stateDefinition: {
        name: "token", // matches StateDefinition.name in StateDefinitions
    },
};
class RemoveRefreshTokenMigratedFlagMigrator extends Migrator {
    migrate(helper) {
        return _58_remove_refresh_token_migrated_state_provider_flag_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _58_remove_refresh_token_migrated_state_provider_flag_awaiter(this, void 0, void 0, function* () {
                    const refreshTokenMigratedFlag = yield helper.getFromUser(userId, REFRESH_TOKEN_MIGRATED_TO_SECURE_STORAGE);
                    if (refreshTokenMigratedFlag != null) {
                        // Only delete the flag if it exists
                        yield helper.removeFromUser(userId, REFRESH_TOKEN_MIGRATED_TO_SECURE_STORAGE);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _58_remove_refresh_token_migrated_state_provider_flag_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/59-move-kdf-config-to-state-provider.ts
var _59_move_kdf_config_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var KdfType;
(function (KdfType) {
    KdfType[KdfType["PBKDF2_SHA256"] = 0] = "PBKDF2_SHA256";
    KdfType[KdfType["Argon2id"] = 1] = "Argon2id";
})(KdfType || (KdfType = {}));
class KdfConfig {
}
const kdfConfigKeyDefinition = {
    key: "kdfConfig",
    stateDefinition: {
        name: "kdfConfig",
    },
};
class KdfConfigMigrator extends Migrator {
    migrate(helper) {
        return _59_move_kdf_config_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _59_move_kdf_config_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c, _d, _e, _f, _g, _h;
                    const iterations = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.kdfIterations;
                    const kdfType = (_b = account === null || account === void 0 ? void 0 : account.profile) === null || _b === void 0 ? void 0 : _b.kdfType;
                    const memory = (_c = account === null || account === void 0 ? void 0 : account.profile) === null || _c === void 0 ? void 0 : _c.kdfMemory;
                    const parallelism = (_d = account === null || account === void 0 ? void 0 : account.profile) === null || _d === void 0 ? void 0 : _d.kdfParallelism;
                    const kdfConfig = {
                        iterations: iterations,
                        kdfType: kdfType,
                        memory: memory,
                        parallelism: parallelism,
                    };
                    if (kdfConfig != null) {
                        yield helper.setToUser(userId, kdfConfigKeyDefinition, kdfConfig);
                        (_e = account === null || account === void 0 ? void 0 : account.profile) === null || _e === void 0 ? true : delete _e.kdfIterations;
                        (_f = account === null || account === void 0 ? void 0 : account.profile) === null || _f === void 0 ? true : delete _f.kdfType;
                        (_g = account === null || account === void 0 ? void 0 : account.profile) === null || _g === void 0 ? true : delete _g.kdfMemory;
                        (_h = account === null || account === void 0 ? void 0 : account.profile) === null || _h === void 0 ? true : delete _h.kdfParallelism;
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _59_move_kdf_config_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _59_move_kdf_config_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    const kdfConfig = yield helper.getFromUser(userId, kdfConfigKeyDefinition);
                    if (kdfConfig != null) {
                        account.profile.kdfIterations = kdfConfig.iterations;
                        account.profile.kdfType = kdfConfig.kdfType;
                        account.profile.kdfMemory = kdfConfig.memory;
                        account.profile.kdfParallelism = kdfConfig.parallelism;
                        yield helper.setToUser(userId, kdfConfigKeyDefinition, null);
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/6-remove-legacy-etm-key.ts
var _6_remove_legacy_etm_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class RemoveLegacyEtmKeyMigrator extends Migrator {
    migrate(helper) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateAccount(userId, account) {
                return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    if ((_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.legacyEtmKey) {
                        delete account.keys.legacyEtmKey;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => updateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/60-known-accounts.ts
var _60_known_accounts_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ACCOUNT_ACCOUNTS = {
    stateDefinition: {
        name: "account",
    },
    key: "accounts",
};
const ACCOUNT_ACTIVE_ACCOUNT_ID = {
    stateDefinition: {
        name: "account",
    },
    key: "activeAccountId",
};
const ACCOUNT_ACTIVITY = {
    stateDefinition: {
        name: "account",
    },
    key: "activity",
};
class KnownAccountsMigrator extends Migrator {
    migrate(helper) {
        return _60_known_accounts_awaiter(this, void 0, void 0, function* () {
            yield this.migrateAuthenticatedAccounts(helper);
            yield this.migrateActiveAccountId(helper);
            yield this.migrateAccountActivity(helper);
        });
    }
    rollback(helper) {
        return _60_known_accounts_awaiter(this, void 0, void 0, function* () {
            var _a;
            // authenticated account are removed, but the accounts record also contains logged out accounts. Best we can do is to add them all back
            const userIds = (_a = (yield helper.getKnownUserIds())) !== null && _a !== void 0 ? _a : [];
            yield helper.set("authenticatedAccounts", userIds);
            yield helper.removeFromGlobal(ACCOUNT_ACCOUNTS);
            // Active Account Id
            const activeAccountId = yield helper.getFromGlobal(ACCOUNT_ACTIVE_ACCOUNT_ID);
            if (activeAccountId) {
                yield helper.set("activeUserId", activeAccountId);
            }
            yield helper.removeFromGlobal(ACCOUNT_ACTIVE_ACCOUNT_ID);
            // Account Activity
            const accountActivity = yield helper.getFromGlobal(ACCOUNT_ACTIVITY);
            if (accountActivity) {
                const toStore = Object.entries(accountActivity).reduce((agg, [userId, dateString]) => {
                    agg[userId] = new Date(dateString).getTime();
                    return agg;
                }, {});
                yield helper.set("accountActivity", toStore);
            }
            yield helper.removeFromGlobal(ACCOUNT_ACTIVITY);
        });
    }
    migrateAuthenticatedAccounts(helper) {
        return _60_known_accounts_awaiter(this, void 0, void 0, function* () {
            var _a;
            const authenticatedAccounts = (_a = (yield helper.get("authenticatedAccounts"))) !== null && _a !== void 0 ? _a : [];
            const accounts = yield Promise.all(authenticatedAccounts.map((userId) => _60_known_accounts_awaiter(this, void 0, void 0, function* () {
                const account = yield helper.get(userId);
                return { userId, account };
            })));
            const accountsToStore = accounts.reduce((agg, { userId, account }) => {
                var _a, _b;
                if (account === null || account === void 0 ? void 0 : account.profile) {
                    agg[userId] = {
                        email: (_a = account.profile.email) !== null && _a !== void 0 ? _a : "",
                        emailVerified: (_b = account.profile.emailVerified) !== null && _b !== void 0 ? _b : false,
                        name: account.profile.name,
                    };
                }
                return agg;
            }, {});
            yield helper.setToGlobal(ACCOUNT_ACCOUNTS, accountsToStore);
            yield helper.remove("authenticatedAccounts");
        });
    }
    migrateAccountActivity(helper) {
        return _60_known_accounts_awaiter(this, void 0, void 0, function* () {
            const stored = yield helper.get("accountActivity");
            const accountActivity = Object.entries(stored !== null && stored !== void 0 ? stored : {}).reduce((agg, [userId, dateMs]) => {
                agg[userId] = JSON.stringify(new Date(dateMs));
                return agg;
            }, {});
            yield helper.setToGlobal(ACCOUNT_ACTIVITY, accountActivity);
            yield helper.remove("accountActivity");
        });
    }
    migrateActiveAccountId(helper) {
        return _60_known_accounts_awaiter(this, void 0, void 0, function* () {
            const activeAccountId = yield helper.get("activeUserId");
            yield helper.setToGlobal(ACCOUNT_ACTIVE_ACCOUNT_ID, activeAccountId);
            yield helper.remove("activeUserId");
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/61-move-pin-state-to-providers.ts
var _61_move_pin_state_to_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const PIN_STATE = { name: "pinUnlock" };
const PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT = {
    stateDefinition: PIN_STATE,
    key: "pinKeyEncryptedUserKeyPersistent",
};
const USER_KEY_ENCRYPTED_PIN = {
    stateDefinition: PIN_STATE,
    key: "userKeyEncryptedPin",
};
const OLD_PIN_KEY_ENCRYPTED_MASTER_KEY = {
    stateDefinition: PIN_STATE,
    key: "oldPinKeyEncryptedMasterKey",
};
class PinStateMigrator extends Migrator {
    migrate(helper) {
        return _61_move_pin_state_to_providers_awaiter(this, void 0, void 0, function* () {
            const legacyAccounts = yield helper.getAccounts();
            let updatedAccount = false;
            function migrateAccount(userId, account) {
                return _61_move_pin_state_to_providers_awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c, _d;
                    // Migrate pinKeyEncryptedUserKey (to `pinKeyEncryptedUserKeyPersistent`)
                    if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.pinKeyEncryptedUserKey) != null) {
                        yield helper.setToUser(userId, PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, account.settings.pinKeyEncryptedUserKey);
                        delete account.settings.pinKeyEncryptedUserKey;
                        updatedAccount = true;
                    }
                    // Migrate protectedPin (to `userKeyEncryptedPin`)
                    if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.protectedPin) != null) {
                        yield helper.setToUser(userId, USER_KEY_ENCRYPTED_PIN, account.settings.protectedPin);
                        delete account.settings.protectedPin;
                        updatedAccount = true;
                    }
                    // Migrate pinProtected (to `oldPinKeyEncryptedMasterKey`)
                    if (((_d = (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? void 0 : _c.pinProtected) === null || _d === void 0 ? void 0 : _d.encrypted) != null) {
                        yield helper.setToUser(userId, OLD_PIN_KEY_ENCRYPTED_MASTER_KEY, account.settings.pinProtected.encrypted);
                        delete account.settings.pinProtected;
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([
                ...legacyAccounts.map(({ userId, account }) => migrateAccount(userId, account)),
            ]);
        });
    }
    rollback(helper) {
        return _61_move_pin_state_to_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _61_move_pin_state_to_providers_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    let updatedAccount = false;
                    const accountPinKeyEncryptedUserKeyPersistent = yield helper.getFromUser(userId, PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT);
                    const accountUserKeyEncryptedPin = yield helper.getFromUser(userId, USER_KEY_ENCRYPTED_PIN);
                    const accountOldPinKeyEncryptedMasterKey = yield helper.getFromUser(userId, OLD_PIN_KEY_ENCRYPTED_MASTER_KEY);
                    if (!account) {
                        account = {};
                    }
                    if (accountPinKeyEncryptedUserKeyPersistent != null) {
                        account.settings.pinKeyEncryptedUserKey = accountPinKeyEncryptedUserKeyPersistent;
                        yield helper.setToUser(userId, PIN_KEY_ENCRYPTED_USER_KEY_PERSISTENT, null);
                        updatedAccount = true;
                    }
                    if (accountUserKeyEncryptedPin != null) {
                        account.settings.protectedPin = accountUserKeyEncryptedPin;
                        yield helper.setToUser(userId, USER_KEY_ENCRYPTED_PIN, null);
                        updatedAccount = true;
                    }
                    if (accountOldPinKeyEncryptedMasterKey != null) {
                        account.settings = Object.assign((_a = account.settings) !== null && _a !== void 0 ? _a : {}, {
                            pinProtected: {
                                encrypted: accountOldPinKeyEncryptedMasterKey,
                            },
                        });
                        yield helper.setToUser(userId, OLD_PIN_KEY_ENCRYPTED_MASTER_KEY, null);
                        updatedAccount = true;
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => rollbackAccount(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/62-migrate-vault-timeout-settings-svc-to-state-provider.ts
var _62_migrate_vault_timeout_settings_svc_to_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const VAULT_TIMEOUT_SETTINGS_STATE_DEF_LIKE = {
    name: "vaultTimeoutSettings",
};
const VAULT_TIMEOUT = {
    key: "vaultTimeout", // matches KeyDefinition.key
    stateDefinition: VAULT_TIMEOUT_SETTINGS_STATE_DEF_LIKE,
};
const VAULT_TIMEOUT_ACTION = {
    key: "vaultTimeoutAction", // matches KeyDefinition.key
    stateDefinition: VAULT_TIMEOUT_SETTINGS_STATE_DEF_LIKE,
};
// Define mapping of old values to new values for migration purposes
const vaultTimeoutTypeMigrateRecord = {
    null: "never",
    "-1": "onRestart",
    "-2": "onLocked",
    "-3": "onSleep",
    "-4": "onIdle",
};
// define mapping of new values to old values for rollback purposes
const vaultTimeoutTypeRollbackRecord = {
    never: null,
    onRestart: -1,
    onLocked: -2,
    onSleep: -3,
    onIdle: -4,
};
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ClientType;
(function (ClientType) {
    ClientType["Web"] = "web";
    ClientType["Browser"] = "browser";
    ClientType["Desktop"] = "desktop";
    ClientType["Cli"] = "cli";
})(ClientType || (ClientType = {}));
class VaultTimeoutSettingsServiceStateProviderMigrator extends Migrator {
    migrate(helper) {
        return _62_migrate_vault_timeout_settings_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const globalData = yield helper.get("global");
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _62_migrate_vault_timeout_settings_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c, _d;
                    let updatedAccount = false;
                    // Migrate vault timeout
                    let existingVaultTimeout = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.vaultTimeout;
                    if (helper.clientType === ClientType.Cli && existingVaultTimeout === undefined) {
                        // The CLI does not set a vault timeout by default so we need to set it to null
                        // so that the migration can migrate null to "never" as the CLI does not have a vault timeout.
                        existingVaultTimeout = null;
                    }
                    if (existingVaultTimeout !== undefined) {
                        // check undefined so that we allow null values (previously meant never timeout)
                        // Only migrate data that exists
                        if (existingVaultTimeout === null || existingVaultTimeout < 0) {
                            // Map null or negative values to new string values
                            const newVaultTimeout = vaultTimeoutTypeMigrateRecord[existingVaultTimeout];
                            yield helper.setToUser(userId, VAULT_TIMEOUT, newVaultTimeout);
                        }
                        else {
                            // Persist positive numbers as is
                            yield helper.setToUser(userId, VAULT_TIMEOUT, existingVaultTimeout);
                        }
                        (_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? true : delete _b.vaultTimeout;
                        updatedAccount = true;
                    }
                    // Migrate vault timeout action
                    const existingVaultTimeoutAction = (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? void 0 : _c.vaultTimeoutAction;
                    if (existingVaultTimeoutAction != null) {
                        // Only migrate data that exists
                        yield helper.setToUser(userId, VAULT_TIMEOUT_ACTION, existingVaultTimeoutAction);
                        (_d = account === null || account === void 0 ? void 0 : account.settings) === null || _d === void 0 ? true : delete _d.vaultTimeoutAction;
                        updatedAccount = true;
                    }
                    // Note: we are explicitly not worrying about mapping over the global fallback vault timeout / action
                    // into the new state provider framework.  It was originally a fallback but hasn't been used for years
                    // so this migration will clean up the global properties fully.
                    if (updatedAccount) {
                        // Save the migrated account only if it was updated
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
            // Delete global data (works for browser extension and web; CLI doesn't have these as global settings).
            globalData === null || globalData === void 0 ? true : delete globalData.vaultTimeout;
            globalData === null || globalData === void 0 ? true : delete globalData.vaultTimeoutAction;
            yield helper.set("global", globalData);
            // Remove desktop only settings. These aren't found by the above global key removal b/c of
            // the different storage key format. This removal does not cause any issues on migrating for other clients.
            yield helper.remove("global\\.vaultTimeout");
            yield helper.remove("global\\.vaultTimeoutAction");
        });
    }
    rollback(helper) {
        return _62_migrate_vault_timeout_settings_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                return _62_migrate_vault_timeout_settings_svc_to_state_provider_awaiter(this, void 0, void 0, function* () {
                    let updatedLegacyAccount = false;
                    // Rollback vault timeout
                    const migratedVaultTimeout = yield helper.getFromUser(userId, VAULT_TIMEOUT);
                    if ((account === null || account === void 0 ? void 0 : account.settings) && migratedVaultTimeout != null) {
                        if (typeof migratedVaultTimeout === "string") {
                            // Map new string values back to old values
                            account.settings.vaultTimeout = vaultTimeoutTypeRollbackRecord[migratedVaultTimeout];
                        }
                        else {
                            // persist numbers as is
                            account.settings.vaultTimeout = migratedVaultTimeout;
                        }
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, VAULT_TIMEOUT, null);
                    // Rollback vault timeout action
                    const migratedVaultTimeoutAction = yield helper.getFromUser(userId, VAULT_TIMEOUT_ACTION);
                    if ((account === null || account === void 0 ? void 0 : account.settings) && migratedVaultTimeoutAction != null) {
                        account.settings.vaultTimeoutAction = migratedVaultTimeoutAction;
                        updatedLegacyAccount = true;
                    }
                    yield helper.setToUser(userId, VAULT_TIMEOUT_ACTION, null);
                    if (updatedLegacyAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/63-migrate-password-settings.ts
var _63_migrate_password_settings_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const NAVIGATION = {
    stateDefinition: {
        name: "generator",
    },
    key: "generatorSettings",
};
const PASSWORD = {
    stateDefinition: {
        name: "generator",
    },
    key: "passwordGeneratorSettings",
};
const PASSPHRASE = {
    stateDefinition: {
        name: "generator",
    },
    key: "passphraseGeneratorSettings",
};
class PasswordOptionsMigrator extends Migrator {
    migrate(helper) {
        return _63_migrate_password_settings_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _63_migrate_password_settings_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const legacyOptions = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.passwordGenerationOptions;
                    if (legacyOptions) {
                        const converted = convertSettings(legacyOptions);
                        yield storeSettings(helper, userId, converted);
                        yield deleteSettings(helper, userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _63_migrate_password_settings_awaiter(this, void 0, void 0, function* () {
            // not supported
        });
    }
}
function convertSettings(options) {
    const password = {
        length: options.length,
        ambiguous: options.ambiguous,
        uppercase: options.uppercase,
        minUppercase: options.minUppercase,
        lowercase: options.lowercase,
        minLowercase: options.minLowercase,
        number: options.number,
        minNumber: options.minNumber,
        special: options.special,
        minSpecial: options.minSpecial,
    };
    const generator = {
        type: options.type,
    };
    const passphrase = {
        numWords: options.numWords,
        wordSeparator: options.wordSeparator,
        capitalize: options.capitalize,
        includeNumber: options.includeNumber,
    };
    return { generator, password, passphrase };
}
function storeSettings(helper, userId, converted) {
    return _63_migrate_password_settings_awaiter(this, void 0, void 0, function* () {
        var _a;
        const existing = (_a = (yield helper.getFromUser(userId, NAVIGATION))) !== null && _a !== void 0 ? _a : {};
        const updated = Object.assign(existing, converted.generator);
        yield Promise.all([
            helper.setToUser(userId, NAVIGATION, updated),
            helper.setToUser(userId, PASSPHRASE, converted.passphrase),
            helper.setToUser(userId, PASSWORD, converted.password),
        ]);
    });
}
function deleteSettings(helper, userId, account) {
    return _63_migrate_password_settings_awaiter(this, void 0, void 0, function* () {
        var _a;
        (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? true : delete _a.passwordGenerationOptions;
        yield helper.set(userId, account);
    });
}

;// ../../libs/state/src/state-migrations/migrations/64-migrate-generator-history.ts
var _64_migrate_generator_history_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const HISTORY = {
    stateDefinition: {
        name: "generator",
    },
    key: "localGeneratorHistoryBuffer",
};
class GeneratorHistoryMigrator extends Migrator {
    migrate(helper) {
        return _64_migrate_generator_history_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _64_migrate_generator_history_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const data = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.passwordGenerationHistory;
                    if (data && data.encrypted) {
                        yield helper.setToUser(userId, HISTORY, data.encrypted);
                        delete account.data.passwordGenerationHistory;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _64_migrate_generator_history_awaiter(this, void 0, void 0, function* () {
            // not supported
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/65-migrate-forwarder-settings.ts
var _65_migrate_forwarder_settings_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _65_migrate_forwarder_settings_NAVIGATION = {
    stateDefinition: {
        name: "generator",
    },
    key: "generatorSettings",
};
const CATCHALL = {
    stateDefinition: {
        name: "generator",
    },
    key: "catchallGeneratorSettings",
};
const EFF_USERNAME = {
    stateDefinition: {
        name: "generator",
    },
    key: "effUsernameGeneratorSettings",
};
const SUBADDRESS = {
    stateDefinition: {
        name: "generator",
    },
    key: "subaddressGeneratorSettings",
};
const ADDY_IO = {
    stateDefinition: {
        name: "generator",
    },
    key: "addyIoBuffer",
};
const DUCK_DUCK_GO = {
    stateDefinition: {
        name: "generator",
    },
    key: "duckDuckGoBuffer",
};
const FASTMAIL = {
    stateDefinition: {
        name: "generator",
    },
    key: "fastmailBuffer",
};
const FIREFOX_RELAY = {
    stateDefinition: {
        name: "generator",
    },
    key: "firefoxRelayBuffer",
};
const FORWARD_EMAIL = {
    stateDefinition: {
        name: "generator",
    },
    key: "forwardEmailBuffer",
};
const SIMPLE_LOGIN = {
    stateDefinition: {
        name: "generator",
    },
    key: "simpleLoginBuffer",
};
class ForwarderOptionsMigrator extends Migrator {
    migrate(helper) {
        return _65_migrate_forwarder_settings_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                return _65_migrate_forwarder_settings_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const legacyOptions = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.usernameGenerationOptions;
                    if (legacyOptions) {
                        const converted = _65_migrate_forwarder_settings_convertSettings(legacyOptions);
                        yield _65_migrate_forwarder_settings_storeSettings(helper, userId, converted);
                        yield _65_migrate_forwarder_settings_deleteSettings(helper, userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _65_migrate_forwarder_settings_awaiter(this, void 0, void 0, function* () {
            // not supported
        });
    }
}
function _65_migrate_forwarder_settings_convertSettings(options) {
    const forwarders = {
        addyIo: {
            baseUrl: options.forwardedAnonAddyBaseUrl,
            token: options.forwardedAnonAddyApiToken,
            domain: options.forwardedAnonAddyDomain,
        },
        duckDuckGo: {
            token: options.forwardedDuckDuckGoToken,
        },
        fastmail: {
            token: options.forwardedFastmailApiToken,
        },
        firefoxRelay: {
            token: options.forwardedFirefoxApiToken,
        },
        forwardEmail: {
            token: options.forwardedForwardEmailApiToken,
            domain: options.forwardedForwardEmailDomain,
        },
        simpleLogin: {
            token: options.forwardedSimpleLoginApiKey,
            baseUrl: options.forwardedSimpleLoginBaseUrl,
        },
    };
    const generator = {
        username: options.type,
        forwarder: options.forwardedService,
    };
    const algorithms = {
        effUsername: {
            wordCapitalize: options.wordCapitalize,
            wordIncludeNumber: options.wordIncludeNumber,
        },
        subaddress: {
            subaddressType: options.subaddressType,
            subaddressEmail: options.subaddressEmail,
        },
        catchall: {
            catchallType: options.catchallType,
            catchallDomain: options.catchallDomain,
        },
    };
    return { generator, algorithms, forwarders };
}
function _65_migrate_forwarder_settings_storeSettings(helper, userId, converted) {
    return _65_migrate_forwarder_settings_awaiter(this, void 0, void 0, function* () {
        yield Promise.all([
            helper.setToUser(userId, _65_migrate_forwarder_settings_NAVIGATION, converted.generator),
            helper.setToUser(userId, CATCHALL, converted.algorithms.catchall),
            helper.setToUser(userId, EFF_USERNAME, converted.algorithms.effUsername),
            helper.setToUser(userId, SUBADDRESS, converted.algorithms.subaddress),
            helper.setToUser(userId, ADDY_IO, converted.forwarders.addyIo),
            helper.setToUser(userId, DUCK_DUCK_GO, converted.forwarders.duckDuckGo),
            helper.setToUser(userId, FASTMAIL, converted.forwarders.fastmail),
            helper.setToUser(userId, FIREFOX_RELAY, converted.forwarders.firefoxRelay),
            helper.setToUser(userId, FORWARD_EMAIL, converted.forwarders.forwardEmail),
            helper.setToUser(userId, SIMPLE_LOGIN, converted.forwarders.simpleLogin),
        ]);
    });
}
function _65_migrate_forwarder_settings_deleteSettings(helper, userId, account) {
    return _65_migrate_forwarder_settings_awaiter(this, void 0, void 0, function* () {
        var _a;
        (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? true : delete _a.usernameGenerationOptions;
        yield helper.set(userId, account);
    });
}

;// ../../libs/state/src/state-migrations/migrations/66-move-final-desktop-settings.ts
var _66_move_final_desktop_settings_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _66_move_final_desktop_settings_DESKTOP_SETTINGS_DISK = {
    name: "desktopSettings",
};
const BROWSER_INTEGRATION_ENABLED = {
    key: "browserIntegrationEnabled",
    stateDefinition: _66_move_final_desktop_settings_DESKTOP_SETTINGS_DISK,
};
const BROWSER_INTEGRATION_FINGERPRINT_ENABLED = {
    key: "browserIntegrationFingerprintEnabled",
    stateDefinition: _66_move_final_desktop_settings_DESKTOP_SETTINGS_DISK,
};
const MINIMIZE_ON_COPY = {
    key: "minimizeOnCopy",
    stateDefinition: _66_move_final_desktop_settings_DESKTOP_SETTINGS_DISK,
};
class MoveFinalDesktopSettingsMigrator extends Migrator {
    migrate(helper) {
        return _66_move_final_desktop_settings_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            const enableBrowserIntegrationValue = legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableBrowserIntegration;
            const enableBrowserIntegrationFingerprintValue = legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.enableBrowserIntegrationFingerprint;
            let updatedGlobal = false;
            if (enableBrowserIntegrationValue != null) {
                yield helper.setToGlobal(BROWSER_INTEGRATION_ENABLED, enableBrowserIntegrationValue);
                delete legacyGlobal.enableBrowserIntegration;
                updatedGlobal = true;
            }
            if (enableBrowserIntegrationFingerprintValue != null) {
                yield helper.setToGlobal(BROWSER_INTEGRATION_FINGERPRINT_ENABLED, enableBrowserIntegrationFingerprintValue);
                delete legacyGlobal.enableBrowserIntegrationFingerprint;
                updatedGlobal = true;
            }
            if (updatedGlobal) {
                yield helper.set("global", legacyGlobal);
            }
            function migrateAccount(userId, account) {
                return _66_move_final_desktop_settings_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const minimizeOnCopyToClipboardValue = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.minimizeOnCopyToClipboard;
                    if (minimizeOnCopyToClipboardValue != null) {
                        yield helper.setToUser(userId, MINIMIZE_ON_COPY, minimizeOnCopyToClipboardValue);
                        delete account.settings.minimizeOnCopyToClipboard;
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _66_move_final_desktop_settings_awaiter(this, void 0, void 0, function* () {
            const browserIntegrationEnabledValue = yield helper.getFromGlobal(BROWSER_INTEGRATION_ENABLED);
            const browserIntegrationFingerprintEnabled = yield helper.getFromGlobal(BROWSER_INTEGRATION_FINGERPRINT_ENABLED);
            if (browserIntegrationEnabledValue != null) {
                let legacyGlobal = yield helper.get("global");
                legacyGlobal !== null && legacyGlobal !== void 0 ? legacyGlobal : (legacyGlobal = {});
                legacyGlobal.enableBrowserIntegration = browserIntegrationEnabledValue;
                yield helper.set("global", legacyGlobal);
                yield helper.removeFromGlobal(BROWSER_INTEGRATION_ENABLED);
            }
            if (browserIntegrationFingerprintEnabled != null) {
                let legacyGlobal = yield helper.get("global");
                legacyGlobal !== null && legacyGlobal !== void 0 ? legacyGlobal : (legacyGlobal = {});
                legacyGlobal.enableBrowserIntegrationFingerprint = browserIntegrationFingerprintEnabled;
                yield helper.set("global", legacyGlobal);
                yield helper.removeFromGlobal(BROWSER_INTEGRATION_FINGERPRINT_ENABLED);
            }
            function rollbackAccount(userId, account) {
                return _66_move_final_desktop_settings_awaiter(this, void 0, void 0, function* () {
                    const minimizeOnCopyToClipboardValue = yield helper.getFromUser(userId, MINIMIZE_ON_COPY);
                    if (minimizeOnCopyToClipboardValue != null) {
                        account !== null && account !== void 0 ? account : (account = { settings: {} });
                        account.settings.minimizeOnCopyToClipboard = minimizeOnCopyToClipboardValue;
                        yield helper.set(userId, account);
                        yield helper.removeFromUser(userId, MINIMIZE_ON_COPY);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackAccount(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/67-remove-unassigned-items-banner-dismissed.ts
var _67_remove_unassigned_items_banner_dismissed_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const SHOW_BANNER = {
    key: "showBanner",
    stateDefinition: { name: "unassignedItemsBanner" },
};
class RemoveUnassignedItemsBannerDismissed extends Migrator {
    migrate(helper) {
        return _67_remove_unassigned_items_banner_dismissed_awaiter(this, void 0, void 0, function* () {
            yield Promise.all((yield helper.getAccounts()).map((_a) => _67_remove_unassigned_items_banner_dismissed_awaiter(this, [_a], void 0, function* ({ userId }) {
                if (helper.getFromUser(userId, SHOW_BANNER) != null) {
                    yield helper.removeFromUser(userId, SHOW_BANNER);
                }
            })));
        });
    }
    rollback(helper) {
        return _67_remove_unassigned_items_banner_dismissed_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/68-move-last-sync-date.ts
var _68_move_last_sync_date_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _68_move_last_sync_date_LAST_SYNC_KEY = {
    key: "lastSync",
    stateDefinition: {
        name: "sync",
    },
};
class MoveLastSyncDate extends Migrator {
    migrate(helper) {
        return _68_move_last_sync_date_awaiter(this, void 0, void 0, function* () {
            function migrateAccount(userId, account) {
                return _68_move_last_sync_date_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.lastSync;
                    if (value != null) {
                        yield helper.setToUser(userId, _68_move_last_sync_date_LAST_SYNC_KEY, value);
                        delete account.profile.lastSync;
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => migrateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _68_move_last_sync_date_awaiter(this, void 0, void 0, function* () {
            function rollbackAccount(userId, account) {
                return _68_move_last_sync_date_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const value = yield helper.getFromUser(userId, _68_move_last_sync_date_LAST_SYNC_KEY);
                    if (value != null) {
                        account !== null && account !== void 0 ? account : (account = {});
                        (_a = account.profile) !== null && _a !== void 0 ? _a : (account.profile = {});
                        account.profile.lastSync = value;
                        yield helper.set(userId, account);
                        yield helper.removeFromUser(userId, _68_move_last_sync_date_LAST_SYNC_KEY);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackAccount(userId, account)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/69-migrate-incorrect-folder-key.ts
var _69_migrate_incorrect_folder_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const BAD_FOLDER_KEY = {
    key: "folder", // We inadvertently changed the key from "folders" to "folder"
    stateDefinition: {
        name: "folder",
    },
};
const GOOD_FOLDER_KEY = {
    key: "folders", // We should keep the key as "folders"
    stateDefinition: {
        name: "folder",
    },
};
class MigrateIncorrectFolderKey extends Migrator {
    migrate(helper) {
        return _69_migrate_incorrect_folder_key_awaiter(this, void 0, void 0, function* () {
            function migrateUser(userId) {
                return _69_migrate_incorrect_folder_key_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, BAD_FOLDER_KEY);
                    if (value != null) {
                        yield helper.setToUser(userId, GOOD_FOLDER_KEY, value);
                    }
                    yield helper.removeFromUser(userId, BAD_FOLDER_KEY);
                });
            }
            const users = yield helper.getKnownUserIds();
            yield Promise.all(users.map((userId) => migrateUser(userId)));
        });
    }
    rollback(helper) {
        return _69_migrate_incorrect_folder_key_awaiter(this, void 0, void 0, function* () {
            function rollbackUser(userId) {
                return _69_migrate_incorrect_folder_key_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, GOOD_FOLDER_KEY);
                    if (value != null) {
                        yield helper.setToUser(userId, BAD_FOLDER_KEY, value);
                    }
                    yield helper.removeFromUser(userId, GOOD_FOLDER_KEY);
                });
            }
            const users = yield helper.getKnownUserIds();
            yield Promise.all(users.map((userId) => rollbackUser(userId)));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/7-move-biometric-auto-prompt-to-account.ts
var _7_move_biometric_auto_prompt_to_account_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveBiometricAutoPromptToAccount extends Migrator {
    migrate(helper) {
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            var _a;
            const global = yield helper.get("global");
            const noAutoPromptBiometrics = (_a = global === null || global === void 0 ? void 0 : global.noAutoPromptBiometrics) !== null && _a !== void 0 ? _a : false;
            const accounts = yield helper.getAccounts();
            function updateAccount(userId, account) {
                return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
                    var _a;
                    if (account == null) {
                        return;
                    }
                    if (noAutoPromptBiometrics) {
                        account.settings = Object.assign((_a = account === null || account === void 0 ? void 0 : account.settings) !== null && _a !== void 0 ? _a : {}, {
                            disableAutoBiometricsPrompt: true,
                        });
                        yield helper.set(userId, account);
                    }
                });
            }
            delete global.noAutoPromptBiometrics;
            yield Promise.all([
                ...accounts.map(({ userId, account }) => updateAccount(userId, account)),
                helper.set("global", global),
            ]);
        });
    }
    rollback(helper) {
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/70-remove-ac-banner-dismissed.ts
var _70_remove_ac_banner_dismissed_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const SHOW_BANNER_KEY = {
    key: "acBannersDismissed",
    stateDefinition: { name: "showProviderClientVaultPrivacyBanner" },
};
class RemoveAcBannersDismissed extends Migrator {
    migrate(helper) {
        return _70_remove_ac_banner_dismissed_awaiter(this, void 0, void 0, function* () {
            yield Promise.all((yield helper.getAccounts()).map((_a) => _70_remove_ac_banner_dismissed_awaiter(this, [_a], void 0, function* ({ userId }) {
                if (helper.getFromUser(userId, SHOW_BANNER_KEY) != null) {
                    yield helper.removeFromUser(userId, SHOW_BANNER_KEY);
                }
            })));
        });
    }
    rollback(helper) {
        return _70_remove_ac_banner_dismissed_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/71-remove-new-customization-options-callout-dismissed.ts
var _71_remove_new_customization_options_callout_dismissed_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const SHOW_CALLOUT_KEY = {
    key: "newCustomizationOptionsCalloutDismissed",
    stateDefinition: { name: "bannersDismissed" },
};
class RemoveNewCustomizationOptionsCalloutDismissed extends Migrator {
    migrate(helper) {
        return _71_remove_new_customization_options_callout_dismissed_awaiter(this, void 0, void 0, function* () {
            yield Promise.all((yield helper.getAccounts()).map((_a) => _71_remove_new_customization_options_callout_dismissed_awaiter(this, [_a], void 0, function* ({ userId }) {
                if (helper.getFromUser(userId, SHOW_CALLOUT_KEY) != null) {
                    yield helper.removeFromUser(userId, SHOW_CALLOUT_KEY);
                }
            })));
        });
    }
    rollback(helper) {
        return _71_remove_new_customization_options_callout_dismissed_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/72-remove-account-deprovisioning-banner-dismissed.ts
var _72_remove_account_deprovisioning_banner_dismissed_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _72_remove_account_deprovisioning_banner_dismissed_SHOW_BANNER_KEY = {
    key: "showAccountDeprovisioningBanner",
    stateDefinition: { name: "accountDeprovisioningBanner" },
};
class RemoveAccountDeprovisioningBannerDismissed extends Migrator {
    migrate(helper) {
        return _72_remove_account_deprovisioning_banner_dismissed_awaiter(this, void 0, void 0, function* () {
            yield Promise.all((yield helper.getAccounts()).map((_a) => _72_remove_account_deprovisioning_banner_dismissed_awaiter(this, [_a], void 0, function* ({ userId }) {
                if (helper.getFromUser(userId, _72_remove_account_deprovisioning_banner_dismissed_SHOW_BANNER_KEY) != null) {
                    yield helper.removeFromUser(userId, _72_remove_account_deprovisioning_banner_dismissed_SHOW_BANNER_KEY);
                }
            })));
        });
    }
    rollback(helper) {
        return _72_remove_account_deprovisioning_banner_dismissed_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/8-move-state-version.ts
var _8_move_state_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveStateVersionMigrator extends Migrator {
    migrate(helper) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            if (global.stateVersion) {
                yield helper.set("stateVersion", global.stateVersion);
                delete global.stateVersion;
                yield helper.set("global", global);
            }
            else {
                throw new Error("Migration failed, state version not found");
            }
        });
    }
    rollback(helper) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const version = yield helper.get("stateVersion");
            const global = yield helper.get("global");
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: version }));
            yield helper.set("stateVersion", undefined);
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but this migration moves
    // it from a `global` object to root.This makes for unique rollback versioning.
    updateVersion(helper, direction) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            if (direction === "up") {
                yield helper.set("stateVersion", endVersion);
            }
            else {
                const global = (yield helper.get("global")) || {};
                yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
            }
        });
    }
}

;// ../../libs/state/src/state-migrations/migrations/9-move-browser-settings-to-global.ts
var _9_move_browser_settings_to_global_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveBrowserSettingsToGlobal extends Migrator {
    // Will first check if any of the accounts have a value from the given accountSelector
    // if they do have a value it will set that value into global state but if multiple
    // users have differing values it will prefer the false setting,
    // if all users have true then it will take true.
    tryAddSetting(accounts, accountSelector, globalSetter) {
        const hasValue = accounts.some(({ account }) => {
            return accountSelector(account) !== undefined;
        });
        if (hasValue) {
            const value = !accounts.some(({ account }) => {
                var _a;
                return ((_a = accountSelector(account)) !== null && _a !== void 0 ? _a : false) === false;
            });
            globalSetter(value);
        }
    }
    migrate(helper) {
        return _9_move_browser_settings_to_global_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            const accounts = yield helper.getAccounts();
            const globalNeverDomainsValue = accounts.reduce((accumulator, { account }) => {
                var _a, _b;
                const normalizedNeverDomains = (_b = (_a = account.settings) === null || _a === void 0 ? void 0 : _a.neverDomains) !== null && _b !== void 0 ? _b : {};
                for (const [id, value] of Object.entries(normalizedNeverDomains)) {
                    accumulator !== null && accumulator !== void 0 ? accumulator : (accumulator = {});
                    accumulator[id] = value;
                }
                return accumulator;
            }, undefined);
            const targetGlobalState = {};
            if (globalNeverDomainsValue != null) {
                targetGlobalState.neverDomains = globalNeverDomainsValue;
            }
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableAddLoginNotification; }, (v) => (targetGlobalState.disableAddLoginNotification = v));
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableChangedPasswordNotification; }, (v) => (targetGlobalState.disableChangedPasswordNotification = v));
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableContextMenuItem; }, (v) => (targetGlobalState.disableContextMenuItem = v));
            yield helper.set("global", Object.assign(Object.assign({}, global), targetGlobalState));
            yield Promise.all(accounts.map((_a) => _9_move_browser_settings_to_global_awaiter(this, [_a], void 0, function* ({ userId, account }) {
                var _b, _c, _d, _e;
                (_b = account.settings) === null || _b === void 0 ? true : delete _b.disableAddLoginNotification;
                (_c = account.settings) === null || _c === void 0 ? true : delete _c.disableChangedPasswordNotification;
                (_d = account.settings) === null || _d === void 0 ? true : delete _d.disableContextMenuItem;
                (_e = account.settings) === null || _e === void 0 ? true : delete _e.neverDomains;
                yield helper.set(userId, account);
            })));
        });
    }
    rollback(helper) {
        throw new Error("Method not implemented.");
    }
}

;// ../../libs/state/src/state-migrations/migrations/min-version.ts
var min_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function minVersionError(current) {
    return `Your local data is too old to be migrated. Your current state version is ${current}, but minimum version is ${MIN_VERSION}.`;
}
class MinVersionMigrator extends Migrator {
    constructor() {
        super(0, MIN_VERSION);
    }
    // Overrides the default implementation to catch any version that may be passed in.
    shouldMigrate(helper) {
        return Promise.resolve(helper.currentVersion < MIN_VERSION);
    }
    migrate(helper) {
        return min_version_awaiter(this, void 0, void 0, function* () {
            if (helper.currentVersion < MIN_VERSION) {
                throw new Error(minVersionError(helper.currentVersion));
            }
        });
    }
    rollback(helper) {
        return min_version_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// ../../libs/state/src/state-migrations/migrate.ts
var migrate_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







































































const MIN_VERSION = 3;
const CURRENT_VERSION = 72;
function createMigrationBuilder() {
    return MigrationBuilder.create()
        .with(MinVersionMigrator)
        .with(RemoveEverBeenUnlockedMigrator, 3, 4)
        .with(AddKeyTypeToOrgKeysMigrator, 4, 5)
        .with(RemoveLegacyEtmKeyMigrator, 5, 6)
        .with(MoveBiometricAutoPromptToAccount, 6, 7)
        .with(MoveStateVersionMigrator, 7, 8)
        .with(MoveBrowserSettingsToGlobal, 8, 9)
        .with(EverHadUserKeyMigrator, 9, 10)
        .with(OrganizationKeyMigrator, 10, 11)
        .with(MoveEnvironmentStateToProviders, 11, 12)
        .with(ProviderKeyMigrator, 12, 13)
        .with(MoveBiometricClientKeyHalfToStateProviders, 13, 14)
        .with(FolderMigrator, 14, 15)
        .with(LastSyncMigrator, 15, 16)
        .with(EnablePasskeysMigrator, 16, 17)
        .with(AutofillSettingsKeyMigrator, 17, 18)
        .with(RequirePasswordOnStartMigrator, 18, 19)
        .with(PrivateKeyMigrator, 19, 20)
        .with(CollectionMigrator, 20, 21)
        .with(CollapsedGroupingsMigrator, 21, 22)
        .with(MoveBiometricPromptsToStateProviders, 22, 23)
        .with(SmOnboardingTasksMigrator, 23, 24)
        .with(ClearClipboardDelayMigrator, 24, 25)
        .with(RevertLastSyncMigrator, 25, 26)
        .with(BadgeSettingsMigrator, 26, 27)
        .with(MoveBiometricUnlockToStateProviders, 27, 28)
        .with(UserNotificationSettingsKeyMigrator, 28, 29)
        .with(PolicyMigrator, 29, 30)
        .with(EnableContextMenuMigrator, 30, 31)
        .with(PreferredLanguageMigrator, 31, 32)
        .with(AppIdMigrator, 32, 33)
        .with(DomainSettingsMigrator, 33, 34)
        .with(MoveThemeToStateProviderMigrator, 34, 35)
        .with(VaultSettingsKeyMigrator, 35, 36)
        .with(AvatarColorMigrator, 36, 37)
        .with(TokenServiceStateProviderMigrator, 37, 38)
        .with(MoveBillingAccountProfileMigrator, 38, 39)
        .with(OrganizationMigrator, 39, 40)
        .with(EventCollectionMigrator, 40, 41)
        .with(EnableFaviconMigrator, 41, 42)
        .with(AutoConfirmFingerPrintsMigrator, 42, 43)
        .with(UserDecryptionOptionsMigrator, 43, 44)
        .with(MergeEnvironmentState, 44, 45)
        .with(DeleteBiometricPromptCancelledData, 45, 46)
        .with(MoveDesktopSettingsMigrator, 46, 47)
        .with(MoveDdgToStateProviderMigrator, 47, 48)
        .with(AccountServerConfigMigrator, 48, 49)
        .with(KeyConnectorMigrator, 49, 50)
        .with(RememberedEmailMigrator, 50, 51)
        .with(DeleteInstalledVersion, 51, 52)
        .with(DeviceTrustServiceStateProviderMigrator, 52, 53)
        .with(SendMigrator, 53, 54)
        .with(MoveMasterKeyStateToProviderMigrator, 54, 55)
        .with(AuthRequestMigrator, 55, 56)
        .with(CipherServiceMigrator, 56, 57)
        .with(RemoveRefreshTokenMigratedFlagMigrator, 57, 58)
        .with(KdfConfigMigrator, 58, 59)
        .with(KnownAccountsMigrator, 59, 60)
        .with(PinStateMigrator, 60, 61)
        .with(VaultTimeoutSettingsServiceStateProviderMigrator, 61, 62)
        .with(PasswordOptionsMigrator, 62, 63)
        .with(GeneratorHistoryMigrator, 63, 64)
        .with(ForwarderOptionsMigrator, 64, 65)
        .with(MoveFinalDesktopSettingsMigrator, 65, 66)
        .with(RemoveUnassignedItemsBannerDismissed, 66, 67)
        .with(MoveLastSyncDate, 67, 68)
        .with(MigrateIncorrectFolderKey, 68, 69)
        .with(RemoveAcBannersDismissed, 69, 70)
        .with(RemoveNewCustomizationOptionsCalloutDismissed, 70, 71)
        .with(RemoveAccountDeprovisioningBannerDismissed, 71, CURRENT_VERSION);
}
function currentVersion(storageService, logService) {
    return migrate_awaiter(this, void 0, void 0, function* () {
        var _a;
        let state = yield storageService.get("stateVersion");
        if (state == null) {
            // Pre v8
            state = (_a = (yield storageService.get("global"))) === null || _a === void 0 ? void 0 : _a.stateVersion;
        }
        if (state == null) {
            logService.info("No state version found, assuming empty state.");
            return -1;
        }
        logService.info(`State version: ${state}`);
        return state;
    });
}
/**
 * Waits for migrations to have a chance to run and will resolve the promise once they are.
 *
 * @param storageService Disk storage where the `stateVersion` will or is already saved in.
 * @param logService Log service
 */
function waitForMigrations(storageService, logService) {
    return migrate_awaiter(this, void 0, void 0, function* () {
        const isReady = () => migrate_awaiter(this, void 0, void 0, function* () {
            const version = yield currentVersion(storageService, logService);
            // The saved version is what we consider the latest
            // migrations should be complete, the state version
            // shouldn't become larger than `CURRENT_VERSION` in
            // any normal usage of the application but it is common
            // enough in dev scenarios where we want to consider that
            // ready as well and return true in that scenario.
            return version >= CURRENT_VERSION;
        });
        const wait = (time) => migrate_awaiter(this, void 0, void 0, function* () {
            // Wait exponentially
            const nextTime = time * 2;
            if (nextTime > 8192) {
                // Don't wait longer than ~8 seconds in a single wait,
                // if the migrations still haven't happened. They aren't
                // likely to.
                return;
            }
            return new Promise((resolve) => {
                setTimeout(() => migrate_awaiter(this, void 0, void 0, function* () {
                    if (!(yield isReady())) {
                        logService.info(`Waiting for migrations to finish, waiting for ${nextTime}ms`);
                        yield wait(nextTime);
                    }
                    resolve();
                }), time);
            });
        });
        if (!(yield isReady())) {
            // Wait for 2ms to start with
            yield wait(2);
        }
    });
}

;// ../../libs/state/src/state-migrations/migration-helper.ts
var migration_helper_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class MigrationHelper {
    constructor(currentVersion, storageService, logService, type, clientType) {
        this.currentVersion = currentVersion;
        this.storageService = storageService;
        this.logService = logService;
        this.clientType = clientType;
        this.type = type;
    }
    /**
     * Gets a value from the storage service at the given key.
     *
     * This is a brute force method to just get a value from the storage service. If you can use {@link getFromGlobal} or {@link getFromUser}, you should.
     * @param key location
     * @returns the value at the location
     */
    get(key) {
        return this.storageService.get(key);
    }
    /**
     * Sets a value in the storage service at the given key.
     *
     * This is a brute force method to just set a value in the storage service. If you can use {@link setToGlobal} or {@link setToUser}, you should.
     * @param key location
     * @param value the value to set
     * @returns
     */
    set(key, value) {
        this.logService.info(`Setting ${key}`);
        return this.storageService.save(key, value);
    }
    /**
     * Remove a value in the storage service at the given key.
     *
     * This is a brute force method to just remove a value in the storage service. If you can use {@link removeFromGlobal} or {@link removeFromUser}, you should.
     * @param key location
     * @returns void
     */
    remove(key) {
        this.logService.info(`Removing ${key}`);
        return this.storageService.remove(key);
    }
    /**
     * Gets a globally scoped value from a location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link get} for those.
     * @param keyDefinition unique key definition
     * @returns value from store
     */
    getFromGlobal(keyDefinition) {
        return this.get(this.getGlobalKey(keyDefinition));
    }
    /**
     * Sets a globally scoped value to a location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link set} for those.
     * @param keyDefinition unique key definition
     * @param value value to store
     * @returns void
     */
    setToGlobal(keyDefinition, value) {
        return this.set(this.getGlobalKey(keyDefinition), value);
    }
    /**
     * Remove a globally scoped location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link remove} for those.
     * @param keyDefinition unique key definition
     * @returns void
     */
    removeFromGlobal(keyDefinition) {
        return this.remove(this.getGlobalKey(keyDefinition));
    }
    /**
     * Gets a user scoped value from a location derived through the user id and key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link get} for those.
     * @param userId userId to use in the key
     * @param keyDefinition unique key definition
     * @returns value from store
     */
    getFromUser(userId, keyDefinition) {
        return this.get(this.getUserKey(userId, keyDefinition));
    }
    /**
     * Sets a user scoped value to a location derived through the user id and key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link set} for those.
     * @param userId userId to use in the key
     * @param keyDefinition unique key definition
     * @param value value to store
     * @returns void
     */
    setToUser(userId, keyDefinition, value) {
        return this.set(this.getUserKey(userId, keyDefinition), value);
    }
    /**
     * Remove a user scoped location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link remove} for those.
     * @param keyDefinition unique key definition
     * @returns void
     */
    removeFromUser(userId, keyDefinition) {
        return this.remove(this.getUserKey(userId, keyDefinition));
    }
    info(message) {
        this.logService.info(message);
    }
    /**
     * Helper method to read all Account objects stored by the State Service.
     *
     * This is useful from creating migrations off of this paradigm, but should not be used once a value is migrated to a state provider.
     *
     * @returns a list of all accounts that have been authenticated with state service, cast the expected type.
     */
    getAccounts() {
        return migration_helper_awaiter(this, void 0, void 0, function* () {
            const userIds = yield this.getKnownUserIds();
            return Promise.all(userIds.map((userId) => migration_helper_awaiter(this, void 0, void 0, function* () {
                return ({
                    userId,
                    account: yield this.get(userId),
                });
            })));
        });
    }
    /**
     * Helper method to read known users ids.
     */
    getKnownUserIds() {
        return migration_helper_awaiter(this, void 0, void 0, function* () {
            if (this.currentVersion < 60) {
                return knownAccountUserIdsBuilderPre60(this.storageService);
            }
            else {
                return knownAccountUserIdsBuilder(this.storageService);
            }
        });
    }
    /**
     * Builds a user storage key appropriate for the current version.
     *
     * @param userId userId to use in the key
     * @param keyDefinition state and key to use in the key
     * @returns
     */
    getUserKey(userId, keyDefinition) {
        if (this.currentVersion < 9) {
            return userKeyBuilderPre9();
        }
        else {
            return userKeyBuilder(userId, keyDefinition);
        }
    }
    /**
     * Builds a global storage key appropriate for the current version.
     *
     * @param keyDefinition state and key to use in the key
     * @returns
     */
    getGlobalKey(keyDefinition) {
        if (this.currentVersion < 9) {
            return globalKeyBuilderPre9();
        }
        else {
            return globalKeyBuilder(keyDefinition);
        }
    }
}
/**
 * When this is updated, rename this function to `userKeyBuilderXToY` where `X` is the version number it
 * became relevant, and `Y` prior to the version it was updated.
 *
 * Be sure to update the map in `MigrationHelper` to point to the appropriate function for the current version.
 * @param userId The userId of the user you want the key to be for.
 * @param keyDefinition the key definition of which data the key should point to.
 * @returns
 */
function userKeyBuilder(userId, keyDefinition) {
    return `user_${userId}_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
function userKeyBuilderPre9() {
    throw Error("No key builder should be used for versions prior to 9.");
}
/**
 * When this is updated, rename this function to `globalKeyBuilderXToY` where `X` is the version number
 * it became relevant, and `Y` prior to the version it was updated.
 *
 * Be sure to update the map in `MigrationHelper` to point to the appropriate function for the current version.
 * @param keyDefinition the key definition of which data the key should point to.
 * @returns
 */
function globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
function globalKeyBuilderPre9() {
    throw Error("No key builder should be used for versions prior to 9.");
}
function knownAccountUserIdsBuilderPre60(storageService) {
    return migration_helper_awaiter(this, void 0, void 0, function* () {
        var _a;
        return (_a = (yield storageService.get("authenticatedAccounts"))) !== null && _a !== void 0 ? _a : [];
    });
}
function knownAccountUserIdsBuilder(storageService) {
    return migration_helper_awaiter(this, void 0, void 0, function* () {
        const accounts = yield storageService.get(globalKeyBuilder({ stateDefinition: { name: "account" }, key: "accounts" }));
        return Object.keys(accounts !== null && accounts !== void 0 ? accounts : {});
    });
}

;// ../../libs/state/src/state-migrations/index.ts





;// ../../libs/state/src/index.ts
// Root barrel for @bitwarden/state





;// ../../libs/state-internal/src/default-active-user-state.ts
var default_active_user_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class DefaultActiveUserState {
    constructor(keyDefinition, activeUserId$, singleUserStateProvider) {
        this.keyDefinition = keyDefinition;
        this.activeUserId$ = activeUserId$;
        this.singleUserStateProvider = singleUserStateProvider;
        this.combinedState$ = this.activeUserId$.pipe((0,external_rxjs_namespaceObject.switchMap)((userId) => userId != null
            ? this.singleUserStateProvider.get(userId, this.keyDefinition).combinedState$
            : external_rxjs_namespaceObject.NEVER));
        // State should just be combined state without the user id
        this.state$ = this.combinedState$.pipe((0,external_rxjs_namespaceObject.map)(([_userId, state]) => state));
    }
    update(configureState_1) {
        return default_active_user_state_awaiter(this, arguments, void 0, function* (configureState, options = {}) {
            const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserId$.pipe((0,external_rxjs_namespaceObject.timeout)({
                first: 1000,
                with: () => (0,external_rxjs_namespaceObject.throwError)(() => new Error(`Timeout while retrieving active user for key ${this.keyDefinition.fullName}.`)),
            })));
            if (userId == null) {
                throw new Error(`Error storing ${this.keyDefinition.fullName} for the active user: No active user at this time.`);
            }
            return [
                userId,
                yield this.singleUserStateProvider
                    .get(userId, this.keyDefinition)
                    .update(configureState, options),
            ];
        });
    }
}

;// ../../libs/state-internal/src/default-active-user-state.provider.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class DefaultActiveUserStateProvider {
    constructor(activeAccountAccessor, singleUserStateProvider) {
        this.activeAccountAccessor = activeAccountAccessor;
        this.singleUserStateProvider = singleUserStateProvider;
        this.activeUserId$ = this.activeAccountAccessor.activeUserId$.pipe(
        // To avoid going to storage when we don't need to, only get updates when there is a true change.
        (0,external_rxjs_namespaceObject.distinctUntilChanged)((a, b) => (a == null || b == null ? a == b : a === b)));
    }
    get(keyDefinition) {
        // All other providers cache the creation of their corresponding `State` objects, this instance
        // doesn't need to do that since it calls `SingleUserStateProvider` it will go through their caching
        // layer, because of that, the creation of this instance is quite simple and not worth caching.
        return new DefaultActiveUserState(keyDefinition, this.activeUserId$, this.singleUserStateProvider);
    }
}

;// ../../libs/state-internal/src/default-derived-state.ts
var default_derived_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/**
 * Default derived state
 */
class DefaultDerivedState {
    constructor(parentState$, deriveDefinition, dependencies) {
        this.parentState$ = parentState$;
        this.deriveDefinition = deriveDefinition;
        this.dependencies = dependencies;
        this.forcedValueSubject = new external_rxjs_namespaceObject.Subject();
        this.storageKey = deriveDefinition.storageKey;
        const derivedState$ = this.parentState$.pipe((0,external_rxjs_namespaceObject.concatMap)((state) => default_derived_state_awaiter(this, void 0, void 0, function* () {
            let derivedStateOrPromise = this.deriveDefinition.derive(state, this.dependencies);
            if (derivedStateOrPromise instanceof Promise) {
                derivedStateOrPromise = yield derivedStateOrPromise;
            }
            const derivedState = derivedStateOrPromise;
            return derivedState;
        })));
        this.state$ = (0,external_rxjs_namespaceObject.merge)(this.forcedValueSubject, derivedState$).pipe((0,external_rxjs_namespaceObject.share)({
            connector: () => {
                return new external_rxjs_namespaceObject.ReplaySubject(1);
            },
            resetOnRefCountZero: () => (0,external_rxjs_namespaceObject.timer)(this.deriveDefinition.cleanupDelayMs),
        }));
    }
    forceValue(value) {
        return default_derived_state_awaiter(this, void 0, void 0, function* () {
            this.forcedValueSubject.next(value);
            return value;
        });
    }
}

;// ../../libs/state-internal/src/default-derived-state.provider.ts

class DefaultDerivedStateProvider {
    constructor() {
        /**
         * The cache uses a WeakMap to maintain separate derived states per user.
         * Each user's state Observable acts as a unique key, without needing to
         * pass around `userId`. Also, when a user's state Observable is cleaned up
         * (like during an account swap) their cache is automatically garbage
         * collected.
         */
        this.cache = new WeakMap();
    }
    get(parentState$, deriveDefinition, dependencies) {
        let stateCache = this.cache.get(parentState$);
        if (!stateCache) {
            stateCache = {};
            this.cache.set(parentState$, stateCache);
        }
        const cacheKey = deriveDefinition.buildCacheKey();
        const existingDerivedState = stateCache[cacheKey];
        if (existingDerivedState != null) {
            // I have to cast out of the unknown generic but this should be safe if rules
            // around domain token are made
            return existingDerivedState;
        }
        const newDerivedState = this.buildDerivedState(parentState$, deriveDefinition, dependencies);
        stateCache[cacheKey] = newDerivedState;
        return newDerivedState;
    }
    buildDerivedState(parentState$, deriveDefinition, dependencies) {
        return new DefaultDerivedState(parentState$, deriveDefinition, dependencies);
    }
}

;// ../../libs/state-internal/src/util.ts
var util_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function getStoredValue(key, storage, deserializer) {
    return util_awaiter(this, void 0, void 0, function* () {
        if (storage.valuesRequireDeserialization) {
            const jsonValue = yield storage.get(key);
            return deserializer(jsonValue);
        }
        else {
            const value = yield storage.get(key);
            return value !== null && value !== void 0 ? value : null;
        }
    });
}
/**
 * Creates a {@link StorageKey}
 * @param keyDefinition The key definition of which data the key should point to.
 * @returns A key that is ready to be used in a storage service to get data.
 */
function util_globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
function populateOptionsWithDefault(options) {
    const { combineLatestWith = null, shouldUpdate = () => true, msTimeout = 1000 } = options;
    return {
        combineLatestWith: combineLatestWith,
        shouldUpdate: shouldUpdate,
        msTimeout: msTimeout,
    };
}

;// ../../libs/state-internal/src/state-base.ts
var state_base_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class StateBase {
    constructor(key, storageService, keyDefinition, logService) {
        this.key = key;
        this.storageService = storageService;
        this.keyDefinition = keyDefinition;
        this.logService = logService;
        const storageUpdate$ = storageService.updates$.pipe((0,external_rxjs_namespaceObject.filter)((storageUpdate) => storageUpdate.key === key), (0,external_rxjs_namespaceObject.switchMap)((storageUpdate) => state_base_awaiter(this, void 0, void 0, function* () {
            if (storageUpdate.updateType === "remove") {
                return null;
            }
            return yield getStoredValue(key, storageService, keyDefinition.deserializer);
        })));
        let state$ = (0,external_rxjs_namespaceObject.merge)((0,external_rxjs_namespaceObject.defer)(() => getStoredValue(key, storageService, keyDefinition.deserializer)), storageUpdate$);
        if (keyDefinition.debug.enableRetrievalLogging) {
            state$ = state$.pipe((0,external_rxjs_namespaceObject.tap)({
                next: (v) => {
                    this.logService.info(`Retrieving '${key}' from storage, value is ${v == null ? "null" : "non-null"}`);
                },
            }));
        }
        // If 0 cleanup is chosen, treat this as absolutely no cache
        if (keyDefinition.cleanupDelayMs !== 0) {
            state$ = state$.pipe((0,external_rxjs_namespaceObject.share)({
                connector: () => new external_rxjs_namespaceObject.ReplaySubject(1),
                resetOnRefCountZero: () => (0,external_rxjs_namespaceObject.timer)(keyDefinition.cleanupDelayMs),
            }));
        }
        this.state$ = state$;
    }
    update(configureState_1) {
        return state_base_awaiter(this, arguments, void 0, function* (configureState, options = {}) {
            const normalizedOptions = populateOptionsWithDefault(options);
            if (this.updatePromise != null) {
                yield this.updatePromise;
            }
            try {
                this.updatePromise = this.internalUpdate(configureState, normalizedOptions);
                return yield this.updatePromise;
            }
            finally {
                this.updatePromise = null;
            }
        });
    }
    internalUpdate(configureState, options) {
        return state_base_awaiter(this, void 0, void 0, function* () {
            const currentState = yield this.getStateForUpdate();
            const combinedDependencies = options.combineLatestWith != null
                ? yield (0,external_rxjs_namespaceObject.firstValueFrom)(options.combineLatestWith.pipe((0,external_rxjs_namespaceObject.timeout)(options.msTimeout)))
                : null;
            if (!options.shouldUpdate(currentState, combinedDependencies)) {
                return currentState;
            }
            const newState = configureState(currentState, combinedDependencies);
            yield this.doStorageSave(newState, currentState);
            return newState;
        });
    }
    doStorageSave(newState, oldState) {
        return state_base_awaiter(this, void 0, void 0, function* () {
            if (this.keyDefinition.debug.enableUpdateLogging) {
                this.logService.info(`Updating '${this.key}' from ${oldState == null ? "null" : "non-null"} to ${newState == null ? "null" : "non-null"}`);
            }
            yield this.storageService.save(this.key, newState);
        });
    }
    /** For use in update methods, does not wait for update to complete before yielding state.
     * The expectation is that that await is already done
     */
    getStateForUpdate() {
        return state_base_awaiter(this, void 0, void 0, function* () {
            return yield getStoredValue(this.key, this.storageService, this.keyDefinition.deserializer);
        });
    }
}

;// ../../libs/state-internal/src/default-global-state.ts


class DefaultGlobalState extends StateBase {
    constructor(keyDefinition, chosenLocation, logService) {
        super(util_globalKeyBuilder(keyDefinition), chosenLocation, keyDefinition, logService);
    }
}

;// ../../libs/state-internal/src/default-global-state.provider.ts

class DefaultGlobalStateProvider {
    constructor(storageServiceProvider, logService) {
        this.storageServiceProvider = storageServiceProvider;
        this.logService = logService;
        this.globalStateCache = {};
    }
    get(keyDefinition) {
        const [location, storageService] = this.storageServiceProvider.get(keyDefinition.stateDefinition.defaultStorageLocation, keyDefinition.stateDefinition.storageLocationOverrides);
        const cacheKey = this.buildCacheKey(location, keyDefinition);
        const existingGlobalState = this.globalStateCache[cacheKey];
        if (existingGlobalState != null) {
            // The cast into the actual generic is safe because of rules around key definitions
            // being unique.
            return existingGlobalState;
        }
        const newGlobalState = new DefaultGlobalState(keyDefinition, storageService, this.logService);
        this.globalStateCache[cacheKey] = newGlobalState;
        return newGlobalState;
    }
    buildCacheKey(location, keyDefinition) {
        return `${location}_${keyDefinition.fullName}`;
    }
}

;// ../../libs/state-internal/src/default-single-user-state.ts
var default_single_user_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class DefaultSingleUserState extends StateBase {
    constructor(userId, keyDefinition, chosenLocation, stateEventRegistrarService, logService) {
        super(keyDefinition.buildKey(userId), chosenLocation, keyDefinition, logService);
        this.userId = userId;
        this.stateEventRegistrarService = stateEventRegistrarService;
        this.combinedState$ = (0,external_rxjs_namespaceObject.combineLatest)([(0,external_rxjs_namespaceObject.of)(userId), this.state$]);
    }
    doStorageSave(newState, oldState) {
        const _super = Object.create(null, {
            doStorageSave: { get: () => super.doStorageSave }
        });
        return default_single_user_state_awaiter(this, void 0, void 0, function* () {
            yield _super.doStorageSave.call(this, newState, oldState);
            if (newState != null && oldState == null) {
                yield this.stateEventRegistrarService.registerEvents(this.keyDefinition);
            }
        });
    }
}

;// ../../libs/state-internal/src/default-single-user-state.provider.ts

class DefaultSingleUserStateProvider {
    constructor(storageServiceProvider, stateEventRegistrarService, logService) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventRegistrarService = stateEventRegistrarService;
        this.logService = logService;
        this.cache = {};
    }
    get(userId, keyDefinition) {
        const [location, storageService] = this.storageServiceProvider.get(keyDefinition.stateDefinition.defaultStorageLocation, keyDefinition.stateDefinition.storageLocationOverrides);
        const cacheKey = this.buildCacheKey(location, userId, keyDefinition);
        const existingUserState = this.cache[cacheKey];
        if (existingUserState != null) {
            // I have to cast out of the unknown generic but this should be safe if rules
            // around domain token are made
            return existingUserState;
        }
        const newUserState = new DefaultSingleUserState(userId, keyDefinition, storageService, this.stateEventRegistrarService, this.logService);
        this.cache[cacheKey] = newUserState;
        return newUserState;
    }
    buildCacheKey(location, userId, keyDefinition) {
        return `${location}_${keyDefinition.fullName}_${userId}`;
    }
}

;// ../../libs/state-internal/src/default-state.provider.ts
var default_state_provider_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class DefaultStateProvider {
    constructor(activeUserStateProvider, singleUserStateProvider, globalStateProvider, derivedStateProvider) {
        this.activeUserStateProvider = activeUserStateProvider;
        this.singleUserStateProvider = singleUserStateProvider;
        this.globalStateProvider = globalStateProvider;
        this.derivedStateProvider = derivedStateProvider;
        this.getActive = this.activeUserStateProvider.get.bind(this.activeUserStateProvider);
        this.getUser = this.singleUserStateProvider.get.bind(this.singleUserStateProvider);
        this.getGlobal = this.globalStateProvider.get.bind(this.globalStateProvider);
        this.getDerived = this.derivedStateProvider.get.bind(this.derivedStateProvider);
        this.activeUserId$ = this.activeUserStateProvider.activeUserId$;
    }
    getUserState$(userKeyDefinition, userId) {
        if (userId) {
            return this.getUser(userId, userKeyDefinition).state$;
        }
        else {
            return this.activeUserId$.pipe((0,external_rxjs_namespaceObject.filter)((userId) => userId != null), // Filter out null-ish user ids since we can't get state for a null user id
            (0,external_rxjs_namespaceObject.take)(1), (0,external_rxjs_namespaceObject.switchMap)((userId) => this.getUser(userId, userKeyDefinition).state$));
        }
    }
    getUserStateOrDefault$(userKeyDefinition, config) {
        const { userId, defaultValue = null } = config;
        if (userId) {
            return this.getUser(userId, userKeyDefinition).state$;
        }
        else {
            return this.activeUserId$.pipe((0,external_rxjs_namespaceObject.take)(1), (0,external_rxjs_namespaceObject.switchMap)((userId) => userId != null ? this.getUser(userId, userKeyDefinition).state$ : (0,external_rxjs_namespaceObject.of)(defaultValue)));
        }
    }
    setUserState(userKeyDefinition, value, userId) {
        return default_state_provider_awaiter(this, void 0, void 0, function* () {
            if (userId) {
                return [userId, yield this.getUser(userId, userKeyDefinition).update(() => value)];
            }
            else {
                return yield this.getActive(userKeyDefinition).update(() => value);
            }
        });
    }
}

;// ../../libs/state-internal/src/inline-derived-state.ts
var inline_derived_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class InlineDerivedStateProvider {
    get(parentState$, deriveDefinition, dependencies) {
        return new InlineDerivedState(parentState$, deriveDefinition, dependencies);
    }
}
class InlineDerivedState {
    constructor(parentState$, deriveDefinition, dependencies) {
        this.state$ = parentState$.pipe(concatMap((value) => inline_derived_state_awaiter(this, void 0, void 0, function* () { return yield deriveDefinition.derive(value, dependencies); })));
    }
    forceValue(value) {
        // No need to force anything, we don't keep a cache
        return Promise.resolve(value);
    }
}

;// ../../libs/state-internal/src/legacy/global-state.ts
class GlobalState {
}

;// ../../libs/state-internal/src/legacy/default-state.service.ts
var default_state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const keys = {
    global: "global",
};
const partialKeys = {
    userAutoKey: "_user_auto",
    userBiometricKey: "_user_biometric",
};
const DDG_SHARED_KEY = "DuckDuckGoSharedKey";
class DefaultStateService {
    constructor(storageService, secureStorageService, activeUserAccessor) {
        this.storageService = storageService;
        this.secureStorageService = secureStorageService;
        this.activeUserAccessor = activeUserAccessor;
    }
    clean(options) {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.setUserKeyAutoUnlock(null, options);
            yield this.clearUserKeyBiometric(options.userId);
        });
    }
    /**
     * user key when using the "never" option of vault timeout
     */
    getUserKeyAutoUnlock(options) {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            if (options.userId == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.userAutoKey}`, {
                userId: options.userId,
                keySuffix: "auto",
            });
        });
    }
    /**
     * user key when using the "never" option of vault timeout
     */
    setUserKeyAutoUnlock(value, options) {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            if (options.userId == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.userAutoKey, value, options.userId, "auto");
        });
    }
    clearUserKeyBiometric(userId) {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.userBiometricKey, null, userId, "biometric");
        });
    }
    getDuckDuckGoSharedKey() {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.getActiveUserIdFromStorage();
            if (userId == null) {
                return null;
            }
            return yield this.secureStorageService.get(DDG_SHARED_KEY);
        });
    }
    setDuckDuckGoSharedKey(value) {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.getActiveUserIdFromStorage();
            if (userId == null) {
                return;
            }
            value == null
                ? yield this.secureStorageService.remove(DDG_SHARED_KEY)
                : yield this.secureStorageService.save(DDG_SHARED_KEY, value);
        });
    }
    setEnableDuckDuckGoBrowserIntegration(value) {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            const globals = (_a = (yield this.storageService.get(keys.global))) !== null && _a !== void 0 ? _a : new GlobalState();
            globals.enableDuckDuckGoBrowserIntegration = value;
            yield this.storageService.save(keys.global, globals);
        });
    }
    getActiveUserIdFromStorage() {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserAccessor.activeUserId$);
        });
    }
    saveSecureStorageKey(key, value, userId, keySuffix) {
        return default_state_service_awaiter(this, void 0, void 0, function* () {
            return value == null
                ? yield this.secureStorageService.remove(`${userId}${key}`, { keySuffix: keySuffix })
                : yield this.secureStorageService.save(`${userId}${key}`, value, {
                    keySuffix: keySuffix,
                });
        });
    }
}

;// ../../libs/state-internal/src/default-state-event-registrar.service.ts
var default_state_event_registrar_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const STATE_LOCK_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "lock", {
    deserializer: (e) => e,
});
const STATE_LOGOUT_EVENT = KeyDefinition.array(CLEAR_EVENT_DISK, "logout", {
    deserializer: (e) => e,
});
class DefaultStateEventRegistrarService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventStateMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    registerEvents(keyDefinition) {
        return default_state_event_registrar_service_awaiter(this, void 0, void 0, function* () {
            for (const clearEvent of keyDefinition.clearOn) {
                const eventState = this.stateEventStateMap[clearEvent];
                // Determine the storage location for this
                const [storageLocation] = this.storageServiceProvider.get(keyDefinition.stateDefinition.defaultStorageLocation, keyDefinition.stateDefinition.storageLocationOverrides);
                const newEvent = {
                    state: keyDefinition.stateDefinition.name,
                    key: keyDefinition.key,
                    location: storageLocation,
                };
                // Only update the event state if the existing list doesn't have a matching entry
                yield eventState.update((existingTickets) => {
                    existingTickets !== null && existingTickets !== void 0 ? existingTickets : (existingTickets = []);
                    existingTickets.push(newEvent);
                    return existingTickets;
                }, {
                    shouldUpdate: (currentTickets) => {
                        return (
                        // If the current tickets are null, then it will for sure be added
                        currentTickets == null ||
                            // If an existing match couldn't be found, we also need to add one
                            currentTickets.findIndex((e) => e.state === newEvent.state &&
                                e.key === newEvent.key &&
                                e.location === newEvent.location) === -1);
                    },
                });
            }
        });
    }
}

;// ../../libs/state-internal/src/default-state-event-runner.service.ts
var default_state_event_runner_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class DefaultStateEventRunnerService {
    constructor(globalStateProvider, storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
        this.stateEventMap = {
            lock: globalStateProvider.get(STATE_LOCK_EVENT),
            logout: globalStateProvider.get(STATE_LOGOUT_EVENT),
        };
    }
    handleEvent(event, userId) {
        return default_state_event_runner_service_awaiter(this, void 0, void 0, function* () {
            let tickets = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateEventMap[event].state$);
            tickets !== null && tickets !== void 0 ? tickets : (tickets = []);
            const failures = [];
            for (const ticket of tickets) {
                try {
                    const [, service] = this.storageServiceProvider.get(ticket.location, {});
                    const ticketStorageKey = this.storageKeyFor(userId, ticket);
                    // Evaluate current value so we can avoid writing to state if we don't need to
                    const currentValue = yield service.get(ticketStorageKey);
                    if (currentValue != null) {
                        yield service.remove(ticketStorageKey);
                    }
                }
                catch (err) {
                    let errorMessage = "Unknown Error";
                    if (err != null &&
                        typeof err === "object" &&
                        "message" in err &&
                        typeof err.message === "string") {
                        errorMessage = err.message;
                    }
                    failures.push(`${errorMessage} in ${ticket.state} > ${ticket.key} located ${ticket.location}`);
                }
            }
            if (failures.length > 0) {
                // Throw aggregated error
                throw new Error(`One or more errors occurred while handling event '${event}' for user ${userId}.\n${failures.join("\n")}`);
            }
        });
    }
    storageKeyFor(userId, ticket) {
        const userKey = new UserKeyDefinition(new StateDefinition(ticket.state, ticket.location), ticket.key, {
            deserializer: (v) => v,
            clearOn: [],
        });
        return userKey.buildKey(userId);
    }
}

;// ../../libs/state-internal/src/index.ts

















;// ../../libs/common/src/platform/state/index.ts



;// ../../libs/auth/src/common/services/login-email/login-email.service.ts
var login_email_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


// FIXME: remove `src` and fix import
// eslint-disable-next-line no-restricted-imports

const LOGIN_EMAIL = new KeyDefinition(LOGIN_EMAIL_MEMORY, "loginEmail", {
    deserializer: (value) => value,
});
const login_email_service_STORED_EMAIL = new KeyDefinition(LOGIN_EMAIL_DISK, "storedEmail", {
    deserializer: (value) => value,
});
class LoginEmailService {
    constructor(accountService, authService, stateProvider) {
        this.accountService = accountService;
        this.authService = authService;
        this.stateProvider = stateProvider;
        this.loginEmailState = this.stateProvider.getGlobal(LOGIN_EMAIL);
        this.storedEmailState = this.stateProvider.getGlobal(login_email_service_STORED_EMAIL);
        // In order to determine if an account is being added, we check if any account is not logged out
        this.addingAccount$ = this.authService.authStatuses$.pipe(switchMap((statuses) => login_email_service_awaiter(this, void 0, void 0, function* () {
            // We don't want to consider the active account since it may have just changed auth status to logged in
            // which would make this observable think an account is being added
            const activeUser = yield firstValueFrom(this.accountService.activeAccount$);
            if (activeUser) {
                delete statuses[activeUser.id];
            }
            return Object.values(statuses).some((status) => status !== AuthenticationStatus.LoggedOut);
        })));
        this.loginEmail$ = this.loginEmailState.state$;
        this.rememberedEmail$ = this.storedEmailState.state$.pipe(switchMap((storedEmail) => login_email_service_awaiter(this, void 0, void 0, function* () {
            // When adding an account, we don't show the stored email
            if (yield firstValueFrom(this.addingAccount$)) {
                return null;
            }
            return storedEmail;
        })));
    }
    /** Sets the login email in memory.
     * The login email is the email that is being used in the current login process.
     */
    setLoginEmail(email) {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            yield this.loginEmailState.update((_) => email);
        });
    }
    /**
     * Clears the in-progress login email from state.
     * Note: Only clear on successful login or you are sure they are not needed.
     * The extension client uses these values to maintain the email between login and 2fa components so
     * we do not want to clear them too early.
     */
    clearLoginEmail() {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            yield this.loginEmailState.update((_) => null);
        });
    }
    setRememberedEmailChoice(email, remember) {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            if (remember) {
                yield this.storedEmailState.update((_) => email);
            }
            else {
                yield this.storedEmailState.update((_) => null);
            }
        });
    }
    clearRememberedEmail() {
        return login_email_service_awaiter(this, void 0, void 0, function* () {
            yield this.storedEmailState.update((_) => null);
        });
    }
}

;// ../../libs/common/src/models/request/prelogin.request.ts
class PreloginRequest {
    constructor(email) {
        this.email = email;
    }
}

;// ../../libs/common/src/platform/scheduling/task-scheduler.service.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/**
 * Creates a RXJS scheduler based on a {@link TaskSchedulerService}.
 *
 * @description This API defers to `TaskSchedulerService` to schedule a task to be ran
 * in the future but the task that is ran is NOT the remainder of your RXJS pipeline. The
 * task you want ran must instead be registered in a location reachable on a service worker
 * startup (on browser). An example of an acceptible location is the constructor of a service
 * you know is created in `MainBackground`. Uses of this API in other clients _can_ have the
 * `registerTaskHandler` call in more places, but in order to have it work across clients
 * it is recommended to register it according to the rules of browser.
 *
 * @link https://rxjs.dev/guide/scheduler#using-schedulers
 *
 * @example
 * ```ts
 * class MyService {
 *   constructor(messageListener: MessageListener, taskScheduler: TaskSchedulerService) {
 *    // VERY IMPORTANT!
 *    this.taskSchedulerService.registerTaskHandler(SchedulerTaskNames.myTaskName, async () => {
 *      await this.runEvent();
 *    });
 *
 *     messageListener.messages$(MY_MESSAGE).pipe(
 *        debounceTime(
 *          10 * 1000,
 *          toScheduler(taskScheduler, ShedulerTaskNames.myTaskName),
 *        ),
 *        switchMap(() => this.runEvent()),
 *     )
 *   }
 * }
 * ```
 *
 * @param taskScheduler The task scheduler service to use to shedule RXJS work.
 * @param taskName The name of the task that the handler should be registered and scheduled based on.
 * @returns A SchedulerLike object that can be passed in to RXJS operators like `delay` and `timeout`.
 */
function toScheduler(taskScheduler, taskName) {
    return new TaskSchedulerSheduler(taskScheduler, taskName);
}
class TaskSchedulerSheduler {
    constructor(taskSchedulerService, taskName) {
        this.taskSchedulerService = taskSchedulerService;
        this.taskName = taskName;
    }
    schedule(work, delay, state) {
        return this.taskSchedulerService.setTimeout(this.taskName, delay !== null && delay !== void 0 ? delay : 0);
    }
    now() {
        return asyncScheduler.now();
    }
}
class TaskSchedulerService {
}

;// ../../libs/common/src/platform/scheduling/default-task-scheduler.service.ts
var default_task_scheduler_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class DefaultTaskSchedulerService extends TaskSchedulerService {
    constructor(logService) {
        super();
        this.logService = logService;
        this.taskHandlers = new Map();
    }
    /**
     * Sets a timeout and returns the timeout id.
     *
     * @param taskName - The name of the task. Unused in the base implementation.
     * @param delayInMs - The delay in milliseconds.
     */
    setTimeout(taskName, delayInMs) {
        this.validateRegisteredTask(taskName);
        const timeoutHandle = globalThis.setTimeout(() => this.triggerTask(taskName), delayInMs);
        return new external_rxjs_namespaceObject.Subscription(() => globalThis.clearTimeout(timeoutHandle));
    }
    /**
     * Sets an interval and returns the interval id.
     *
     * @param taskName - The name of the task. Unused in the base implementation.
     * @param intervalInMs - The interval in milliseconds.
     * @param _initialDelayInMs - The initial delay in milliseconds. Unused in the base implementation.
     */
    setInterval(taskName, intervalInMs, _initialDelayInMs) {
        this.validateRegisteredTask(taskName);
        const intervalHandle = globalThis.setInterval(() => this.triggerTask(taskName), intervalInMs);
        return new external_rxjs_namespaceObject.Subscription(() => globalThis.clearInterval(intervalHandle));
    }
    /**
     * Registers a task handler.
     *
     * @param taskName - The name of the task.
     * @param handler - The task handler.
     */
    registerTaskHandler(taskName, handler) {
        const existingHandler = this.taskHandlers.get(taskName);
        if (existingHandler) {
            this.logService.warning(`Task handler for ${taskName} already exists. Overwriting.`);
            this.unregisterTaskHandler(taskName);
        }
        this.taskHandlers.set(taskName, handler);
    }
    /**
     * Unregisters a task handler.
     *
     * @param taskName - The name of the task.
     */
    unregisterTaskHandler(taskName) {
        this.taskHandlers.delete(taskName);
    }
    /**
     * Triggers a task.
     *
     * @param taskName - The name of the task.
     * @param _periodInMinutes - The period in minutes. Unused in the base implementation.
     */
    triggerTask(taskName, _periodInMinutes) {
        return default_task_scheduler_service_awaiter(this, void 0, void 0, function* () {
            const handler = this.taskHandlers.get(taskName);
            if (handler) {
                handler();
            }
        });
    }
    /**
     * Validates that a task handler is registered.
     *
     * @param taskName - The name of the task.
     */
    validateRegisteredTask(taskName) {
        if (!this.taskHandlers.has(taskName)) {
            throw new Error(`Task handler for ${taskName} not registered. Unable to schedule task.`);
        }
    }
}

;// ../../libs/common/src/platform/scheduling/scheduled-task-name.enum.ts
const ScheduledTaskNames = {
    generatePasswordClearClipboardTimeout: "generatePasswordClearClipboardTimeout",
    systemClearClipboardTimeout: "systemClearClipboardTimeout",
    loginStrategySessionTimeout: "loginStrategySessionTimeout",
    notificationsReconnectTimeout: "notificationsReconnectTimeout",
    fido2ClientAbortTimeout: "fido2ClientAbortTimeout",
    scheduleNextSyncInterval: "scheduleNextSyncInterval",
    eventUploadsInterval: "eventUploadsInterval",
    vaultTimeoutCheckInterval: "vaultTimeoutCheckInterval",
    clearPopupViewCache: "clearPopupViewCache",
};

;// ../../libs/common/src/platform/scheduling/index.ts




;// ../../libs/common/src/key-management/crypto/models/enc-string.ts
var enc_string_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const DECRYPT_ERROR = "[error: cannot decrypt]";
class enc_string_EncString {
    constructor(encryptedStringOrType, data, iv, mac) {
        if (data != null) {
            this.initFromData(encryptedStringOrType, data, iv, mac);
        }
        else {
            this.initFromEncryptedString(encryptedStringOrType);
        }
    }
    get ivBytes() {
        return this.iv == null ? null : utils_Utils.fromB64ToArray(this.iv);
    }
    get macBytes() {
        return this.mac == null ? null : utils_Utils.fromB64ToArray(this.mac);
    }
    get dataBytes() {
        return this.data == null ? null : utils_Utils.fromB64ToArray(this.data);
    }
    toSdk() {
        return this.encryptedString;
    }
    toJSON() {
        return this.encryptedString;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return new enc_string_EncString(obj);
    }
    initFromData(encType, data, iv, mac) {
        if (iv != null) {
            this.encryptedString = (encType + "." + iv + "|" + data);
        }
        else {
            this.encryptedString = (encType + "." + data);
        }
        // mac
        if (mac != null) {
            this.encryptedString = (this.encryptedString + "|" + mac);
        }
        this.encryptionType = encType;
        this.data = data;
        this.iv = iv;
        this.mac = mac;
    }
    initFromEncryptedString(encryptedString) {
        this.encryptedString = encryptedString;
        if (!this.encryptedString) {
            return;
        }
        const { encType, encPieces } = enc_string_EncString.parseEncryptedString(this.encryptedString);
        this.encryptionType = encType;
        if (encPieces.length !== EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType]) {
            return;
        }
        switch (encType) {
            case encryption_type_enum_EncryptionType.AesCbc256_HmacSha256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                this.mac = encPieces[2];
                break;
            case encryption_type_enum_EncryptionType.AesCbc256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                break;
            case encryption_type_enum_EncryptionType.Rsa2048_OaepSha256_B64:
            case encryption_type_enum_EncryptionType.Rsa2048_OaepSha1_B64:
                this.data = encPieces[0];
                break;
            case encryption_type_enum_EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64:
            case encryption_type_enum_EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                this.data = encPieces[0];
                this.mac = encPieces[1];
                break;
            default:
                return;
        }
    }
    static parseEncryptedString(encryptedString) {
        const headerPieces = encryptedString.split(".");
        let encType;
        let encPieces = null;
        if (headerPieces.length === 2) {
            try {
                encType = parseInt(headerPieces[0], null);
                encPieces = headerPieces[1].split("|");
                // FIXME: Remove when updating file. Eslint update
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
            }
            catch (e) {
                return { encType: NaN, encPieces: [] };
            }
        }
        else {
            encPieces = encryptedString.split("|");
            encType = encryption_type_enum_EncryptionType.AesCbc256_B64;
        }
        return {
            encType,
            encPieces,
        };
    }
    static isSerializedEncString(s) {
        if (s == null) {
            return false;
        }
        const { encType, encPieces } = this.parseEncryptedString(s);
        if (isNaN(encType) || encPieces.length === 0) {
            return false;
        }
        return EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType] === encPieces.length;
    }
    /**
     * @deprecated - This function is deprecated. Use EncryptService.decryptString instead.
     * @returns - The decrypted string, or `[error: cannot decrypt]` if decryption fails.
     */
    decrypt(orgId_1) {
        return enc_string_awaiter(this, arguments, void 0, function* (orgId, key = null, context) {
            if (this.decryptedValue != null) {
                return this.decryptedValue;
            }
            try {
                if (key == null) {
                    key = yield this.getKeyForDecryption(orgId);
                }
                if (key == null) {
                    throw new Error("No key to decrypt EncString with orgId " + orgId);
                }
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                this.decryptedValue = yield encryptService.decryptString(this, key);
            }
            catch (e) {
                // eslint-disable-next-line no-console
                console.error("[EncString Generic Decrypt] failed to decrypt encstring. Context: " +
                    (context !== null && context !== void 0 ? context : "No context"), e);
                this.decryptedValue = DECRYPT_ERROR;
            }
            return this.decryptedValue;
        });
    }
    getKeyForDecryption(orgId) {
        return enc_string_awaiter(this, void 0, void 0, function* () {
            const keyService = utils_Utils.getContainerService().getKeyService();
            return orgId != null ? yield keyService.getOrgKey(orgId) : yield keyService.getUserKey();
        });
    }
}

;// ../../libs/key-management/src/biometrics/biometric.state.ts

/**
 * Indicates whether the user elected to store a biometric key to unlock their vault.
 */
const biometric_state_BIOMETRIC_UNLOCK_ENABLED = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "biometricUnlockEnabled", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * If the user has elected to require a password on first unlock of an application instance, this key will store the
 * encrypted client key half used to unlock the vault.
 *
 * For operating systems without application-level key storage, this key half is concatenated with a signature
 * provided by the OS and used to encrypt the biometric key prior to storage.
 */
const ENCRYPTED_CLIENT_KEY_HALF = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "clientKeyHalf", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
/**
 * Stores whether the user has elected to cancel the biometric prompt. This is stored on disk due to process-reload
 * wiping memory state. We don't want to prompt the user again if they've elected to cancel.
 */
const biometric_state_PROMPT_CANCELLED = KeyDefinition.record(BIOMETRIC_SETTINGS_DISK, "promptCancelled", {
    deserializer: (obj) => obj,
});
/**
 * Stores whether the user has elected to automatically prompt for biometric unlock on application start.
 */
const biometric_state_PROMPT_AUTOMATICALLY = new UserKeyDefinition(BIOMETRIC_SETTINGS_DISK, "promptAutomatically", {
    deserializer: (obj) => obj,
    clearOn: [],
});
/**
 * Stores whether or not IPC handshake has been validated this session.
 */
const FINGERPRINT_VALIDATED = new KeyDefinition(BIOMETRIC_SETTINGS_DISK, "fingerprintValidated", {
    deserializer: (obj) => obj,
});
/**
 * Last process reload time
 */
const LAST_PROCESS_RELOAD = new KeyDefinition(BIOMETRIC_SETTINGS_DISK, "lastProcessReload", {
    deserializer: (obj) => new Date(obj),
});

;// ../../libs/key-management/src/biometrics/biometric-state.service.ts
var biometric_state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class BiometricStateService {
}
class DefaultBiometricStateService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.biometricUnlockEnabledState = this.stateProvider.getActive(biometric_state_BIOMETRIC_UNLOCK_ENABLED);
        this.biometricUnlockEnabled$ = this.biometricUnlockEnabledState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.encryptedClientKeyHalfState = this.stateProvider.getActive(ENCRYPTED_CLIENT_KEY_HALF);
        this.encryptedClientKeyHalf$ = this.encryptedClientKeyHalfState.state$.pipe((0,external_rxjs_namespaceObject.map)(encryptedClientKeyHalfToEncString));
        this.promptCancelledState = this.stateProvider.getGlobal(biometric_state_PROMPT_CANCELLED);
        this.promptCancelled$ = (0,external_rxjs_namespaceObject.combineLatest)([
            this.stateProvider.activeUserId$,
            this.promptCancelledState.state$,
        ]).pipe((0,external_rxjs_namespaceObject.map)(([userId, record]) => {
            var _a;
            return userId != null ? ((_a = record === null || record === void 0 ? void 0 : record[userId]) !== null && _a !== void 0 ? _a : false) : false;
        }));
        this.promptAutomaticallyState = this.stateProvider.getActive(biometric_state_PROMPT_AUTOMATICALLY);
        this.promptAutomatically$ = this.promptAutomaticallyState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.fingerprintValidatedState = this.stateProvider.getGlobal(FINGERPRINT_VALIDATED);
        this.fingerprintValidated$ = this.fingerprintValidatedState.state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean));
        this.lastProcessReloadState = this.stateProvider.getGlobal(LAST_PROCESS_RELOAD);
        this.lastProcessReload$ = this.lastProcessReloadState.state$;
    }
    setBiometricUnlockEnabled(enabled) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.biometricUnlockEnabledState.update(() => enabled);
        });
    }
    getBiometricUnlockEnabled(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, biometric_state_BIOMETRIC_UNLOCK_ENABLED).state$.pipe((0,external_rxjs_namespaceObject.map)(Boolean)));
        });
    }
    setEncryptedClientKeyHalf(encryptedKeyHalf, userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            const value = (_a = encryptedKeyHalf === null || encryptedKeyHalf === void 0 ? void 0 : encryptedKeyHalf.encryptedString) !== null && _a !== void 0 ? _a : null;
            if (userId) {
                yield this.stateProvider.getUser(userId, ENCRYPTED_CLIENT_KEY_HALF).update(() => value);
            }
            else {
                yield this.encryptedClientKeyHalfState.update(() => value);
            }
        });
    }
    getEncryptedClientKeyHalf(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider
                .getUser(userId, ENCRYPTED_CLIENT_KEY_HALF)
                .state$.pipe((0,external_rxjs_namespaceObject.map)(encryptedClientKeyHalfToEncString)));
        });
    }
    logout(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getUser(userId, ENCRYPTED_CLIENT_KEY_HALF).update(() => null);
            yield this.resetUserPromptCancelled(userId);
            // Persist auto prompt setting through logout
            // Persist dismissed require password on start callout through logout
        });
    }
    resetUserPromptCancelled(userId) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getGlobal(biometric_state_PROMPT_CANCELLED).update((data, activeUserId) => {
                if (data != null) {
                    delete data[userId !== null && userId !== void 0 ? userId : activeUserId];
                }
                return data;
            }, {
                combineLatestWith: this.stateProvider.activeUserId$,
                shouldUpdate: (data, activeUserId) => (data === null || data === void 0 ? void 0 : data[userId !== null && userId !== void 0 ? userId : activeUserId]) != null,
            });
        });
    }
    setUserPromptCancelled() {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.promptCancelledState.update((record, userId) => {
                if (userId != null) {
                    record !== null && record !== void 0 ? record : (record = {});
                    record[userId] = true;
                }
                return record;
            }, {
                combineLatestWith: this.stateProvider.activeUserId$,
                shouldUpdate: (_, userId) => {
                    if (userId == null) {
                        throw new Error("Cannot update biometric prompt cancelled state without an active user");
                    }
                    return true;
                },
            });
        });
    }
    resetAllPromptCancelled() {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.promptCancelledState.update(() => null);
        });
    }
    setPromptAutomatically(prompt) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.promptAutomaticallyState.update(() => prompt);
        });
    }
    setFingerprintValidated(validated) {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.fingerprintValidatedState.update(() => validated);
        });
    }
    updateLastProcessReload() {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            yield this.lastProcessReloadState.update(() => new Date());
        });
    }
    getLastProcessReload() {
        return biometric_state_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.lastProcessReload$);
        });
    }
}
function encryptedClientKeyHalfToEncString(encryptedKeyHalf) {
    return encryptedKeyHalf == null ? null : new enc_string_EncString(encryptedKeyHalf);
}

;// ../../libs/key-management/src/biometrics/biometrics-status.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var BiometricsStatus;
(function (BiometricsStatus) {
    /** For the biometrics interface, this means that biometric unlock is available and can be used. Querying for the user specifically, this means that biometric can be used for to unlock this user */
    BiometricsStatus[BiometricsStatus["Available"] = 0] = "Available";
    /** Biometrics cannot be used, because the userkey needs to first be unlocked by the user's password, because unlock needs some volatile data that is not available on app-start */
    BiometricsStatus[BiometricsStatus["UnlockNeeded"] = 1] = "UnlockNeeded";
    /** Biometric hardware is not available (i.e laptop folded shut, sensor unplugged) */
    BiometricsStatus[BiometricsStatus["HardwareUnavailable"] = 2] = "HardwareUnavailable";
    /** Only relevant for linux, this means that polkit policies need to be set up and that can happen automatically */
    BiometricsStatus[BiometricsStatus["AutoSetupNeeded"] = 3] = "AutoSetupNeeded";
    /** Only relevant for linux, this means that polkit policies need to be set up but that needs to be done manually */
    BiometricsStatus[BiometricsStatus["ManualSetupNeeded"] = 4] = "ManualSetupNeeded";
    /** Biometrics is not implemented for this platform (i.e web) */
    BiometricsStatus[BiometricsStatus["PlatformUnsupported"] = 5] = "PlatformUnsupported";
    /** Browser extension cannot connect to the desktop app to use biometrics */
    BiometricsStatus[BiometricsStatus["DesktopDisconnected"] = 6] = "DesktopDisconnected";
    /** Biometrics is not enabled in the desktop app/extension (current app) */
    BiometricsStatus[BiometricsStatus["NotEnabledLocally"] = 7] = "NotEnabledLocally";
    /** Only on browser extension; Biometrics is not enabled in the desktop app */
    BiometricsStatus[BiometricsStatus["NotEnabledInConnectedDesktopApp"] = 8] = "NotEnabledInConnectedDesktopApp";
    /** Browser extension does not have the permission to talk to the desktop app */
    BiometricsStatus[BiometricsStatus["NativeMessagingPermissionMissing"] = 9] = "NativeMessagingPermissionMissing";
})(BiometricsStatus || (BiometricsStatus = {}));

;// ../../libs/key-management/src/biometrics/biometrics-commands.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var BiometricsCommands;
(function (BiometricsCommands) {
    /** Perform biometric authentication for the system's user. Does not require setup, and does not return cryptographic material, only yes or no. */
    BiometricsCommands["AuthenticateWithBiometrics"] = "authenticateWithBiometrics";
    /** Get biometric status of the system, and can be used before biometrics is set up. Only returns data about the biometrics system, not about availability of cryptographic material */
    BiometricsCommands["GetBiometricsStatus"] = "getBiometricsStatus";
    /** Perform biometric authentication for the system's user for the given bitwarden account's credentials. This returns cryptographic material that can be used to unlock the vault. */
    BiometricsCommands["UnlockWithBiometricsForUser"] = "unlockWithBiometricsForUser";
    /** Get biometric status for a specific user account. This includes both information about availability of cryptographic material (is the user configured for biometric unlock? is a masterpassword unlock needed? But also information about the biometric system's availability in a single status) */
    BiometricsCommands["GetBiometricsStatusForUser"] = "getBiometricsStatusForUser";
    /** Checks whether the biometric unlock can be enabled. */
    BiometricsCommands["CanEnableBiometricUnlock"] = "canEnableBiometricUnlock";
})(BiometricsCommands || (BiometricsCommands = {}));

;// ../../libs/key-management/src/biometrics/biometric.service.ts
/**
 * The biometrics service is used to provide access to the status of and access to biometric functionality on the platforms.
 */
class BiometricsService {
    supportsBiometric() {
        throw new Error("Method not implemented.");
    }
}

;// ../../libs/key-management/src/abstractions/key.service.ts
class UserPrivateKeyDecryptionFailedError extends Error {
    constructor() {
        super("Failed to decrypt the user's private key.");
    }
}
class KeyService {
}

;// external "big-integer"
const external_big_integer_namespaceObject = require("big-integer");
;// ../../libs/common/src/admin-console/models/domain/encrypted-organization-key.ts
var encrypted_organization_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class BaseEncryptedOrganizationKey {
    static fromData(data) {
        switch (data.type) {
            case "organization":
                return new EncryptedOrganizationKey(data.key);
            case "provider":
                return new ProviderEncryptedOrganizationKey(data.key, data.providerId);
            default:
                return null;
        }
    }
    static isProviderEncrypted(key) {
        return key.toData().type === "provider";
    }
}
class EncryptedOrganizationKey {
    constructor(key) {
        this.key = key;
    }
    decrypt(encryptService, privateKey) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            return (yield encryptService.decapsulateKeyUnsigned(this.encryptedOrganizationKey, privateKey));
        });
    }
    get encryptedOrganizationKey() {
        return new enc_string_EncString(this.key);
    }
    toData() {
        return {
            type: "organization",
            key: this.key,
        };
    }
}
class ProviderEncryptedOrganizationKey {
    constructor(key, providerId) {
        this.key = key;
        this.providerId = providerId;
    }
    decrypt(encryptService, providerKeys) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            const decValue = yield encryptService.unwrapSymmetricKey(new enc_string_EncString(this.key), providerKeys[this.providerId]);
            if (decValue == null) {
                throw new Error("Failed to decrypt organization key");
            }
            return decValue;
        });
    }
    get encryptedOrganizationKey() {
        return new enc_string_EncString(this.key);
    }
    toData() {
        return {
            type: "provider",
            key: this.key,
            providerId: this.providerId,
        };
    }
}

;// ../../libs/common/src/admin-console/enums/organization-api-key-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationApiKeyType;
(function (OrganizationApiKeyType) {
    OrganizationApiKeyType[OrganizationApiKeyType["Default"] = 0] = "Default";
    OrganizationApiKeyType[OrganizationApiKeyType["BillingSync"] = 1] = "BillingSync";
    OrganizationApiKeyType[OrganizationApiKeyType["Scim"] = 2] = "Scim";
})(OrganizationApiKeyType || (OrganizationApiKeyType = {}));

;// ../../libs/common/src/admin-console/enums/organization-connection-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var OrganizationConnectionType;
(function (OrganizationConnectionType) {
    OrganizationConnectionType[OrganizationConnectionType["CloudBillingSync"] = 1] = "CloudBillingSync";
    OrganizationConnectionType[OrganizationConnectionType["Scim"] = 2] = "Scim";
})(OrganizationConnectionType || (OrganizationConnectionType = {}));

;// ../../libs/common/src/admin-console/enums/organization-user-status-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var organization_user_status_type_enum_OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(organization_user_status_type_enum_OrganizationUserStatusType || (organization_user_status_type_enum_OrganizationUserStatusType = {}));

;// ../../libs/common/src/admin-console/enums/organization-user-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var organization_user_type_enum_OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    // Manager = 3 has been intentionally permanently deleted
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(organization_user_type_enum_OrganizationUserType || (organization_user_type_enum_OrganizationUserType = {}));

;// ../../libs/common/src/admin-console/enums/policy-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var policy_type_enum_PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["OrganizationDataOwnership"] = 5] = "OrganizationDataOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
    PolicyType[PolicyType["AutomaticAppLogIn"] = 12] = "AutomaticAppLogIn";
    PolicyType[PolicyType["FreeFamiliesSponsorshipPolicy"] = 13] = "FreeFamiliesSponsorshipPolicy";
    PolicyType[PolicyType["RemoveUnlockWithPin"] = 14] = "RemoveUnlockWithPin";
    PolicyType[PolicyType["RestrictedItemTypes"] = 15] = "RestrictedItemTypes";
})(policy_type_enum_PolicyType || (policy_type_enum_PolicyType = {}));

;// ../../libs/common/src/admin-console/enums/provider-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var provider_type_enum_ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
    ProviderType[ProviderType["BusinessUnit"] = 2] = "BusinessUnit";
})(provider_type_enum_ProviderType || (provider_type_enum_ProviderType = {}));

;// ../../libs/common/src/admin-console/enums/provider-user-status-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderUserStatusType;
(function (ProviderUserStatusType) {
    ProviderUserStatusType[ProviderUserStatusType["Invited"] = 0] = "Invited";
    ProviderUserStatusType[ProviderUserStatusType["Accepted"] = 1] = "Accepted";
    ProviderUserStatusType[ProviderUserStatusType["Confirmed"] = 2] = "Confirmed";
    ProviderUserStatusType[ProviderUserStatusType["Revoked"] = -1] = "Revoked";
})(ProviderUserStatusType || (ProviderUserStatusType = {}));

;// ../../libs/common/src/admin-console/enums/provider-user-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderUserType;
(function (ProviderUserType) {
    ProviderUserType[ProviderUserType["ProviderAdmin"] = 0] = "ProviderAdmin";
    ProviderUserType[ProviderUserType["ServiceUser"] = 1] = "ServiceUser";
})(ProviderUserType || (ProviderUserType = {}));

;// ../../libs/common/src/admin-console/enums/scim-provider-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ScimProviderType;
(function (ScimProviderType) {
    ScimProviderType[ScimProviderType["Default"] = 0] = "Default";
    ScimProviderType[ScimProviderType["AzureAd"] = 1] = "AzureAd";
    ScimProviderType[ScimProviderType["Okta"] = 2] = "Okta";
    ScimProviderType[ScimProviderType["OneLogin"] = 3] = "OneLogin";
    ScimProviderType[ScimProviderType["JumpCloud"] = 4] = "JumpCloud";
    ScimProviderType[ScimProviderType["GoogleWorkspace"] = 5] = "GoogleWorkspace";
    ScimProviderType[ScimProviderType["Rippling"] = 6] = "Rippling";
})(ScimProviderType || (ScimProviderType = {}));

;// ../../libs/common/src/admin-console/enums/provider-status-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ProviderStatusType;
(function (ProviderStatusType) {
    ProviderStatusType[ProviderStatusType["Pending"] = 0] = "Pending";
    ProviderStatusType[ProviderStatusType["Created"] = 1] = "Created";
    ProviderStatusType[ProviderStatusType["Billable"] = 2] = "Billable";
})(ProviderStatusType || (ProviderStatusType = {}));

;// ../../libs/common/src/admin-console/enums/index.ts











;// ../../libs/common/src/platform/models/domain/domain-base.ts
var domain_base_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// https://contributing.bitwarden.com/architecture/clients/data-model#domain
class domain_base_Domain {
    buildDomainModel(domain, dataObj, map, notEncList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = dataObj[map[prop] || prop];
            if (notEncList.indexOf(prop) > -1) {
                domain[prop] = objProp ? objProp : null;
            }
            else {
                domain[prop] = objProp ? new enc_string_EncString(objProp) : null;
            }
        }
    }
    buildDataModel(domain, dataObj, map, notEncStringList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = domain[map[prop] || prop];
            if (notEncStringList.indexOf(prop) > -1) {
                dataObj[prop] = objProp != null ? objProp : null;
            }
            else {
                dataObj[prop] = objProp != null ? objProp.encryptedString : null;
            }
        }
    }
    decryptObj(domain_1, viewModel_1, props_1, orgId_1) {
        return domain_base_awaiter(this, arguments, void 0, function* (domain, viewModel, props, orgId, key = null, objectContext = "No Domain Context") {
            var _a, _b;
            for (const prop of props) {
                viewModel[prop] =
                    (_b = (yield ((_a = domain[prop]) === null || _a === void 0 ? void 0 : _a.decrypt(orgId, key, `Property: ${prop}; ObjectContext: ${objectContext}`)))) !== null && _b !== void 0 ? _b : null;
            }
            return viewModel;
        });
    }
}

;// ../../libs/common/src/admin-console/models/domain/master-password-policy-options.ts

class MasterPasswordPolicyOptions extends domain_base_Domain {
    constructor() {
        super(...arguments);
        this.minComplexity = 0;
        this.minLength = 0;
        this.requireUpper = false;
        this.requireLower = false;
        this.requireNumbers = false;
        this.requireSpecial = false;
        /**
         * Flag to indicate if the policy should be enforced on login.
         * If true, and the user's password does not meet the policy requirements,
         * the user will be forced to update their password.
         */
        this.enforceOnLogin = false;
    }
    static fromResponse(policy) {
        if (policy == null) {
            return null;
        }
        const options = new MasterPasswordPolicyOptions();
        options.minComplexity = policy.minComplexity;
        options.minLength = policy.minLength;
        options.requireUpper = policy.requireUpper;
        options.requireLower = policy.requireLower;
        options.requireNumbers = policy.requireNumbers;
        options.requireSpecial = policy.requireSpecial;
        options.enforceOnLogin = policy.enforceOnLogin;
        return options;
    }
}

;// ../../libs/common/src/admin-console/models/data/policy.data.ts
class PolicyData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.type = response.type;
        this.data = response.data;
        this.enabled = response.enabled;
    }
    static fromPolicy(policy) {
        return Object.assign(new PolicyData(), policy);
    }
}

;// ../../libs/common/src/admin-console/models/domain/policy.ts


class Policy extends domain_base_Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.organizationId = obj.organizationId;
        this.type = obj.type;
        this.data = obj.data;
        this.enabled = obj.enabled;
    }
    static fromResponse(response) {
        return new Policy(new PolicyData(response));
    }
    static fromListResponse(response) {
        var _a, _b;
        return (_b = (_a = response.data) === null || _a === void 0 ? void 0 : _a.map((d) => Policy.fromResponse(d))) !== null && _b !== void 0 ? _b : undefined;
    }
}

;// ../../libs/common/src/admin-console/models/domain/reset-password-policy-options.ts

class ResetPasswordPolicyOptions extends domain_base_Domain {
    constructor() {
        super(...arguments);
        this.autoEnrollEnabled = false;
    }
}

;// ../../libs/common/src/admin-console/services/policy/policy-state.ts

const POLICIES = UserKeyDefinition.record(POLICIES_DISK, "policies", {
    deserializer: (policyData) => policyData,
    clearOn: ["logout"],
});

;// ../../libs/common/src/admin-console/services/policy/default-policy.service.ts
var default_policy_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






function policyRecordToArray(policiesMap) {
    return Object.values(policiesMap || {}).map((f) => new Policy(f));
}
const getFirstPolicy = (0,external_rxjs_namespaceObject.map)((policies) => {
    var _a;
    return (_a = policies.at(0)) !== null && _a !== void 0 ? _a : undefined;
});
class DefaultPolicyService {
    constructor(stateProvider, organizationService) {
        this.stateProvider = stateProvider;
        this.organizationService = organizationService;
    }
    policyState(userId) {
        return this.stateProvider.getUser(userId, POLICIES);
    }
    policyData$(userId) {
        return this.policyState(userId).state$.pipe((0,external_rxjs_namespaceObject.map)((policyData) => policyData !== null && policyData !== void 0 ? policyData : {}));
    }
    policies$(userId) {
        return this.policyData$(userId).pipe((0,external_rxjs_namespaceObject.map)((policyData) => policyRecordToArray(policyData)));
    }
    policiesByType$(policyType, userId) {
        const filteredPolicies$ = this.policies$(userId).pipe((0,external_rxjs_namespaceObject.map)((policies) => policies.filter((p) => p.type === policyType)));
        if (!userId) {
            throw new Error("No userId provided");
        }
        const organizations$ = this.organizationService.organizations$(userId);
        return (0,external_rxjs_namespaceObject.combineLatest)([filteredPolicies$, organizations$]).pipe((0,external_rxjs_namespaceObject.map)(([policies, organizations]) => this.enforcedPolicyFilter(policies, organizations)));
    }
    policyAppliesToUser$(policyType, userId) {
        return this.policiesByType$(policyType, userId).pipe(getFirstPolicy, (0,external_rxjs_namespaceObject.map)((policy) => !!policy));
    }
    enforcedPolicyFilter(policies, organizations) {
        const orgDict = Object.fromEntries(organizations.map((o) => [o.id, o]));
        return policies.filter((policy) => {
            const organization = orgDict[policy.organizationId];
            // This shouldn't happen, i.e. the user should only have policies for orgs they are a member of
            // But if it does, err on the side of enforcing the policy
            if (!organization) {
                return true;
            }
            return (policy.enabled &&
                organization.status >= organization_user_status_type_enum_OrganizationUserStatusType.Accepted &&
                organization.usePolicies &&
                !this.isExemptFromPolicy(policy.type, organization));
        });
    }
    masterPasswordPolicyOptions$(userId, policies) {
        const policies$ = policies ? (0,external_rxjs_namespaceObject.of)(policies) : this.policies$(userId);
        return policies$.pipe((0,external_rxjs_namespaceObject.map)((obsPolicies) => {
            var _a;
            // TODO ([PM-23777]): replace with this.combinePoliciesIntoMasterPasswordPolicyOptions(obsPolicies))
            let enforcedOptions = undefined;
            const filteredPolicies = (_a = obsPolicies.filter((p) => p.type === policy_type_enum_PolicyType.MasterPassword)) !== null && _a !== void 0 ? _a : [];
            if (filteredPolicies.length === 0) {
                return;
            }
            filteredPolicies.forEach((currentPolicy) => {
                if (!currentPolicy.enabled || !currentPolicy.data) {
                    return;
                }
                if (!enforcedOptions) {
                    enforcedOptions = new MasterPasswordPolicyOptions();
                }
                if (currentPolicy.data.minComplexity != null &&
                    currentPolicy.data.minComplexity > enforcedOptions.minComplexity) {
                    enforcedOptions.minComplexity = currentPolicy.data.minComplexity;
                }
                if (currentPolicy.data.minLength != null &&
                    currentPolicy.data.minLength > enforcedOptions.minLength) {
                    enforcedOptions.minLength = currentPolicy.data.minLength;
                }
                if (currentPolicy.data.requireUpper) {
                    enforcedOptions.requireUpper = true;
                }
                if (currentPolicy.data.requireLower) {
                    enforcedOptions.requireLower = true;
                }
                if (currentPolicy.data.requireNumbers) {
                    enforcedOptions.requireNumbers = true;
                }
                if (currentPolicy.data.requireSpecial) {
                    enforcedOptions.requireSpecial = true;
                }
                if (currentPolicy.data.enforceOnLogin) {
                    enforcedOptions.enforceOnLogin = true;
                }
            });
            return enforcedOptions;
        }));
    }
    combinePoliciesIntoMasterPasswordPolicyOptions(policies) {
        var _a;
        let enforcedOptions = undefined;
        const filteredPolicies = (_a = policies.filter((p) => p.type === policy_type_enum_PolicyType.MasterPassword)) !== null && _a !== void 0 ? _a : [];
        if (filteredPolicies.length === 0) {
            return;
        }
        filteredPolicies.forEach((currentPolicy) => {
            if (!currentPolicy.enabled || !currentPolicy.data) {
                return undefined;
            }
            if (!enforcedOptions) {
                enforcedOptions = new MasterPasswordPolicyOptions();
            }
            this.mergeMasterPasswordPolicyOptions(enforcedOptions, currentPolicy.data);
        });
        return enforcedOptions;
    }
    combineMasterPasswordPolicyOptions(...policies) {
        let combinedOptions = undefined;
        policies.forEach((currentOptions) => {
            if (!combinedOptions) {
                combinedOptions = new MasterPasswordPolicyOptions();
            }
            this.mergeMasterPasswordPolicyOptions(combinedOptions, currentOptions);
        });
        return combinedOptions;
    }
    evaluateMasterPassword(passwordStrength, newPassword, enforcedPolicyOptions) {
        if (!enforcedPolicyOptions) {
            return true;
        }
        if (enforcedPolicyOptions.minComplexity > 0 &&
            enforcedPolicyOptions.minComplexity > passwordStrength) {
            return false;
        }
        if (enforcedPolicyOptions.minLength > 0 &&
            enforcedPolicyOptions.minLength > newPassword.length) {
            return false;
        }
        if (enforcedPolicyOptions.requireUpper && newPassword.toLocaleLowerCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireLower && newPassword.toLocaleUpperCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireNumbers && !/[0-9]/.test(newPassword)) {
            return false;
        }
        // eslint-disable-next-line
        if (enforcedPolicyOptions.requireSpecial && !/[!@#$%\^&*]/g.test(newPassword)) {
            return false;
        }
        return true;
    }
    getResetPasswordPolicyOptions(policies, orgId) {
        var _a, _b, _c;
        const resetPasswordPolicyOptions = new ResetPasswordPolicyOptions();
        if (!policies || !orgId) {
            return [resetPasswordPolicyOptions, false];
        }
        const policy = policies.find((p) => p.organizationId === orgId && p.type === policy_type_enum_PolicyType.ResetPassword && p.enabled);
        resetPasswordPolicyOptions.autoEnrollEnabled = (_b = (_a = policy === null || policy === void 0 ? void 0 : policy.data) === null || _a === void 0 ? void 0 : _a.autoEnrollEnabled) !== null && _b !== void 0 ? _b : false;
        return [resetPasswordPolicyOptions, (_c = policy === null || policy === void 0 ? void 0 : policy.enabled) !== null && _c !== void 0 ? _c : false];
    }
    upsert(policy, userId) {
        return default_policy_service_awaiter(this, void 0, void 0, function* () {
            yield this.policyState(userId).update((policies) => {
                policies !== null && policies !== void 0 ? policies : (policies = {});
                policies[policy.id] = policy;
                return policies;
            });
        });
    }
    replace(policies, userId) {
        return default_policy_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.setUserState(POLICIES, policies, userId);
        });
    }
    /**
     * Determines whether an orgUser is exempt from a specific policy because of their role
     * Generally orgUsers who can manage policies are exempt from them, but some policies are stricter
     */
    isExemptFromPolicy(policyType, organization) {
        switch (policyType) {
            case policy_type_enum_PolicyType.MaximumVaultTimeout:
                // Max Vault Timeout applies to everyone except owners
                return organization.isOwner;
            // the following policies apply to everyone
            case policy_type_enum_PolicyType.PasswordGenerator:
                // password generation policy
                return false;
            case policy_type_enum_PolicyType.FreeFamiliesSponsorshipPolicy:
                // free Bitwarden families policy
                return false;
            case policy_type_enum_PolicyType.RestrictedItemTypes:
                // restricted item types policy
                return false;
            case policy_type_enum_PolicyType.RemoveUnlockWithPin:
                // Remove Unlock with PIN policy
                return false;
            case policy_type_enum_PolicyType.OrganizationDataOwnership:
                // organization data ownership policy applies to everyone except admins and owners
                return organization.isAdmin;
            default:
                return organization.canManagePolicies;
        }
    }
    mergeMasterPasswordPolicyOptions(target, source) {
        var _a, _b;
        if (!target) {
            target = new MasterPasswordPolicyOptions();
        }
        // For complexity and minLength, take the highest value.
        // For boolean settings, enable it if either policy has it enabled (OR).
        if (source) {
            target.minComplexity = Math.max(target.minComplexity, (_a = source.minComplexity) !== null && _a !== void 0 ? _a : target.minComplexity);
            target.minLength = Math.max(target.minLength, (_b = source.minLength) !== null && _b !== void 0 ? _b : target.minLength);
            target.requireUpper = Boolean(target.requireUpper || source.requireUpper);
            target.requireLower = Boolean(target.requireLower || source.requireLower);
            target.requireNumbers = Boolean(target.requireNumbers || source.requireNumbers);
            target.requireSpecial = Boolean(target.requireSpecial || source.requireSpecial);
            target.enforceOnLogin = Boolean(target.enforceOnLogin || source.enforceOnLogin);
        }
    }
}

;// ../../libs/common/src/key-management/vault-timeout/enums/vault-timeout-action.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var VaultTimeoutAction;
(function (VaultTimeoutAction) {
    VaultTimeoutAction["Lock"] = "lock";
    VaultTimeoutAction["LogOut"] = "logOut";
})(VaultTimeoutAction || (VaultTimeoutAction = {}));

;// ../../libs/common/src/key-management/vault-timeout/types/vault-timeout.type.ts
// Note: the below comments are just for documenting what they used to be.
const VaultTimeoutStringType = {
    Never: "never", // null
    OnRestart: "onRestart", // -1
    OnLocked: "onLocked", // -2
    OnSleep: "onSleep", // -3
    OnIdle: "onIdle", // -4
};

;// ../../libs/common/src/key-management/vault-timeout/services/vault-timeout-settings.state.ts

/**
 * Settings use disk storage and local storage on web so settings can persist after logout
 * in order for us to know if the user's chose to never lock their vault or not.
 * When the user has never lock selected, we have to set the user key in memory
 * from the user auto unlock key stored on disk on client bootstrap.
 */
const vault_timeout_settings_state_VAULT_TIMEOUT_ACTION = new UserKeyDefinition(VAULT_TIMEOUT_SETTINGS_DISK_LOCAL, "vaultTimeoutAction", {
    deserializer: (vaultTimeoutAction) => vaultTimeoutAction,
    clearOn: [], // persisted on logout
});
const vault_timeout_settings_state_VAULT_TIMEOUT = new UserKeyDefinition(VAULT_TIMEOUT_SETTINGS_DISK_LOCAL, "vaultTimeout", {
    deserializer: (vaultTimeout) => vaultTimeout,
    clearOn: [], // persisted on logout
});

;// ../../libs/common/src/key-management/vault-timeout/services/vault-timeout-settings.service.ts
var vault_timeout_settings_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore






class VaultTimeoutSettingsService {
    constructor(accountService, pinService, userDecryptionOptionsService, keyService, tokenService, policyService, biometricStateService, stateProvider, logService, defaultVaultTimeout) {
        this.accountService = accountService;
        this.pinService = pinService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.keyService = keyService;
        this.tokenService = tokenService;
        this.policyService = policyService;
        this.biometricStateService = biometricStateService;
        this.stateProvider = stateProvider;
        this.logService = logService;
        this.defaultVaultTimeout = defaultVaultTimeout;
    }
    setVaultTimeoutOptions(userId, timeout, action) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("User id required. Cannot set vault timeout settings.");
            }
            if (timeout == null) {
                throw new Error("Vault Timeout cannot be null.");
            }
            if (action == null) {
                throw new Error("Vault Timeout Action cannot be null.");
            }
            // We swap these tokens from being on disk for lock actions, and in memory for logout actions
            // Get them here to set them to their new location after changing the timeout action and clearing if needed
            const accessToken = yield this.tokenService.getAccessToken(userId);
            const refreshToken = yield this.tokenService.getRefreshToken(userId);
            const clientId = yield this.tokenService.getClientId(userId);
            const clientSecret = yield this.tokenService.getClientSecret(userId);
            yield this.setVaultTimeout(userId, timeout);
            if (timeout != VaultTimeoutStringType.Never && action === VaultTimeoutAction.LogOut) {
                // if we have a vault timeout and the action is log out, reset tokens
                // as the tokens were stored on disk and now should be stored in memory
                yield this.tokenService.clearTokens(userId);
            }
            yield this.setVaultTimeoutAction(userId, action);
            yield this.tokenService.setTokens(accessToken, action, timeout, refreshToken, [
                clientId,
                clientSecret,
            ]);
            yield this.keyService.refreshAdditionalKeys(userId);
        });
    }
    availableVaultTimeoutActions$(userId) {
        return (0,external_rxjs_namespaceObject.defer)(() => this.getAvailableVaultTimeoutActions(userId));
    }
    canLock(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            const availableVaultTimeoutActions = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.availableVaultTimeoutActions$(userId));
            return (availableVaultTimeoutActions === null || availableVaultTimeoutActions === void 0 ? void 0 : availableVaultTimeoutActions.includes(VaultTimeoutAction.Lock)) || false;
        });
    }
    isBiometricLockSet(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            const biometricUnlockPromise = userId == null
                ? (0,external_rxjs_namespaceObject.firstValueFrom)(this.biometricStateService.biometricUnlockEnabled$)
                : this.biometricStateService.getBiometricUnlockEnabled(userId);
            return yield biometricUnlockPromise;
        });
    }
    setVaultTimeout(userId, timeout) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("User id required. Cannot set vault timeout.");
            }
            if (timeout == null) {
                throw new Error("Vault Timeout cannot be null.");
            }
            yield this.stateProvider.setUserState(vault_timeout_settings_state_VAULT_TIMEOUT, timeout, userId);
        });
    }
    getVaultTimeoutByUserId$(userId) {
        if (!userId) {
            throw new Error("User id required. Cannot get vault timeout.");
        }
        return (0,external_rxjs_namespaceObject.combineLatest)([
            this.stateProvider.getUserState$(vault_timeout_settings_state_VAULT_TIMEOUT, userId),
            this.getMaxVaultTimeoutPolicyByUserId$(userId),
        ]).pipe((0,external_rxjs_namespaceObject.switchMap)(([currentVaultTimeout, maxVaultTimeoutPolicy]) => {
            return (0,external_rxjs_namespaceObject.from)(this.determineVaultTimeout(currentVaultTimeout, maxVaultTimeoutPolicy)).pipe((0,external_rxjs_namespaceObject.tap)((vaultTimeout) => {
                // As a side effect, set the new value determined by determineVaultTimeout into state if it's different from the current
                if (vaultTimeout !== currentVaultTimeout) {
                    return this.stateProvider.setUserState(vault_timeout_settings_state_VAULT_TIMEOUT, vaultTimeout, userId);
                }
            }), (0,external_rxjs_namespaceObject.catchError)((error) => {
                // Protect outer observable from canceling on error by catching and returning EMPTY
                this.logService.error(`Error getting vault timeout: ${error}`);
                return external_rxjs_namespaceObject.EMPTY;
            }));
        }), (0,external_rxjs_namespaceObject.distinctUntilChanged)(), // Avoid having the set side effect trigger a new emission of the same action
        (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
    }
    determineVaultTimeout(currentVaultTimeout, maxVaultTimeoutPolicy) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            // if current vault timeout is null, apply the client specific default
            currentVaultTimeout = currentVaultTimeout !== null && currentVaultTimeout !== void 0 ? currentVaultTimeout : this.defaultVaultTimeout;
            // If no policy applies, return the current vault timeout
            if (!maxVaultTimeoutPolicy) {
                return currentVaultTimeout;
            }
            // User is subject to a max vault timeout policy
            const maxVaultTimeoutPolicyData = maxVaultTimeoutPolicy.data;
            // If the current vault timeout is not numeric, change it to the policy compliant value
            if (typeof currentVaultTimeout === "string") {
                return maxVaultTimeoutPolicyData.minutes;
            }
            // For numeric vault timeouts, ensure they are smaller than maximum allowed value according to policy
            const policyCompliantTimeout = Math.min(currentVaultTimeout, maxVaultTimeoutPolicyData.minutes);
            return policyCompliantTimeout;
        });
    }
    setVaultTimeoutAction(userId, action) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            if (!userId) {
                throw new Error("User id required. Cannot set vault timeout action.");
            }
            if (!action) {
                throw new Error("Vault Timeout Action cannot be null");
            }
            yield this.stateProvider.setUserState(vault_timeout_settings_state_VAULT_TIMEOUT_ACTION, action, userId);
        });
    }
    getVaultTimeoutActionByUserId$(userId) {
        if (!userId) {
            throw new Error("User id required. Cannot get vault timeout action.");
        }
        return (0,external_rxjs_namespaceObject.combineLatest)([
            this.stateProvider.getUserState$(vault_timeout_settings_state_VAULT_TIMEOUT_ACTION, userId),
            this.getMaxVaultTimeoutPolicyByUserId$(userId),
        ]).pipe((0,external_rxjs_namespaceObject.switchMap)(([currentVaultTimeoutAction, maxVaultTimeoutPolicy]) => {
            return (0,external_rxjs_namespaceObject.from)(this.determineVaultTimeoutAction(userId, currentVaultTimeoutAction, maxVaultTimeoutPolicy)).pipe((0,external_rxjs_namespaceObject.tap)((vaultTimeoutAction) => {
                // As a side effect, set the new value determined by determineVaultTimeout into state if it's different from the current
                // We want to avoid having a null timeout action always so we set it to the default if it is null
                // and if the user becomes subject to a policy that requires a specific action, we set it to that
                if (vaultTimeoutAction !== currentVaultTimeoutAction) {
                    return this.stateProvider.setUserState(vault_timeout_settings_state_VAULT_TIMEOUT_ACTION, vaultTimeoutAction, userId);
                }
            }), (0,external_rxjs_namespaceObject.catchError)((error) => {
                // Protect outer observable from canceling on error by catching and returning EMPTY
                this.logService.error(`Error getting vault timeout: ${error}`);
                return external_rxjs_namespaceObject.EMPTY;
            }));
        }), (0,external_rxjs_namespaceObject.distinctUntilChanged)(), // Avoid having the set side effect trigger a new emission of the same action
        (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
    }
    determineVaultTimeoutAction(userId, currentVaultTimeoutAction, maxVaultTimeoutPolicy) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            const availableVaultTimeoutActions = yield this.getAvailableVaultTimeoutActions(userId);
            if (availableVaultTimeoutActions.length === 1) {
                return availableVaultTimeoutActions[0];
            }
            if (((_a = maxVaultTimeoutPolicy === null || maxVaultTimeoutPolicy === void 0 ? void 0 : maxVaultTimeoutPolicy.data) === null || _a === void 0 ? void 0 : _a.action) &&
                availableVaultTimeoutActions.includes(maxVaultTimeoutPolicy.data.action)) {
                // return policy defined vault timeout action
                return maxVaultTimeoutPolicy.data.action;
            }
            // No policy applies from here on
            // If the current vault timeout is null and lock is an option, set it as the default
            if (currentVaultTimeoutAction == null &&
                availableVaultTimeoutActions.includes(VaultTimeoutAction.Lock)) {
                return VaultTimeoutAction.Lock;
            }
            return currentVaultTimeoutAction;
        });
    }
    getMaxVaultTimeoutPolicyByUserId$(userId) {
        if (!userId) {
            throw new Error("User id required. Cannot get max vault timeout policy.");
        }
        return this.policyService
            .policiesByType$(policy_type_enum_PolicyType.MaximumVaultTimeout, userId)
            .pipe(getFirstPolicy);
    }
    getAvailableVaultTimeoutActions(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            userId !== null && userId !== void 0 ? userId : (userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id);
            const availableActions = [VaultTimeoutAction.LogOut];
            const canLock = (yield this.userHasMasterPassword(userId)) ||
                (yield this.pinService.isPinSet(userId)) ||
                (yield this.isBiometricLockSet(userId));
            if (canLock) {
                availableActions.push(VaultTimeoutAction.Lock);
            }
            return availableActions;
        });
    }
    clear(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            yield this.keyService.clearPinKeys(userId);
        });
    }
    userHasMasterPassword(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            if (userId) {
                const decryptionOptions = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.userDecryptionOptionsService.userDecryptionOptionsById$(userId));
                return !!(decryptionOptions === null || decryptionOptions === void 0 ? void 0 : decryptionOptions.hasMasterPassword);
            }
            else {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.userDecryptionOptionsService.hasMasterPassword$);
            }
        });
    }
}

;// ../../libs/common/src/key-management/vault-timeout/services/vault-timeout.service.ts
var vault_timeout_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class VaultTimeoutService {
    constructor(accountService, masterPasswordService, cipherService, folderService, collectionService, platformUtilsService, messagingService, searchService, stateService, tokenService, authService, vaultTimeoutSettingsService, stateEventRunnerService, taskSchedulerService, logService, biometricService, lockedCallback = null, loggedOutCallback = null) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.collectionService = collectionService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.searchService = searchService;
        this.stateService = stateService;
        this.tokenService = tokenService;
        this.authService = authService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.stateEventRunnerService = stateEventRunnerService;
        this.taskSchedulerService = taskSchedulerService;
        this.logService = logService;
        this.biometricService = biometricService;
        this.lockedCallback = lockedCallback;
        this.loggedOutCallback = loggedOutCallback;
        this.inited = false;
        this.taskSchedulerService.registerTaskHandler(ScheduledTaskNames.vaultTimeoutCheckInterval, () => this.checkVaultTimeout());
    }
    init(checkOnInterval) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            if (this.inited) {
                return;
            }
            this.inited = true;
            if (checkOnInterval) {
                this.startCheck();
            }
        });
    }
    startCheck() {
        this.checkVaultTimeout().catch((error) => this.logService.error(error));
        this.taskSchedulerService.setInterval(ScheduledTaskNames.vaultTimeoutCheckInterval, 10 * 1000);
    }
    checkVaultTimeout() {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            // Get whether or not the view is open a single time so it can be compared for each user
            const isViewOpen = yield this.platformUtilsService.isPopupOpen();
            yield (0,external_rxjs_namespaceObject.firstValueFrom)((0,external_rxjs_namespaceObject.combineLatest)([
                this.accountService.activeAccount$,
                this.accountService.accountActivity$,
            ]).pipe((0,external_rxjs_namespaceObject.concatMap)((_a) => vault_timeout_service_awaiter(this, [_a], void 0, function* ([activeAccount, accountActivity]) {
                const activeUserId = activeAccount === null || activeAccount === void 0 ? void 0 : activeAccount.id;
                for (const userIdString in accountActivity) {
                    const userId = userIdString;
                    if (userId != null &&
                        (yield this.shouldLock(userId, accountActivity[userId], activeUserId, isViewOpen))) {
                        yield this.executeTimeoutAction(userId);
                    }
                }
            }))));
        });
    }
    lock(userId) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            yield this.biometricService.setShouldAutopromptNow(false);
            const lockingUserId = userId !== null && userId !== void 0 ? userId : (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => a === null || a === void 0 ? void 0 : a.id))));
            const authed = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.tokenService.hasAccessToken$(lockingUserId));
            if (!authed) {
                return;
            }
            const availableActions = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.availableVaultTimeoutActions$(userId));
            const supportsLock = availableActions.includes(VaultTimeoutAction.Lock);
            if (!supportsLock) {
                yield this.logOut(userId);
            }
            // HACK: Start listening for the transition of the locking user from something to the locked state.
            // This is very much a hack to ensure that the authentication status to retrievable right after
            // it does its work. Particularly the `lockedCallback` and `"locked"` message. Instead
            // lockedCallback should be deprecated and people should subscribe and react to `authStatusFor$` themselves.
            const lockPromise = (0,external_rxjs_namespaceObject.firstValueFrom)(this.authService.authStatusFor$(lockingUserId).pipe((0,external_rxjs_namespaceObject.filter)((authStatus) => authStatus === authentication_status_AuthenticationStatus.Locked), (0,external_rxjs_namespaceObject.timeout)({
                first: 5000,
                with: () => {
                    throw new Error("The lock process did not complete in a reasonable amount of time.");
                },
            })));
            yield this.searchService.clearIndex(lockingUserId);
            yield this.folderService.clearDecryptedFolderState(lockingUserId);
            yield this.masterPasswordService.clearMasterKey(lockingUserId);
            yield this.stateService.setUserKeyAutoUnlock(null, { userId: lockingUserId });
            yield this.cipherService.clearCache(lockingUserId);
            yield this.stateEventRunnerService.handleEvent("lock", lockingUserId);
            // HACK: Sit here and wait for the the auth status to transition to `Locked`
            // to ensure the message and lockedCallback will get the correct status
            // if/when they call it.
            yield lockPromise;
            this.messagingService.send("locked", { userId: lockingUserId });
            if (this.lockedCallback != null) {
                yield this.lockedCallback(lockingUserId);
            }
        });
    }
    logOut(userId) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            if (this.loggedOutCallback != null) {
                yield this.loggedOutCallback("vaultTimeout", userId);
            }
        });
    }
    shouldLock(userId, lastActive, activeUserId, isViewOpen) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            if (isViewOpen && userId === activeUserId) {
                // We know a view is open and this is the currently active user
                // which means they are likely looking at their vault
                // and they should not lock.
                return false;
            }
            const authStatus = yield this.authService.getAuthStatus(userId);
            if (authStatus === authentication_status_AuthenticationStatus.Locked ||
                authStatus === authentication_status_AuthenticationStatus.LoggedOut) {
                return false;
            }
            const vaultTimeout = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutByUserId$(userId));
            if (typeof vaultTimeout === "string") {
                return false;
            }
            if (lastActive == null) {
                return false;
            }
            const vaultTimeoutSeconds = vaultTimeout * 60;
            const diffSeconds = (new Date().getTime() - lastActive.getTime()) / 1000;
            return diffSeconds >= vaultTimeoutSeconds;
        });
    }
    executeTimeoutAction(userId) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            const timeoutAction = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutActionByUserId$(userId));
            timeoutAction === VaultTimeoutAction.LogOut
                ? yield this.logOut(userId)
                : yield this.lock(userId);
        });
    }
}

;// ../../libs/common/src/key-management/vault-timeout/index.ts







;// ../../libs/common/src/platform/misc/convert-values.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

/**
 * Converts a record of keys and values into a record preserving the original key and converting each value into an {@link ObservableInput}.
 * @param project A function to project a given key and value pair into an {@link ObservableInput}
 */
function convertValues(project) {
    return (0,external_rxjs_namespaceObject.map)((inputRecord) => {
        if (inputRecord == null) {
            return null;
        }
        // Can't use TKey in here, have to use `PropertyKey`
        const result = {};
        for (const [key, value] of Object.entries(inputRecord)) {
            result[key] = project(key, value);
        }
        return result;
    });
}

;// ../../libs/common/src/platform/misc/wordlist.ts
// EFF's Long Wordlist from https://www.eff.org/dice
const EFFLongWordList = [
    "abacus",
    "abdomen",
    "abdominal",
    "abide",
    "abiding",
    "ability",
    "ablaze",
    "able",
    "abnormal",
    "abrasion",
    "abrasive",
    "abreast",
    "abridge",
    "abroad",
    "abruptly",
    "absence",
    "absentee",
    "absently",
    "absinthe",
    "absolute",
    "absolve",
    "abstain",
    "abstract",
    "absurd",
    "accent",
    "acclaim",
    "acclimate",
    "accompany",
    "account",
    "accuracy",
    "accurate",
    "accustom",
    "acetone",
    "achiness",
    "aching",
    "acid",
    "acorn",
    "acquaint",
    "acquire",
    "acre",
    "acrobat",
    "acronym",
    "acting",
    "action",
    "activate",
    "activator",
    "active",
    "activism",
    "activist",
    "activity",
    "actress",
    "acts",
    "acutely",
    "acuteness",
    "aeration",
    "aerobics",
    "aerosol",
    "aerospace",
    "afar",
    "affair",
    "affected",
    "affecting",
    "affection",
    "affidavit",
    "affiliate",
    "affirm",
    "affix",
    "afflicted",
    "affluent",
    "afford",
    "affront",
    "aflame",
    "afloat",
    "aflutter",
    "afoot",
    "afraid",
    "afterglow",
    "afterlife",
    "aftermath",
    "aftermost",
    "afternoon",
    "aged",
    "ageless",
    "agency",
    "agenda",
    "agent",
    "aggregate",
    "aghast",
    "agile",
    "agility",
    "aging",
    "agnostic",
    "agonize",
    "agonizing",
    "agony",
    "agreeable",
    "agreeably",
    "agreed",
    "agreeing",
    "agreement",
    "aground",
    "ahead",
    "ahoy",
    "aide",
    "aids",
    "aim",
    "ajar",
    "alabaster",
    "alarm",
    "albatross",
    "album",
    "alfalfa",
    "algebra",
    "algorithm",
    "alias",
    "alibi",
    "alienable",
    "alienate",
    "aliens",
    "alike",
    "alive",
    "alkaline",
    "alkalize",
    "almanac",
    "almighty",
    "almost",
    "aloe",
    "aloft",
    "aloha",
    "alone",
    "alongside",
    "aloof",
    "alphabet",
    "alright",
    "although",
    "altitude",
    "alto",
    "aluminum",
    "alumni",
    "always",
    "amaretto",
    "amaze",
    "amazingly",
    "amber",
    "ambiance",
    "ambiguity",
    "ambiguous",
    "ambition",
    "ambitious",
    "ambulance",
    "ambush",
    "amendable",
    "amendment",
    "amends",
    "amenity",
    "amiable",
    "amicably",
    "amid",
    "amigo",
    "amino",
    "amiss",
    "ammonia",
    "ammonium",
    "amnesty",
    "amniotic",
    "among",
    "amount",
    "amperage",
    "ample",
    "amplifier",
    "amplify",
    "amply",
    "amuck",
    "amulet",
    "amusable",
    "amused",
    "amusement",
    "amuser",
    "amusing",
    "anaconda",
    "anaerobic",
    "anagram",
    "anatomist",
    "anatomy",
    "anchor",
    "anchovy",
    "ancient",
    "android",
    "anemia",
    "anemic",
    "aneurism",
    "anew",
    "angelfish",
    "angelic",
    "anger",
    "angled",
    "angler",
    "angles",
    "angling",
    "angrily",
    "angriness",
    "anguished",
    "angular",
    "animal",
    "animate",
    "animating",
    "animation",
    "animator",
    "anime",
    "animosity",
    "ankle",
    "annex",
    "annotate",
    "announcer",
    "annoying",
    "annually",
    "annuity",
    "anointer",
    "another",
    "answering",
    "antacid",
    "antarctic",
    "anteater",
    "antelope",
    "antennae",
    "anthem",
    "anthill",
    "anthology",
    "antibody",
    "antics",
    "antidote",
    "antihero",
    "antiquely",
    "antiques",
    "antiquity",
    "antirust",
    "antitoxic",
    "antitrust",
    "antiviral",
    "antivirus",
    "antler",
    "antonym",
    "antsy",
    "anvil",
    "anybody",
    "anyhow",
    "anymore",
    "anyone",
    "anyplace",
    "anything",
    "anytime",
    "anyway",
    "anywhere",
    "aorta",
    "apache",
    "apostle",
    "appealing",
    "appear",
    "appease",
    "appeasing",
    "appendage",
    "appendix",
    "appetite",
    "appetizer",
    "applaud",
    "applause",
    "apple",
    "appliance",
    "applicant",
    "applied",
    "apply",
    "appointee",
    "appraisal",
    "appraiser",
    "apprehend",
    "approach",
    "approval",
    "approve",
    "apricot",
    "april",
    "apron",
    "aptitude",
    "aptly",
    "aqua",
    "aqueduct",
    "arbitrary",
    "arbitrate",
    "ardently",
    "area",
    "arena",
    "arguable",
    "arguably",
    "argue",
    "arise",
    "armadillo",
    "armband",
    "armchair",
    "armed",
    "armful",
    "armhole",
    "arming",
    "armless",
    "armoire",
    "armored",
    "armory",
    "armrest",
    "army",
    "aroma",
    "arose",
    "around",
    "arousal",
    "arrange",
    "array",
    "arrest",
    "arrival",
    "arrive",
    "arrogance",
    "arrogant",
    "arson",
    "art",
    "ascend",
    "ascension",
    "ascent",
    "ascertain",
    "ashamed",
    "ashen",
    "ashes",
    "ashy",
    "aside",
    "askew",
    "asleep",
    "asparagus",
    "aspect",
    "aspirate",
    "aspire",
    "aspirin",
    "astonish",
    "astound",
    "astride",
    "astrology",
    "astronaut",
    "astronomy",
    "astute",
    "atlantic",
    "atlas",
    "atom",
    "atonable",
    "atop",
    "atrium",
    "atrocious",
    "atrophy",
    "attach",
    "attain",
    "attempt",
    "attendant",
    "attendee",
    "attention",
    "attentive",
    "attest",
    "attic",
    "attire",
    "attitude",
    "attractor",
    "attribute",
    "atypical",
    "auction",
    "audacious",
    "audacity",
    "audible",
    "audibly",
    "audience",
    "audio",
    "audition",
    "augmented",
    "august",
    "authentic",
    "author",
    "autism",
    "autistic",
    "autograph",
    "automaker",
    "automated",
    "automatic",
    "autopilot",
    "available",
    "avalanche",
    "avatar",
    "avenge",
    "avenging",
    "avenue",
    "average",
    "aversion",
    "avert",
    "aviation",
    "aviator",
    "avid",
    "avoid",
    "await",
    "awaken",
    "award",
    "aware",
    "awhile",
    "awkward",
    "awning",
    "awoke",
    "awry",
    "axis",
    "babble",
    "babbling",
    "babied",
    "baboon",
    "backache",
    "backboard",
    "backboned",
    "backdrop",
    "backed",
    "backer",
    "backfield",
    "backfire",
    "backhand",
    "backing",
    "backlands",
    "backlash",
    "backless",
    "backlight",
    "backlit",
    "backlog",
    "backpack",
    "backpedal",
    "backrest",
    "backroom",
    "backshift",
    "backside",
    "backslid",
    "backspace",
    "backspin",
    "backstab",
    "backstage",
    "backtalk",
    "backtrack",
    "backup",
    "backward",
    "backwash",
    "backwater",
    "backyard",
    "bacon",
    "bacteria",
    "bacterium",
    "badass",
    "badge",
    "badland",
    "badly",
    "badness",
    "baffle",
    "baffling",
    "bagel",
    "bagful",
    "baggage",
    "bagged",
    "baggie",
    "bagginess",
    "bagging",
    "baggy",
    "bagpipe",
    "baguette",
    "baked",
    "bakery",
    "bakeshop",
    "baking",
    "balance",
    "balancing",
    "balcony",
    "balmy",
    "balsamic",
    "bamboo",
    "banana",
    "banish",
    "banister",
    "banjo",
    "bankable",
    "bankbook",
    "banked",
    "banker",
    "banking",
    "banknote",
    "bankroll",
    "banner",
    "bannister",
    "banshee",
    "banter",
    "barbecue",
    "barbed",
    "barbell",
    "barber",
    "barcode",
    "barge",
    "bargraph",
    "barista",
    "baritone",
    "barley",
    "barmaid",
    "barman",
    "barn",
    "barometer",
    "barrack",
    "barracuda",
    "barrel",
    "barrette",
    "barricade",
    "barrier",
    "barstool",
    "bartender",
    "barterer",
    "bash",
    "basically",
    "basics",
    "basil",
    "basin",
    "basis",
    "basket",
    "batboy",
    "batch",
    "bath",
    "baton",
    "bats",
    "battalion",
    "battered",
    "battering",
    "battery",
    "batting",
    "battle",
    "bauble",
    "bazooka",
    "blabber",
    "bladder",
    "blade",
    "blah",
    "blame",
    "blaming",
    "blanching",
    "blandness",
    "blank",
    "blaspheme",
    "blasphemy",
    "blast",
    "blatancy",
    "blatantly",
    "blazer",
    "blazing",
    "bleach",
    "bleak",
    "bleep",
    "blemish",
    "blend",
    "bless",
    "blighted",
    "blimp",
    "bling",
    "blinked",
    "blinker",
    "blinking",
    "blinks",
    "blip",
    "blissful",
    "blitz",
    "blizzard",
    "bloated",
    "bloating",
    "blob",
    "blog",
    "bloomers",
    "blooming",
    "blooper",
    "blot",
    "blouse",
    "blubber",
    "bluff",
    "bluish",
    "blunderer",
    "blunt",
    "blurb",
    "blurred",
    "blurry",
    "blurt",
    "blush",
    "blustery",
    "boaster",
    "boastful",
    "boasting",
    "boat",
    "bobbed",
    "bobbing",
    "bobble",
    "bobcat",
    "bobsled",
    "bobtail",
    "bodacious",
    "body",
    "bogged",
    "boggle",
    "bogus",
    "boil",
    "bok",
    "bolster",
    "bolt",
    "bonanza",
    "bonded",
    "bonding",
    "bondless",
    "boned",
    "bonehead",
    "boneless",
    "bonelike",
    "boney",
    "bonfire",
    "bonnet",
    "bonsai",
    "bonus",
    "bony",
    "boogeyman",
    "boogieman",
    "book",
    "boondocks",
    "booted",
    "booth",
    "bootie",
    "booting",
    "bootlace",
    "bootleg",
    "boots",
    "boozy",
    "borax",
    "boring",
    "borough",
    "borrower",
    "borrowing",
    "boss",
    "botanical",
    "botanist",
    "botany",
    "botch",
    "both",
    "bottle",
    "bottling",
    "bottom",
    "bounce",
    "bouncing",
    "bouncy",
    "bounding",
    "boundless",
    "bountiful",
    "bovine",
    "boxcar",
    "boxer",
    "boxing",
    "boxlike",
    "boxy",
    "breach",
    "breath",
    "breeches",
    "breeching",
    "breeder",
    "breeding",
    "breeze",
    "breezy",
    "brethren",
    "brewery",
    "brewing",
    "briar",
    "bribe",
    "brick",
    "bride",
    "bridged",
    "brigade",
    "bright",
    "brilliant",
    "brim",
    "bring",
    "brink",
    "brisket",
    "briskly",
    "briskness",
    "bristle",
    "brittle",
    "broadband",
    "broadcast",
    "broaden",
    "broadly",
    "broadness",
    "broadside",
    "broadways",
    "broiler",
    "broiling",
    "broken",
    "broker",
    "bronchial",
    "bronco",
    "bronze",
    "bronzing",
    "brook",
    "broom",
    "brought",
    "browbeat",
    "brownnose",
    "browse",
    "browsing",
    "bruising",
    "brunch",
    "brunette",
    "brunt",
    "brush",
    "brussels",
    "brute",
    "brutishly",
    "bubble",
    "bubbling",
    "bubbly",
    "buccaneer",
    "bucked",
    "bucket",
    "buckle",
    "buckshot",
    "buckskin",
    "bucktooth",
    "buckwheat",
    "buddhism",
    "buddhist",
    "budding",
    "buddy",
    "budget",
    "buffalo",
    "buffed",
    "buffer",
    "buffing",
    "buffoon",
    "buggy",
    "bulb",
    "bulge",
    "bulginess",
    "bulgur",
    "bulk",
    "bulldog",
    "bulldozer",
    "bullfight",
    "bullfrog",
    "bullhorn",
    "bullion",
    "bullish",
    "bullpen",
    "bullring",
    "bullseye",
    "bullwhip",
    "bully",
    "bunch",
    "bundle",
    "bungee",
    "bunion",
    "bunkbed",
    "bunkhouse",
    "bunkmate",
    "bunny",
    "bunt",
    "busboy",
    "bush",
    "busily",
    "busload",
    "bust",
    "busybody",
    "buzz",
    "cabana",
    "cabbage",
    "cabbie",
    "cabdriver",
    "cable",
    "caboose",
    "cache",
    "cackle",
    "cacti",
    "cactus",
    "caddie",
    "caddy",
    "cadet",
    "cadillac",
    "cadmium",
    "cage",
    "cahoots",
    "cake",
    "calamari",
    "calamity",
    "calcium",
    "calculate",
    "calculus",
    "caliber",
    "calibrate",
    "calm",
    "caloric",
    "calorie",
    "calzone",
    "camcorder",
    "cameo",
    "camera",
    "camisole",
    "camper",
    "campfire",
    "camping",
    "campsite",
    "campus",
    "canal",
    "canary",
    "cancel",
    "candied",
    "candle",
    "candy",
    "cane",
    "canine",
    "canister",
    "cannabis",
    "canned",
    "canning",
    "cannon",
    "cannot",
    "canola",
    "canon",
    "canopener",
    "canopy",
    "canteen",
    "canyon",
    "capable",
    "capably",
    "capacity",
    "cape",
    "capillary",
    "capital",
    "capitol",
    "capped",
    "capricorn",
    "capsize",
    "capsule",
    "caption",
    "captivate",
    "captive",
    "captivity",
    "capture",
    "caramel",
    "carat",
    "caravan",
    "carbon",
    "cardboard",
    "carded",
    "cardiac",
    "cardigan",
    "cardinal",
    "cardstock",
    "carefully",
    "caregiver",
    "careless",
    "caress",
    "caretaker",
    "cargo",
    "caring",
    "carless",
    "carload",
    "carmaker",
    "carnage",
    "carnation",
    "carnival",
    "carnivore",
    "carol",
    "carpenter",
    "carpentry",
    "carpool",
    "carport",
    "carried",
    "carrot",
    "carrousel",
    "carry",
    "cartel",
    "cartload",
    "carton",
    "cartoon",
    "cartridge",
    "cartwheel",
    "carve",
    "carving",
    "carwash",
    "cascade",
    "case",
    "cash",
    "casing",
    "casino",
    "casket",
    "cassette",
    "casually",
    "casualty",
    "catacomb",
    "catalog",
    "catalyst",
    "catalyze",
    "catapult",
    "cataract",
    "catatonic",
    "catcall",
    "catchable",
    "catcher",
    "catching",
    "catchy",
    "caterer",
    "catering",
    "catfight",
    "catfish",
    "cathedral",
    "cathouse",
    "catlike",
    "catnap",
    "catnip",
    "catsup",
    "cattail",
    "cattishly",
    "cattle",
    "catty",
    "catwalk",
    "caucasian",
    "caucus",
    "causal",
    "causation",
    "cause",
    "causing",
    "cauterize",
    "caution",
    "cautious",
    "cavalier",
    "cavalry",
    "caviar",
    "cavity",
    "cedar",
    "celery",
    "celestial",
    "celibacy",
    "celibate",
    "celtic",
    "cement",
    "census",
    "ceramics",
    "ceremony",
    "certainly",
    "certainty",
    "certified",
    "certify",
    "cesarean",
    "cesspool",
    "chafe",
    "chaffing",
    "chain",
    "chair",
    "chalice",
    "challenge",
    "chamber",
    "chamomile",
    "champion",
    "chance",
    "change",
    "channel",
    "chant",
    "chaos",
    "chaperone",
    "chaplain",
    "chapped",
    "chaps",
    "chapter",
    "character",
    "charbroil",
    "charcoal",
    "charger",
    "charging",
    "chariot",
    "charity",
    "charm",
    "charred",
    "charter",
    "charting",
    "chase",
    "chasing",
    "chaste",
    "chastise",
    "chastity",
    "chatroom",
    "chatter",
    "chatting",
    "chatty",
    "cheating",
    "cheddar",
    "cheek",
    "cheer",
    "cheese",
    "cheesy",
    "chef",
    "chemicals",
    "chemist",
    "chemo",
    "cherisher",
    "cherub",
    "chess",
    "chest",
    "chevron",
    "chevy",
    "chewable",
    "chewer",
    "chewing",
    "chewy",
    "chief",
    "chihuahua",
    "childcare",
    "childhood",
    "childish",
    "childless",
    "childlike",
    "chili",
    "chill",
    "chimp",
    "chip",
    "chirping",
    "chirpy",
    "chitchat",
    "chivalry",
    "chive",
    "chloride",
    "chlorine",
    "choice",
    "chokehold",
    "choking",
    "chomp",
    "chooser",
    "choosing",
    "choosy",
    "chop",
    "chosen",
    "chowder",
    "chowtime",
    "chrome",
    "chubby",
    "chuck",
    "chug",
    "chummy",
    "chump",
    "chunk",
    "churn",
    "chute",
    "cider",
    "cilantro",
    "cinch",
    "cinema",
    "cinnamon",
    "circle",
    "circling",
    "circular",
    "circulate",
    "circus",
    "citable",
    "citadel",
    "citation",
    "citizen",
    "citric",
    "citrus",
    "city",
    "civic",
    "civil",
    "clad",
    "claim",
    "clambake",
    "clammy",
    "clamor",
    "clamp",
    "clamshell",
    "clang",
    "clanking",
    "clapped",
    "clapper",
    "clapping",
    "clarify",
    "clarinet",
    "clarity",
    "clash",
    "clasp",
    "class",
    "clatter",
    "clause",
    "clavicle",
    "claw",
    "clay",
    "clean",
    "clear",
    "cleat",
    "cleaver",
    "cleft",
    "clench",
    "clergyman",
    "clerical",
    "clerk",
    "clever",
    "clicker",
    "client",
    "climate",
    "climatic",
    "cling",
    "clinic",
    "clinking",
    "clip",
    "clique",
    "cloak",
    "clobber",
    "clock",
    "clone",
    "cloning",
    "closable",
    "closure",
    "clothes",
    "clothing",
    "cloud",
    "clover",
    "clubbed",
    "clubbing",
    "clubhouse",
    "clump",
    "clumsily",
    "clumsy",
    "clunky",
    "clustered",
    "clutch",
    "clutter",
    "coach",
    "coagulant",
    "coastal",
    "coaster",
    "coasting",
    "coastland",
    "coastline",
    "coat",
    "coauthor",
    "cobalt",
    "cobbler",
    "cobweb",
    "cocoa",
    "coconut",
    "cod",
    "coeditor",
    "coerce",
    "coexist",
    "coffee",
    "cofounder",
    "cognition",
    "cognitive",
    "cogwheel",
    "coherence",
    "coherent",
    "cohesive",
    "coil",
    "coke",
    "cola",
    "cold",
    "coleslaw",
    "coliseum",
    "collage",
    "collapse",
    "collar",
    "collected",
    "collector",
    "collide",
    "collie",
    "collision",
    "colonial",
    "colonist",
    "colonize",
    "colony",
    "colossal",
    "colt",
    "coma",
    "come",
    "comfort",
    "comfy",
    "comic",
    "coming",
    "comma",
    "commence",
    "commend",
    "comment",
    "commerce",
    "commode",
    "commodity",
    "commodore",
    "common",
    "commotion",
    "commute",
    "commuting",
    "compacted",
    "compacter",
    "compactly",
    "compactor",
    "companion",
    "company",
    "compare",
    "compel",
    "compile",
    "comply",
    "component",
    "composed",
    "composer",
    "composite",
    "compost",
    "composure",
    "compound",
    "compress",
    "comprised",
    "computer",
    "computing",
    "comrade",
    "concave",
    "conceal",
    "conceded",
    "concept",
    "concerned",
    "concert",
    "conch",
    "concierge",
    "concise",
    "conclude",
    "concrete",
    "concur",
    "condense",
    "condiment",
    "condition",
    "condone",
    "conducive",
    "conductor",
    "conduit",
    "cone",
    "confess",
    "confetti",
    "confidant",
    "confident",
    "confider",
    "confiding",
    "configure",
    "confined",
    "confining",
    "confirm",
    "conflict",
    "conform",
    "confound",
    "confront",
    "confused",
    "confusing",
    "confusion",
    "congenial",
    "congested",
    "congrats",
    "congress",
    "conical",
    "conjoined",
    "conjure",
    "conjuror",
    "connected",
    "connector",
    "consensus",
    "consent",
    "console",
    "consoling",
    "consonant",
    "constable",
    "constant",
    "constrain",
    "constrict",
    "construct",
    "consult",
    "consumer",
    "consuming",
    "contact",
    "container",
    "contempt",
    "contend",
    "contented",
    "contently",
    "contents",
    "contest",
    "context",
    "contort",
    "contour",
    "contrite",
    "control",
    "contusion",
    "convene",
    "convent",
    "copartner",
    "cope",
    "copied",
    "copier",
    "copilot",
    "coping",
    "copious",
    "copper",
    "copy",
    "coral",
    "cork",
    "cornball",
    "cornbread",
    "corncob",
    "cornea",
    "corned",
    "corner",
    "cornfield",
    "cornflake",
    "cornhusk",
    "cornmeal",
    "cornstalk",
    "corny",
    "coronary",
    "coroner",
    "corporal",
    "corporate",
    "corral",
    "correct",
    "corridor",
    "corrode",
    "corroding",
    "corrosive",
    "corsage",
    "corset",
    "cortex",
    "cosigner",
    "cosmetics",
    "cosmic",
    "cosmos",
    "cosponsor",
    "cost",
    "cottage",
    "cotton",
    "couch",
    "cough",
    "could",
    "countable",
    "countdown",
    "counting",
    "countless",
    "country",
    "county",
    "courier",
    "covenant",
    "cover",
    "coveted",
    "coveting",
    "coyness",
    "cozily",
    "coziness",
    "cozy",
    "crabbing",
    "crabgrass",
    "crablike",
    "crabmeat",
    "cradle",
    "cradling",
    "crafter",
    "craftily",
    "craftsman",
    "craftwork",
    "crafty",
    "cramp",
    "cranberry",
    "crane",
    "cranial",
    "cranium",
    "crank",
    "crate",
    "crave",
    "craving",
    "crawfish",
    "crawlers",
    "crawling",
    "crayfish",
    "crayon",
    "crazed",
    "crazily",
    "craziness",
    "crazy",
    "creamed",
    "creamer",
    "creamlike",
    "crease",
    "creasing",
    "creatable",
    "create",
    "creation",
    "creative",
    "creature",
    "credible",
    "credibly",
    "credit",
    "creed",
    "creme",
    "creole",
    "crepe",
    "crept",
    "crescent",
    "crested",
    "cresting",
    "crestless",
    "crevice",
    "crewless",
    "crewman",
    "crewmate",
    "crib",
    "cricket",
    "cried",
    "crier",
    "crimp",
    "crimson",
    "cringe",
    "cringing",
    "crinkle",
    "crinkly",
    "crisped",
    "crisping",
    "crisply",
    "crispness",
    "crispy",
    "criteria",
    "critter",
    "croak",
    "crock",
    "crook",
    "croon",
    "crop",
    "cross",
    "crouch",
    "crouton",
    "crowbar",
    "crowd",
    "crown",
    "crucial",
    "crudely",
    "crudeness",
    "cruelly",
    "cruelness",
    "cruelty",
    "crumb",
    "crummiest",
    "crummy",
    "crumpet",
    "crumpled",
    "cruncher",
    "crunching",
    "crunchy",
    "crusader",
    "crushable",
    "crushed",
    "crusher",
    "crushing",
    "crust",
    "crux",
    "crying",
    "cryptic",
    "crystal",
    "cubbyhole",
    "cube",
    "cubical",
    "cubicle",
    "cucumber",
    "cuddle",
    "cuddly",
    "cufflink",
    "culinary",
    "culminate",
    "culpable",
    "culprit",
    "cultivate",
    "cultural",
    "culture",
    "cupbearer",
    "cupcake",
    "cupid",
    "cupped",
    "cupping",
    "curable",
    "curator",
    "curdle",
    "cure",
    "curfew",
    "curing",
    "curled",
    "curler",
    "curliness",
    "curling",
    "curly",
    "curry",
    "curse",
    "cursive",
    "cursor",
    "curtain",
    "curtly",
    "curtsy",
    "curvature",
    "curve",
    "curvy",
    "cushy",
    "cusp",
    "cussed",
    "custard",
    "custodian",
    "custody",
    "customary",
    "customer",
    "customize",
    "customs",
    "cut",
    "cycle",
    "cyclic",
    "cycling",
    "cyclist",
    "cylinder",
    "cymbal",
    "cytoplasm",
    "cytoplast",
    "dab",
    "dad",
    "daffodil",
    "dagger",
    "daily",
    "daintily",
    "dainty",
    "dairy",
    "daisy",
    "dallying",
    "dance",
    "dancing",
    "dandelion",
    "dander",
    "dandruff",
    "dandy",
    "danger",
    "dangle",
    "dangling",
    "daredevil",
    "dares",
    "daringly",
    "darkened",
    "darkening",
    "darkish",
    "darkness",
    "darkroom",
    "darling",
    "darn",
    "dart",
    "darwinism",
    "dash",
    "dastardly",
    "data",
    "datebook",
    "dating",
    "daughter",
    "daunting",
    "dawdler",
    "dawn",
    "daybed",
    "daybreak",
    "daycare",
    "daydream",
    "daylight",
    "daylong",
    "dayroom",
    "daytime",
    "dazzler",
    "dazzling",
    "deacon",
    "deafening",
    "deafness",
    "dealer",
    "dealing",
    "dealmaker",
    "dealt",
    "dean",
    "debatable",
    "debate",
    "debating",
    "debit",
    "debrief",
    "debtless",
    "debtor",
    "debug",
    "debunk",
    "decade",
    "decaf",
    "decal",
    "decathlon",
    "decay",
    "deceased",
    "deceit",
    "deceiver",
    "deceiving",
    "december",
    "decency",
    "decent",
    "deception",
    "deceptive",
    "decibel",
    "decidable",
    "decimal",
    "decimeter",
    "decipher",
    "deck",
    "declared",
    "decline",
    "decode",
    "decompose",
    "decorated",
    "decorator",
    "decoy",
    "decrease",
    "decree",
    "dedicate",
    "dedicator",
    "deduce",
    "deduct",
    "deed",
    "deem",
    "deepen",
    "deeply",
    "deepness",
    "deface",
    "defacing",
    "defame",
    "default",
    "defeat",
    "defection",
    "defective",
    "defendant",
    "defender",
    "defense",
    "defensive",
    "deferral",
    "deferred",
    "defiance",
    "defiant",
    "defile",
    "defiling",
    "define",
    "definite",
    "deflate",
    "deflation",
    "deflator",
    "deflected",
    "deflector",
    "defog",
    "deforest",
    "defraud",
    "defrost",
    "deftly",
    "defuse",
    "defy",
    "degraded",
    "degrading",
    "degrease",
    "degree",
    "dehydrate",
    "deity",
    "dejected",
    "delay",
    "delegate",
    "delegator",
    "delete",
    "deletion",
    "delicacy",
    "delicate",
    "delicious",
    "delighted",
    "delirious",
    "delirium",
    "deliverer",
    "delivery",
    "delouse",
    "delta",
    "deluge",
    "delusion",
    "deluxe",
    "demanding",
    "demeaning",
    "demeanor",
    "demise",
    "democracy",
    "democrat",
    "demote",
    "demotion",
    "demystify",
    "denatured",
    "deniable",
    "denial",
    "denim",
    "denote",
    "dense",
    "density",
    "dental",
    "dentist",
    "denture",
    "deny",
    "deodorant",
    "deodorize",
    "departed",
    "departure",
    "depict",
    "deplete",
    "depletion",
    "deplored",
    "deploy",
    "deport",
    "depose",
    "depraved",
    "depravity",
    "deprecate",
    "depress",
    "deprive",
    "depth",
    "deputize",
    "deputy",
    "derail",
    "deranged",
    "derby",
    "derived",
    "desecrate",
    "deserve",
    "deserving",
    "designate",
    "designed",
    "designer",
    "designing",
    "deskbound",
    "desktop",
    "deskwork",
    "desolate",
    "despair",
    "despise",
    "despite",
    "destiny",
    "destitute",
    "destruct",
    "detached",
    "detail",
    "detection",
    "detective",
    "detector",
    "detention",
    "detergent",
    "detest",
    "detonate",
    "detonator",
    "detoxify",
    "detract",
    "deuce",
    "devalue",
    "deviancy",
    "deviant",
    "deviate",
    "deviation",
    "deviator",
    "device",
    "devious",
    "devotedly",
    "devotee",
    "devotion",
    "devourer",
    "devouring",
    "devoutly",
    "dexterity",
    "dexterous",
    "diabetes",
    "diabetic",
    "diabolic",
    "diagnoses",
    "diagnosis",
    "diagram",
    "dial",
    "diameter",
    "diaper",
    "diaphragm",
    "diary",
    "dice",
    "dicing",
    "dictate",
    "dictation",
    "dictator",
    "difficult",
    "diffused",
    "diffuser",
    "diffusion",
    "diffusive",
    "dig",
    "dilation",
    "diligence",
    "diligent",
    "dill",
    "dilute",
    "dime",
    "diminish",
    "dimly",
    "dimmed",
    "dimmer",
    "dimness",
    "dimple",
    "diner",
    "dingbat",
    "dinghy",
    "dinginess",
    "dingo",
    "dingy",
    "dining",
    "dinner",
    "diocese",
    "dioxide",
    "diploma",
    "dipped",
    "dipper",
    "dipping",
    "directed",
    "direction",
    "directive",
    "directly",
    "directory",
    "direness",
    "dirtiness",
    "disabled",
    "disagree",
    "disallow",
    "disarm",
    "disarray",
    "disaster",
    "disband",
    "disbelief",
    "disburse",
    "discard",
    "discern",
    "discharge",
    "disclose",
    "discolor",
    "discount",
    "discourse",
    "discover",
    "discuss",
    "disdain",
    "disengage",
    "disfigure",
    "disgrace",
    "dish",
    "disinfect",
    "disjoin",
    "disk",
    "dislike",
    "disliking",
    "dislocate",
    "dislodge",
    "disloyal",
    "dismantle",
    "dismay",
    "dismiss",
    "dismount",
    "disobey",
    "disorder",
    "disown",
    "disparate",
    "disparity",
    "dispatch",
    "dispense",
    "dispersal",
    "dispersed",
    "disperser",
    "displace",
    "display",
    "displease",
    "disposal",
    "dispose",
    "disprove",
    "dispute",
    "disregard",
    "disrupt",
    "dissuade",
    "distance",
    "distant",
    "distaste",
    "distill",
    "distinct",
    "distort",
    "distract",
    "distress",
    "district",
    "distrust",
    "ditch",
    "ditto",
    "ditzy",
    "dividable",
    "divided",
    "dividend",
    "dividers",
    "dividing",
    "divinely",
    "diving",
    "divinity",
    "divisible",
    "divisibly",
    "division",
    "divisive",
    "divorcee",
    "dizziness",
    "dizzy",
    "doable",
    "docile",
    "dock",
    "doctrine",
    "document",
    "dodge",
    "dodgy",
    "doily",
    "doing",
    "dole",
    "dollar",
    "dollhouse",
    "dollop",
    "dolly",
    "dolphin",
    "domain",
    "domelike",
    "domestic",
    "dominion",
    "dominoes",
    "donated",
    "donation",
    "donator",
    "donor",
    "donut",
    "doodle",
    "doorbell",
    "doorframe",
    "doorknob",
    "doorman",
    "doormat",
    "doornail",
    "doorpost",
    "doorstep",
    "doorstop",
    "doorway",
    "doozy",
    "dork",
    "dormitory",
    "dorsal",
    "dosage",
    "dose",
    "dotted",
    "doubling",
    "douche",
    "dove",
    "down",
    "dowry",
    "doze",
    "drab",
    "dragging",
    "dragonfly",
    "dragonish",
    "dragster",
    "drainable",
    "drainage",
    "drained",
    "drainer",
    "drainpipe",
    "dramatic",
    "dramatize",
    "drank",
    "drapery",
    "drastic",
    "draw",
    "dreaded",
    "dreadful",
    "dreadlock",
    "dreamboat",
    "dreamily",
    "dreamland",
    "dreamless",
    "dreamlike",
    "dreamt",
    "dreamy",
    "drearily",
    "dreary",
    "drench",
    "dress",
    "drew",
    "dribble",
    "dried",
    "drier",
    "drift",
    "driller",
    "drilling",
    "drinkable",
    "drinking",
    "dripping",
    "drippy",
    "drivable",
    "driven",
    "driver",
    "driveway",
    "driving",
    "drizzle",
    "drizzly",
    "drone",
    "drool",
    "droop",
    "drop-down",
    "dropbox",
    "dropkick",
    "droplet",
    "dropout",
    "dropper",
    "drove",
    "drown",
    "drowsily",
    "drudge",
    "drum",
    "dry",
    "dubbed",
    "dubiously",
    "duchess",
    "duckbill",
    "ducking",
    "duckling",
    "ducktail",
    "ducky",
    "duct",
    "dude",
    "duffel",
    "dugout",
    "duh",
    "duke",
    "duller",
    "dullness",
    "duly",
    "dumping",
    "dumpling",
    "dumpster",
    "duo",
    "dupe",
    "duplex",
    "duplicate",
    "duplicity",
    "durable",
    "durably",
    "duration",
    "duress",
    "during",
    "dusk",
    "dust",
    "dutiful",
    "duty",
    "duvet",
    "dwarf",
    "dweeb",
    "dwelled",
    "dweller",
    "dwelling",
    "dwindle",
    "dwindling",
    "dynamic",
    "dynamite",
    "dynasty",
    "dyslexia",
    "dyslexic",
    "each",
    "eagle",
    "earache",
    "eardrum",
    "earflap",
    "earful",
    "earlobe",
    "early",
    "earmark",
    "earmuff",
    "earphone",
    "earpiece",
    "earplugs",
    "earring",
    "earshot",
    "earthen",
    "earthlike",
    "earthling",
    "earthly",
    "earthworm",
    "earthy",
    "earwig",
    "easeful",
    "easel",
    "easiest",
    "easily",
    "easiness",
    "easing",
    "eastbound",
    "eastcoast",
    "easter",
    "eastward",
    "eatable",
    "eaten",
    "eatery",
    "eating",
    "eats",
    "ebay",
    "ebony",
    "ebook",
    "ecard",
    "eccentric",
    "echo",
    "eclair",
    "eclipse",
    "ecologist",
    "ecology",
    "economic",
    "economist",
    "economy",
    "ecosphere",
    "ecosystem",
    "edge",
    "edginess",
    "edging",
    "edgy",
    "edition",
    "editor",
    "educated",
    "education",
    "educator",
    "eel",
    "effective",
    "effects",
    "efficient",
    "effort",
    "eggbeater",
    "egging",
    "eggnog",
    "eggplant",
    "eggshell",
    "egomaniac",
    "egotism",
    "egotistic",
    "either",
    "eject",
    "elaborate",
    "elastic",
    "elated",
    "elbow",
    "eldercare",
    "elderly",
    "eldest",
    "electable",
    "election",
    "elective",
    "elephant",
    "elevate",
    "elevating",
    "elevation",
    "elevator",
    "eleven",
    "elf",
    "eligible",
    "eligibly",
    "eliminate",
    "elite",
    "elitism",
    "elixir",
    "elk",
    "ellipse",
    "elliptic",
    "elm",
    "elongated",
    "elope",
    "eloquence",
    "eloquent",
    "elsewhere",
    "elude",
    "elusive",
    "elves",
    "email",
    "embargo",
    "embark",
    "embassy",
    "embattled",
    "embellish",
    "ember",
    "embezzle",
    "emblaze",
    "emblem",
    "embody",
    "embolism",
    "emboss",
    "embroider",
    "emcee",
    "emerald",
    "emergency",
    "emission",
    "emit",
    "emote",
    "emoticon",
    "emotion",
    "empathic",
    "empathy",
    "emperor",
    "emphases",
    "emphasis",
    "emphasize",
    "emphatic",
    "empirical",
    "employed",
    "employee",
    "employer",
    "emporium",
    "empower",
    "emptier",
    "emptiness",
    "empty",
    "emu",
    "enable",
    "enactment",
    "enamel",
    "enchanted",
    "enchilada",
    "encircle",
    "enclose",
    "enclosure",
    "encode",
    "encore",
    "encounter",
    "encourage",
    "encroach",
    "encrust",
    "encrypt",
    "endanger",
    "endeared",
    "endearing",
    "ended",
    "ending",
    "endless",
    "endnote",
    "endocrine",
    "endorphin",
    "endorse",
    "endowment",
    "endpoint",
    "endurable",
    "endurance",
    "enduring",
    "energetic",
    "energize",
    "energy",
    "enforced",
    "enforcer",
    "engaged",
    "engaging",
    "engine",
    "engorge",
    "engraved",
    "engraver",
    "engraving",
    "engross",
    "engulf",
    "enhance",
    "enigmatic",
    "enjoyable",
    "enjoyably",
    "enjoyer",
    "enjoying",
    "enjoyment",
    "enlarged",
    "enlarging",
    "enlighten",
    "enlisted",
    "enquirer",
    "enrage",
    "enrich",
    "enroll",
    "enslave",
    "ensnare",
    "ensure",
    "entail",
    "entangled",
    "entering",
    "entertain",
    "enticing",
    "entire",
    "entitle",
    "entity",
    "entomb",
    "entourage",
    "entrap",
    "entree",
    "entrench",
    "entrust",
    "entryway",
    "entwine",
    "enunciate",
    "envelope",
    "enviable",
    "enviably",
    "envious",
    "envision",
    "envoy",
    "envy",
    "enzyme",
    "epic",
    "epidemic",
    "epidermal",
    "epidermis",
    "epidural",
    "epilepsy",
    "epileptic",
    "epilogue",
    "epiphany",
    "episode",
    "equal",
    "equate",
    "equation",
    "equator",
    "equinox",
    "equipment",
    "equity",
    "equivocal",
    "eradicate",
    "erasable",
    "erased",
    "eraser",
    "erasure",
    "ergonomic",
    "errand",
    "errant",
    "erratic",
    "error",
    "erupt",
    "escalate",
    "escalator",
    "escapable",
    "escapade",
    "escapist",
    "escargot",
    "eskimo",
    "esophagus",
    "espionage",
    "espresso",
    "esquire",
    "essay",
    "essence",
    "essential",
    "establish",
    "estate",
    "esteemed",
    "estimate",
    "estimator",
    "estranged",
    "estrogen",
    "etching",
    "eternal",
    "eternity",
    "ethanol",
    "ether",
    "ethically",
    "ethics",
    "euphemism",
    "evacuate",
    "evacuee",
    "evade",
    "evaluate",
    "evaluator",
    "evaporate",
    "evasion",
    "evasive",
    "even",
    "everglade",
    "evergreen",
    "everybody",
    "everyday",
    "everyone",
    "evict",
    "evidence",
    "evident",
    "evil",
    "evoke",
    "evolution",
    "evolve",
    "exact",
    "exalted",
    "example",
    "excavate",
    "excavator",
    "exceeding",
    "exception",
    "excess",
    "exchange",
    "excitable",
    "exciting",
    "exclaim",
    "exclude",
    "excluding",
    "exclusion",
    "exclusive",
    "excretion",
    "excretory",
    "excursion",
    "excusable",
    "excusably",
    "excuse",
    "exemplary",
    "exemplify",
    "exemption",
    "exerciser",
    "exert",
    "exes",
    "exfoliate",
    "exhale",
    "exhaust",
    "exhume",
    "exile",
    "existing",
    "exit",
    "exodus",
    "exonerate",
    "exorcism",
    "exorcist",
    "expand",
    "expanse",
    "expansion",
    "expansive",
    "expectant",
    "expedited",
    "expediter",
    "expel",
    "expend",
    "expenses",
    "expensive",
    "expert",
    "expire",
    "expiring",
    "explain",
    "expletive",
    "explicit",
    "explode",
    "exploit",
    "explore",
    "exploring",
    "exponent",
    "exporter",
    "exposable",
    "expose",
    "exposure",
    "express",
    "expulsion",
    "exquisite",
    "extended",
    "extending",
    "extent",
    "extenuate",
    "exterior",
    "external",
    "extinct",
    "extortion",
    "extradite",
    "extras",
    "extrovert",
    "extrude",
    "extruding",
    "exuberant",
    "fable",
    "fabric",
    "fabulous",
    "facebook",
    "facecloth",
    "facedown",
    "faceless",
    "facelift",
    "faceplate",
    "faceted",
    "facial",
    "facility",
    "facing",
    "facsimile",
    "faction",
    "factoid",
    "factor",
    "factsheet",
    "factual",
    "faculty",
    "fade",
    "fading",
    "failing",
    "falcon",
    "fall",
    "false",
    "falsify",
    "fame",
    "familiar",
    "family",
    "famine",
    "famished",
    "fanatic",
    "fancied",
    "fanciness",
    "fancy",
    "fanfare",
    "fang",
    "fanning",
    "fantasize",
    "fantastic",
    "fantasy",
    "fascism",
    "fastball",
    "faster",
    "fasting",
    "fastness",
    "faucet",
    "favorable",
    "favorably",
    "favored",
    "favoring",
    "favorite",
    "fax",
    "feast",
    "federal",
    "fedora",
    "feeble",
    "feed",
    "feel",
    "feisty",
    "feline",
    "felt-tip",
    "feminine",
    "feminism",
    "feminist",
    "feminize",
    "femur",
    "fence",
    "fencing",
    "fender",
    "ferment",
    "fernlike",
    "ferocious",
    "ferocity",
    "ferret",
    "ferris",
    "ferry",
    "fervor",
    "fester",
    "festival",
    "festive",
    "festivity",
    "fetal",
    "fetch",
    "fever",
    "fiber",
    "fiction",
    "fiddle",
    "fiddling",
    "fidelity",
    "fidgeting",
    "fidgety",
    "fifteen",
    "fifth",
    "fiftieth",
    "fifty",
    "figment",
    "figure",
    "figurine",
    "filing",
    "filled",
    "filler",
    "filling",
    "film",
    "filter",
    "filth",
    "filtrate",
    "finale",
    "finalist",
    "finalize",
    "finally",
    "finance",
    "financial",
    "finch",
    "fineness",
    "finer",
    "finicky",
    "finished",
    "finisher",
    "finishing",
    "finite",
    "finless",
    "finlike",
    "fiscally",
    "fit",
    "five",
    "flaccid",
    "flagman",
    "flagpole",
    "flagship",
    "flagstick",
    "flagstone",
    "flail",
    "flakily",
    "flaky",
    "flame",
    "flammable",
    "flanked",
    "flanking",
    "flannels",
    "flap",
    "flaring",
    "flashback",
    "flashbulb",
    "flashcard",
    "flashily",
    "flashing",
    "flashy",
    "flask",
    "flatbed",
    "flatfoot",
    "flatly",
    "flatness",
    "flatten",
    "flattered",
    "flatterer",
    "flattery",
    "flattop",
    "flatware",
    "flatworm",
    "flavored",
    "flavorful",
    "flavoring",
    "flaxseed",
    "fled",
    "fleshed",
    "fleshy",
    "flick",
    "flier",
    "flight",
    "flinch",
    "fling",
    "flint",
    "flip",
    "flirt",
    "float",
    "flock",
    "flogging",
    "flop",
    "floral",
    "florist",
    "floss",
    "flounder",
    "flyable",
    "flyaway",
    "flyer",
    "flying",
    "flyover",
    "flypaper",
    "foam",
    "foe",
    "fog",
    "foil",
    "folic",
    "folk",
    "follicle",
    "follow",
    "fondling",
    "fondly",
    "fondness",
    "fondue",
    "font",
    "food",
    "fool",
    "footage",
    "football",
    "footbath",
    "footboard",
    "footer",
    "footgear",
    "foothill",
    "foothold",
    "footing",
    "footless",
    "footman",
    "footnote",
    "footpad",
    "footpath",
    "footprint",
    "footrest",
    "footsie",
    "footsore",
    "footwear",
    "footwork",
    "fossil",
    "foster",
    "founder",
    "founding",
    "fountain",
    "fox",
    "foyer",
    "fraction",
    "fracture",
    "fragile",
    "fragility",
    "fragment",
    "fragrance",
    "fragrant",
    "frail",
    "frame",
    "framing",
    "frantic",
    "fraternal",
    "frayed",
    "fraying",
    "frays",
    "freckled",
    "freckles",
    "freebase",
    "freebee",
    "freebie",
    "freedom",
    "freefall",
    "freehand",
    "freeing",
    "freeload",
    "freely",
    "freemason",
    "freeness",
    "freestyle",
    "freeware",
    "freeway",
    "freewill",
    "freezable",
    "freezing",
    "freight",
    "french",
    "frenzied",
    "frenzy",
    "frequency",
    "frequent",
    "fresh",
    "fretful",
    "fretted",
    "friction",
    "friday",
    "fridge",
    "fried",
    "friend",
    "frighten",
    "frightful",
    "frigidity",
    "frigidly",
    "frill",
    "fringe",
    "frisbee",
    "frisk",
    "fritter",
    "frivolous",
    "frolic",
    "from",
    "front",
    "frostbite",
    "frosted",
    "frostily",
    "frosting",
    "frostlike",
    "frosty",
    "froth",
    "frown",
    "frozen",
    "fructose",
    "frugality",
    "frugally",
    "fruit",
    "frustrate",
    "frying",
    "gab",
    "gaffe",
    "gag",
    "gainfully",
    "gaining",
    "gains",
    "gala",
    "gallantly",
    "galleria",
    "gallery",
    "galley",
    "gallon",
    "gallows",
    "gallstone",
    "galore",
    "galvanize",
    "gambling",
    "game",
    "gaming",
    "gamma",
    "gander",
    "gangly",
    "gangrene",
    "gangway",
    "gap",
    "garage",
    "garbage",
    "garden",
    "gargle",
    "garland",
    "garlic",
    "garment",
    "garnet",
    "garnish",
    "garter",
    "gas",
    "gatherer",
    "gathering",
    "gating",
    "gauging",
    "gauntlet",
    "gauze",
    "gave",
    "gawk",
    "gazing",
    "gear",
    "gecko",
    "geek",
    "geiger",
    "gem",
    "gender",
    "generic",
    "generous",
    "genetics",
    "genre",
    "gentile",
    "gentleman",
    "gently",
    "gents",
    "geography",
    "geologic",
    "geologist",
    "geology",
    "geometric",
    "geometry",
    "geranium",
    "gerbil",
    "geriatric",
    "germicide",
    "germinate",
    "germless",
    "germproof",
    "gestate",
    "gestation",
    "gesture",
    "getaway",
    "getting",
    "getup",
    "giant",
    "gibberish",
    "giblet",
    "giddily",
    "giddiness",
    "giddy",
    "gift",
    "gigabyte",
    "gigahertz",
    "gigantic",
    "giggle",
    "giggling",
    "giggly",
    "gigolo",
    "gilled",
    "gills",
    "gimmick",
    "girdle",
    "giveaway",
    "given",
    "giver",
    "giving",
    "gizmo",
    "gizzard",
    "glacial",
    "glacier",
    "glade",
    "gladiator",
    "gladly",
    "glamorous",
    "glamour",
    "glance",
    "glancing",
    "glandular",
    "glare",
    "glaring",
    "glass",
    "glaucoma",
    "glazing",
    "gleaming",
    "gleeful",
    "glider",
    "gliding",
    "glimmer",
    "glimpse",
    "glisten",
    "glitch",
    "glitter",
    "glitzy",
    "gloater",
    "gloating",
    "gloomily",
    "gloomy",
    "glorified",
    "glorifier",
    "glorify",
    "glorious",
    "glory",
    "gloss",
    "glove",
    "glowing",
    "glowworm",
    "glucose",
    "glue",
    "gluten",
    "glutinous",
    "glutton",
    "gnarly",
    "gnat",
    "goal",
    "goatskin",
    "goes",
    "goggles",
    "going",
    "goldfish",
    "goldmine",
    "goldsmith",
    "golf",
    "goliath",
    "gonad",
    "gondola",
    "gone",
    "gong",
    "good",
    "gooey",
    "goofball",
    "goofiness",
    "goofy",
    "google",
    "goon",
    "gopher",
    "gore",
    "gorged",
    "gorgeous",
    "gory",
    "gosling",
    "gossip",
    "gothic",
    "gotten",
    "gout",
    "gown",
    "grab",
    "graceful",
    "graceless",
    "gracious",
    "gradation",
    "graded",
    "grader",
    "gradient",
    "grading",
    "gradually",
    "graduate",
    "graffiti",
    "grafted",
    "grafting",
    "grain",
    "granddad",
    "grandkid",
    "grandly",
    "grandma",
    "grandpa",
    "grandson",
    "granite",
    "granny",
    "granola",
    "grant",
    "granular",
    "grape",
    "graph",
    "grapple",
    "grappling",
    "grasp",
    "grass",
    "gratified",
    "gratify",
    "grating",
    "gratitude",
    "gratuity",
    "gravel",
    "graveness",
    "graves",
    "graveyard",
    "gravitate",
    "gravity",
    "gravy",
    "gray",
    "grazing",
    "greasily",
    "greedily",
    "greedless",
    "greedy",
    "green",
    "greeter",
    "greeting",
    "grew",
    "greyhound",
    "grid",
    "grief",
    "grievance",
    "grieving",
    "grievous",
    "grill",
    "grimace",
    "grimacing",
    "grime",
    "griminess",
    "grimy",
    "grinch",
    "grinning",
    "grip",
    "gristle",
    "grit",
    "groggily",
    "groggy",
    "groin",
    "groom",
    "groove",
    "grooving",
    "groovy",
    "grope",
    "ground",
    "grouped",
    "grout",
    "grove",
    "grower",
    "growing",
    "growl",
    "grub",
    "grudge",
    "grudging",
    "grueling",
    "gruffly",
    "grumble",
    "grumbling",
    "grumbly",
    "grumpily",
    "grunge",
    "grunt",
    "guacamole",
    "guidable",
    "guidance",
    "guide",
    "guiding",
    "guileless",
    "guise",
    "gulf",
    "gullible",
    "gully",
    "gulp",
    "gumball",
    "gumdrop",
    "gumminess",
    "gumming",
    "gummy",
    "gurgle",
    "gurgling",
    "guru",
    "gush",
    "gusto",
    "gusty",
    "gutless",
    "guts",
    "gutter",
    "guy",
    "guzzler",
    "gyration",
    "habitable",
    "habitant",
    "habitat",
    "habitual",
    "hacked",
    "hacker",
    "hacking",
    "hacksaw",
    "had",
    "haggler",
    "haiku",
    "half",
    "halogen",
    "halt",
    "halved",
    "halves",
    "hamburger",
    "hamlet",
    "hammock",
    "hamper",
    "hamster",
    "hamstring",
    "handbag",
    "handball",
    "handbook",
    "handbrake",
    "handcart",
    "handclap",
    "handclasp",
    "handcraft",
    "handcuff",
    "handed",
    "handful",
    "handgrip",
    "handgun",
    "handheld",
    "handiness",
    "handiwork",
    "handlebar",
    "handled",
    "handler",
    "handling",
    "handmade",
    "handoff",
    "handpick",
    "handprint",
    "handrail",
    "handsaw",
    "handset",
    "handsfree",
    "handshake",
    "handstand",
    "handwash",
    "handwork",
    "handwoven",
    "handwrite",
    "handyman",
    "hangnail",
    "hangout",
    "hangover",
    "hangup",
    "hankering",
    "hankie",
    "hanky",
    "haphazard",
    "happening",
    "happier",
    "happiest",
    "happily",
    "happiness",
    "happy",
    "harbor",
    "hardcopy",
    "hardcore",
    "hardcover",
    "harddisk",
    "hardened",
    "hardener",
    "hardening",
    "hardhat",
    "hardhead",
    "hardiness",
    "hardly",
    "hardness",
    "hardship",
    "hardware",
    "hardwired",
    "hardwood",
    "hardy",
    "harmful",
    "harmless",
    "harmonica",
    "harmonics",
    "harmonize",
    "harmony",
    "harness",
    "harpist",
    "harsh",
    "harvest",
    "hash",
    "hassle",
    "haste",
    "hastily",
    "hastiness",
    "hasty",
    "hatbox",
    "hatchback",
    "hatchery",
    "hatchet",
    "hatching",
    "hatchling",
    "hate",
    "hatless",
    "hatred",
    "haunt",
    "haven",
    "hazard",
    "hazelnut",
    "hazily",
    "haziness",
    "hazing",
    "hazy",
    "headache",
    "headband",
    "headboard",
    "headcount",
    "headdress",
    "headed",
    "header",
    "headfirst",
    "headgear",
    "heading",
    "headlamp",
    "headless",
    "headlock",
    "headphone",
    "headpiece",
    "headrest",
    "headroom",
    "headscarf",
    "headset",
    "headsman",
    "headstand",
    "headstone",
    "headway",
    "headwear",
    "heap",
    "heat",
    "heave",
    "heavily",
    "heaviness",
    "heaving",
    "hedge",
    "hedging",
    "heftiness",
    "hefty",
    "helium",
    "helmet",
    "helper",
    "helpful",
    "helping",
    "helpless",
    "helpline",
    "hemlock",
    "hemstitch",
    "hence",
    "henchman",
    "henna",
    "herald",
    "herbal",
    "herbicide",
    "herbs",
    "heritage",
    "hermit",
    "heroics",
    "heroism",
    "herring",
    "herself",
    "hertz",
    "hesitancy",
    "hesitant",
    "hesitate",
    "hexagon",
    "hexagram",
    "hubcap",
    "huddle",
    "huddling",
    "huff",
    "hug",
    "hula",
    "hulk",
    "hull",
    "human",
    "humble",
    "humbling",
    "humbly",
    "humid",
    "humiliate",
    "humility",
    "humming",
    "hummus",
    "humongous",
    "humorist",
    "humorless",
    "humorous",
    "humpback",
    "humped",
    "humvee",
    "hunchback",
    "hundredth",
    "hunger",
    "hungrily",
    "hungry",
    "hunk",
    "hunter",
    "hunting",
    "huntress",
    "huntsman",
    "hurdle",
    "hurled",
    "hurler",
    "hurling",
    "hurray",
    "hurricane",
    "hurried",
    "hurry",
    "hurt",
    "husband",
    "hush",
    "husked",
    "huskiness",
    "hut",
    "hybrid",
    "hydrant",
    "hydrated",
    "hydration",
    "hydrogen",
    "hydroxide",
    "hyperlink",
    "hypertext",
    "hyphen",
    "hypnoses",
    "hypnosis",
    "hypnotic",
    "hypnotism",
    "hypnotist",
    "hypnotize",
    "hypocrisy",
    "hypocrite",
    "ibuprofen",
    "ice",
    "iciness",
    "icing",
    "icky",
    "icon",
    "icy",
    "idealism",
    "idealist",
    "idealize",
    "ideally",
    "idealness",
    "identical",
    "identify",
    "identity",
    "ideology",
    "idiocy",
    "idiom",
    "idly",
    "igloo",
    "ignition",
    "ignore",
    "iguana",
    "illicitly",
    "illusion",
    "illusive",
    "image",
    "imaginary",
    "imagines",
    "imaging",
    "imbecile",
    "imitate",
    "imitation",
    "immature",
    "immerse",
    "immersion",
    "imminent",
    "immobile",
    "immodest",
    "immorally",
    "immortal",
    "immovable",
    "immovably",
    "immunity",
    "immunize",
    "impaired",
    "impale",
    "impart",
    "impatient",
    "impeach",
    "impeding",
    "impending",
    "imperfect",
    "imperial",
    "impish",
    "implant",
    "implement",
    "implicate",
    "implicit",
    "implode",
    "implosion",
    "implosive",
    "imply",
    "impolite",
    "important",
    "importer",
    "impose",
    "imposing",
    "impotence",
    "impotency",
    "impotent",
    "impound",
    "imprecise",
    "imprint",
    "imprison",
    "impromptu",
    "improper",
    "improve",
    "improving",
    "improvise",
    "imprudent",
    "impulse",
    "impulsive",
    "impure",
    "impurity",
    "iodine",
    "iodize",
    "ion",
    "ipad",
    "iphone",
    "ipod",
    "irate",
    "irk",
    "iron",
    "irregular",
    "irrigate",
    "irritable",
    "irritably",
    "irritant",
    "irritate",
    "islamic",
    "islamist",
    "isolated",
    "isolating",
    "isolation",
    "isotope",
    "issue",
    "issuing",
    "italicize",
    "italics",
    "item",
    "itinerary",
    "itunes",
    "ivory",
    "ivy",
    "jab",
    "jackal",
    "jacket",
    "jackknife",
    "jackpot",
    "jailbird",
    "jailbreak",
    "jailer",
    "jailhouse",
    "jalapeno",
    "jam",
    "janitor",
    "january",
    "jargon",
    "jarring",
    "jasmine",
    "jaundice",
    "jaunt",
    "java",
    "jawed",
    "jawless",
    "jawline",
    "jaws",
    "jaybird",
    "jaywalker",
    "jazz",
    "jeep",
    "jeeringly",
    "jellied",
    "jelly",
    "jersey",
    "jester",
    "jet",
    "jiffy",
    "jigsaw",
    "jimmy",
    "jingle",
    "jingling",
    "jinx",
    "jitters",
    "jittery",
    "job",
    "jockey",
    "jockstrap",
    "jogger",
    "jogging",
    "john",
    "joining",
    "jokester",
    "jokingly",
    "jolliness",
    "jolly",
    "jolt",
    "jot",
    "jovial",
    "joyfully",
    "joylessly",
    "joyous",
    "joyride",
    "joystick",
    "jubilance",
    "jubilant",
    "judge",
    "judgingly",
    "judicial",
    "judiciary",
    "judo",
    "juggle",
    "juggling",
    "jugular",
    "juice",
    "juiciness",
    "juicy",
    "jujitsu",
    "jukebox",
    "july",
    "jumble",
    "jumbo",
    "jump",
    "junction",
    "juncture",
    "june",
    "junior",
    "juniper",
    "junkie",
    "junkman",
    "junkyard",
    "jurist",
    "juror",
    "jury",
    "justice",
    "justifier",
    "justify",
    "justly",
    "justness",
    "juvenile",
    "kabob",
    "kangaroo",
    "karaoke",
    "karate",
    "karma",
    "kebab",
    "keenly",
    "keenness",
    "keep",
    "keg",
    "kelp",
    "kennel",
    "kept",
    "kerchief",
    "kerosene",
    "kettle",
    "kick",
    "kiln",
    "kilobyte",
    "kilogram",
    "kilometer",
    "kilowatt",
    "kilt",
    "kimono",
    "kindle",
    "kindling",
    "kindly",
    "kindness",
    "kindred",
    "kinetic",
    "kinfolk",
    "king",
    "kinship",
    "kinsman",
    "kinswoman",
    "kissable",
    "kisser",
    "kissing",
    "kitchen",
    "kite",
    "kitten",
    "kitty",
    "kiwi",
    "kleenex",
    "knapsack",
    "knee",
    "knelt",
    "knickers",
    "knoll",
    "koala",
    "kooky",
    "kosher",
    "krypton",
    "kudos",
    "kung",
    "labored",
    "laborer",
    "laboring",
    "laborious",
    "labrador",
    "ladder",
    "ladies",
    "ladle",
    "ladybug",
    "ladylike",
    "lagged",
    "lagging",
    "lagoon",
    "lair",
    "lake",
    "lance",
    "landed",
    "landfall",
    "landfill",
    "landing",
    "landlady",
    "landless",
    "landline",
    "landlord",
    "landmark",
    "landmass",
    "landmine",
    "landowner",
    "landscape",
    "landside",
    "landslide",
    "language",
    "lankiness",
    "lanky",
    "lantern",
    "lapdog",
    "lapel",
    "lapped",
    "lapping",
    "laptop",
    "lard",
    "large",
    "lark",
    "lash",
    "lasso",
    "last",
    "latch",
    "late",
    "lather",
    "latitude",
    "latrine",
    "latter",
    "latticed",
    "launch",
    "launder",
    "laundry",
    "laurel",
    "lavender",
    "lavish",
    "laxative",
    "lazily",
    "laziness",
    "lazy",
    "lecturer",
    "left",
    "legacy",
    "legal",
    "legend",
    "legged",
    "leggings",
    "legible",
    "legibly",
    "legislate",
    "lego",
    "legroom",
    "legume",
    "legwarmer",
    "legwork",
    "lemon",
    "lend",
    "length",
    "lens",
    "lent",
    "leotard",
    "lesser",
    "letdown",
    "lethargic",
    "lethargy",
    "letter",
    "lettuce",
    "level",
    "leverage",
    "levers",
    "levitate",
    "levitator",
    "liability",
    "liable",
    "liberty",
    "librarian",
    "library",
    "licking",
    "licorice",
    "lid",
    "life",
    "lifter",
    "lifting",
    "liftoff",
    "ligament",
    "likely",
    "likeness",
    "likewise",
    "liking",
    "lilac",
    "lilly",
    "lily",
    "limb",
    "limeade",
    "limelight",
    "limes",
    "limit",
    "limping",
    "limpness",
    "line",
    "lingo",
    "linguini",
    "linguist",
    "lining",
    "linked",
    "linoleum",
    "linseed",
    "lint",
    "lion",
    "lip",
    "liquefy",
    "liqueur",
    "liquid",
    "lisp",
    "list",
    "litigate",
    "litigator",
    "litmus",
    "litter",
    "little",
    "livable",
    "lived",
    "lively",
    "liver",
    "livestock",
    "lividly",
    "living",
    "lizard",
    "lubricant",
    "lubricate",
    "lucid",
    "luckily",
    "luckiness",
    "luckless",
    "lucrative",
    "ludicrous",
    "lugged",
    "lukewarm",
    "lullaby",
    "lumber",
    "luminance",
    "luminous",
    "lumpiness",
    "lumping",
    "lumpish",
    "lunacy",
    "lunar",
    "lunchbox",
    "luncheon",
    "lunchroom",
    "lunchtime",
    "lung",
    "lurch",
    "lure",
    "luridness",
    "lurk",
    "lushly",
    "lushness",
    "luster",
    "lustfully",
    "lustily",
    "lustiness",
    "lustrous",
    "lusty",
    "luxurious",
    "luxury",
    "lying",
    "lyrically",
    "lyricism",
    "lyricist",
    "lyrics",
    "macarena",
    "macaroni",
    "macaw",
    "mace",
    "machine",
    "machinist",
    "magazine",
    "magenta",
    "maggot",
    "magical",
    "magician",
    "magma",
    "magnesium",
    "magnetic",
    "magnetism",
    "magnetize",
    "magnifier",
    "magnify",
    "magnitude",
    "magnolia",
    "mahogany",
    "maimed",
    "majestic",
    "majesty",
    "majorette",
    "majority",
    "makeover",
    "maker",
    "makeshift",
    "making",
    "malformed",
    "malt",
    "mama",
    "mammal",
    "mammary",
    "mammogram",
    "manager",
    "managing",
    "manatee",
    "mandarin",
    "mandate",
    "mandatory",
    "mandolin",
    "manger",
    "mangle",
    "mango",
    "mangy",
    "manhandle",
    "manhole",
    "manhood",
    "manhunt",
    "manicotti",
    "manicure",
    "manifesto",
    "manila",
    "mankind",
    "manlike",
    "manliness",
    "manly",
    "manmade",
    "manned",
    "mannish",
    "manor",
    "manpower",
    "mantis",
    "mantra",
    "manual",
    "many",
    "map",
    "marathon",
    "marauding",
    "marbled",
    "marbles",
    "marbling",
    "march",
    "mardi",
    "margarine",
    "margarita",
    "margin",
    "marigold",
    "marina",
    "marine",
    "marital",
    "maritime",
    "marlin",
    "marmalade",
    "maroon",
    "married",
    "marrow",
    "marry",
    "marshland",
    "marshy",
    "marsupial",
    "marvelous",
    "marxism",
    "mascot",
    "masculine",
    "mashed",
    "mashing",
    "massager",
    "masses",
    "massive",
    "mastiff",
    "matador",
    "matchbook",
    "matchbox",
    "matcher",
    "matching",
    "matchless",
    "material",
    "maternal",
    "maternity",
    "math",
    "mating",
    "matriarch",
    "matrimony",
    "matrix",
    "matron",
    "matted",
    "matter",
    "maturely",
    "maturing",
    "maturity",
    "mauve",
    "maverick",
    "maximize",
    "maximum",
    "maybe",
    "mayday",
    "mayflower",
    "moaner",
    "moaning",
    "mobile",
    "mobility",
    "mobilize",
    "mobster",
    "mocha",
    "mocker",
    "mockup",
    "modified",
    "modify",
    "modular",
    "modulator",
    "module",
    "moisten",
    "moistness",
    "moisture",
    "molar",
    "molasses",
    "mold",
    "molecular",
    "molecule",
    "molehill",
    "mollusk",
    "mom",
    "monastery",
    "monday",
    "monetary",
    "monetize",
    "moneybags",
    "moneyless",
    "moneywise",
    "mongoose",
    "mongrel",
    "monitor",
    "monkhood",
    "monogamy",
    "monogram",
    "monologue",
    "monopoly",
    "monorail",
    "monotone",
    "monotype",
    "monoxide",
    "monsieur",
    "monsoon",
    "monstrous",
    "monthly",
    "monument",
    "moocher",
    "moodiness",
    "moody",
    "mooing",
    "moonbeam",
    "mooned",
    "moonlight",
    "moonlike",
    "moonlit",
    "moonrise",
    "moonscape",
    "moonshine",
    "moonstone",
    "moonwalk",
    "mop",
    "morale",
    "morality",
    "morally",
    "morbidity",
    "morbidly",
    "morphine",
    "morphing",
    "morse",
    "mortality",
    "mortally",
    "mortician",
    "mortified",
    "mortify",
    "mortuary",
    "mosaic",
    "mossy",
    "most",
    "mothball",
    "mothproof",
    "motion",
    "motivate",
    "motivator",
    "motive",
    "motocross",
    "motor",
    "motto",
    "mountable",
    "mountain",
    "mounted",
    "mounting",
    "mourner",
    "mournful",
    "mouse",
    "mousiness",
    "moustache",
    "mousy",
    "mouth",
    "movable",
    "move",
    "movie",
    "moving",
    "mower",
    "mowing",
    "much",
    "muck",
    "mud",
    "mug",
    "mulberry",
    "mulch",
    "mule",
    "mulled",
    "mullets",
    "multiple",
    "multiply",
    "multitask",
    "multitude",
    "mumble",
    "mumbling",
    "mumbo",
    "mummified",
    "mummify",
    "mummy",
    "mumps",
    "munchkin",
    "mundane",
    "municipal",
    "muppet",
    "mural",
    "murkiness",
    "murky",
    "murmuring",
    "muscular",
    "museum",
    "mushily",
    "mushiness",
    "mushroom",
    "mushy",
    "music",
    "musket",
    "muskiness",
    "musky",
    "mustang",
    "mustard",
    "muster",
    "mustiness",
    "musty",
    "mutable",
    "mutate",
    "mutation",
    "mute",
    "mutilated",
    "mutilator",
    "mutiny",
    "mutt",
    "mutual",
    "muzzle",
    "myself",
    "myspace",
    "mystified",
    "mystify",
    "myth",
    "nacho",
    "nag",
    "nail",
    "name",
    "naming",
    "nanny",
    "nanometer",
    "nape",
    "napkin",
    "napped",
    "napping",
    "nappy",
    "narrow",
    "nastily",
    "nastiness",
    "national",
    "native",
    "nativity",
    "natural",
    "nature",
    "naturist",
    "nautical",
    "navigate",
    "navigator",
    "navy",
    "nearby",
    "nearest",
    "nearly",
    "nearness",
    "neatly",
    "neatness",
    "nebula",
    "nebulizer",
    "nectar",
    "negate",
    "negation",
    "negative",
    "neglector",
    "negligee",
    "negligent",
    "negotiate",
    "nemeses",
    "nemesis",
    "neon",
    "nephew",
    "nerd",
    "nervous",
    "nervy",
    "nest",
    "net",
    "neurology",
    "neuron",
    "neurosis",
    "neurotic",
    "neuter",
    "neutron",
    "never",
    "next",
    "nibble",
    "nickname",
    "nicotine",
    "niece",
    "nifty",
    "nimble",
    "nimbly",
    "nineteen",
    "ninetieth",
    "ninja",
    "nintendo",
    "ninth",
    "nuclear",
    "nuclei",
    "nucleus",
    "nugget",
    "nullify",
    "number",
    "numbing",
    "numbly",
    "numbness",
    "numeral",
    "numerate",
    "numerator",
    "numeric",
    "numerous",
    "nuptials",
    "nursery",
    "nursing",
    "nurture",
    "nutcase",
    "nutlike",
    "nutmeg",
    "nutrient",
    "nutshell",
    "nuttiness",
    "nutty",
    "nuzzle",
    "nylon",
    "oaf",
    "oak",
    "oasis",
    "oat",
    "obedience",
    "obedient",
    "obituary",
    "object",
    "obligate",
    "obliged",
    "oblivion",
    "oblivious",
    "oblong",
    "obnoxious",
    "oboe",
    "obscure",
    "obscurity",
    "observant",
    "observer",
    "observing",
    "obsessed",
    "obsession",
    "obsessive",
    "obsolete",
    "obstacle",
    "obstinate",
    "obstruct",
    "obtain",
    "obtrusive",
    "obtuse",
    "obvious",
    "occultist",
    "occupancy",
    "occupant",
    "occupier",
    "occupy",
    "ocean",
    "ocelot",
    "octagon",
    "octane",
    "october",
    "octopus",
    "ogle",
    "oil",
    "oink",
    "ointment",
    "okay",
    "old",
    "olive",
    "olympics",
    "omega",
    "omen",
    "ominous",
    "omission",
    "omit",
    "omnivore",
    "onboard",
    "oncoming",
    "ongoing",
    "onion",
    "online",
    "onlooker",
    "only",
    "onscreen",
    "onset",
    "onshore",
    "onslaught",
    "onstage",
    "onto",
    "onward",
    "onyx",
    "oops",
    "ooze",
    "oozy",
    "opacity",
    "opal",
    "open",
    "operable",
    "operate",
    "operating",
    "operation",
    "operative",
    "operator",
    "opium",
    "opossum",
    "opponent",
    "oppose",
    "opposing",
    "opposite",
    "oppressed",
    "oppressor",
    "opt",
    "opulently",
    "osmosis",
    "other",
    "otter",
    "ouch",
    "ought",
    "ounce",
    "outage",
    "outback",
    "outbid",
    "outboard",
    "outbound",
    "outbreak",
    "outburst",
    "outcast",
    "outclass",
    "outcome",
    "outdated",
    "outdoors",
    "outer",
    "outfield",
    "outfit",
    "outflank",
    "outgoing",
    "outgrow",
    "outhouse",
    "outing",
    "outlast",
    "outlet",
    "outline",
    "outlook",
    "outlying",
    "outmatch",
    "outmost",
    "outnumber",
    "outplayed",
    "outpost",
    "outpour",
    "output",
    "outrage",
    "outrank",
    "outreach",
    "outright",
    "outscore",
    "outsell",
    "outshine",
    "outshoot",
    "outsider",
    "outskirts",
    "outsmart",
    "outsource",
    "outspoken",
    "outtakes",
    "outthink",
    "outward",
    "outweigh",
    "outwit",
    "oval",
    "ovary",
    "oven",
    "overact",
    "overall",
    "overarch",
    "overbid",
    "overbill",
    "overbite",
    "overblown",
    "overboard",
    "overbook",
    "overbuilt",
    "overcast",
    "overcoat",
    "overcome",
    "overcook",
    "overcrowd",
    "overdraft",
    "overdrawn",
    "overdress",
    "overdrive",
    "overdue",
    "overeager",
    "overeater",
    "overexert",
    "overfed",
    "overfeed",
    "overfill",
    "overflow",
    "overfull",
    "overgrown",
    "overhand",
    "overhang",
    "overhaul",
    "overhead",
    "overhear",
    "overheat",
    "overhung",
    "overjoyed",
    "overkill",
    "overlabor",
    "overlaid",
    "overlap",
    "overlay",
    "overload",
    "overlook",
    "overlord",
    "overlying",
    "overnight",
    "overpass",
    "overpay",
    "overplant",
    "overplay",
    "overpower",
    "overprice",
    "overrate",
    "overreach",
    "overreact",
    "override",
    "overripe",
    "overrule",
    "overrun",
    "overshoot",
    "overshot",
    "oversight",
    "oversized",
    "oversleep",
    "oversold",
    "overspend",
    "overstate",
    "overstay",
    "overstep",
    "overstock",
    "overstuff",
    "oversweet",
    "overtake",
    "overthrow",
    "overtime",
    "overtly",
    "overtone",
    "overture",
    "overturn",
    "overuse",
    "overvalue",
    "overview",
    "overwrite",
    "owl",
    "oxford",
    "oxidant",
    "oxidation",
    "oxidize",
    "oxidizing",
    "oxygen",
    "oxymoron",
    "oyster",
    "ozone",
    "paced",
    "pacemaker",
    "pacific",
    "pacifier",
    "pacifism",
    "pacifist",
    "pacify",
    "padded",
    "padding",
    "paddle",
    "paddling",
    "padlock",
    "pagan",
    "pager",
    "paging",
    "pajamas",
    "palace",
    "palatable",
    "palm",
    "palpable",
    "palpitate",
    "paltry",
    "pampered",
    "pamperer",
    "pampers",
    "pamphlet",
    "panama",
    "pancake",
    "pancreas",
    "panda",
    "pandemic",
    "pang",
    "panhandle",
    "panic",
    "panning",
    "panorama",
    "panoramic",
    "panther",
    "pantomime",
    "pantry",
    "pants",
    "pantyhose",
    "paparazzi",
    "papaya",
    "paper",
    "paprika",
    "papyrus",
    "parabola",
    "parachute",
    "parade",
    "paradox",
    "paragraph",
    "parakeet",
    "paralegal",
    "paralyses",
    "paralysis",
    "paralyze",
    "paramedic",
    "parameter",
    "paramount",
    "parasail",
    "parasite",
    "parasitic",
    "parcel",
    "parched",
    "parchment",
    "pardon",
    "parish",
    "parka",
    "parking",
    "parkway",
    "parlor",
    "parmesan",
    "parole",
    "parrot",
    "parsley",
    "parsnip",
    "partake",
    "parted",
    "parting",
    "partition",
    "partly",
    "partner",
    "partridge",
    "party",
    "passable",
    "passably",
    "passage",
    "passcode",
    "passenger",
    "passerby",
    "passing",
    "passion",
    "passive",
    "passivism",
    "passover",
    "passport",
    "password",
    "pasta",
    "pasted",
    "pastel",
    "pastime",
    "pastor",
    "pastrami",
    "pasture",
    "pasty",
    "patchwork",
    "patchy",
    "paternal",
    "paternity",
    "path",
    "patience",
    "patient",
    "patio",
    "patriarch",
    "patriot",
    "patrol",
    "patronage",
    "patronize",
    "pauper",
    "pavement",
    "paver",
    "pavestone",
    "pavilion",
    "paving",
    "pawing",
    "payable",
    "payback",
    "paycheck",
    "payday",
    "payee",
    "payer",
    "paying",
    "payment",
    "payphone",
    "payroll",
    "pebble",
    "pebbly",
    "pecan",
    "pectin",
    "peculiar",
    "peddling",
    "pediatric",
    "pedicure",
    "pedigree",
    "pedometer",
    "pegboard",
    "pelican",
    "pellet",
    "pelt",
    "pelvis",
    "penalize",
    "penalty",
    "pencil",
    "pendant",
    "pending",
    "penholder",
    "penknife",
    "pennant",
    "penniless",
    "penny",
    "penpal",
    "pension",
    "pentagon",
    "pentagram",
    "pep",
    "perceive",
    "percent",
    "perch",
    "percolate",
    "perennial",
    "perfected",
    "perfectly",
    "perfume",
    "periscope",
    "perish",
    "perjurer",
    "perjury",
    "perkiness",
    "perky",
    "perm",
    "peroxide",
    "perpetual",
    "perplexed",
    "persecute",
    "persevere",
    "persuaded",
    "persuader",
    "pesky",
    "peso",
    "pessimism",
    "pessimist",
    "pester",
    "pesticide",
    "petal",
    "petite",
    "petition",
    "petri",
    "petroleum",
    "petted",
    "petticoat",
    "pettiness",
    "petty",
    "petunia",
    "phantom",
    "phobia",
    "phoenix",
    "phonebook",
    "phoney",
    "phonics",
    "phoniness",
    "phony",
    "phosphate",
    "photo",
    "phrase",
    "phrasing",
    "placard",
    "placate",
    "placidly",
    "plank",
    "planner",
    "plant",
    "plasma",
    "plaster",
    "plastic",
    "plated",
    "platform",
    "plating",
    "platinum",
    "platonic",
    "platter",
    "platypus",
    "plausible",
    "plausibly",
    "playable",
    "playback",
    "player",
    "playful",
    "playgroup",
    "playhouse",
    "playing",
    "playlist",
    "playmaker",
    "playmate",
    "playoff",
    "playpen",
    "playroom",
    "playset",
    "plaything",
    "playtime",
    "plaza",
    "pleading",
    "pleat",
    "pledge",
    "plentiful",
    "plenty",
    "plethora",
    "plexiglas",
    "pliable",
    "plod",
    "plop",
    "plot",
    "plow",
    "ploy",
    "pluck",
    "plug",
    "plunder",
    "plunging",
    "plural",
    "plus",
    "plutonium",
    "plywood",
    "poach",
    "pod",
    "poem",
    "poet",
    "pogo",
    "pointed",
    "pointer",
    "pointing",
    "pointless",
    "pointy",
    "poise",
    "poison",
    "poker",
    "poking",
    "polar",
    "police",
    "policy",
    "polio",
    "polish",
    "politely",
    "polka",
    "polo",
    "polyester",
    "polygon",
    "polygraph",
    "polymer",
    "poncho",
    "pond",
    "pony",
    "popcorn",
    "pope",
    "poplar",
    "popper",
    "poppy",
    "popsicle",
    "populace",
    "popular",
    "populate",
    "porcupine",
    "pork",
    "porous",
    "porridge",
    "portable",
    "portal",
    "portfolio",
    "porthole",
    "portion",
    "portly",
    "portside",
    "poser",
    "posh",
    "posing",
    "possible",
    "possibly",
    "possum",
    "postage",
    "postal",
    "postbox",
    "postcard",
    "posted",
    "poster",
    "posting",
    "postnasal",
    "posture",
    "postwar",
    "pouch",
    "pounce",
    "pouncing",
    "pound",
    "pouring",
    "pout",
    "powdered",
    "powdering",
    "powdery",
    "power",
    "powwow",
    "pox",
    "praising",
    "prance",
    "prancing",
    "pranker",
    "prankish",
    "prankster",
    "prayer",
    "praying",
    "preacher",
    "preaching",
    "preachy",
    "preamble",
    "precinct",
    "precise",
    "precision",
    "precook",
    "precut",
    "predator",
    "predefine",
    "predict",
    "preface",
    "prefix",
    "preflight",
    "preformed",
    "pregame",
    "pregnancy",
    "pregnant",
    "preheated",
    "prelaunch",
    "prelaw",
    "prelude",
    "premiere",
    "premises",
    "premium",
    "prenatal",
    "preoccupy",
    "preorder",
    "prepaid",
    "prepay",
    "preplan",
    "preppy",
    "preschool",
    "prescribe",
    "preseason",
    "preset",
    "preshow",
    "president",
    "presoak",
    "press",
    "presume",
    "presuming",
    "preteen",
    "pretended",
    "pretender",
    "pretense",
    "pretext",
    "pretty",
    "pretzel",
    "prevail",
    "prevalent",
    "prevent",
    "preview",
    "previous",
    "prewar",
    "prewashed",
    "prideful",
    "pried",
    "primal",
    "primarily",
    "primary",
    "primate",
    "primer",
    "primp",
    "princess",
    "print",
    "prior",
    "prism",
    "prison",
    "prissy",
    "pristine",
    "privacy",
    "private",
    "privatize",
    "prize",
    "proactive",
    "probable",
    "probably",
    "probation",
    "probe",
    "probing",
    "probiotic",
    "problem",
    "procedure",
    "process",
    "proclaim",
    "procreate",
    "procurer",
    "prodigal",
    "prodigy",
    "produce",
    "product",
    "profane",
    "profanity",
    "professed",
    "professor",
    "profile",
    "profound",
    "profusely",
    "progeny",
    "prognosis",
    "program",
    "progress",
    "projector",
    "prologue",
    "prolonged",
    "promenade",
    "prominent",
    "promoter",
    "promotion",
    "prompter",
    "promptly",
    "prone",
    "prong",
    "pronounce",
    "pronto",
    "proofing",
    "proofread",
    "proofs",
    "propeller",
    "properly",
    "property",
    "proponent",
    "proposal",
    "propose",
    "props",
    "prorate",
    "protector",
    "protegee",
    "proton",
    "prototype",
    "protozoan",
    "protract",
    "protrude",
    "proud",
    "provable",
    "proved",
    "proven",
    "provided",
    "provider",
    "providing",
    "province",
    "proving",
    "provoke",
    "provoking",
    "provolone",
    "prowess",
    "prowler",
    "prowling",
    "proximity",
    "proxy",
    "prozac",
    "prude",
    "prudishly",
    "prune",
    "pruning",
    "pry",
    "psychic",
    "public",
    "publisher",
    "pucker",
    "pueblo",
    "pug",
    "pull",
    "pulmonary",
    "pulp",
    "pulsate",
    "pulse",
    "pulverize",
    "puma",
    "pumice",
    "pummel",
    "punch",
    "punctual",
    "punctuate",
    "punctured",
    "pungent",
    "punisher",
    "punk",
    "pupil",
    "puppet",
    "puppy",
    "purchase",
    "pureblood",
    "purebred",
    "purely",
    "pureness",
    "purgatory",
    "purge",
    "purging",
    "purifier",
    "purify",
    "purist",
    "puritan",
    "purity",
    "purple",
    "purplish",
    "purposely",
    "purr",
    "purse",
    "pursuable",
    "pursuant",
    "pursuit",
    "purveyor",
    "pushcart",
    "pushchair",
    "pusher",
    "pushiness",
    "pushing",
    "pushover",
    "pushpin",
    "pushup",
    "pushy",
    "putdown",
    "putt",
    "puzzle",
    "puzzling",
    "pyramid",
    "pyromania",
    "python",
    "quack",
    "quadrant",
    "quail",
    "quaintly",
    "quake",
    "quaking",
    "qualified",
    "qualifier",
    "qualify",
    "quality",
    "qualm",
    "quantum",
    "quarrel",
    "quarry",
    "quartered",
    "quarterly",
    "quarters",
    "quartet",
    "quench",
    "query",
    "quicken",
    "quickly",
    "quickness",
    "quicksand",
    "quickstep",
    "quiet",
    "quill",
    "quilt",
    "quintet",
    "quintuple",
    "quirk",
    "quit",
    "quiver",
    "quizzical",
    "quotable",
    "quotation",
    "quote",
    "rabid",
    "race",
    "racing",
    "racism",
    "rack",
    "racoon",
    "radar",
    "radial",
    "radiance",
    "radiantly",
    "radiated",
    "radiation",
    "radiator",
    "radio",
    "radish",
    "raffle",
    "raft",
    "rage",
    "ragged",
    "raging",
    "ragweed",
    "raider",
    "railcar",
    "railing",
    "railroad",
    "railway",
    "raisin",
    "rake",
    "raking",
    "rally",
    "ramble",
    "rambling",
    "ramp",
    "ramrod",
    "ranch",
    "rancidity",
    "random",
    "ranged",
    "ranger",
    "ranging",
    "ranked",
    "ranking",
    "ransack",
    "ranting",
    "rants",
    "rare",
    "rarity",
    "rascal",
    "rash",
    "rasping",
    "ravage",
    "raven",
    "ravine",
    "raving",
    "ravioli",
    "ravishing",
    "reabsorb",
    "reach",
    "reacquire",
    "reaction",
    "reactive",
    "reactor",
    "reaffirm",
    "ream",
    "reanalyze",
    "reappear",
    "reapply",
    "reappoint",
    "reapprove",
    "rearrange",
    "rearview",
    "reason",
    "reassign",
    "reassure",
    "reattach",
    "reawake",
    "rebalance",
    "rebate",
    "rebel",
    "rebirth",
    "reboot",
    "reborn",
    "rebound",
    "rebuff",
    "rebuild",
    "rebuilt",
    "reburial",
    "rebuttal",
    "recall",
    "recant",
    "recapture",
    "recast",
    "recede",
    "recent",
    "recess",
    "recharger",
    "recipient",
    "recital",
    "recite",
    "reckless",
    "reclaim",
    "recliner",
    "reclining",
    "recluse",
    "reclusive",
    "recognize",
    "recoil",
    "recollect",
    "recolor",
    "reconcile",
    "reconfirm",
    "reconvene",
    "recopy",
    "record",
    "recount",
    "recoup",
    "recovery",
    "recreate",
    "rectal",
    "rectangle",
    "rectified",
    "rectify",
    "recycled",
    "recycler",
    "recycling",
    "reemerge",
    "reenact",
    "reenter",
    "reentry",
    "reexamine",
    "referable",
    "referee",
    "reference",
    "refill",
    "refinance",
    "refined",
    "refinery",
    "refining",
    "refinish",
    "reflected",
    "reflector",
    "reflex",
    "reflux",
    "refocus",
    "refold",
    "reforest",
    "reformat",
    "reformed",
    "reformer",
    "reformist",
    "refract",
    "refrain",
    "refreeze",
    "refresh",
    "refried",
    "refueling",
    "refund",
    "refurbish",
    "refurnish",
    "refusal",
    "refuse",
    "refusing",
    "refutable",
    "refute",
    "regain",
    "regalia",
    "regally",
    "reggae",
    "regime",
    "region",
    "register",
    "registrar",
    "registry",
    "regress",
    "regretful",
    "regroup",
    "regular",
    "regulate",
    "regulator",
    "rehab",
    "reheat",
    "rehire",
    "rehydrate",
    "reimburse",
    "reissue",
    "reiterate",
    "rejoice",
    "rejoicing",
    "rejoin",
    "rekindle",
    "relapse",
    "relapsing",
    "relatable",
    "related",
    "relation",
    "relative",
    "relax",
    "relay",
    "relearn",
    "release",
    "relenting",
    "reliable",
    "reliably",
    "reliance",
    "reliant",
    "relic",
    "relieve",
    "relieving",
    "relight",
    "relish",
    "relive",
    "reload",
    "relocate",
    "relock",
    "reluctant",
    "rely",
    "remake",
    "remark",
    "remarry",
    "rematch",
    "remedial",
    "remedy",
    "remember",
    "reminder",
    "remindful",
    "remission",
    "remix",
    "remnant",
    "remodeler",
    "remold",
    "remorse",
    "remote",
    "removable",
    "removal",
    "removed",
    "remover",
    "removing",
    "rename",
    "renderer",
    "rendering",
    "rendition",
    "renegade",
    "renewable",
    "renewably",
    "renewal",
    "renewed",
    "renounce",
    "renovate",
    "renovator",
    "rentable",
    "rental",
    "rented",
    "renter",
    "reoccupy",
    "reoccur",
    "reopen",
    "reorder",
    "repackage",
    "repacking",
    "repaint",
    "repair",
    "repave",
    "repaying",
    "repayment",
    "repeal",
    "repeated",
    "repeater",
    "repent",
    "rephrase",
    "replace",
    "replay",
    "replica",
    "reply",
    "reporter",
    "repose",
    "repossess",
    "repost",
    "repressed",
    "reprimand",
    "reprint",
    "reprise",
    "reproach",
    "reprocess",
    "reproduce",
    "reprogram",
    "reps",
    "reptile",
    "reptilian",
    "repugnant",
    "repulsion",
    "repulsive",
    "repurpose",
    "reputable",
    "reputably",
    "request",
    "require",
    "requisite",
    "reroute",
    "rerun",
    "resale",
    "resample",
    "rescuer",
    "reseal",
    "research",
    "reselect",
    "reseller",
    "resemble",
    "resend",
    "resent",
    "reset",
    "reshape",
    "reshoot",
    "reshuffle",
    "residence",
    "residency",
    "resident",
    "residual",
    "residue",
    "resigned",
    "resilient",
    "resistant",
    "resisting",
    "resize",
    "resolute",
    "resolved",
    "resonant",
    "resonate",
    "resort",
    "resource",
    "respect",
    "resubmit",
    "result",
    "resume",
    "resupply",
    "resurface",
    "resurrect",
    "retail",
    "retainer",
    "retaining",
    "retake",
    "retaliate",
    "retention",
    "rethink",
    "retinal",
    "retired",
    "retiree",
    "retiring",
    "retold",
    "retool",
    "retorted",
    "retouch",
    "retrace",
    "retract",
    "retrain",
    "retread",
    "retreat",
    "retrial",
    "retrieval",
    "retriever",
    "retry",
    "return",
    "retying",
    "retype",
    "reunion",
    "reunite",
    "reusable",
    "reuse",
    "reveal",
    "reveler",
    "revenge",
    "revenue",
    "reverb",
    "revered",
    "reverence",
    "reverend",
    "reversal",
    "reverse",
    "reversing",
    "reversion",
    "revert",
    "revisable",
    "revise",
    "revision",
    "revisit",
    "revivable",
    "revival",
    "reviver",
    "reviving",
    "revocable",
    "revoke",
    "revolt",
    "revolver",
    "revolving",
    "reward",
    "rewash",
    "rewind",
    "rewire",
    "reword",
    "rework",
    "rewrap",
    "rewrite",
    "rhyme",
    "ribbon",
    "ribcage",
    "rice",
    "riches",
    "richly",
    "richness",
    "rickety",
    "ricotta",
    "riddance",
    "ridden",
    "ride",
    "riding",
    "rifling",
    "rift",
    "rigging",
    "rigid",
    "rigor",
    "rimless",
    "rimmed",
    "rind",
    "rink",
    "rinse",
    "rinsing",
    "riot",
    "ripcord",
    "ripeness",
    "ripening",
    "ripping",
    "ripple",
    "rippling",
    "riptide",
    "rise",
    "rising",
    "risk",
    "risotto",
    "ritalin",
    "ritzy",
    "rival",
    "riverbank",
    "riverbed",
    "riverboat",
    "riverside",
    "riveter",
    "riveting",
    "roamer",
    "roaming",
    "roast",
    "robbing",
    "robe",
    "robin",
    "robotics",
    "robust",
    "rockband",
    "rocker",
    "rocket",
    "rockfish",
    "rockiness",
    "rocking",
    "rocklike",
    "rockslide",
    "rockstar",
    "rocky",
    "rogue",
    "roman",
    "romp",
    "rope",
    "roping",
    "roster",
    "rosy",
    "rotten",
    "rotting",
    "rotunda",
    "roulette",
    "rounding",
    "roundish",
    "roundness",
    "roundup",
    "roundworm",
    "routine",
    "routing",
    "rover",
    "roving",
    "royal",
    "rubbed",
    "rubber",
    "rubbing",
    "rubble",
    "rubdown",
    "ruby",
    "ruckus",
    "rudder",
    "rug",
    "ruined",
    "rule",
    "rumble",
    "rumbling",
    "rummage",
    "rumor",
    "runaround",
    "rundown",
    "runner",
    "running",
    "runny",
    "runt",
    "runway",
    "rupture",
    "rural",
    "ruse",
    "rush",
    "rust",
    "rut",
    "sabbath",
    "sabotage",
    "sacrament",
    "sacred",
    "sacrifice",
    "sadden",
    "saddlebag",
    "saddled",
    "saddling",
    "sadly",
    "sadness",
    "safari",
    "safeguard",
    "safehouse",
    "safely",
    "safeness",
    "saffron",
    "saga",
    "sage",
    "sagging",
    "saggy",
    "said",
    "saint",
    "sake",
    "salad",
    "salami",
    "salaried",
    "salary",
    "saline",
    "salon",
    "saloon",
    "salsa",
    "salt",
    "salutary",
    "salute",
    "salvage",
    "salvaging",
    "salvation",
    "same",
    "sample",
    "sampling",
    "sanction",
    "sanctity",
    "sanctuary",
    "sandal",
    "sandbag",
    "sandbank",
    "sandbar",
    "sandblast",
    "sandbox",
    "sanded",
    "sandfish",
    "sanding",
    "sandlot",
    "sandpaper",
    "sandpit",
    "sandstone",
    "sandstorm",
    "sandworm",
    "sandy",
    "sanitary",
    "sanitizer",
    "sank",
    "santa",
    "sapling",
    "sappiness",
    "sappy",
    "sarcasm",
    "sarcastic",
    "sardine",
    "sash",
    "sasquatch",
    "sassy",
    "satchel",
    "satiable",
    "satin",
    "satirical",
    "satisfied",
    "satisfy",
    "saturate",
    "saturday",
    "sauciness",
    "saucy",
    "sauna",
    "savage",
    "savanna",
    "saved",
    "savings",
    "savior",
    "savor",
    "saxophone",
    "say",
    "scabbed",
    "scabby",
    "scalded",
    "scalding",
    "scale",
    "scaling",
    "scallion",
    "scallop",
    "scalping",
    "scam",
    "scandal",
    "scanner",
    "scanning",
    "scant",
    "scapegoat",
    "scarce",
    "scarcity",
    "scarecrow",
    "scared",
    "scarf",
    "scarily",
    "scariness",
    "scarring",
    "scary",
    "scavenger",
    "scenic",
    "schedule",
    "schematic",
    "scheme",
    "scheming",
    "schilling",
    "schnapps",
    "scholar",
    "science",
    "scientist",
    "scion",
    "scoff",
    "scolding",
    "scone",
    "scoop",
    "scooter",
    "scope",
    "scorch",
    "scorebook",
    "scorecard",
    "scored",
    "scoreless",
    "scorer",
    "scoring",
    "scorn",
    "scorpion",
    "scotch",
    "scoundrel",
    "scoured",
    "scouring",
    "scouting",
    "scouts",
    "scowling",
    "scrabble",
    "scraggly",
    "scrambled",
    "scrambler",
    "scrap",
    "scratch",
    "scrawny",
    "screen",
    "scribble",
    "scribe",
    "scribing",
    "scrimmage",
    "script",
    "scroll",
    "scrooge",
    "scrounger",
    "scrubbed",
    "scrubber",
    "scruffy",
    "scrunch",
    "scrutiny",
    "scuba",
    "scuff",
    "sculptor",
    "sculpture",
    "scurvy",
    "scuttle",
    "secluded",
    "secluding",
    "seclusion",
    "second",
    "secrecy",
    "secret",
    "sectional",
    "sector",
    "secular",
    "securely",
    "security",
    "sedan",
    "sedate",
    "sedation",
    "sedative",
    "sediment",
    "seduce",
    "seducing",
    "segment",
    "seismic",
    "seizing",
    "seldom",
    "selected",
    "selection",
    "selective",
    "selector",
    "self",
    "seltzer",
    "semantic",
    "semester",
    "semicolon",
    "semifinal",
    "seminar",
    "semisoft",
    "semisweet",
    "senate",
    "senator",
    "send",
    "senior",
    "senorita",
    "sensation",
    "sensitive",
    "sensitize",
    "sensually",
    "sensuous",
    "sepia",
    "september",
    "septic",
    "septum",
    "sequel",
    "sequence",
    "sequester",
    "series",
    "sermon",
    "serotonin",
    "serpent",
    "serrated",
    "serve",
    "service",
    "serving",
    "sesame",
    "sessions",
    "setback",
    "setting",
    "settle",
    "settling",
    "setup",
    "sevenfold",
    "seventeen",
    "seventh",
    "seventy",
    "severity",
    "shabby",
    "shack",
    "shaded",
    "shadily",
    "shadiness",
    "shading",
    "shadow",
    "shady",
    "shaft",
    "shakable",
    "shakily",
    "shakiness",
    "shaking",
    "shaky",
    "shale",
    "shallot",
    "shallow",
    "shame",
    "shampoo",
    "shamrock",
    "shank",
    "shanty",
    "shape",
    "shaping",
    "share",
    "sharpener",
    "sharper",
    "sharpie",
    "sharply",
    "sharpness",
    "shawl",
    "sheath",
    "shed",
    "sheep",
    "sheet",
    "shelf",
    "shell",
    "shelter",
    "shelve",
    "shelving",
    "sherry",
    "shield",
    "shifter",
    "shifting",
    "shiftless",
    "shifty",
    "shimmer",
    "shimmy",
    "shindig",
    "shine",
    "shingle",
    "shininess",
    "shining",
    "shiny",
    "ship",
    "shirt",
    "shivering",
    "shock",
    "shone",
    "shoplift",
    "shopper",
    "shopping",
    "shoptalk",
    "shore",
    "shortage",
    "shortcake",
    "shortcut",
    "shorten",
    "shorter",
    "shorthand",
    "shortlist",
    "shortly",
    "shortness",
    "shorts",
    "shortwave",
    "shorty",
    "shout",
    "shove",
    "showbiz",
    "showcase",
    "showdown",
    "shower",
    "showgirl",
    "showing",
    "showman",
    "shown",
    "showoff",
    "showpiece",
    "showplace",
    "showroom",
    "showy",
    "shrank",
    "shrapnel",
    "shredder",
    "shredding",
    "shrewdly",
    "shriek",
    "shrill",
    "shrimp",
    "shrine",
    "shrink",
    "shrivel",
    "shrouded",
    "shrubbery",
    "shrubs",
    "shrug",
    "shrunk",
    "shucking",
    "shudder",
    "shuffle",
    "shuffling",
    "shun",
    "shush",
    "shut",
    "shy",
    "siamese",
    "siberian",
    "sibling",
    "siding",
    "sierra",
    "siesta",
    "sift",
    "sighing",
    "silenced",
    "silencer",
    "silent",
    "silica",
    "silicon",
    "silk",
    "silliness",
    "silly",
    "silo",
    "silt",
    "silver",
    "similarly",
    "simile",
    "simmering",
    "simple",
    "simplify",
    "simply",
    "sincere",
    "sincerity",
    "singer",
    "singing",
    "single",
    "singular",
    "sinister",
    "sinless",
    "sinner",
    "sinuous",
    "sip",
    "siren",
    "sister",
    "sitcom",
    "sitter",
    "sitting",
    "situated",
    "situation",
    "sixfold",
    "sixteen",
    "sixth",
    "sixties",
    "sixtieth",
    "sixtyfold",
    "sizable",
    "sizably",
    "size",
    "sizing",
    "sizzle",
    "sizzling",
    "skater",
    "skating",
    "skedaddle",
    "skeletal",
    "skeleton",
    "skeptic",
    "sketch",
    "skewed",
    "skewer",
    "skid",
    "skied",
    "skier",
    "skies",
    "skiing",
    "skilled",
    "skillet",
    "skillful",
    "skimmed",
    "skimmer",
    "skimming",
    "skimpily",
    "skincare",
    "skinhead",
    "skinless",
    "skinning",
    "skinny",
    "skintight",
    "skipper",
    "skipping",
    "skirmish",
    "skirt",
    "skittle",
    "skydiver",
    "skylight",
    "skyline",
    "skype",
    "skyrocket",
    "skyward",
    "slab",
    "slacked",
    "slacker",
    "slacking",
    "slackness",
    "slacks",
    "slain",
    "slam",
    "slander",
    "slang",
    "slapping",
    "slapstick",
    "slashed",
    "slashing",
    "slate",
    "slather",
    "slaw",
    "sled",
    "sleek",
    "sleep",
    "sleet",
    "sleeve",
    "slept",
    "sliceable",
    "sliced",
    "slicer",
    "slicing",
    "slick",
    "slider",
    "slideshow",
    "sliding",
    "slighted",
    "slighting",
    "slightly",
    "slimness",
    "slimy",
    "slinging",
    "slingshot",
    "slinky",
    "slip",
    "slit",
    "sliver",
    "slobbery",
    "slogan",
    "sloped",
    "sloping",
    "sloppily",
    "sloppy",
    "slot",
    "slouching",
    "slouchy",
    "sludge",
    "slug",
    "slum",
    "slurp",
    "slush",
    "sly",
    "small",
    "smartly",
    "smartness",
    "smasher",
    "smashing",
    "smashup",
    "smell",
    "smelting",
    "smile",
    "smilingly",
    "smirk",
    "smite",
    "smith",
    "smitten",
    "smock",
    "smog",
    "smoked",
    "smokeless",
    "smokiness",
    "smoking",
    "smoky",
    "smolder",
    "smooth",
    "smother",
    "smudge",
    "smudgy",
    "smuggler",
    "smuggling",
    "smugly",
    "smugness",
    "snack",
    "snagged",
    "snaking",
    "snap",
    "snare",
    "snarl",
    "snazzy",
    "sneak",
    "sneer",
    "sneeze",
    "sneezing",
    "snide",
    "sniff",
    "snippet",
    "snipping",
    "snitch",
    "snooper",
    "snooze",
    "snore",
    "snoring",
    "snorkel",
    "snort",
    "snout",
    "snowbird",
    "snowboard",
    "snowbound",
    "snowcap",
    "snowdrift",
    "snowdrop",
    "snowfall",
    "snowfield",
    "snowflake",
    "snowiness",
    "snowless",
    "snowman",
    "snowplow",
    "snowshoe",
    "snowstorm",
    "snowsuit",
    "snowy",
    "snub",
    "snuff",
    "snuggle",
    "snugly",
    "snugness",
    "speak",
    "spearfish",
    "spearhead",
    "spearman",
    "spearmint",
    "species",
    "specimen",
    "specked",
    "speckled",
    "specks",
    "spectacle",
    "spectator",
    "spectrum",
    "speculate",
    "speech",
    "speed",
    "spellbind",
    "speller",
    "spelling",
    "spendable",
    "spender",
    "spending",
    "spent",
    "spew",
    "sphere",
    "spherical",
    "sphinx",
    "spider",
    "spied",
    "spiffy",
    "spill",
    "spilt",
    "spinach",
    "spinal",
    "spindle",
    "spinner",
    "spinning",
    "spinout",
    "spinster",
    "spiny",
    "spiral",
    "spirited",
    "spiritism",
    "spirits",
    "spiritual",
    "splashed",
    "splashing",
    "splashy",
    "splatter",
    "spleen",
    "splendid",
    "splendor",
    "splice",
    "splicing",
    "splinter",
    "splotchy",
    "splurge",
    "spoilage",
    "spoiled",
    "spoiler",
    "spoiling",
    "spoils",
    "spoken",
    "spokesman",
    "sponge",
    "spongy",
    "sponsor",
    "spoof",
    "spookily",
    "spooky",
    "spool",
    "spoon",
    "spore",
    "sporting",
    "sports",
    "sporty",
    "spotless",
    "spotlight",
    "spotted",
    "spotter",
    "spotting",
    "spotty",
    "spousal",
    "spouse",
    "spout",
    "sprain",
    "sprang",
    "sprawl",
    "spray",
    "spree",
    "sprig",
    "spring",
    "sprinkled",
    "sprinkler",
    "sprint",
    "sprite",
    "sprout",
    "spruce",
    "sprung",
    "spry",
    "spud",
    "spur",
    "sputter",
    "spyglass",
    "squabble",
    "squad",
    "squall",
    "squander",
    "squash",
    "squatted",
    "squatter",
    "squatting",
    "squeak",
    "squealer",
    "squealing",
    "squeamish",
    "squeegee",
    "squeeze",
    "squeezing",
    "squid",
    "squiggle",
    "squiggly",
    "squint",
    "squire",
    "squirt",
    "squishier",
    "squishy",
    "stability",
    "stabilize",
    "stable",
    "stack",
    "stadium",
    "staff",
    "stage",
    "staging",
    "stagnant",
    "stagnate",
    "stainable",
    "stained",
    "staining",
    "stainless",
    "stalemate",
    "staleness",
    "stalling",
    "stallion",
    "stamina",
    "stammer",
    "stamp",
    "stand",
    "stank",
    "staple",
    "stapling",
    "starboard",
    "starch",
    "stardom",
    "stardust",
    "starfish",
    "stargazer",
    "staring",
    "stark",
    "starless",
    "starlet",
    "starlight",
    "starlit",
    "starring",
    "starry",
    "starship",
    "starter",
    "starting",
    "startle",
    "startling",
    "startup",
    "starved",
    "starving",
    "stash",
    "state",
    "static",
    "statistic",
    "statue",
    "stature",
    "status",
    "statute",
    "statutory",
    "staunch",
    "stays",
    "steadfast",
    "steadier",
    "steadily",
    "steadying",
    "steam",
    "steed",
    "steep",
    "steerable",
    "steering",
    "steersman",
    "stegosaur",
    "stellar",
    "stem",
    "stench",
    "stencil",
    "step",
    "stereo",
    "sterile",
    "sterility",
    "sterilize",
    "sterling",
    "sternness",
    "sternum",
    "stew",
    "stick",
    "stiffen",
    "stiffly",
    "stiffness",
    "stifle",
    "stifling",
    "stillness",
    "stilt",
    "stimulant",
    "stimulate",
    "stimuli",
    "stimulus",
    "stinger",
    "stingily",
    "stinging",
    "stingray",
    "stingy",
    "stinking",
    "stinky",
    "stipend",
    "stipulate",
    "stir",
    "stitch",
    "stock",
    "stoic",
    "stoke",
    "stole",
    "stomp",
    "stonewall",
    "stoneware",
    "stonework",
    "stoning",
    "stony",
    "stood",
    "stooge",
    "stool",
    "stoop",
    "stoplight",
    "stoppable",
    "stoppage",
    "stopped",
    "stopper",
    "stopping",
    "stopwatch",
    "storable",
    "storage",
    "storeroom",
    "storewide",
    "storm",
    "stout",
    "stove",
    "stowaway",
    "stowing",
    "straddle",
    "straggler",
    "strained",
    "strainer",
    "straining",
    "strangely",
    "stranger",
    "strangle",
    "strategic",
    "strategy",
    "stratus",
    "straw",
    "stray",
    "streak",
    "stream",
    "street",
    "strength",
    "strenuous",
    "strep",
    "stress",
    "stretch",
    "strewn",
    "stricken",
    "strict",
    "stride",
    "strife",
    "strike",
    "striking",
    "strive",
    "striving",
    "strobe",
    "strode",
    "stroller",
    "strongbox",
    "strongly",
    "strongman",
    "struck",
    "structure",
    "strudel",
    "struggle",
    "strum",
    "strung",
    "strut",
    "stubbed",
    "stubble",
    "stubbly",
    "stubborn",
    "stucco",
    "stuck",
    "student",
    "studied",
    "studio",
    "study",
    "stuffed",
    "stuffing",
    "stuffy",
    "stumble",
    "stumbling",
    "stump",
    "stung",
    "stunned",
    "stunner",
    "stunning",
    "stunt",
    "stupor",
    "sturdily",
    "sturdy",
    "styling",
    "stylishly",
    "stylist",
    "stylized",
    "stylus",
    "suave",
    "subarctic",
    "subatomic",
    "subdivide",
    "subdued",
    "subduing",
    "subfloor",
    "subgroup",
    "subheader",
    "subject",
    "sublease",
    "sublet",
    "sublevel",
    "sublime",
    "submarine",
    "submerge",
    "submersed",
    "submitter",
    "subpanel",
    "subpar",
    "subplot",
    "subprime",
    "subscribe",
    "subscript",
    "subsector",
    "subside",
    "subsiding",
    "subsidize",
    "subsidy",
    "subsoil",
    "subsonic",
    "substance",
    "subsystem",
    "subtext",
    "subtitle",
    "subtly",
    "subtotal",
    "subtract",
    "subtype",
    "suburb",
    "subway",
    "subwoofer",
    "subzero",
    "succulent",
    "such",
    "suction",
    "sudden",
    "sudoku",
    "suds",
    "sufferer",
    "suffering",
    "suffice",
    "suffix",
    "suffocate",
    "suffrage",
    "sugar",
    "suggest",
    "suing",
    "suitable",
    "suitably",
    "suitcase",
    "suitor",
    "sulfate",
    "sulfide",
    "sulfite",
    "sulfur",
    "sulk",
    "sullen",
    "sulphate",
    "sulphuric",
    "sultry",
    "superbowl",
    "superglue",
    "superhero",
    "superior",
    "superjet",
    "superman",
    "supermom",
    "supernova",
    "supervise",
    "supper",
    "supplier",
    "supply",
    "support",
    "supremacy",
    "supreme",
    "surcharge",
    "surely",
    "sureness",
    "surface",
    "surfacing",
    "surfboard",
    "surfer",
    "surgery",
    "surgical",
    "surging",
    "surname",
    "surpass",
    "surplus",
    "surprise",
    "surreal",
    "surrender",
    "surrogate",
    "surround",
    "survey",
    "survival",
    "survive",
    "surviving",
    "survivor",
    "sushi",
    "suspect",
    "suspend",
    "suspense",
    "sustained",
    "sustainer",
    "swab",
    "swaddling",
    "swagger",
    "swampland",
    "swan",
    "swapping",
    "swarm",
    "sway",
    "swear",
    "sweat",
    "sweep",
    "swell",
    "swept",
    "swerve",
    "swifter",
    "swiftly",
    "swiftness",
    "swimmable",
    "swimmer",
    "swimming",
    "swimsuit",
    "swimwear",
    "swinger",
    "swinging",
    "swipe",
    "swirl",
    "switch",
    "swivel",
    "swizzle",
    "swooned",
    "swoop",
    "swoosh",
    "swore",
    "sworn",
    "swung",
    "sycamore",
    "sympathy",
    "symphonic",
    "symphony",
    "symptom",
    "synapse",
    "syndrome",
    "synergy",
    "synopses",
    "synopsis",
    "synthesis",
    "synthetic",
    "syrup",
    "system",
    "t-shirt",
    "tabasco",
    "tabby",
    "tableful",
    "tables",
    "tablet",
    "tableware",
    "tabloid",
    "tackiness",
    "tacking",
    "tackle",
    "tackling",
    "tacky",
    "taco",
    "tactful",
    "tactical",
    "tactics",
    "tactile",
    "tactless",
    "tadpole",
    "taekwondo",
    "tag",
    "tainted",
    "take",
    "taking",
    "talcum",
    "talisman",
    "tall",
    "talon",
    "tamale",
    "tameness",
    "tamer",
    "tamper",
    "tank",
    "tanned",
    "tannery",
    "tanning",
    "tantrum",
    "tapeless",
    "tapered",
    "tapering",
    "tapestry",
    "tapioca",
    "tapping",
    "taps",
    "tarantula",
    "target",
    "tarmac",
    "tarnish",
    "tarot",
    "tartar",
    "tartly",
    "tartness",
    "task",
    "tassel",
    "taste",
    "tastiness",
    "tasting",
    "tasty",
    "tattered",
    "tattle",
    "tattling",
    "tattoo",
    "taunt",
    "tavern",
    "thank",
    "that",
    "thaw",
    "theater",
    "theatrics",
    "thee",
    "theft",
    "theme",
    "theology",
    "theorize",
    "thermal",
    "thermos",
    "thesaurus",
    "these",
    "thesis",
    "thespian",
    "thicken",
    "thicket",
    "thickness",
    "thieving",
    "thievish",
    "thigh",
    "thimble",
    "thing",
    "think",
    "thinly",
    "thinner",
    "thinness",
    "thinning",
    "thirstily",
    "thirsting",
    "thirsty",
    "thirteen",
    "thirty",
    "thong",
    "thorn",
    "those",
    "thousand",
    "thrash",
    "thread",
    "threaten",
    "threefold",
    "thrift",
    "thrill",
    "thrive",
    "thriving",
    "throat",
    "throbbing",
    "throng",
    "throttle",
    "throwaway",
    "throwback",
    "thrower",
    "throwing",
    "thud",
    "thumb",
    "thumping",
    "thursday",
    "thus",
    "thwarting",
    "thyself",
    "tiara",
    "tibia",
    "tidal",
    "tidbit",
    "tidiness",
    "tidings",
    "tidy",
    "tiger",
    "tighten",
    "tightly",
    "tightness",
    "tightrope",
    "tightwad",
    "tigress",
    "tile",
    "tiling",
    "till",
    "tilt",
    "timid",
    "timing",
    "timothy",
    "tinderbox",
    "tinfoil",
    "tingle",
    "tingling",
    "tingly",
    "tinker",
    "tinkling",
    "tinsel",
    "tinsmith",
    "tint",
    "tinwork",
    "tiny",
    "tipoff",
    "tipped",
    "tipper",
    "tipping",
    "tiptoeing",
    "tiptop",
    "tiring",
    "tissue",
    "trace",
    "tracing",
    "track",
    "traction",
    "tractor",
    "trade",
    "trading",
    "tradition",
    "traffic",
    "tragedy",
    "trailing",
    "trailside",
    "train",
    "traitor",
    "trance",
    "tranquil",
    "transfer",
    "transform",
    "translate",
    "transpire",
    "transport",
    "transpose",
    "trapdoor",
    "trapeze",
    "trapezoid",
    "trapped",
    "trapper",
    "trapping",
    "traps",
    "trash",
    "travel",
    "traverse",
    "travesty",
    "tray",
    "treachery",
    "treading",
    "treadmill",
    "treason",
    "treat",
    "treble",
    "tree",
    "trekker",
    "tremble",
    "trembling",
    "tremor",
    "trench",
    "trend",
    "trespass",
    "triage",
    "trial",
    "triangle",
    "tribesman",
    "tribunal",
    "tribune",
    "tributary",
    "tribute",
    "triceps",
    "trickery",
    "trickily",
    "tricking",
    "trickle",
    "trickster",
    "tricky",
    "tricolor",
    "tricycle",
    "trident",
    "tried",
    "trifle",
    "trifocals",
    "trillion",
    "trilogy",
    "trimester",
    "trimmer",
    "trimming",
    "trimness",
    "trinity",
    "trio",
    "tripod",
    "tripping",
    "triumph",
    "trivial",
    "trodden",
    "trolling",
    "trombone",
    "trophy",
    "tropical",
    "tropics",
    "trouble",
    "troubling",
    "trough",
    "trousers",
    "trout",
    "trowel",
    "truce",
    "truck",
    "truffle",
    "trump",
    "trunks",
    "trustable",
    "trustee",
    "trustful",
    "trusting",
    "trustless",
    "truth",
    "try",
    "tubby",
    "tubeless",
    "tubular",
    "tucking",
    "tuesday",
    "tug",
    "tuition",
    "tulip",
    "tumble",
    "tumbling",
    "tummy",
    "turban",
    "turbine",
    "turbofan",
    "turbojet",
    "turbulent",
    "turf",
    "turkey",
    "turmoil",
    "turret",
    "turtle",
    "tusk",
    "tutor",
    "tutu",
    "tux",
    "tweak",
    "tweed",
    "tweet",
    "tweezers",
    "twelve",
    "twentieth",
    "twenty",
    "twerp",
    "twice",
    "twiddle",
    "twiddling",
    "twig",
    "twilight",
    "twine",
    "twins",
    "twirl",
    "twistable",
    "twisted",
    "twister",
    "twisting",
    "twisty",
    "twitch",
    "twitter",
    "tycoon",
    "tying",
    "tyke",
    "udder",
    "ultimate",
    "ultimatum",
    "ultra",
    "umbilical",
    "umbrella",
    "umpire",
    "unabashed",
    "unable",
    "unadorned",
    "unadvised",
    "unafraid",
    "unaired",
    "unaligned",
    "unaltered",
    "unarmored",
    "unashamed",
    "unaudited",
    "unawake",
    "unaware",
    "unbaked",
    "unbalance",
    "unbeaten",
    "unbend",
    "unbent",
    "unbiased",
    "unbitten",
    "unblended",
    "unblessed",
    "unblock",
    "unbolted",
    "unbounded",
    "unboxed",
    "unbraided",
    "unbridle",
    "unbroken",
    "unbuckled",
    "unbundle",
    "unburned",
    "unbutton",
    "uncanny",
    "uncapped",
    "uncaring",
    "uncertain",
    "unchain",
    "unchanged",
    "uncharted",
    "uncheck",
    "uncivil",
    "unclad",
    "unclaimed",
    "unclamped",
    "unclasp",
    "uncle",
    "unclip",
    "uncloak",
    "unclog",
    "unclothed",
    "uncoated",
    "uncoiled",
    "uncolored",
    "uncombed",
    "uncommon",
    "uncooked",
    "uncork",
    "uncorrupt",
    "uncounted",
    "uncouple",
    "uncouth",
    "uncover",
    "uncross",
    "uncrown",
    "uncrushed",
    "uncured",
    "uncurious",
    "uncurled",
    "uncut",
    "undamaged",
    "undated",
    "undaunted",
    "undead",
    "undecided",
    "undefined",
    "underage",
    "underarm",
    "undercoat",
    "undercook",
    "undercut",
    "underdog",
    "underdone",
    "underfed",
    "underfeed",
    "underfoot",
    "undergo",
    "undergrad",
    "underhand",
    "underline",
    "underling",
    "undermine",
    "undermost",
    "underpaid",
    "underpass",
    "underpay",
    "underrate",
    "undertake",
    "undertone",
    "undertook",
    "undertow",
    "underuse",
    "underwear",
    "underwent",
    "underwire",
    "undesired",
    "undiluted",
    "undivided",
    "undocked",
    "undoing",
    "undone",
    "undrafted",
    "undress",
    "undrilled",
    "undusted",
    "undying",
    "unearned",
    "unearth",
    "unease",
    "uneasily",
    "uneasy",
    "uneatable",
    "uneaten",
    "unedited",
    "unelected",
    "unending",
    "unengaged",
    "unenvied",
    "unequal",
    "unethical",
    "uneven",
    "unexpired",
    "unexposed",
    "unfailing",
    "unfair",
    "unfasten",
    "unfazed",
    "unfeeling",
    "unfiled",
    "unfilled",
    "unfitted",
    "unfitting",
    "unfixable",
    "unfixed",
    "unflawed",
    "unfocused",
    "unfold",
    "unfounded",
    "unframed",
    "unfreeze",
    "unfrosted",
    "unfrozen",
    "unfunded",
    "unglazed",
    "ungloved",
    "unglue",
    "ungodly",
    "ungraded",
    "ungreased",
    "unguarded",
    "unguided",
    "unhappily",
    "unhappy",
    "unharmed",
    "unhealthy",
    "unheard",
    "unhearing",
    "unheated",
    "unhelpful",
    "unhidden",
    "unhinge",
    "unhitched",
    "unholy",
    "unhook",
    "unicorn",
    "unicycle",
    "unified",
    "unifier",
    "uniformed",
    "uniformly",
    "unify",
    "unimpeded",
    "uninjured",
    "uninstall",
    "uninsured",
    "uninvited",
    "union",
    "uniquely",
    "unisexual",
    "unison",
    "unissued",
    "unit",
    "universal",
    "universe",
    "unjustly",
    "unkempt",
    "unkind",
    "unknotted",
    "unknowing",
    "unknown",
    "unlaced",
    "unlatch",
    "unlawful",
    "unleaded",
    "unlearned",
    "unleash",
    "unless",
    "unleveled",
    "unlighted",
    "unlikable",
    "unlimited",
    "unlined",
    "unlinked",
    "unlisted",
    "unlit",
    "unlivable",
    "unloaded",
    "unloader",
    "unlocked",
    "unlocking",
    "unlovable",
    "unloved",
    "unlovely",
    "unloving",
    "unluckily",
    "unlucky",
    "unmade",
    "unmanaged",
    "unmanned",
    "unmapped",
    "unmarked",
    "unmasked",
    "unmasking",
    "unmatched",
    "unmindful",
    "unmixable",
    "unmixed",
    "unmolded",
    "unmoral",
    "unmovable",
    "unmoved",
    "unmoving",
    "unnamable",
    "unnamed",
    "unnatural",
    "unneeded",
    "unnerve",
    "unnerving",
    "unnoticed",
    "unopened",
    "unopposed",
    "unpack",
    "unpadded",
    "unpaid",
    "unpainted",
    "unpaired",
    "unpaved",
    "unpeeled",
    "unpicked",
    "unpiloted",
    "unpinned",
    "unplanned",
    "unplanted",
    "unpleased",
    "unpledged",
    "unplowed",
    "unplug",
    "unpopular",
    "unproven",
    "unquote",
    "unranked",
    "unrated",
    "unraveled",
    "unreached",
    "unread",
    "unreal",
    "unreeling",
    "unrefined",
    "unrelated",
    "unrented",
    "unrest",
    "unretired",
    "unrevised",
    "unrigged",
    "unripe",
    "unrivaled",
    "unroasted",
    "unrobed",
    "unroll",
    "unruffled",
    "unruly",
    "unrushed",
    "unsaddle",
    "unsafe",
    "unsaid",
    "unsalted",
    "unsaved",
    "unsavory",
    "unscathed",
    "unscented",
    "unscrew",
    "unsealed",
    "unseated",
    "unsecured",
    "unseeing",
    "unseemly",
    "unseen",
    "unselect",
    "unselfish",
    "unsent",
    "unsettled",
    "unshackle",
    "unshaken",
    "unshaved",
    "unshaven",
    "unsheathe",
    "unshipped",
    "unsightly",
    "unsigned",
    "unskilled",
    "unsliced",
    "unsmooth",
    "unsnap",
    "unsocial",
    "unsoiled",
    "unsold",
    "unsolved",
    "unsorted",
    "unspoiled",
    "unspoken",
    "unstable",
    "unstaffed",
    "unstamped",
    "unsteady",
    "unsterile",
    "unstirred",
    "unstitch",
    "unstopped",
    "unstuck",
    "unstuffed",
    "unstylish",
    "unsubtle",
    "unsubtly",
    "unsuited",
    "unsure",
    "unsworn",
    "untagged",
    "untainted",
    "untaken",
    "untamed",
    "untangled",
    "untapped",
    "untaxed",
    "unthawed",
    "unthread",
    "untidy",
    "untie",
    "until",
    "untimed",
    "untimely",
    "untitled",
    "untoasted",
    "untold",
    "untouched",
    "untracked",
    "untrained",
    "untreated",
    "untried",
    "untrimmed",
    "untrue",
    "untruth",
    "unturned",
    "untwist",
    "untying",
    "unusable",
    "unused",
    "unusual",
    "unvalued",
    "unvaried",
    "unvarying",
    "unveiled",
    "unveiling",
    "unvented",
    "unviable",
    "unvisited",
    "unvocal",
    "unwanted",
    "unwarlike",
    "unwary",
    "unwashed",
    "unwatched",
    "unweave",
    "unwed",
    "unwelcome",
    "unwell",
    "unwieldy",
    "unwilling",
    "unwind",
    "unwired",
    "unwitting",
    "unwomanly",
    "unworldly",
    "unworn",
    "unworried",
    "unworthy",
    "unwound",
    "unwoven",
    "unwrapped",
    "unwritten",
    "unzip",
    "upbeat",
    "upchuck",
    "upcoming",
    "upcountry",
    "update",
    "upfront",
    "upgrade",
    "upheaval",
    "upheld",
    "uphill",
    "uphold",
    "uplifted",
    "uplifting",
    "upload",
    "upon",
    "upper",
    "upright",
    "uprising",
    "upriver",
    "uproar",
    "uproot",
    "upscale",
    "upside",
    "upstage",
    "upstairs",
    "upstart",
    "upstate",
    "upstream",
    "upstroke",
    "upswing",
    "uptake",
    "uptight",
    "uptown",
    "upturned",
    "upward",
    "upwind",
    "uranium",
    "urban",
    "urchin",
    "urethane",
    "urgency",
    "urgent",
    "urging",
    "urologist",
    "urology",
    "usable",
    "usage",
    "useable",
    "used",
    "uselessly",
    "user",
    "usher",
    "usual",
    "utensil",
    "utility",
    "utilize",
    "utmost",
    "utopia",
    "utter",
    "vacancy",
    "vacant",
    "vacate",
    "vacation",
    "vagabond",
    "vagrancy",
    "vagrantly",
    "vaguely",
    "vagueness",
    "valiant",
    "valid",
    "valium",
    "valley",
    "valuables",
    "value",
    "vanilla",
    "vanish",
    "vanity",
    "vanquish",
    "vantage",
    "vaporizer",
    "variable",
    "variably",
    "varied",
    "variety",
    "various",
    "varmint",
    "varnish",
    "varsity",
    "varying",
    "vascular",
    "vaseline",
    "vastly",
    "vastness",
    "veal",
    "vegan",
    "veggie",
    "vehicular",
    "velcro",
    "velocity",
    "velvet",
    "vendetta",
    "vending",
    "vendor",
    "veneering",
    "vengeful",
    "venomous",
    "ventricle",
    "venture",
    "venue",
    "venus",
    "verbalize",
    "verbally",
    "verbose",
    "verdict",
    "verify",
    "verse",
    "version",
    "versus",
    "vertebrae",
    "vertical",
    "vertigo",
    "very",
    "vessel",
    "vest",
    "veteran",
    "veto",
    "vexingly",
    "viability",
    "viable",
    "vibes",
    "vice",
    "vicinity",
    "victory",
    "video",
    "viewable",
    "viewer",
    "viewing",
    "viewless",
    "viewpoint",
    "vigorous",
    "village",
    "villain",
    "vindicate",
    "vineyard",
    "vintage",
    "violate",
    "violation",
    "violator",
    "violet",
    "violin",
    "viper",
    "viral",
    "virtual",
    "virtuous",
    "virus",
    "visa",
    "viscosity",
    "viscous",
    "viselike",
    "visible",
    "visibly",
    "vision",
    "visiting",
    "visitor",
    "visor",
    "vista",
    "vitality",
    "vitalize",
    "vitally",
    "vitamins",
    "vivacious",
    "vividly",
    "vividness",
    "vixen",
    "vocalist",
    "vocalize",
    "vocally",
    "vocation",
    "voice",
    "voicing",
    "void",
    "volatile",
    "volley",
    "voltage",
    "volumes",
    "voter",
    "voting",
    "voucher",
    "vowed",
    "vowel",
    "voyage",
    "wackiness",
    "wad",
    "wafer",
    "waffle",
    "waged",
    "wager",
    "wages",
    "waggle",
    "wagon",
    "wake",
    "waking",
    "walk",
    "walmart",
    "walnut",
    "walrus",
    "waltz",
    "wand",
    "wannabe",
    "wanted",
    "wanting",
    "wasabi",
    "washable",
    "washbasin",
    "washboard",
    "washbowl",
    "washcloth",
    "washday",
    "washed",
    "washer",
    "washhouse",
    "washing",
    "washout",
    "washroom",
    "washstand",
    "washtub",
    "wasp",
    "wasting",
    "watch",
    "water",
    "waviness",
    "waving",
    "wavy",
    "whacking",
    "whacky",
    "wham",
    "wharf",
    "wheat",
    "whenever",
    "whiff",
    "whimsical",
    "whinny",
    "whiny",
    "whisking",
    "whoever",
    "whole",
    "whomever",
    "whoopee",
    "whooping",
    "whoops",
    "why",
    "wick",
    "widely",
    "widen",
    "widget",
    "widow",
    "width",
    "wieldable",
    "wielder",
    "wife",
    "wifi",
    "wikipedia",
    "wildcard",
    "wildcat",
    "wilder",
    "wildfire",
    "wildfowl",
    "wildland",
    "wildlife",
    "wildly",
    "wildness",
    "willed",
    "willfully",
    "willing",
    "willow",
    "willpower",
    "wilt",
    "wimp",
    "wince",
    "wincing",
    "wind",
    "wing",
    "winking",
    "winner",
    "winnings",
    "winter",
    "wipe",
    "wired",
    "wireless",
    "wiring",
    "wiry",
    "wisdom",
    "wise",
    "wish",
    "wisplike",
    "wispy",
    "wistful",
    "wizard",
    "wobble",
    "wobbling",
    "wobbly",
    "wok",
    "wolf",
    "wolverine",
    "womanhood",
    "womankind",
    "womanless",
    "womanlike",
    "womanly",
    "womb",
    "woof",
    "wooing",
    "wool",
    "woozy",
    "word",
    "work",
    "worried",
    "worrier",
    "worrisome",
    "worry",
    "worsening",
    "worshiper",
    "worst",
    "wound",
    "woven",
    "wow",
    "wrangle",
    "wrath",
    "wreath",
    "wreckage",
    "wrecker",
    "wrecking",
    "wrench",
    "wriggle",
    "wriggly",
    "wrinkle",
    "wrinkly",
    "wrist",
    "writing",
    "written",
    "wrongdoer",
    "wronged",
    "wrongful",
    "wrongly",
    "wrongness",
    "wrought",
    "xbox",
    "xerox",
    "yahoo",
    "yam",
    "yanking",
    "yapping",
    "yard",
    "yarn",
    "yeah",
    "yearbook",
    "yearling",
    "yearly",
    "yearning",
    "yeast",
    "yelling",
    "yelp",
    "yen",
    "yesterday",
    "yiddish",
    "yield",
    "yin",
    "yippee",
    "yo-yo",
    "yodel",
    "yoga",
    "yogurt",
    "yonder",
    "yoyo",
    "yummy",
    "zap",
    "zealous",
    "zebra",
    "zen",
    "zeppelin",
    "zero",
    "zestfully",
    "zesty",
    "zigzagged",
    "zipfile",
    "zipping",
    "zippy",
    "zips",
    "zit",
    "zodiac",
    "zombie",
    "zone",
    "zoning",
    "zookeeper",
    "zoologist",
    "zoology",
    "zoom",
];

;// ../../libs/common/src/platform/services/key-state/org-keys.state.ts

const org_keys_state_USER_ENCRYPTED_ORGANIZATION_KEYS = UserKeyDefinition.record(CRYPTO_DISK, "organizationKeys", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});

;// ../../libs/common/src/platform/services/key-state/provider-keys.state.ts

const provider_keys_state_USER_ENCRYPTED_PROVIDER_KEYS = UserKeyDefinition.record(CRYPTO_DISK, "providerKeys", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});

;// ../../libs/common/src/platform/services/key-state/user-key.state.ts


const user_key_state_USER_EVER_HAD_USER_KEY = new UserKeyDefinition(CRYPTO_DISK, "everHadUserKey", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
const user_key_state_USER_ENCRYPTED_PRIVATE_KEY = new UserKeyDefinition(CRYPTO_DISK, "privateKey", {
    deserializer: (obj) => obj,
    clearOn: ["logout"],
});
const USER_KEY = new UserKeyDefinition(CRYPTO_MEMORY, "userKey", {
    deserializer: (obj) => SymmetricCryptoKey.fromJSON(obj),
    clearOn: ["logout", "lock"],
});

;// ../../libs/key-management/src/key.service.ts
var key_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















class DefaultKeyService {
    constructor(pinService, masterPasswordService, keyGenerationService, cryptoFunctionService, encryptService, platformUtilService, logService, stateService, accountService, stateProvider, kdfConfigService) {
        this.pinService = pinService;
        this.masterPasswordService = masterPasswordService;
        this.keyGenerationService = keyGenerationService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.encryptService = encryptService;
        this.platformUtilService = platformUtilService;
        this.logService = logService;
        this.stateService = stateService;
        this.accountService = accountService;
        this.stateProvider = stateProvider;
        this.kdfConfigService = kdfConfigService;
        this.activeUserOrgKeys$ = this.stateProvider.activeUserId$.pipe((0,external_rxjs_namespaceObject.switchMap)((userId) => (userId != null ? this.orgKeys$(userId) : external_rxjs_namespaceObject.NEVER)), (0,external_rxjs_namespaceObject.filter)((orgKeys) => orgKeys != null), (0,external_rxjs_namespaceObject.distinctUntilChanged)(), (0,external_rxjs_namespaceObject.shareReplay)({ bufferSize: 1, refCount: false }));
    }
    setUserKey(key, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided. Lock the user to clear the key");
            }
            if (userId == null) {
                throw new Error("No userId provided.");
            }
            // Set userId to ensure we have one for the account status update
            yield this.stateProvider.setUserState(USER_KEY, key, userId);
            yield this.stateProvider.setUserState(user_key_state_USER_EVER_HAD_USER_KEY, true, userId);
            yield this.storeAdditionalKeys(key, userId);
        });
    }
    setUserKeys(userKey, encPrivateKey, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userKey == null) {
                throw new Error("No userKey provided. Lock the user to clear the key");
            }
            if (encPrivateKey == null) {
                throw new Error("No encPrivateKey provided.");
            }
            if (userId == null) {
                throw new Error("No userId provided.");
            }
            const decryptedPrivateKey = yield this.decryptPrivateKey(encPrivateKey, userKey);
            if (decryptedPrivateKey == null) {
                throw new UserPrivateKeyDecryptionFailedError();
            }
            yield this.setUserKey(userKey, userId);
            yield this.setPrivateKey(encPrivateKey, userId);
        });
    }
    refreshAdditionalKeys(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("UserId is required.");
            }
            const key = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.userKey$(userId));
            if (key == null) {
                throw new Error("No user key found for: " + userId);
            }
            yield this.setUserKey(key, userId);
        });
    }
    everHadUserKey$(userId) {
        return this.stateProvider
            .getUser(userId, user_key_state_USER_EVER_HAD_USER_KEY)
            .state$.pipe((0,external_rxjs_namespaceObject.map)((x) => x !== null && x !== void 0 ? x : false));
    }
    getInMemoryUserKeyFor$(userId) {
        return this.stateProvider.getUserState$(USER_KEY, userId);
    }
    getUserKey(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(USER_KEY, userId));
            return userKey;
        });
    }
    getUserKeyFromStorage(keySuffix, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("UserId is required");
            }
            const userKey = yield this.getKeyFromStorage(keySuffix, userId);
            if (userKey == null) {
                return null;
            }
            if (!(yield this.validateUserKey(userKey, userId))) {
                this.logService.warning("Invalid key, throwing away stored keys");
                yield this.clearAllStoredUserKeys(userId);
            }
            return userKey;
        });
    }
    hasUserKey(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                return false;
            }
            return (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(USER_KEY, userId))) != null;
        });
    }
    makeUserKey(masterKey) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (masterKey == null) {
                const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$);
                if (userId == null) {
                    throw new Error("No active user id found.");
                }
                masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            }
            if (masterKey == null) {
                throw new Error("No Master Key found.");
            }
            const newUserKey = yield this.keyGenerationService.createKey(512);
            return this.buildProtectedSymmetricKey(masterKey, newUserKey);
        });
    }
    makeUserKeyV1() {
        return key_service_awaiter(this, void 0, void 0, function* () {
            const newUserKey = yield this.keyGenerationService.createKey(512);
            return newUserKey;
        });
    }
    /**
     * Clears the user key. Clears all stored versions of the user keys as well, such as the biometrics key
     * @param userId The desired user
     */
    clearUserKey(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                // nothing to do
                return;
            }
            // Set userId to ensure we have one for the account status update
            yield this.stateProvider.setUserState(USER_KEY, null, userId);
            yield this.clearAllStoredUserKeys(userId);
        });
    }
    clearStoredUserKey(keySuffix, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("UserId is required");
            }
            if (keySuffix === KeySuffixOptions.Auto) {
                yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            }
            if (keySuffix === KeySuffixOptions.Pin) {
                yield this.pinService.clearPinKeyEncryptedUserKeyEphemeral(userId);
            }
        });
    }
    /**
     * @deprecated Please use `makeMasterPasswordAuthenticationData`, `unwrapUserKeyFromMasterPasswordUnlockData` or `makeMasterPasswordUnlockData` in @link MasterPasswordService instead.
     */
    getOrDeriveMasterKey(password, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required.");
            }
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (masterKey != null) {
                return masterKey;
            }
            const email = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.accounts$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => { var _a; return (_a = accounts[userId]) === null || _a === void 0 ? void 0 : _a.email; })));
            if (email == null) {
                throw new Error("No email found for user " + userId);
            }
            const kdf = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.kdfConfigService.getKdfConfig$(userId));
            if (kdf == null) {
                throw new Error("No kdf found for user " + userId);
            }
            return yield this.makeMasterKey(password, email, kdf);
        });
    }
    /**
     * Derive a master key from a password and email.
     *
     * @deprecated Please use `makeMasterPasswordAuthenticationData`, `makeMasterPasswordAuthenticationData`, `unwrapUserKeyFromMasterPasswordUnlockData` in @link MasterPasswordService instead.
     *
     * @remarks
     * Does not validate the kdf config to ensure it satisfies the minimum requirements for the given kdf type.
     */
    makeMasterKey(password, email, kdfConfig) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            const start = new Date().getTime();
            email = email.trim().toLowerCase();
            const masterKey = (yield this.keyGenerationService.deriveKeyFromPassword(password, email, kdfConfig));
            const end = new Date().getTime();
            this.logService.info(`[KeyService] Deriving master key took ${end - start}ms`);
            return masterKey;
        });
    }
    /**
     * @deprecated Please use `makeMasterPasswordUnlockData` in {@link MasterPasswordService} instead.
     */
    encryptUserKeyWithMasterKey(masterKey, userKey) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            userKey || (userKey = yield this.getUserKey());
            return yield this.buildProtectedSymmetricKey(masterKey, userKey);
        });
    }
    /**
     * @deprecated Please use `makeMasterPasswordAuthenticationData` in {@link MasterPasswordService} instead.
     */
    hashMasterKey(password, key, hashPurpose) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (password == null) {
                throw new Error("password is required.");
            }
            if (key == null) {
                throw new Error("key is required.");
            }
            const iterations = hashPurpose === HashPurpose.LocalAuthorization ? 2 : 1;
            const hash = yield this.cryptoFunctionService.pbkdf2(key.inner().encryptionKey, password, "sha256", iterations);
            return utils_Utils.fromBufferToB64(hash);
        });
    }
    compareKeyHash(masterPassword, masterKey, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (masterKey == null) {
                throw new Error("'masterKey' is required to be non-null.");
            }
            if (masterPassword == null) {
                // If they don't give us a master password, we can't hash it, and therefore
                // it will never match what we have stored.
                return false;
            }
            // Retrieve the current password hash
            const storedPasswordHash = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKeyHash$(userId));
            if (storedPasswordHash == null) {
                return false;
            }
            // Hash the key for local use
            const localKeyHash = yield this.hashMasterKey(masterPassword, masterKey, HashPurpose.LocalAuthorization);
            // Check if the stored hash is already equal to the hash we create locally
            if (localKeyHash == null || storedPasswordHash !== localKeyHash) {
                return false;
            }
            return true;
        });
    }
    setOrgKeys(orgs, providerOrgs, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getUser(userId, org_keys_state_USER_ENCRYPTED_ORGANIZATION_KEYS).update(() => {
                const encOrgKeyData = {};
                for (const org of orgs) {
                    encOrgKeyData[org.id] = {
                        type: "organization",
                        key: org.key,
                    };
                }
                for (const org of providerOrgs) {
                    encOrgKeyData[org.id] = {
                        type: "provider",
                        providerId: org.providerId,
                        key: org.key,
                    };
                }
                return encOrgKeyData;
            });
        });
    }
    getOrgKey(orgId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserOrgKeys$.pipe((0,external_rxjs_namespaceObject.map)((orgKeys) => { var _a; return (_a = orgKeys[orgId]) !== null && _a !== void 0 ? _a : null; })));
        });
    }
    makeDataEncKey(key) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided");
            }
            const newSymKey = yield this.keyGenerationService.createKey(512);
            return this.buildProtectedSymmetricKey(key, newSymKey);
        });
    }
    clearOrgKeys(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                // nothing to do
                return;
            }
            yield this.stateProvider.setUserState(org_keys_state_USER_ENCRYPTED_ORGANIZATION_KEYS, null, userId);
        });
    }
    setProviderKeys(providers, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.getUser(userId, provider_keys_state_USER_ENCRYPTED_PROVIDER_KEYS).update(() => {
                const encProviderKeys = {};
                providers.forEach((provider) => {
                    encProviderKeys[provider.id] = provider.key;
                });
                return encProviderKeys;
            });
        });
    }
    // TODO: Deprecate in favor of observable
    getProviderKey(providerId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            if (providerId == null) {
                return null;
            }
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.activeUserId$);
            if (activeUserId == null) {
                throw new Error("No active user found.");
            }
            const providerKeys = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.providerKeys$(activeUserId));
            return (_a = providerKeys === null || providerKeys === void 0 ? void 0 : providerKeys[providerId]) !== null && _a !== void 0 ? _a : null;
        });
    }
    clearProviderKeys(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                // nothing to do
                return;
            }
            yield this.stateProvider.setUserState(provider_keys_state_USER_ENCRYPTED_PROVIDER_KEYS, null, userId);
        });
    }
    makeOrgKey(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("UserId is required");
            }
            const publicKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.userPublicKey$(userId));
            if (publicKey == null) {
                throw new Error("No public key found for user " + userId);
            }
            const shareKey = yield this.keyGenerationService.createKey(512);
            const encShareKey = yield this.encryptService.encapsulateKeyUnsigned(shareKey, publicKey);
            return [encShareKey, shareKey];
        });
    }
    setPrivateKey(encPrivateKey, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (encPrivateKey == null) {
                return;
            }
            yield this.stateProvider
                .getUser(userId, user_key_state_USER_ENCRYPTED_PRIVATE_KEY)
                .update(() => encPrivateKey);
        });
    }
    getFingerprint(fingerprintMaterial, publicKey) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (publicKey == null) {
                throw new Error("Public key is required to generate a fingerprint.");
            }
            const keyFingerprint = yield this.cryptoFunctionService.hash(publicKey, "sha256");
            const userFingerprint = yield this.cryptoFunctionService.hkdfExpand(keyFingerprint, fingerprintMaterial, 32, "sha256");
            return this.hashPhrase(userFingerprint);
        });
    }
    makeKeyPair(key) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("'key' is a required parameter and must be non-null.");
            }
            const keyPair = yield this.cryptoFunctionService.rsaGenerateKeyPair(2048);
            const publicB64 = utils_Utils.fromBufferToB64(keyPair[0]);
            const privateEnc = yield this.encryptService.wrapDecapsulationKey(keyPair[1], key);
            return [publicB64, privateEnc];
        });
    }
    /**
     * Clears the user's key pair
     * @param userId The desired user
     */
    clearKeyPair(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateProvider.setUserState(user_key_state_USER_ENCRYPTED_PRIVATE_KEY, null, userId);
        });
    }
    clearPinKeys(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("UserId is required");
            }
            yield this.pinService.clearPinKeyEncryptedUserKeyPersistent(userId);
            yield this.pinService.clearPinKeyEncryptedUserKeyEphemeral(userId);
            yield this.pinService.clearUserKeyEncryptedPin(userId);
        });
    }
    makeSendKey(keyMaterial) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            return yield this.keyGenerationService.deriveKeyFromMaterial(keyMaterial, "bitwarden-send", "send");
        });
    }
    makeCipherKey() {
        return key_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.keyGenerationService.createKey(512));
        });
    }
    clearKeys(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("UserId is required");
            }
            yield this.masterPasswordService.clearMasterKeyHash(userId);
            yield this.clearUserKey(userId);
            yield this.clearOrgKeys(userId);
            yield this.clearProviderKeys(userId);
            yield this.clearKeyPair(userId);
            yield this.clearPinKeys(userId);
            yield this.stateProvider.setUserState(user_key_state_USER_EVER_HAD_USER_KEY, null, userId);
        });
    }
    // EFForg/OpenWireless
    // ref https://github.com/EFForg/OpenWireless/blob/master/app/js/diceware.js
    randomNumber(min, max) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            let rval = 0;
            const range = max - min + 1;
            const bitsNeeded = Math.ceil(Math.log2(range));
            if (bitsNeeded > 53) {
                throw new Error("We cannot generate numbers larger than 53 bits.");
            }
            const bytesNeeded = Math.ceil(bitsNeeded / 8);
            const mask = Math.pow(2, bitsNeeded) - 1;
            // 7776 -> (2^13 = 8192) -1 == 8191 or 0x00001111 11111111
            // Fill a byte array with N random numbers
            const byteArray = new Uint8Array(yield this.cryptoFunctionService.randomBytes(bytesNeeded));
            let p = (bytesNeeded - 1) * 8;
            for (let i = 0; i < bytesNeeded; i++) {
                rval += byteArray[i] * Math.pow(2, p);
                p -= 8;
            }
            // Use & to apply the mask and reduce the number of recursive lookups
            rval = rval & mask;
            if (rval >= range) {
                // Integer out of acceptable range
                return this.randomNumber(min, max);
            }
            // Return an integer that falls within the range
            return min + rval;
        });
    }
    // ---HELPERS---
    validateUserKey(key, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                return false;
            }
            try {
                const encPrivateKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, user_key_state_USER_ENCRYPTED_PRIVATE_KEY).state$);
                if (encPrivateKey == null) {
                    return false;
                }
                // Can decrypt private key
                const privateKey = yield this.decryptPrivateKey(encPrivateKey, key);
                if (privateKey == null) {
                    // failed to decrypt
                    return false;
                }
                // Can successfully derive public key
                const publicKey = yield this.derivePublicKey(privateKey);
                if (publicKey == null) {
                    // failed to decrypt
                    return false;
                }
                // FIXME: Remove when updating file. Eslint update
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
            }
            catch (e) {
                return false;
            }
            return true;
        });
    }
    /**
     * Initialize all necessary crypto keys needed for a new account.
     * Warning! This completely replaces any existing keys!
     */
    initAccount(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("UserId is required.");
            }
            // Verify user key doesn't exist
            const existingUserKey = yield this.getUserKey(userId);
            if (existingUserKey != null) {
                this.logService.error("Tried to initialize account with existing user key.");
                throw new Error("Cannot initialize account, keys already exist.");
            }
            const userKey = (yield this.keyGenerationService.createKey(512));
            const [publicKey, privateKey] = yield this.makeKeyPair(userKey);
            if (privateKey.encryptedString == null) {
                throw new Error("Failed to create valid private key.");
            }
            yield this.setUserKey(userKey, userId);
            yield this.stateProvider
                .getUser(userId, user_key_state_USER_ENCRYPTED_PRIVATE_KEY)
                .update(() => privateKey.encryptedString);
            return {
                userKey,
                publicKey,
                privateKey,
            };
        });
    }
    /**
     * Generates any additional keys if needed. Additional keys are
     * keys such as biometrics, auto, and pin keys.
     * Useful to make sure other keys stay in sync when the user key
     * has been rotated.
     * @param key The user key
     * @param userId The desired user
     */
    storeAdditionalKeys(key, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            const storeAuto = yield this.shouldStoreKey(KeySuffixOptions.Auto, userId);
            if (storeAuto) {
                yield this.stateService.setUserKeyAutoUnlock(key.keyB64, { userId: userId });
            }
            else {
                yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            }
            const storePin = yield this.shouldStoreKey(KeySuffixOptions.Pin, userId);
            if (storePin) {
                // Decrypt userKeyEncryptedPin with user key
                const pin = yield this.encryptService.decryptString((yield this.pinService.getUserKeyEncryptedPin(userId)), key);
                const pinKeyEncryptedUserKey = yield this.pinService.createPinKeyEncryptedUserKey(pin, key, userId);
                const noPreExistingPersistentKey = (yield this.pinService.getPinKeyEncryptedUserKeyPersistent(userId)) == null;
                yield this.pinService.storePinKeyEncryptedUserKey(pinKeyEncryptedUserKey, noPreExistingPersistentKey, userId);
            }
            else {
                yield this.pinService.clearPinKeyEncryptedUserKeyPersistent(userId);
                yield this.pinService.clearPinKeyEncryptedUserKeyEphemeral(userId);
            }
        });
    }
    shouldStoreKey(keySuffix, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            let shouldStoreKey = false;
            switch (keySuffix) {
                case KeySuffixOptions.Auto: {
                    // TODO: Sharing the UserKeyDefinition is temporary to get around a circ dep issue between
                    // the VaultTimeoutSettingsSvc and this service.
                    // This should be fixed as part of the PM-7082 - Auto Key Service work.
                    const vaultTimeout = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUserState$(vault_timeout_settings_state_VAULT_TIMEOUT, userId));
                    shouldStoreKey = vaultTimeout == VaultTimeoutStringType.Never;
                    break;
                }
                case KeySuffixOptions.Pin: {
                    const userKeyEncryptedPin = yield this.pinService.getUserKeyEncryptedPin(userId);
                    shouldStoreKey = !!userKeyEncryptedPin;
                    break;
                }
            }
            return shouldStoreKey;
        });
    }
    getKeyFromStorage(keySuffix, userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (keySuffix === KeySuffixOptions.Auto) {
                const userKey = yield this.stateService.getUserKeyAutoUnlock({ userId: userId });
                if (userKey) {
                    return new SymmetricCryptoKey(utils_Utils.fromB64ToArray(userKey));
                }
            }
            return null;
        });
    }
    clearAllStoredUserKeys(userId) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            yield this.pinService.clearPinKeyEncryptedUserKeyEphemeral(userId);
        });
    }
    hashPhrase(hash_1) {
        return key_service_awaiter(this, arguments, void 0, function* (hash, minimumEntropy = 64) {
            const entropyPerWord = Math.log(EFFLongWordList.length) / Math.log(2);
            let numWords = Math.ceil(minimumEntropy / entropyPerWord);
            const hashArr = Array.from(new Uint8Array(hash));
            const entropyAvailable = hashArr.length * 4;
            if (numWords * entropyPerWord > entropyAvailable) {
                throw new Error("Output entropy of hash function is too small");
            }
            const phrase = [];
            let hashNumber = external_big_integer_namespaceObject.fromArray(hashArr, 256);
            while (numWords--) {
                const remainder = hashNumber.mod(EFFLongWordList.length);
                hashNumber = hashNumber.divide(EFFLongWordList.length);
                phrase.push(EFFLongWordList[remainder]);
            }
            return phrase;
        });
    }
    buildProtectedSymmetricKey(encryptionKey, newSymKey) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            let protectedSymKey;
            if (encryptionKey.inner().type === encryption_type_enum_EncryptionType.AesCbc256_B64) {
                const stretchedEncryptionKey = yield this.keyGenerationService.stretchKey(encryptionKey);
                protectedSymKey = yield this.encryptService.wrapSymmetricKey(newSymKey, stretchedEncryptionKey);
            }
            else if (encryptionKey.inner().type === encryption_type_enum_EncryptionType.AesCbc256_HmacSha256_B64) {
                protectedSymKey = yield this.encryptService.wrapSymmetricKey(newSymKey, encryptionKey);
            }
            else {
                throw new Error("Invalid key size.");
            }
            return [newSymKey, protectedSymKey];
        });
    }
    userKey$(userId) {
        return this.stateProvider.getUser(userId, USER_KEY).state$;
    }
    userPublicKey$(userId) {
        return this.userPrivateKey$(userId).pipe((0,external_rxjs_namespaceObject.switchMap)((pk) => key_service_awaiter(this, void 0, void 0, function* () { return yield this.derivePublicKey(pk); })));
    }
    derivePublicKey(privateKey) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (privateKey == null) {
                return null;
            }
            return (yield this.cryptoFunctionService.rsaExtractPublicKey(privateKey));
        });
    }
    userPrivateKey$(userId) {
        return this.userPrivateKeyHelper$(userId).pipe((0,external_rxjs_namespaceObject.map)((keys) => { var _a; return (_a = keys === null || keys === void 0 ? void 0 : keys.userPrivateKey) !== null && _a !== void 0 ? _a : null; }));
    }
    userEncryptionKeyPair$(userId) {
        return this.userPrivateKey$(userId).pipe((0,external_rxjs_namespaceObject.switchMap)((privateKey) => key_service_awaiter(this, void 0, void 0, function* () {
            if (privateKey == null) {
                return null;
            }
            const publicKey = (yield this.derivePublicKey(privateKey));
            return { privateKey, publicKey };
        })));
    }
    userEncryptedPrivateKey$(userId) {
        return this.stateProvider.getUser(userId, user_key_state_USER_ENCRYPTED_PRIVATE_KEY).state$;
    }
    userPrivateKeyHelper$(userId) {
        const userKey$ = this.userKey$(userId);
        return userKey$.pipe((0,external_rxjs_namespaceObject.switchMap)((userKey) => {
            if (userKey == null) {
                return (0,external_rxjs_namespaceObject.of)(null);
            }
            return this.stateProvider.getUser(userId, user_key_state_USER_ENCRYPTED_PRIVATE_KEY).state$.pipe((0,external_rxjs_namespaceObject.switchMap)((encryptedPrivateKey) => key_service_awaiter(this, void 0, void 0, function* () {
                try {
                    return yield this.decryptPrivateKey(encryptedPrivateKey, userKey);
                }
                catch (e) {
                    this.logService.error("Failed to decrypt private key for user ", userId, e);
                    throw e;
                }
            })), 
            // Combine outerscope info with user private key
            (0,external_rxjs_namespaceObject.map)((userPrivateKey) => ({
                userKey,
                userPrivateKey,
            })));
        }));
    }
    decryptPrivateKey(encryptedPrivateKey, key) {
        return key_service_awaiter(this, void 0, void 0, function* () {
            if (encryptedPrivateKey == null) {
                return null;
            }
            return (yield this.encryptService.unwrapDecapsulationKey(new enc_string_EncString(encryptedPrivateKey), key));
        });
    }
    providerKeys$(userId) {
        return this.userPrivateKey$(userId).pipe((0,external_rxjs_namespaceObject.switchMap)((userPrivateKey) => {
            if (userPrivateKey == null) {
                return (0,external_rxjs_namespaceObject.of)(null);
            }
            return this.providerKeysHelper$(userId, userPrivateKey);
        }));
    }
    /**
     * A helper for decrypting provider keys that requires a user id and that users decrypted private key
     * this is helpful for when you may have already grabbed the user private key and don't want to redo
     * that work to get the provider keys.
     */
    providerKeysHelper$(userId, userPrivateKey) {
        return this.stateProvider.getUser(userId, provider_keys_state_USER_ENCRYPTED_PROVIDER_KEYS).state$.pipe(
        // Convert each value in the record to it's own decryption observable
        convertValues((_, value) => key_service_awaiter(this, void 0, void 0, function* () {
            const decapsulatedKey = yield this.encryptService.decapsulateKeyUnsigned(new enc_string_EncString(value), userPrivateKey);
            return decapsulatedKey;
        })), 
        // switchMap since there are no side effects
        (0,external_rxjs_namespaceObject.switchMap)((encryptedProviderKeys) => {
            if (encryptedProviderKeys == null) {
                return (0,external_rxjs_namespaceObject.of)(null);
            }
            // Can't give an empty record to forkJoin
            if (Object.keys(encryptedProviderKeys).length === 0) {
                return (0,external_rxjs_namespaceObject.of)({});
            }
            return (0,external_rxjs_namespaceObject.forkJoin)(encryptedProviderKeys);
        }));
    }
    orgKeys$(userId) {
        return this.cipherDecryptionKeys$(userId).pipe((0,external_rxjs_namespaceObject.map)((keys) => { var _a; return (_a = keys === null || keys === void 0 ? void 0 : keys.orgKeys) !== null && _a !== void 0 ? _a : null; }));
    }
    encryptedOrgKeys$(userId) {
        var _a;
        return (_a = this.userPrivateKey$(userId)) === null || _a === void 0 ? void 0 : _a.pipe((0,external_rxjs_namespaceObject.switchMap)((userPrivateKey) => {
            if (userPrivateKey == null) {
                // We can't do any org based decryption
                return (0,external_rxjs_namespaceObject.of)({});
            }
            return (0,external_rxjs_namespaceObject.combineLatest)([
                this.stateProvider.getUser(userId, org_keys_state_USER_ENCRYPTED_ORGANIZATION_KEYS).state$,
                this.providerKeysHelper$(userId, userPrivateKey),
            ]).pipe((0,external_rxjs_namespaceObject.switchMap)((_a) => key_service_awaiter(this, [_a], void 0, function* ([encryptedOrgKeys, providerKeys]) {
                const userPubKey = yield this.derivePublicKey(userPrivateKey);
                const result = {};
                encryptedOrgKeys = encryptedOrgKeys !== null && encryptedOrgKeys !== void 0 ? encryptedOrgKeys : {};
                for (const orgId of Object.keys(encryptedOrgKeys)) {
                    if (result[orgId] != null) {
                        continue;
                    }
                    const encrypted = BaseEncryptedOrganizationKey.fromData(encryptedOrgKeys[orgId]);
                    if (encrypted == null) {
                        continue;
                    }
                    let orgKey;
                    // Because the SDK only supports user encrypted org keys, we need to re-encrypt
                    // any provider encrypted org keys with the user's public key. This should be removed
                    // once the SDK has support for provider keys.
                    if (BaseEncryptedOrganizationKey.isProviderEncrypted(encrypted)) {
                        if (providerKeys == null) {
                            continue;
                        }
                        orgKey = yield this.encryptService.encapsulateKeyUnsigned(yield encrypted.decrypt(this.encryptService, providerKeys), userPubKey);
                    }
                    else {
                        orgKey = encrypted.encryptedOrganizationKey;
                    }
                    result[orgId] = orgKey;
                }
                return result;
            })));
        }));
    }
    cipherDecryptionKeys$(userId) {
        var _a;
        return (_a = this.userPrivateKeyHelper$(userId)) === null || _a === void 0 ? void 0 : _a.pipe((0,external_rxjs_namespaceObject.switchMap)((userKeys) => {
            if (userKeys == null) {
                return (0,external_rxjs_namespaceObject.of)(null);
            }
            const userPrivateKey = userKeys.userPrivateKey;
            if (userPrivateKey == null) {
                // We can't do any org based decryption
                return (0,external_rxjs_namespaceObject.of)({ userKey: userKeys.userKey, orgKeys: null });
            }
            return (0,external_rxjs_namespaceObject.combineLatest)([
                this.stateProvider.getUser(userId, org_keys_state_USER_ENCRYPTED_ORGANIZATION_KEYS).state$,
                this.providerKeysHelper$(userId, userPrivateKey),
            ]).pipe((0,external_rxjs_namespaceObject.switchMap)((_a) => key_service_awaiter(this, [_a], void 0, function* ([encryptedOrgKeys, providerKeys]) {
                const result = {};
                encryptedOrgKeys = encryptedOrgKeys !== null && encryptedOrgKeys !== void 0 ? encryptedOrgKeys : {};
                for (const orgId of Object.keys(encryptedOrgKeys)) {
                    if (result[orgId] != null) {
                        continue;
                    }
                    const encrypted = BaseEncryptedOrganizationKey.fromData(encryptedOrgKeys[orgId]);
                    if (encrypted == null) {
                        continue;
                    }
                    let decrypted;
                    if (BaseEncryptedOrganizationKey.isProviderEncrypted(encrypted)) {
                        if (providerKeys == null) {
                            continue;
                        }
                        decrypted = yield encrypted.decrypt(this.encryptService, providerKeys);
                    }
                    else {
                        decrypted = yield encrypted.decrypt(this.encryptService, userPrivateKey);
                    }
                    result[orgId] = decrypted;
                }
                return result;
            })), 
            // Combine them back together
            (0,external_rxjs_namespaceObject.map)((orgKeys) => ({ userKey: userKeys.userKey, orgKeys: orgKeys })));
        }));
    }
}

;// ../../libs/common/src/platform/misc/range-with-default.ts
/**
 * A range with a default value.
 *
 * Enforces constraints to ensure min > default > max.
 */
class RangeWithDefault {
    constructor(min, max, defaultValue) {
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
        if (min > max) {
            throw new Error(`${min} is greater than ${max}.`);
        }
        if (this.inRange(defaultValue) === false) {
            throw new Error("Default value is not in range.");
        }
    }
    inRange(value) {
        return value >= this.min && value <= this.max;
    }
}

;// ../../libs/key-management/src/enums/kdf-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var kdf_type_enum_KdfType;
(function (KdfType) {
    KdfType[KdfType["PBKDF2_SHA256"] = 0] = "PBKDF2_SHA256";
    KdfType[KdfType["Argon2id"] = 1] = "Argon2id";
})(kdf_type_enum_KdfType || (kdf_type_enum_KdfType = {}));

;// ../../libs/key-management/src/models/kdf-config.ts


/**
 * Password-Based Key Derivation Function 2 (PBKDF2) KDF configuration.
 */
class PBKDF2KdfConfig {
    constructor(iterations) {
        this.kdfType = kdf_type_enum_KdfType.PBKDF2_SHA256;
        this.iterations = iterations !== null && iterations !== void 0 ? iterations : PBKDF2KdfConfig.ITERATIONS.defaultValue;
    }
    /**
     * Validates the PBKDF2 KDF configuration for updating the KDF config.
     * A Valid PBKDF2 KDF configuration has KDF iterations between the 600_000 and 2_000_000.
     */
    validateKdfConfigForSetting() {
        if (!PBKDF2KdfConfig.ITERATIONS.inRange(this.iterations)) {
            throw new Error(`PBKDF2 iterations must be between ${PBKDF2KdfConfig.ITERATIONS.min} and ${PBKDF2KdfConfig.ITERATIONS.max}`);
        }
    }
    /**
     * Validates the PBKDF2 KDF configuration for pre-login.
     * A Valid PBKDF2 KDF configuration has KDF iterations between the 5000 and 2_000_000.
     */
    validateKdfConfigForPrelogin() {
        if (PBKDF2KdfConfig.PRELOGIN_ITERATIONS_MIN > this.iterations) {
            throw new Error(`PBKDF2 iterations must be at least ${PBKDF2KdfConfig.PRELOGIN_ITERATIONS_MIN}, but was ${this.iterations}; possible pre-login downgrade attack detected.`);
        }
    }
    static fromJSON(json) {
        return new PBKDF2KdfConfig(json.iterations);
    }
    toSdkConfig() {
        return {
            pBKDF2: {
                iterations: this.iterations,
            },
        };
    }
}
PBKDF2KdfConfig.ITERATIONS = new RangeWithDefault(600000, 2000000, 600000);
PBKDF2KdfConfig.PRELOGIN_ITERATIONS_MIN = 5000;
/**
 * Argon2 KDF configuration.
 */
class Argon2KdfConfig {
    constructor(iterations, memory, parallelism) {
        this.kdfType = kdf_type_enum_KdfType.Argon2id;
        this.iterations = iterations !== null && iterations !== void 0 ? iterations : Argon2KdfConfig.ITERATIONS.defaultValue;
        this.memory = memory !== null && memory !== void 0 ? memory : Argon2KdfConfig.MEMORY.defaultValue;
        this.parallelism = parallelism !== null && parallelism !== void 0 ? parallelism : Argon2KdfConfig.PARALLELISM.defaultValue;
    }
    /**
     * Validates the Argon2 KDF configuration for updating the KDF config.
     * A Valid Argon2 KDF configuration has iterations between 2 and 10, memory between 16mb and 1024mb, and parallelism between 1 and 16.
     */
    validateKdfConfigForSetting() {
        if (!Argon2KdfConfig.ITERATIONS.inRange(this.iterations)) {
            throw new Error(`Argon2 iterations must be between ${Argon2KdfConfig.ITERATIONS.min} and ${Argon2KdfConfig.ITERATIONS.max}`);
        }
        if (!Argon2KdfConfig.MEMORY.inRange(this.memory)) {
            throw new Error(`Argon2 memory must be between ${Argon2KdfConfig.MEMORY.min} MiB and ${Argon2KdfConfig.MEMORY.max} MiB`);
        }
        if (!Argon2KdfConfig.PARALLELISM.inRange(this.parallelism)) {
            throw new Error(`Argon2 parallelism must be between ${Argon2KdfConfig.PARALLELISM.min} and ${Argon2KdfConfig.PARALLELISM.max}.`);
        }
    }
    /**
     * Validates the Argon2 KDF configuration for pre-login.
     */
    validateKdfConfigForPrelogin() {
        if (Argon2KdfConfig.PRELOGIN_ITERATIONS_MIN > this.iterations) {
            throw new Error(`Argon2 iterations must be at least ${Argon2KdfConfig.PRELOGIN_ITERATIONS_MIN}, but was ${this.iterations}; possible pre-login downgrade attack detected.`);
        }
        if (Argon2KdfConfig.PRELOGIN_MEMORY_MIN > this.memory) {
            throw new Error(`Argon2 memory must be at least ${Argon2KdfConfig.PRELOGIN_MEMORY_MIN} MiB, but was ${this.memory} MiB; possible pre-login downgrade attack detected.`);
        }
        if (Argon2KdfConfig.PRELOGIN_PARALLELISM_MIN > this.parallelism) {
            throw new Error(`Argon2 parallelism must be at least ${Argon2KdfConfig.PRELOGIN_PARALLELISM_MIN}, but was ${this.parallelism}; possible pre-login downgrade attack detected.`);
        }
    }
    static fromJSON(json) {
        return new Argon2KdfConfig(json.iterations, json.memory, json.parallelism);
    }
    toSdkConfig() {
        return {
            argon2id: {
                iterations: this.iterations,
                memory: this.memory,
                parallelism: this.parallelism,
            },
        };
    }
}
Argon2KdfConfig.MEMORY = new RangeWithDefault(16, 1024, 64);
Argon2KdfConfig.PARALLELISM = new RangeWithDefault(1, 16, 4);
Argon2KdfConfig.ITERATIONS = new RangeWithDefault(2, 10, 3);
Argon2KdfConfig.PRELOGIN_MEMORY_MIN = 16;
Argon2KdfConfig.PRELOGIN_PARALLELISM_MIN = 1;
Argon2KdfConfig.PRELOGIN_ITERATIONS_MIN = 2;
const DEFAULT_KDF_CONFIG = new PBKDF2KdfConfig(PBKDF2KdfConfig.ITERATIONS.defaultValue);

;// ../../libs/key-management/src/kdf-config.service.ts
var kdf_config_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const KDF_CONFIG = new UserKeyDefinition(KDF_CONFIG_DISK, "kdfConfig", {
    deserializer: (kdfConfig) => {
        if (kdfConfig == null) {
            return null;
        }
        return kdfConfig.kdfType === kdf_type_enum_KdfType.PBKDF2_SHA256
            ? PBKDF2KdfConfig.fromJSON(kdfConfig)
            : Argon2KdfConfig.fromJSON(kdfConfig);
    },
    clearOn: ["logout"],
});
class DefaultKdfConfigService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
    }
    setKdfConfig(userId, kdfConfig) {
        return kdf_config_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("userId cannot be null");
            }
            if (kdfConfig == null) {
                throw new Error("kdfConfig cannot be null");
            }
            yield this.stateProvider.setUserState(KDF_CONFIG, kdfConfig, userId);
        });
    }
    getKdfConfig(userId) {
        return kdf_config_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("userId cannot be null");
            }
            const state = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, KDF_CONFIG).state$);
            if (state == null) {
                throw new Error("KdfConfig for user " + userId + " is null");
            }
            return state;
        });
    }
    getKdfConfig$(userId) {
        if (userId == null) {
            throw new Error("userId cannot be null");
        }
        return this.stateProvider.getUser(userId, KDF_CONFIG).state$;
    }
}

;// ../../libs/common/src/enums/feature-flag.enum.ts
/**
 * Feature flags.
 *
 * Flags MUST be short lived and SHALL be removed once enabled.
 *
 * Flags should be grouped by team to have visibility of ownership and cleanup.
 */
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var feature_flag_enum_FeatureFlag;
(function (FeatureFlag) {
    /* Admin Console Team */
    FeatureFlag["CreateDefaultLocation"] = "pm-19467-create-default-location";
    FeatureFlag["CollectionVaultRefactor"] = "pm-25030-resolve-ts-upgrade-errors";
    /* Auth */
    FeatureFlag["PM14938_BrowserExtensionLoginApproval"] = "pm-14938-browser-extension-login-approvals";
    /* Autofill */
    FeatureFlag["NotificationRefresh"] = "notification-refresh";
    FeatureFlag["MacOsNativeCredentialSync"] = "macos-native-credential-sync";
    FeatureFlag["WindowsDesktopAutotype"] = "windows-desktop-autotype";
    /* Billing */
    FeatureFlag["TrialPaymentOptional"] = "PM-8163-trial-payment";
    FeatureFlag["PM17772_AdminInitiatedSponsorships"] = "pm-17772-admin-initiated-sponsorships";
    FeatureFlag["UseOrganizationWarningsService"] = "use-organization-warnings-service";
    FeatureFlag["PM21881_ManagePaymentDetailsOutsideCheckout"] = "pm-21881-manage-payment-details-outside-checkout";
    FeatureFlag["PM21821_ProviderPortalTakeover"] = "pm-21821-provider-portal-takeover";
    FeatureFlag["PM22415_TaxIDWarnings"] = "pm-22415-tax-id-warnings";
    /* Key Management */
    FeatureFlag["PrivateKeyRegeneration"] = "pm-12241-private-key-regeneration";
    FeatureFlag["EnrollAeadOnKeyRotation"] = "enroll-aead-on-key-rotation";
    FeatureFlag["ForceUpdateKDFSettings"] = "pm-18021-force-update-kdf-settings";
    /* Tools */
    FeatureFlag["DesktopSendUIRefresh"] = "desktop-send-ui-refresh";
    FeatureFlag["UseSdkPasswordGenerators"] = "pm-19976-use-sdk-password-generators";
    FeatureFlag["UseChromiumImporter"] = "pm-23982-chromium-importer";
    /* DIRT */
    FeatureFlag["EventBasedOrganizationIntegrations"] = "event-based-organization-integrations";
    /* Vault */
    FeatureFlag["PM19941MigrateCipherDomainToSdk"] = "pm-19941-migrate-cipher-domain-to-sdk";
    FeatureFlag["PM22134SdkCipherListView"] = "pm-22134-sdk-cipher-list-view";
    FeatureFlag["PM22136_SdkCipherEncryption"] = "pm-22136-sdk-cipher-encryption";
    FeatureFlag["CipherKeyEncryption"] = "cipher-key-encryption";
    FeatureFlag["RemoveCardItemTypePolicy"] = "pm-16442-remove-card-item-type-policy";
    /* Platform */
    FeatureFlag["IpcChannelFramework"] = "ipc-channel-framework";
    FeatureFlag["InactiveUserServerNotification"] = "pm-25130-receive-push-notifications-for-inactive-users";
    FeatureFlag["PushNotificationsWhenLocked"] = "pm-19388-push-notifications-when-locked";
})(feature_flag_enum_FeatureFlag || (feature_flag_enum_FeatureFlag = {}));
// Helper to ensure the value is treated as a boolean.
const FALSE = false;
/**
 * Default value for feature flags.
 *
 * DO NOT enable previously disabled flags, REMOVE them instead.
 * We support true as a value as we prefer flags to "enable" not "disable".
 *
 * Flags should be grouped by team to have visibility of ownership and cleanup.
 */
const DefaultFeatureFlagValue = {
    /* Admin Console Team */
    [feature_flag_enum_FeatureFlag.CreateDefaultLocation]: FALSE,
    [feature_flag_enum_FeatureFlag.CollectionVaultRefactor]: FALSE,
    /* Autofill */
    [feature_flag_enum_FeatureFlag.NotificationRefresh]: FALSE,
    [feature_flag_enum_FeatureFlag.MacOsNativeCredentialSync]: FALSE,
    [feature_flag_enum_FeatureFlag.WindowsDesktopAutotype]: FALSE,
    /* Tools */
    [feature_flag_enum_FeatureFlag.DesktopSendUIRefresh]: FALSE,
    [feature_flag_enum_FeatureFlag.UseSdkPasswordGenerators]: FALSE,
    [feature_flag_enum_FeatureFlag.UseChromiumImporter]: FALSE,
    /* DIRT */
    [feature_flag_enum_FeatureFlag.EventBasedOrganizationIntegrations]: FALSE,
    /* Vault */
    [feature_flag_enum_FeatureFlag.CipherKeyEncryption]: FALSE,
    [feature_flag_enum_FeatureFlag.PM19941MigrateCipherDomainToSdk]: FALSE,
    [feature_flag_enum_FeatureFlag.RemoveCardItemTypePolicy]: FALSE,
    [feature_flag_enum_FeatureFlag.PM22134SdkCipherListView]: FALSE,
    [feature_flag_enum_FeatureFlag.PM22136_SdkCipherEncryption]: FALSE,
    /* Auth */
    [feature_flag_enum_FeatureFlag.PM14938_BrowserExtensionLoginApproval]: FALSE,
    /* Billing */
    [feature_flag_enum_FeatureFlag.TrialPaymentOptional]: FALSE,
    [feature_flag_enum_FeatureFlag.PM17772_AdminInitiatedSponsorships]: FALSE,
    [feature_flag_enum_FeatureFlag.UseOrganizationWarningsService]: FALSE,
    [feature_flag_enum_FeatureFlag.PM21881_ManagePaymentDetailsOutsideCheckout]: FALSE,
    [feature_flag_enum_FeatureFlag.PM21821_ProviderPortalTakeover]: FALSE,
    [feature_flag_enum_FeatureFlag.PM22415_TaxIDWarnings]: FALSE,
    /* Key Management */
    [feature_flag_enum_FeatureFlag.PrivateKeyRegeneration]: FALSE,
    [feature_flag_enum_FeatureFlag.EnrollAeadOnKeyRotation]: FALSE,
    [feature_flag_enum_FeatureFlag.ForceUpdateKDFSettings]: FALSE,
    /* Platform */
    [feature_flag_enum_FeatureFlag.IpcChannelFramework]: FALSE,
    [feature_flag_enum_FeatureFlag.InactiveUserServerNotification]: FALSE,
    [feature_flag_enum_FeatureFlag.PushNotificationsWhenLocked]: FALSE,
};
function getFeatureFlagValue(serverConfig, flag) {
    if ((serverConfig === null || serverConfig === void 0 ? void 0 : serverConfig.featureStates) == null || serverConfig.featureStates[flag] == null) {
        return DefaultFeatureFlagValue[flag];
    }
    return serverConfig.featureStates[flag];
}

;// ../../libs/key-management/src/user-asymmetric-key-regeneration/services/default-user-asymmetric-key-regeneration.service.ts
var default_user_asymmetric_key_regeneration_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class DefaultUserAsymmetricKeysRegenerationService {
    constructor(keyService, cipherService, userAsymmetricKeysRegenerationApiService, logService, sdkService, apiService, configService) {
        this.keyService = keyService;
        this.cipherService = cipherService;
        this.userAsymmetricKeysRegenerationApiService = userAsymmetricKeysRegenerationApiService;
        this.logService = logService;
        this.sdkService = sdkService;
        this.apiService = apiService;
        this.configService = configService;
    }
    regenerateIfNeeded(userId) {
        return default_user_asymmetric_key_regeneration_service_awaiter(this, void 0, void 0, function* () {
            try {
                const privateKeyRegenerationFlag = yield this.configService.getFeatureFlag(FeatureFlag.PrivateKeyRegeneration);
                if (privateKeyRegenerationFlag) {
                    const shouldRegenerate = yield this.shouldRegenerate(userId);
                    if (shouldRegenerate) {
                        yield this.regenerateUserAsymmetricKeys(userId);
                    }
                }
            }
            catch (error) {
                this.logService.error("[UserAsymmetricKeyRegeneration] An error occurred: " +
                    error +
                    " Skipping regeneration for the user.");
            }
        });
    }
    shouldRegenerate(userId) {
        return default_user_asymmetric_key_regeneration_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield firstValueFrom(this.keyService.userKey$(userId));
            // For SSO logins from untrusted devices, the userKey will not be available, and the private key regeneration process should be skipped.
            // In such cases, regeneration will occur on the following device login flow.
            if (!userKey) {
                this.logService.info("[UserAsymmetricKeyRegeneration] User symmetric key unavailable, skipping regeneration for the user.");
                return false;
            }
            if (userKey.inner().type === EncryptionType.CoseEncrypt0) {
                this.logService.error("[UserAsymmetricKeyRegeneration] Cannot regenerate asymmetric keys for accounts on V2 encryption.");
                return false;
            }
            const [userKeyEncryptedPrivateKey, publicKeyResponse] = yield firstValueFrom(combineLatest([
                this.keyService.userEncryptedPrivateKey$(userId),
                this.apiService.getUserPublicKey(userId),
            ]));
            if (!userKeyEncryptedPrivateKey || !publicKeyResponse) {
                this.logService.warning("[UserAsymmetricKeyRegeneration] User's asymmetric key initialization data is unavailable, skipping regeneration.");
                return false;
            }
            const verificationResponse = yield firstValueFrom(this.sdkService.client$.pipe(map((sdk) => {
                if (sdk === undefined) {
                    throw new Error("SDK is undefined");
                }
                return sdk.crypto().verify_asymmetric_keys({
                    userKey: userKey.keyB64,
                    userPublicKey: publicKeyResponse.publicKey,
                    userKeyEncryptedPrivateKey: userKeyEncryptedPrivateKey,
                });
            })));
            if (verificationResponse.privateKeyDecryptable) {
                if (verificationResponse.validPrivateKey) {
                    // The private key is decryptable and valid. Should not regenerate.
                    return false;
                }
                else {
                    // The private key is decryptable but not valid so we should regenerate it.
                    this.logService.info("[UserAsymmetricKeyRegeneration] User's private key is decryptable but not a valid key, attempting regeneration.");
                    return true;
                }
            }
            // The private isn't decryptable, check to see if we can decrypt something with the userKey.
            const userKeyCanDecrypt = yield this.userKeyCanDecrypt(userKey, userId);
            if (userKeyCanDecrypt) {
                this.logService.info("[UserAsymmetricKeyRegeneration] User Asymmetric Key decryption failure detected, attempting regeneration.");
                return true;
            }
            this.logService.warning("[UserAsymmetricKeyRegeneration] User Asymmetric Key decryption failure detected, but unable to determine User Symmetric Key validity, skipping regeneration.");
            return false;
        });
    }
    regenerateUserAsymmetricKeys(userId) {
        return default_user_asymmetric_key_regeneration_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield firstValueFrom(this.keyService.userKey$(userId));
            if (userKey == null) {
                throw new Error("User key not found");
            }
            const makeKeyPairResponse = yield firstValueFrom(this.sdkService.client$.pipe(map((sdk) => {
                if (sdk === undefined) {
                    throw new Error("SDK is undefined");
                }
                return sdk.crypto().make_key_pair(userKey.keyB64);
            })));
            try {
                yield this.userAsymmetricKeysRegenerationApiService.regenerateUserAsymmetricKeys(makeKeyPairResponse.userPublicKey, new EncString(makeKeyPairResponse.userKeyEncryptedPrivateKey));
            }
            catch (error) {
                if ((error === null || error === void 0 ? void 0 : error.message) === "Key regeneration not supported for this user.") {
                    this.logService.info("[UserAsymmetricKeyRegeneration] Regeneration not supported for this user at this time.");
                }
                else {
                    this.logService.error("[UserAsymmetricKeyRegeneration] Regeneration error when submitting the request to the server: " +
                        error);
                }
                return;
            }
            yield this.keyService.setPrivateKey(makeKeyPairResponse.userKeyEncryptedPrivateKey, userId);
            this.logService.info("[UserAsymmetricKeyRegeneration] User's asymmetric keys successfully regenerated.");
        });
    }
    userKeyCanDecrypt(userKey, userId) {
        return default_user_asymmetric_key_regeneration_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = yield this.cipherService.getAll(userId);
            const cipher = ciphers.find((cipher) => cipher.organizationId == null);
            if (!cipher) {
                return false;
            }
            try {
                const cipherView = yield cipher.decrypt(userKey);
                if (cipherView.decryptionFailure) {
                    this.logService.error("[UserAsymmetricKeyRegeneration] User Symmetric Key validation error: Cipher decryption failed");
                    return false;
                }
                return true;
            }
            catch (error) {
                this.logService.error("[UserAsymmetricKeyRegeneration] User Symmetric Key validation error: " + error);
                return false;
            }
        });
    }
}

;// ../../libs/key-management/src/user-asymmetric-key-regeneration/services/default-user-asymmetric-key-regeneration-api.service.ts
var default_user_asymmetric_key_regeneration_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class DefaultUserAsymmetricKeysRegenerationApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    regenerateUserAsymmetricKeys(userPublicKey, userKeyEncryptedUserPrivateKey) {
        return default_user_asymmetric_key_regeneration_api_service_awaiter(this, void 0, void 0, function* () {
            const request = {
                userPublicKey,
                userKeyEncryptedUserPrivateKey,
            };
            yield this.apiService.send("POST", "/accounts/key-management/regenerate-keys", request, true, true);
        });
    }
}

;// ../../libs/key-management/src/user-asymmetric-key-regeneration/index.ts





;// ../../libs/key-management/src/index.ts













;// ../../libs/common/src/auth/models/request/identity-token/device.request.ts
class DeviceRequest {
    constructor(appId, platformUtilsService) {
        this.type = platformUtilsService.getDevice();
        this.name = platformUtilsService.getDeviceString();
        this.identifier = appId;
        this.pushToken = null;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(DeviceRequest.prototype), json);
    }
}

;// ../../libs/common/src/auth/models/request/identity-token/token.request.ts
class TokenRequest {
    constructor(twoFactor, device) {
        this.twoFactor = twoFactor;
        this.device = device != null ? device : null;
    }
    setTwoFactor(twoFactor) {
        this.twoFactor = twoFactor;
    }
    setAuthRequestAccessCode(accessCode) {
        this.authRequest = accessCode;
    }
    toIdentityToken(clientId) {
        const obj = {
            scope: "api offline_access",
            client_id: clientId,
        };
        if (this.device) {
            obj.deviceType = this.device.type;
            obj.deviceIdentifier = this.device.identifier;
            obj.deviceName = this.device.name;
            // no push tokens for browser apps yet
            // obj.devicePushToken = this.device.pushToken;
        }
        //passswordless login
        if (this.authRequest) {
            obj.authRequest = this.authRequest;
        }
        if (this.twoFactor) {
            if (this.twoFactor.token && this.twoFactor.provider != null) {
                obj.twoFactorToken = this.twoFactor.token;
                obj.twoFactorProvider = this.twoFactor.provider;
                obj.twoFactorRemember = this.twoFactor.remember ? "1" : "0";
            }
        }
        return obj;
    }
}

;// ../../libs/common/src/auth/models/request/identity-token/password-token.request.ts



class PasswordTokenRequest extends TokenRequest {
    constructor(email, masterPasswordHash, twoFactor, device, newDeviceOtp) {
        super(twoFactor, device);
        this.email = email;
        this.masterPasswordHash = masterPasswordHash;
        this.twoFactor = twoFactor;
        this.newDeviceOtp = newDeviceOtp;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "password";
        obj.username = this.email;
        obj.password = this.masterPasswordHash;
        if (this.newDeviceOtp) {
            obj.newDeviceOtp = this.newDeviceOtp;
        }
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(PasswordTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// ../../libs/common/src/auth/enums/two-factor-provider-type.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var TwoFactorProviderType;
(function (TwoFactorProviderType) {
    TwoFactorProviderType[TwoFactorProviderType["Authenticator"] = 0] = "Authenticator";
    TwoFactorProviderType[TwoFactorProviderType["Email"] = 1] = "Email";
    TwoFactorProviderType[TwoFactorProviderType["Duo"] = 2] = "Duo";
    TwoFactorProviderType[TwoFactorProviderType["Yubikey"] = 3] = "Yubikey";
    TwoFactorProviderType[TwoFactorProviderType["U2f"] = 4] = "U2f";
    TwoFactorProviderType[TwoFactorProviderType["Remember"] = 5] = "Remember";
    TwoFactorProviderType[TwoFactorProviderType["OrganizationDuo"] = 6] = "OrganizationDuo";
    TwoFactorProviderType[TwoFactorProviderType["WebAuthn"] = 7] = "WebAuthn";
    TwoFactorProviderType[TwoFactorProviderType["RecoveryCode"] = 8] = "RecoveryCode";
})(TwoFactorProviderType || (TwoFactorProviderType = {}));

;// ../../libs/common/src/auth/models/domain/auth-result.ts
class AuthResult {
    constructor() {
        // TODO: PM-3287 - Remove this after 3 releases of backwards compatibility. - Target release 2023.12 for removal
        /**
         * @deprecated
         * Replace with using UserDecryptionOptions to determine if the user does
         * not have a master password and is not using Key Connector.
         * */
        this.resetMasterPassword = false;
        this.twoFactorProviders = null;
    }
    get requiresTwoFactor() {
        return this.twoFactorProviders != null;
    }
}

;// ../../libs/common/src/auth/models/domain/force-set-password-reason.ts
/**
 * This enum is used to determine if a user should be forced to set an initial password or
 * change their existing password upon login (communicated via server flag) or upon unlocking
 * with their master password (set via client evaluation).
 */
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var ForceSetPasswordReason;
(function (ForceSetPasswordReason) {
    /**
     * A password set/change should not be forced.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["None"] = 0] = "None";
    /*--------------------------
        Set Initial Password
    ---------------------------*/
    /**
     * Occurs when a user JIT provisions into a master-password-encryption org via SSO and must set their initial password.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["SsoNewJitProvisionedUser"] = 1] = "SsoNewJitProvisionedUser";
    /**
     * Occurs when a TDE org user without a password obtains the password reset ("manage account recovery")
     * permission, which requires the TDE user to have/set a password.
     *
     * Set post login & decryption client side and by server in sync (to catch logged in users).
     */
    ForceSetPasswordReason[ForceSetPasswordReason["TdeUserWithoutPasswordHasPasswordResetPermission"] = 2] = "TdeUserWithoutPasswordHasPasswordResetPermission";
    /**
     * Occurs when an org admin switches the org from trusted-device-encryption to master-password-encryption,
     * which forces the org user to set an initial password. User must not already have a master password,
     * and they must be on a previously trusted device.
     *
     * Communicated via server flag.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["TdeOffboarding"] = 3] = "TdeOffboarding";
    /**
     * Occurs when an org admin switches the org from trusted-device-encryption to master-password-encryption,
     * which forces the org user to set an initial password. User must not already have a master password,
     * and they must be on an untrusted device.
     *
     * Calculated on client based on server flags and user state.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["TdeOffboardingUntrustedDevice"] = 4] = "TdeOffboardingUntrustedDevice";
    /*----------------------------
        Change Existing Password
    -----------------------------*/
    /**
     * Occurs when an org admin forces a user to change their password via Account Recovery.
     *
     * Communicated via server flag.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["AdminForcePasswordReset"] = 5] = "AdminForcePasswordReset";
    /**
     * Occurs when a user logs in / unlocks their vault with a master password that does not meet an org's
     * master password policy that is enforced on login/unlock.
     *
     * Only set client side b/c server can't evaluate MP.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["WeakMasterPassword"] = 6] = "WeakMasterPassword";
})(ForceSetPasswordReason || (ForceSetPasswordReason = {}));

;// ../../libs/common/src/auth/models/response/identity-device-verification.response.ts

class IdentityDeviceVerificationResponse extends BaseResponse {
    constructor(response) {
        var _a;
        super(response);
        this.deviceVerified = (_a = this.getResponseProperty("DeviceVerified")) !== null && _a !== void 0 ? _a : false;
    }
}

;// ../../libs/common/src/auth/models/response/master-password-policy.response.ts

class MasterPasswordPolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.minComplexity = this.getResponseProperty("MinComplexity");
        this.minLength = this.getResponseProperty("MinLength");
        this.requireUpper = this.getResponseProperty("RequireUpper");
        this.requireLower = this.getResponseProperty("RequireLower");
        this.requireNumbers = this.getResponseProperty("RequireNumbers");
        this.requireSpecial = this.getResponseProperty("RequireSpecial");
        this.enforceOnLogin = this.getResponseProperty("EnforceOnLogin");
    }
}

;// ../../libs/common/src/auth/models/response/user-decryption-options/key-connector-user-decryption-option.response.ts

class KeyConnectorUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
    }
}

;// ../../libs/common/src/auth/models/response/user-decryption-options/trusted-device-user-decryption-option.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class TrustedDeviceUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasAdminApproval = this.getResponseProperty("HasAdminApproval");
        this.hasLoginApprovingDevice = this.getResponseProperty("HasLoginApprovingDevice");
        this.hasManageResetPasswordPermission = this.getResponseProperty("HasManageResetPasswordPermission");
        this.isTdeOffboarding = this.getResponseProperty("IsTdeOffboarding");
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new enc_string_EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new enc_string_EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// ../../libs/common/src/auth/models/response/user-decryption-options/webauthn-prf-decryption-option.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore


class WebAuthnPrfDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new enc_string_EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new enc_string_EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// ../../libs/common/src/auth/models/response/user-decryption-options/user-decryption-options.response.ts




class UserDecryptionOptionsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        if (response.TrustedDeviceOption) {
            this.trustedDeviceOption = new TrustedDeviceUserDecryptionOptionResponse(this.getResponseProperty("TrustedDeviceOption"));
        }
        if (response.KeyConnectorOption) {
            this.keyConnectorOption = new KeyConnectorUserDecryptionOptionResponse(this.getResponseProperty("KeyConnectorOption"));
        }
        if (response.WebAuthnPrfOption) {
            this.webAuthnPrfOption = new WebAuthnPrfDecryptionOptionResponse(this.getResponseProperty("WebAuthnPrfOption"));
        }
    }
}

;// ../../libs/common/src/auth/models/response/identity-token.response.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
// This import has been flagged as unallowed for this class. It may be involved in a circular dependency loop.
// eslint-disable-next-line no-restricted-imports





class IdentityTokenResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.accessToken = response.access_token;
        this.expiresIn = response.expires_in;
        this.refreshToken = response.refresh_token;
        this.tokenType = response.token_type;
        this.resetMasterPassword = this.getResponseProperty("ResetMasterPassword");
        this.privateKey = this.getResponseProperty("PrivateKey");
        const key = this.getResponseProperty("Key");
        if (key) {
            this.key = new enc_string_EncString(key);
        }
        this.twoFactorToken = this.getResponseProperty("TwoFactorToken");
        const kdf = this.getResponseProperty("Kdf");
        const kdfIterations = this.getResponseProperty("KdfIterations");
        const kdfMemory = this.getResponseProperty("KdfMemory");
        const kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.kdfConfig =
            kdf == kdf_type_enum_KdfType.PBKDF2_SHA256
                ? new PBKDF2KdfConfig(kdfIterations)
                : new Argon2KdfConfig(kdfIterations, kdfMemory, kdfParallelism);
        this.forcePasswordReset = this.getResponseProperty("ForcePasswordReset");
        this.apiUseKeyConnector = this.getResponseProperty("ApiUseKeyConnector");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        if (response.UserDecryptionOptions) {
            this.userDecryptionOptions = new UserDecryptionOptionsResponse(this.getResponseProperty("UserDecryptionOptions"));
        }
    }
    hasMasterKeyEncryptedUserKey() {
        return Boolean(this.key);
    }
}

;// ../../libs/common/src/auth/models/response/identity-two-factor.response.ts


class IdentityTwoFactorResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.twoFactorProviders = this.getResponseProperty("TwoFactorProviders");
        this.twoFactorProviders2 = this.getResponseProperty("TwoFactorProviders2");
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        this.ssoEmail2faSessionToken = this.getResponseProperty("SsoEmail2faSessionToken");
        this.email = this.getResponseProperty("Email");
    }
}

;// ../../libs/common/src/models/request/keys.request.ts
class KeysRequest {
    constructor(publicKey, encryptedPrivateKey) {
        this.publicKey = publicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// ../../libs/auth/src/common/login-strategies/login.strategy.ts
var login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












class LoginStrategyData {
}
class LoginStrategy {
    constructor(accountService, masterPasswordService, keyService, encryptService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, userDecryptionOptionsService, billingAccountProfileStateService, vaultTimeoutSettingsService, KdfConfigService, environmentService, configService) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.keyService = keyService;
        this.encryptService = encryptService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.billingAccountProfileStateService = billingAccountProfileStateService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.KdfConfigService = KdfConfigService;
        this.environmentService = environmentService;
        this.configService = configService;
        this.sessionTimeoutSubject = new external_rxjs_namespaceObject.BehaviorSubject(false);
        this.sessionTimeout$ = this.sessionTimeoutSubject.asObservable();
    }
    logInTwoFactor(twoFactor) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            if (!data.tokenRequest) {
                throw new Error("Token request is undefined");
            }
            data.tokenRequest.setTwoFactor(twoFactor);
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    startLogIn() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.twoFactorService.clearSelectedProvider();
            const tokenRequest = this.cache.value.tokenRequest;
            if (!tokenRequest) {
                throw new Error("Token request is undefined");
            }
            const response = yield this.apiService.postIdentityToken(tokenRequest);
            if (response instanceof IdentityTwoFactorResponse) {
                return [yield this.processTwoFactorResponse(response), response];
            }
            else if (response instanceof IdentityTokenResponse) {
                return [yield this.processTokenResponse(response), response];
            }
            else if (response instanceof IdentityDeviceVerificationResponse) {
                return [yield this.processDeviceVerificationResponse(response), response];
            }
            throw new Error("Invalid response object.");
        });
    }
    buildDeviceRequest() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const appId = yield this.appIdService.getAppId();
            return new DeviceRequest(appId, this.platformUtilsService);
        });
    }
    /**
     * Builds the TokenTwoFactorRequest to be used within other login strategies token requests
     * to the server.
     * If the user provided a 2FA token in an already created TokenTwoFactorRequest, it will be used.
     * If not, and the user has previously remembered a 2FA token, it will be used.
     * If neither of these are true, an empty TokenTwoFactorRequest will be returned.
     * @param userProvidedTwoFactor - optional - The 2FA token request provided by the caller
     * @param email - optional - ensure that email is provided for any login strategies that support remember 2FA functionality
     * @returns a promise which resolves to a TokenTwoFactorRequest to be sent to the server
     */
    buildTwoFactor(userProvidedTwoFactor, email) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            if (userProvidedTwoFactor != null) {
                return userProvidedTwoFactor;
            }
            if (email) {
                const storedTwoFactorToken = yield this.tokenService.getTwoFactorToken(email);
                if (storedTwoFactorToken != null) {
                    return new TokenTwoFactorRequest(TwoFactorProviderType.Remember, storedTwoFactorToken, false);
                }
            }
            return new TokenTwoFactorRequest();
        });
    }
    /**
     * Initializes the account with information from the IdTokenResponse after successful login.
     * It also sets the access token and refresh token in the token service.
     *
     * @param {IdentityTokenResponse} tokenResponse - The response from the server containing the identity token.
     * @returns {Promise<UserId>} - A promise that resolves the the UserId when the account information has been successfully saved.
     */
    saveAccountInformation(tokenResponse) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c;
            const accountInformation = yield this.tokenService.decodeAccessToken(tokenResponse.accessToken);
            const userId = accountInformation.sub;
            yield this.accountService.addAccount(userId, {
                name: accountInformation.name,
                email: (_a = accountInformation.email) !== null && _a !== void 0 ? _a : "",
                emailVerified: (_b = accountInformation.email_verified) !== null && _b !== void 0 ? _b : false,
            });
            // User env must be seeded from currently set env before switching to the account
            // to avoid any incorrect emissions of the global default env.
            yield this.environmentService.seedUserEnvironment(userId);
            yield this.accountService.switchAccount(userId);
            yield this.verifyAccountAdded(userId);
            // We must set user decryption options before retrieving vault timeout settings
            // as the user decryption options help determine the available timeout actions.
            yield this.userDecryptionOptionsService.setUserDecryptionOptions(UserDecryptionOptions.fromResponse(tokenResponse));
            const vaultTimeoutAction = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutActionByUserId$(userId));
            const vaultTimeout = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutByUserId$(userId));
            // User id will be derived from the access token.
            yield this.tokenService.setTokens(tokenResponse.accessToken, vaultTimeoutAction, vaultTimeout, tokenResponse.refreshToken);
            yield this.KdfConfigService.setKdfConfig(userId, tokenResponse.kdfConfig);
            yield this.billingAccountProfileStateService.setHasPremium((_c = accountInformation.premium) !== null && _c !== void 0 ? _c : false, false, userId);
            return userId;
        });
    }
    processTokenResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            // Encryption key migration of legacy users (with no userkey) is not supported anymore
            if (this.encryptionKeyMigrationRequired(response)) {
                result.requiresEncryptionKeyMigration = true;
                return result;
            }
            // Must come before setting keys, user key needs email to update additional keys.
            const userId = yield this.saveAccountInformation(response);
            result.userId = userId;
            result.resetMasterPassword = response.resetMasterPassword;
            if (response.twoFactorToken != null) {
                // note: we can read email from access token b/c it was saved in saveAccountInformation
                const userEmail = yield this.tokenService.getEmail();
                yield this.tokenService.setTwoFactorToken(userEmail, response.twoFactorToken);
            }
            yield this.setMasterKey(response, userId);
            yield this.setUserKey(response, userId);
            yield this.setPrivateKey(response, userId);
            // This needs to run after the keys are set because it checks for the existence of the encrypted private key
            yield this.processForceSetPasswordReason(response.forcePasswordReset, userId);
            this.messagingService.send("loggedIn");
            return result;
        });
    }
    // Old accounts used master key for encryption. We are forcing migrations but only need to
    // check on password logins
    encryptionKeyMigrationRequired(response) {
        return false;
    }
    /**
     * Checks if adminForcePasswordReset is true and sets the ForceSetPasswordReason.AdminForcePasswordReset flag in the master password service.
     * @param adminForcePasswordReset - The admin force password reset flag
     * @param userId - The user ID
     * @returns a promise that resolves to a boolean indicating whether the admin force password reset flag was set
     */
    processForceSetPasswordReason(adminForcePasswordReset, userId) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            if (!adminForcePasswordReset) {
                return false;
            }
            // set the flag in the master password service so we know when we reach the auth guard
            // that we need to guide them properly to admin password reset.
            yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.AdminForcePasswordReset, userId);
            return true;
        });
    }
    createKeyPairForOldAccount(userId) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            try {
                const userKey = yield this.keyService.getUserKey(userId);
                if (userKey.inner().type == encryption_type_enum_EncryptionType.CoseEncrypt0) {
                    throw new Error("Cannot create key pair for account on V2 encryption");
                }
                const [publicKey, privateKey] = yield this.keyService.makeKeyPair(userKey);
                if (!privateKey.encryptedString) {
                    throw new Error("Failed to create encrypted private key");
                }
                yield this.apiService.postAccountKeys(new KeysRequest(publicKey, privateKey.encryptedString));
                return privateKey.encryptedString;
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
    /**
     * Handles the response from the server when a 2FA is required.
     * It clears any existing 2FA token, as it's no longer valid, and sets up the necessary data for the 2FA process.
     *
     * @param {IdentityTwoFactorResponse} response - The response from the server indicating that 2FA is required.
     * @returns {Promise<AuthResult>} - A promise that resolves to an AuthResult object
     */
    processTwoFactorResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            // If we get a 2FA required response, then we should clear the 2FA token
            // just in case as it is no longer valid.
            yield this.clearTwoFactorToken();
            const result = new AuthResult();
            result.twoFactorProviders = response.twoFactorProviders2;
            yield this.twoFactorService.setProviders(response);
            result.ssoEmail2FaSessionToken = response.ssoEmail2faSessionToken;
            result.email = (_a = response.email) !== null && _a !== void 0 ? _a : "";
            return result;
        });
    }
    /**
     * Clears the 2FA token from the token service using the user's email if it exists
     */
    clearTwoFactorToken() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const email = this.cache.value.userEnteredEmail;
            if (email) {
                yield this.tokenService.clearTwoFactorToken(email);
            }
        });
    }
    /**
     * Verifies that the active account is set after initialization.
     * Note: In browser there is a slight delay between when active account emits in background,
     * and when it emits in foreground. We're giving the foreground 1 second to catch up.
     * If nothing is emitted, we throw an error.
     */
    verifyAccountAdded(expectedUserId) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.filter)((account) => (account === null || account === void 0 ? void 0 : account.id) === expectedUserId), (0,external_rxjs_namespaceObject.timeout)({
                first: 1000,
                with: () => {
                    throw new Error("Expected user never made active user after initialization.");
                },
            })));
        });
    }
    /**
     * Handles the response from the server when a device verification is required.
     * It sets the requiresDeviceVerification flag to true.
     *
     * @param {IdentityDeviceVerificationResponse} response - The response from the server indicating that device verification is required.
     * @returns {Promise<AuthResult>} - A promise that resolves to an AuthResult object
     */
    processDeviceVerificationResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.requiresDeviceVerification = true;
            return result;
        });
    }
}

;// ../../libs/auth/src/common/login-strategies/auth-request-login.strategy.ts
var auth_request_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore




class AuthRequestLoginStrategyData {
    static fromJSON(obj) {
        const data = Object.assign(new AuthRequestLoginStrategyData(), obj, {
            tokenRequest: PasswordTokenRequest.fromJSON(obj.tokenRequest),
            authRequestCredentials: AuthRequestLoginCredentials.fromJSON(obj.authRequestCredentials),
        });
        return data;
    }
}
class AuthRequestLoginStrategy extends LoginStrategy {
    constructor(data, deviceTrustService, ...sharedDeps) {
        super(...sharedDeps);
        this.deviceTrustService = deviceTrustService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.tokenRequest.email));
        this.accessCode$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.authRequestCredentials.accessCode));
        this.authRequestId$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((data) => data.authRequestCredentials.authRequestId));
    }
    logIn(credentials) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new AuthRequestLoginStrategyData();
            data.tokenRequest = new PasswordTokenRequest(credentials.email, credentials.accessCode, yield this.buildTwoFactor(credentials.twoFactor, credentials.email), yield this.buildDeviceRequest());
            data.tokenRequest.setAuthRequestAccessCode(credentials.authRequestId);
            data.authRequestCredentials = credentials;
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    logInTwoFactor(twoFactor) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            this.cache.next(data);
            return _super.logInTwoFactor.call(this, twoFactor);
        });
    }
    setMasterKey(response, userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const authRequestCredentials = this.cache.value.authRequestCredentials;
            if (authRequestCredentials.decryptedMasterKey &&
                authRequestCredentials.decryptedMasterKeyHash) {
                yield this.masterPasswordService.setMasterKey(authRequestCredentials.decryptedMasterKey, userId);
                yield this.masterPasswordService.setMasterKeyHash(authRequestCredentials.decryptedMasterKeyHash, userId);
            }
        });
    }
    setUserKey(response, userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const authRequestCredentials = this.cache.value.authRequestCredentials;
            // User now may or may not have a master password
            // but set the master key encrypted user key if it exists regardless
            if (response.key) {
                yield this.masterPasswordService.setMasterKeyEncryptedUserKey(response.key, userId);
            }
            if (authRequestCredentials.decryptedUserKey) {
                yield this.keyService.setUserKey(authRequestCredentials.decryptedUserKey, userId);
            }
            else {
                yield this.trySetUserKeyWithMasterKey(userId);
                // Establish trust if required after setting user key
                yield this.deviceTrustService.trustDeviceIfRequired(userId);
            }
        });
    }
    trySetUserKeyWithMasterKey(userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (masterKey) {
                const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey, userId);
                yield this.keyService.setUserKey(userKey, userId);
            }
        });
    }
    setPrivateKey(response, userId) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            yield this.keyService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    exportCache() {
        return {
            authRequest: this.cache.value,
        };
    }
}

;// ../../libs/auth/src/common/login-strategies/password-login.strategy.ts
var password_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore









class PasswordLoginStrategyData {
    constructor() {
        /**
         * Tracks if the user needs to update their password due to
         * a password that does not meet an organization's master password policy.
         */
        this.forcePasswordResetReason = ForceSetPasswordReason.None;
    }
    static fromJSON(obj) {
        const data = Object.assign(new PasswordLoginStrategyData(), obj, {
            tokenRequest: PasswordTokenRequest.fromJSON(obj.tokenRequest),
            masterKey: SymmetricCryptoKey.fromJSON(obj.masterKey),
        });
        return data;
    }
}
class PasswordLoginStrategy extends LoginStrategy {
    constructor(data, passwordStrengthService, policyService, loginStrategyService, ...sharedDeps) {
        super(...sharedDeps);
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.loginStrategyService = loginStrategyService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.tokenRequest.email));
        this.serverMasterKeyHash$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.tokenRequest.masterPasswordHash));
        this.localMasterKeyHash$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.localMasterKeyHash));
    }
    logIn(credentials) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { email, masterPassword, twoFactor } = credentials;
            const data = new PasswordLoginStrategyData();
            data.masterKey = yield this.loginStrategyService.makePreloginKey(masterPassword, email);
            data.userEnteredEmail = email;
            // Hash the password early (before authentication) so we don't persist it in memory in plaintext
            data.localMasterKeyHash = yield this.keyService.hashMasterKey(masterPassword, data.masterKey, HashPurpose.LocalAuthorization);
            const serverMasterKeyHash = yield this.keyService.hashMasterKey(masterPassword, data.masterKey);
            data.tokenRequest = new PasswordTokenRequest(email, serverMasterKeyHash, yield this.buildTwoFactor(twoFactor, email), yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult, identityResponse] = yield this.startLogIn();
            yield this.evaluateMasterPasswordIfRequired(identityResponse, credentials, authResult);
            return authResult;
        });
    }
    logInTwoFactor(twoFactor) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = yield _super.logInTwoFactor.call(this, twoFactor);
            return result;
        });
    }
    setMasterKey(response, userId) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { masterKey, localMasterKeyHash } = this.cache.value;
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            yield this.masterPasswordService.setMasterKeyHash(localMasterKeyHash, userId);
        });
    }
    setUserKey(response, userId) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            // If migration is required, we won't have a user key to set yet.
            if (this.encryptionKeyMigrationRequired(response)) {
                return;
            }
            if (response.key) {
                yield this.masterPasswordService.setMasterKeyEncryptedUserKey(response.key, userId);
            }
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            if (masterKey) {
                const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey, userId);
                yield this.keyService.setUserKey(userKey, userId);
            }
        });
    }
    setPrivateKey(response, userId) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            yield this.keyService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    encryptionKeyMigrationRequired(response) {
        return !response.key;
    }
    evaluateMasterPasswordIfRequired(identityResponse, credentials, authResult) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            // TODO: PM-21084 - investigate if we should be sending down masterPasswordPolicy on the
            // IdentityDeviceVerificationResponse like we do for the IdentityTwoFactorResponse
            // If the response is a device verification response, we don't need to evaluate the password
            if (identityResponse instanceof IdentityDeviceVerificationResponse) {
                return;
            }
            // The identity result can contain master password policies for the user's organizations.
            // Get the master password policy options from both the org invite and the identity response.
            const masterPasswordPolicyOptions = this.policyService.combineMasterPasswordPolicyOptions(credentials.masterPasswordPoliciesFromOrgInvite, this.getMasterPasswordPolicyOptionsFromResponse(identityResponse));
            // We deliberately do not check enforceOnLogin as existing users who are logging
            // in after getting an org invite should always be forced to set a password that
            // meets the org's policy. Org Invite -> Registration also works this way for
            // new BW users as well.
            if (!credentials.masterPasswordPoliciesFromOrgInvite &&
                !(masterPasswordPolicyOptions === null || masterPasswordPolicyOptions === void 0 ? void 0 : masterPasswordPolicyOptions.enforceOnLogin)) {
                return;
            }
            // If there is a policy active, evaluate the supplied password before its no longer in memory
            const meetsRequirements = this.evaluateMasterPassword(credentials, masterPasswordPolicyOptions);
            if (meetsRequirements) {
                return;
            }
            if (identityResponse instanceof IdentityTwoFactorResponse) {
                // Save the flag to this strategy for use in 2fa as the master password is about to pass out of scope
                this.cache.next(Object.assign(Object.assign({}, this.cache.value), { forcePasswordResetReason: ForceSetPasswordReason.WeakMasterPassword }));
                return;
            }
            // Authentication was successful, save the force update password options with the state service
            // if there isn't already a reason set (this would only be AdminForcePasswordReset as that can be set server side
            // and would have already been processed in the base login strategy processForceSetPasswordReason method)
            // Note: masterPasswordService.setForceSetPasswordReason will not allow overwriting
            // AdminForcePasswordReset with any other reason except for None. This is because
            // an AdminForcePasswordReset will always force a user to update their password to a password that meets the policy.
            yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.WeakMasterPassword, authResult.userId);
        });
    }
    getMasterPasswordPolicyOptionsFromResponse(response) {
        if (response == null) {
            return null;
        }
        return MasterPasswordPolicyOptions.fromResponse(response.masterPasswordPolicy);
    }
    evaluateMasterPassword({ masterPassword, email }, options) {
        var _a;
        const passwordStrength = (_a = this.passwordStrengthService.getPasswordStrength(masterPassword, email)) === null || _a === void 0 ? void 0 : _a.score;
        return this.policyService.evaluateMasterPassword(passwordStrength, masterPassword, options);
    }
    exportCache() {
        return {
            password: this.cache.value,
        };
    }
    logInNewDeviceVerification(deviceVerificationOtp) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = this.cache.value;
            data.tokenRequest.newDeviceOtp = deviceVerificationOtp;
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    /**
     * Override to handle the WeakMasterPassword reason if no other reason is set.
     * @param authResult - The authentication result
     * @param userId - The user ID
     */
    processForceSetPasswordReason(adminForcePasswordReset, userId) {
        const _super = Object.create(null, {
            processForceSetPasswordReason: { get: () => super.processForceSetPasswordReason }
        });
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            // handle any existing reasons
            const adminForcePasswordResetFlagSet = yield _super.processForceSetPasswordReason.call(this, adminForcePasswordReset, userId);
            // If we are already processing an admin force password reset, don't process other reasons
            if (adminForcePasswordResetFlagSet) {
                return false;
            }
            // If we have a cached weak password reason from login/logInTwoFactor apply it
            const cachedReason = this.cache.value.forcePasswordResetReason;
            if (cachedReason !== ForceSetPasswordReason.None) {
                yield this.masterPasswordService.setForceSetPasswordReason(cachedReason, userId);
                return true;
            }
            // If none of the conditions are met, return false
            return false;
        });
    }
}

;// ../../libs/common/src/auth/models/request/identity-token/sso-token.request.ts



class SsoTokenRequest extends TokenRequest {
    constructor(code, codeVerifier, redirectUri, twoFactor, device) {
        super(twoFactor, device);
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUri = redirectUri;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "authorization_code";
        obj.code = this.code;
        obj.code_verifier = this.codeVerifier;
        obj.redirect_uri = this.redirectUri;
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(SsoTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// ../../libs/client-type/src/index.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var src_ClientType;
(function (ClientType) {
    ClientType["Web"] = "web";
    ClientType["Browser"] = "browser";
    ClientType["Desktop"] = "desktop";
    // Mobile = "mobile",
    ClientType["Cli"] = "cli";
    // DirectoryConnector = "connector",
})(src_ClientType || (src_ClientType = {}));

;// ../../libs/common/src/enums/client-type.enum.ts


;// ../../libs/common/src/enums/device-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var DeviceType;
(function (DeviceType) {
    DeviceType[DeviceType["Android"] = 0] = "Android";
    DeviceType[DeviceType["iOS"] = 1] = "iOS";
    DeviceType[DeviceType["ChromeExtension"] = 2] = "ChromeExtension";
    DeviceType[DeviceType["FirefoxExtension"] = 3] = "FirefoxExtension";
    DeviceType[DeviceType["OperaExtension"] = 4] = "OperaExtension";
    DeviceType[DeviceType["EdgeExtension"] = 5] = "EdgeExtension";
    DeviceType[DeviceType["WindowsDesktop"] = 6] = "WindowsDesktop";
    DeviceType[DeviceType["MacOsDesktop"] = 7] = "MacOsDesktop";
    DeviceType[DeviceType["LinuxDesktop"] = 8] = "LinuxDesktop";
    DeviceType[DeviceType["ChromeBrowser"] = 9] = "ChromeBrowser";
    DeviceType[DeviceType["FirefoxBrowser"] = 10] = "FirefoxBrowser";
    DeviceType[DeviceType["OperaBrowser"] = 11] = "OperaBrowser";
    DeviceType[DeviceType["EdgeBrowser"] = 12] = "EdgeBrowser";
    DeviceType[DeviceType["IEBrowser"] = 13] = "IEBrowser";
    DeviceType[DeviceType["UnknownBrowser"] = 14] = "UnknownBrowser";
    DeviceType[DeviceType["AndroidAmazon"] = 15] = "AndroidAmazon";
    DeviceType[DeviceType["UWP"] = 16] = "UWP";
    DeviceType[DeviceType["SafariBrowser"] = 17] = "SafariBrowser";
    DeviceType[DeviceType["VivaldiBrowser"] = 18] = "VivaldiBrowser";
    DeviceType[DeviceType["VivaldiExtension"] = 19] = "VivaldiExtension";
    DeviceType[DeviceType["SafariExtension"] = 20] = "SafariExtension";
    DeviceType[DeviceType["SDK"] = 21] = "SDK";
    DeviceType[DeviceType["Server"] = 22] = "Server";
    DeviceType[DeviceType["WindowsCLI"] = 23] = "WindowsCLI";
    DeviceType[DeviceType["MacOsCLI"] = 24] = "MacOsCLI";
    DeviceType[DeviceType["LinuxCLI"] = 25] = "LinuxCLI";
    DeviceType[DeviceType["DuckDuckGoBrowser"] = 26] = "DuckDuckGoBrowser";
})(DeviceType || (DeviceType = {}));
const DeviceTypeMetadata = {
    [DeviceType.Android]: { category: "mobile", platform: "Android" },
    [DeviceType.iOS]: { category: "mobile", platform: "iOS" },
    [DeviceType.AndroidAmazon]: { category: "mobile", platform: "Amazon" },
    [DeviceType.ChromeExtension]: { category: "extension", platform: "Chrome" },
    [DeviceType.FirefoxExtension]: { category: "extension", platform: "Firefox" },
    [DeviceType.OperaExtension]: { category: "extension", platform: "Opera" },
    [DeviceType.EdgeExtension]: { category: "extension", platform: "Edge" },
    [DeviceType.VivaldiExtension]: { category: "extension", platform: "Vivaldi" },
    [DeviceType.SafariExtension]: { category: "extension", platform: "Safari" },
    [DeviceType.ChromeBrowser]: { category: "webApp", platform: "Chrome" },
    [DeviceType.FirefoxBrowser]: { category: "webApp", platform: "Firefox" },
    [DeviceType.OperaBrowser]: { category: "webApp", platform: "Opera" },
    [DeviceType.EdgeBrowser]: { category: "webApp", platform: "Edge" },
    [DeviceType.IEBrowser]: { category: "webApp", platform: "IE" },
    [DeviceType.SafariBrowser]: { category: "webApp", platform: "Safari" },
    [DeviceType.VivaldiBrowser]: { category: "webApp", platform: "Vivaldi" },
    [DeviceType.DuckDuckGoBrowser]: { category: "webApp", platform: "DuckDuckGo" },
    [DeviceType.UnknownBrowser]: { category: "webApp", platform: "Unknown" },
    [DeviceType.WindowsDesktop]: { category: "desktop", platform: "Windows" },
    [DeviceType.MacOsDesktop]: { category: "desktop", platform: "macOS" },
    [DeviceType.LinuxDesktop]: { category: "desktop", platform: "Linux" },
    [DeviceType.UWP]: { category: "desktop", platform: "Windows UWP" },
    [DeviceType.WindowsCLI]: { category: "cli", platform: "Windows" },
    [DeviceType.MacOsCLI]: { category: "cli", platform: "macOS" },
    [DeviceType.LinuxCLI]: { category: "cli", platform: "Linux" },
    [DeviceType.SDK]: { category: "sdk", platform: "" },
    [DeviceType.Server]: { category: "server", platform: "" },
};

;// ../../libs/common/src/enums/event-system-user.enum.ts
// Note: the enum key is used to describe the EventSystemUser in the UI. Be careful about changing it.
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var EventSystemUser;
(function (EventSystemUser) {
    EventSystemUser[EventSystemUser["SCIM"] = 1] = "SCIM";
    EventSystemUser[EventSystemUser["DomainVerification"] = 2] = "DomainVerification";
    EventSystemUser[EventSystemUser["PublicApi"] = 3] = "PublicApi";
})(EventSystemUser || (EventSystemUser = {}));

;// ../../libs/common/src/enums/event-type.enum.ts
// Increment by 100 for each new set of events
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var EventType;
(function (EventType) {
    EventType[EventType["User_LoggedIn"] = 1000] = "User_LoggedIn";
    EventType[EventType["User_ChangedPassword"] = 1001] = "User_ChangedPassword";
    EventType[EventType["User_Updated2fa"] = 1002] = "User_Updated2fa";
    EventType[EventType["User_Disabled2fa"] = 1003] = "User_Disabled2fa";
    EventType[EventType["User_Recovered2fa"] = 1004] = "User_Recovered2fa";
    EventType[EventType["User_FailedLogIn"] = 1005] = "User_FailedLogIn";
    EventType[EventType["User_FailedLogIn2fa"] = 1006] = "User_FailedLogIn2fa";
    EventType[EventType["User_ClientExportedVault"] = 1007] = "User_ClientExportedVault";
    EventType[EventType["User_UpdatedTempPassword"] = 1008] = "User_UpdatedTempPassword";
    EventType[EventType["User_MigratedKeyToKeyConnector"] = 1009] = "User_MigratedKeyToKeyConnector";
    EventType[EventType["User_RequestedDeviceApproval"] = 1010] = "User_RequestedDeviceApproval";
    EventType[EventType["User_TdeOffboardingPasswordSet"] = 1011] = "User_TdeOffboardingPasswordSet";
    EventType[EventType["Cipher_Created"] = 1100] = "Cipher_Created";
    EventType[EventType["Cipher_Updated"] = 1101] = "Cipher_Updated";
    EventType[EventType["Cipher_Deleted"] = 1102] = "Cipher_Deleted";
    EventType[EventType["Cipher_AttachmentCreated"] = 1103] = "Cipher_AttachmentCreated";
    EventType[EventType["Cipher_AttachmentDeleted"] = 1104] = "Cipher_AttachmentDeleted";
    EventType[EventType["Cipher_Shared"] = 1105] = "Cipher_Shared";
    EventType[EventType["Cipher_UpdatedCollections"] = 1106] = "Cipher_UpdatedCollections";
    EventType[EventType["Cipher_ClientViewed"] = 1107] = "Cipher_ClientViewed";
    EventType[EventType["Cipher_ClientToggledPasswordVisible"] = 1108] = "Cipher_ClientToggledPasswordVisible";
    EventType[EventType["Cipher_ClientToggledHiddenFieldVisible"] = 1109] = "Cipher_ClientToggledHiddenFieldVisible";
    EventType[EventType["Cipher_ClientToggledCardCodeVisible"] = 1110] = "Cipher_ClientToggledCardCodeVisible";
    EventType[EventType["Cipher_ClientCopiedPassword"] = 1111] = "Cipher_ClientCopiedPassword";
    EventType[EventType["Cipher_ClientCopiedHiddenField"] = 1112] = "Cipher_ClientCopiedHiddenField";
    EventType[EventType["Cipher_ClientCopiedCardCode"] = 1113] = "Cipher_ClientCopiedCardCode";
    EventType[EventType["Cipher_ClientAutofilled"] = 1114] = "Cipher_ClientAutofilled";
    EventType[EventType["Cipher_SoftDeleted"] = 1115] = "Cipher_SoftDeleted";
    EventType[EventType["Cipher_Restored"] = 1116] = "Cipher_Restored";
    EventType[EventType["Cipher_ClientToggledCardNumberVisible"] = 1117] = "Cipher_ClientToggledCardNumberVisible";
    EventType[EventType["Cipher_ClientToggledTOTPSeedVisible"] = 1118] = "Cipher_ClientToggledTOTPSeedVisible";
    EventType[EventType["Collection_Created"] = 1300] = "Collection_Created";
    EventType[EventType["Collection_Updated"] = 1301] = "Collection_Updated";
    EventType[EventType["Collection_Deleted"] = 1302] = "Collection_Deleted";
    EventType[EventType["Group_Created"] = 1400] = "Group_Created";
    EventType[EventType["Group_Updated"] = 1401] = "Group_Updated";
    EventType[EventType["Group_Deleted"] = 1402] = "Group_Deleted";
    EventType[EventType["OrganizationUser_Invited"] = 1500] = "OrganizationUser_Invited";
    EventType[EventType["OrganizationUser_Confirmed"] = 1501] = "OrganizationUser_Confirmed";
    EventType[EventType["OrganizationUser_Updated"] = 1502] = "OrganizationUser_Updated";
    EventType[EventType["OrganizationUser_Removed"] = 1503] = "OrganizationUser_Removed";
    EventType[EventType["OrganizationUser_UpdatedGroups"] = 1504] = "OrganizationUser_UpdatedGroups";
    EventType[EventType["OrganizationUser_UnlinkedSso"] = 1505] = "OrganizationUser_UnlinkedSso";
    EventType[EventType["OrganizationUser_ResetPassword_Enroll"] = 1506] = "OrganizationUser_ResetPassword_Enroll";
    EventType[EventType["OrganizationUser_ResetPassword_Withdraw"] = 1507] = "OrganizationUser_ResetPassword_Withdraw";
    EventType[EventType["OrganizationUser_AdminResetPassword"] = 1508] = "OrganizationUser_AdminResetPassword";
    EventType[EventType["OrganizationUser_ResetSsoLink"] = 1509] = "OrganizationUser_ResetSsoLink";
    EventType[EventType["OrganizationUser_FirstSsoLogin"] = 1510] = "OrganizationUser_FirstSsoLogin";
    EventType[EventType["OrganizationUser_Revoked"] = 1511] = "OrganizationUser_Revoked";
    EventType[EventType["OrganizationUser_Restored"] = 1512] = "OrganizationUser_Restored";
    EventType[EventType["OrganizationUser_ApprovedAuthRequest"] = 1513] = "OrganizationUser_ApprovedAuthRequest";
    EventType[EventType["OrganizationUser_RejectedAuthRequest"] = 1514] = "OrganizationUser_RejectedAuthRequest";
    EventType[EventType["OrganizationUser_Deleted"] = 1515] = "OrganizationUser_Deleted";
    EventType[EventType["OrganizationUser_Left"] = 1516] = "OrganizationUser_Left";
    EventType[EventType["Organization_Updated"] = 1600] = "Organization_Updated";
    EventType[EventType["Organization_PurgedVault"] = 1601] = "Organization_PurgedVault";
    EventType[EventType["Organization_ClientExportedVault"] = 1602] = "Organization_ClientExportedVault";
    EventType[EventType["Organization_VaultAccessed"] = 1603] = "Organization_VaultAccessed";
    EventType[EventType["Organization_EnabledSso"] = 1604] = "Organization_EnabledSso";
    EventType[EventType["Organization_DisabledSso"] = 1605] = "Organization_DisabledSso";
    EventType[EventType["Organization_EnabledKeyConnector"] = 1606] = "Organization_EnabledKeyConnector";
    EventType[EventType["Organization_DisabledKeyConnector"] = 1607] = "Organization_DisabledKeyConnector";
    EventType[EventType["Organization_SponsorshipsSynced"] = 1608] = "Organization_SponsorshipsSynced";
    EventType[EventType["Organization_CollectionManagementUpdated"] = 1609] = "Organization_CollectionManagementUpdated";
    EventType[EventType["Organization_CollectionManagement_LimitCollectionCreationEnabled"] = 1610] = "Organization_CollectionManagement_LimitCollectionCreationEnabled";
    EventType[EventType["Organization_CollectionManagement_LimitCollectionCreationDisabled"] = 1611] = "Organization_CollectionManagement_LimitCollectionCreationDisabled";
    EventType[EventType["Organization_CollectionManagement_LimitCollectionDeletionEnabled"] = 1612] = "Organization_CollectionManagement_LimitCollectionDeletionEnabled";
    EventType[EventType["Organization_CollectionManagement_LimitCollectionDeletionDisabled"] = 1613] = "Organization_CollectionManagement_LimitCollectionDeletionDisabled";
    EventType[EventType["Organization_CollectionManagement_LimitItemDeletionEnabled"] = 1614] = "Organization_CollectionManagement_LimitItemDeletionEnabled";
    EventType[EventType["Organization_CollectionManagement_LimitItemDeletionDisabled"] = 1615] = "Organization_CollectionManagement_LimitItemDeletionDisabled";
    EventType[EventType["Organization_CollectionManagement_AllowAdminAccessToAllCollectionItemsEnabled"] = 1616] = "Organization_CollectionManagement_AllowAdminAccessToAllCollectionItemsEnabled";
    EventType[EventType["Organization_CollectionManagement_AllowAdminAccessToAllCollectionItemsDisabled"] = 1617] = "Organization_CollectionManagement_AllowAdminAccessToAllCollectionItemsDisabled";
    EventType[EventType["Policy_Updated"] = 1700] = "Policy_Updated";
    EventType[EventType["ProviderUser_Invited"] = 1800] = "ProviderUser_Invited";
    EventType[EventType["ProviderUser_Confirmed"] = 1801] = "ProviderUser_Confirmed";
    EventType[EventType["ProviderUser_Updated"] = 1802] = "ProviderUser_Updated";
    EventType[EventType["ProviderUser_Removed"] = 1803] = "ProviderUser_Removed";
    EventType[EventType["ProviderOrganization_Created"] = 1900] = "ProviderOrganization_Created";
    EventType[EventType["ProviderOrganization_Added"] = 1901] = "ProviderOrganization_Added";
    EventType[EventType["ProviderOrganization_Removed"] = 1902] = "ProviderOrganization_Removed";
    EventType[EventType["ProviderOrganization_VaultAccessed"] = 1903] = "ProviderOrganization_VaultAccessed";
    EventType[EventType["OrganizationDomain_Added"] = 2000] = "OrganizationDomain_Added";
    EventType[EventType["OrganizationDomain_Removed"] = 2001] = "OrganizationDomain_Removed";
    EventType[EventType["OrganizationDomain_Verified"] = 2002] = "OrganizationDomain_Verified";
    EventType[EventType["OrganizationDomain_NotVerified"] = 2003] = "OrganizationDomain_NotVerified";
    EventType[EventType["Secret_Retrieved"] = 2100] = "Secret_Retrieved";
    EventType[EventType["Secret_Created"] = 2101] = "Secret_Created";
    EventType[EventType["Secret_Edited"] = 2102] = "Secret_Edited";
    EventType[EventType["Secret_Deleted"] = 2103] = "Secret_Deleted";
    EventType[EventType["Secret_Permanently_Deleted"] = 2104] = "Secret_Permanently_Deleted";
    EventType[EventType["Secret_Restored"] = 2105] = "Secret_Restored";
    EventType[EventType["Project_Retrieved"] = 2200] = "Project_Retrieved";
    EventType[EventType["Project_Created"] = 2201] = "Project_Created";
    EventType[EventType["Project_Edited"] = 2202] = "Project_Edited";
    EventType[EventType["Project_Deleted"] = 2203] = "Project_Deleted";
})(EventType || (EventType = {}));

;// ../../libs/common/src/enums/http-status-code.enum.ts
/**
 * Hypertext Transfer Protocol (HTTP) response status codes.
 *
 * @see {@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}
 * src: https://gist.github.com/RWOverdijk/6cef816cfdf5722228e01cc05fd4b094
 */
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var HttpStatusCode;
(function (HttpStatusCode) {
    /**
     * The server has received the request headers and the client should proceed to send the request body
     * (in the case of a request for which a body needs to be sent; for example, a POST request).
     * Sending a large request body to a server after a request has been rejected for inappropriate headers would be inefficient.
     * To have a server check the request's headers, a client must send Expect: 100-continue as a header in its initial request
     * and receive a 100 Continue status code in response before sending the body. The response 417 Expectation Failed indicates the request should not be continued.
     */
    HttpStatusCode[HttpStatusCode["Continue"] = 100] = "Continue";
    /**
     * The requester has asked the server to switch protocols and the server has agreed to do so.
     */
    HttpStatusCode[HttpStatusCode["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    /**
     * A WebDAV request may contain many sub-requests involving file operations, requiring a long time to complete the request.
     * This code indicates that the server has received and is processing the request, but no response is available yet.
     * This prevents the client from timing out and assuming the request was lost.
     */
    HttpStatusCode[HttpStatusCode["Processing"] = 102] = "Processing";
    // **********************************************************************************************************
    // 200s - SUCCESS
    // **********************************************************************************************************
    /**
     * Standard response for successful HTTP requests.
     * The actual response will depend on the request method used.
     * In a GET request, the response will contain an entity corresponding to the requested resource.
     * In a POST request, the response will contain an entity describing or containing the result of the action.
     */
    HttpStatusCode[HttpStatusCode["Ok"] = 200] = "Ok";
    /**
     * The request has been fulfilled, resulting in the creation of a new resource.
     */
    HttpStatusCode[HttpStatusCode["Created"] = 201] = "Created";
    /**
     * The request has been accepted for processing, but the processing has not been completed.
     * The request might or might not be eventually acted upon, and may be disallowed when processing occurs.
     */
    HttpStatusCode[HttpStatusCode["Accepted"] = 202] = "Accepted";
    /**
     * SINCE HTTP/1.1
     * The server is a transforming proxy that received a 200 OK from its origin,
     * but is returning a modified version of the origin's response.
     */
    HttpStatusCode[HttpStatusCode["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
    /**
     * The server successfully processed the request and is not returning any content.
     */
    HttpStatusCode[HttpStatusCode["NoContent"] = 204] = "NoContent";
    /**
     * The server successfully processed the request, but is not returning any content.
     * Unlike a 204 response, this response requires that the requester reset the document view.
     */
    HttpStatusCode[HttpStatusCode["ResetContent"] = 205] = "ResetContent";
    /**
     * The server is delivering only part of the resource (byte serving) due to a range header sent by the client.
     * The range header is used by HTTP clients to enable resuming of interrupted downloads,
     * or split a download into multiple simultaneous streams.
     */
    HttpStatusCode[HttpStatusCode["PartialContent"] = 206] = "PartialContent";
    /**
     * The message body that follows is an XML message and can contain a number of separate response codes,
     * depending on how many sub-requests were made.
     */
    HttpStatusCode[HttpStatusCode["MultiStatus"] = 207] = "MultiStatus";
    /**
     * The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response,
     * and are not being included again.
     */
    HttpStatusCode[HttpStatusCode["AlreadyReported"] = 208] = "AlreadyReported";
    /**
     * The server has fulfilled a request for the resource,
     * and the response is a representation of the result of one or more instance-manipulations applied to the current instance.
     */
    HttpStatusCode[HttpStatusCode["ImUsed"] = 226] = "ImUsed";
    // **********************************************************************************************************
    // 300s - Redirections
    // **********************************************************************************************************
    /**
     * Indicates multiple options for the resource from which the client may choose (via agent-driven content negotiation).
     * For example, this code could be used to present multiple video format options,
     * to list files with different filename extensions, or to suggest word-sense disambiguation.
     */
    HttpStatusCode[HttpStatusCode["MultipleChoices"] = 300] = "MultipleChoices";
    /**
     * This and all future requests should be directed to the given URI.
     */
    HttpStatusCode[HttpStatusCode["MovedPermanently"] = 301] = "MovedPermanently";
    /**
     * This is an example of industry practice contradicting the standard.
     * The HTTP/1.0 specification (RFC 1945) required the client to perform a temporary redirect
     * (the original describing phrase was "Moved Temporarily"), but popular browsers implemented 302
     * with the functionality of a 303 See Other. Therefore, HTTP/1.1 added status codes 303 and 307
     * to distinguish between the two behaviours. However, some Web applications and frameworks
     * use the 302 status code as if it were the 303.
     */
    HttpStatusCode[HttpStatusCode["Found"] = 302] = "Found";
    /**
     * SINCE HTTP/1.1
     * The response to the request can be found under another URI using a GET method.
     * When received in response to a POST (or PUT/DELETE), the client should presume that
     * the server has received the data and should issue a redirect with a separate GET message.
     */
    HttpStatusCode[HttpStatusCode["SeeOther"] = 303] = "SeeOther";
    /**
     * Indicates that the resource has not been modified since the version specified by the request headers If-Modified-Since or If-None-Match.
     * In such case, there is no need to retransmit the resource since the client still has a previously-downloaded copy.
     */
    HttpStatusCode[HttpStatusCode["NotModified"] = 304] = "NotModified";
    /**
     * SINCE HTTP/1.1
     * The requested resource is available only through a proxy, the address for which is provided in the response.
     * Many HTTP clients (such as Mozilla and Internet Explorer) do not correctly handle responses with this status code, primarily for security reasons.
     */
    HttpStatusCode[HttpStatusCode["UseProxy"] = 305] = "UseProxy";
    /**
     * No longer used. Originally meant "Subsequent requests should use the specified proxy."
     */
    HttpStatusCode[HttpStatusCode["SwitchProxy"] = 306] = "SwitchProxy";
    /**
     * SINCE HTTP/1.1
     * In this case, the request should be repeated with another URI; however, future requests should still use the original URI.
     * In contrast to how 302 was historically implemented, the request method is not allowed to be changed when reissuing the original request.
     * For example, a POST request should be repeated using another POST request.
     */
    HttpStatusCode[HttpStatusCode["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    /**
     * The request and all future requests should be repeated using another URI.
     * 307 and 308 parallel the behaviors of 302 and 301, but do not allow the HTTP method to change.
     * So, for example, submitting a form to a permanently redirected resource may continue smoothly.
     */
    HttpStatusCode[HttpStatusCode["PermanentRedirect"] = 308] = "PermanentRedirect";
    // **********************************************************************************************************
    // 400s - Client / User messed up
    // **********************************************************************************************************
    /**
     * The server cannot or will not process the request due to an apparent client error
     * (e.g., malformed request syntax, too large size, invalid request message framing, or deceptive request routing).
     */
    HttpStatusCode[HttpStatusCode["BadRequest"] = 400] = "BadRequest";
    /**
     * Similar to 403 Forbidden, but specifically for use when authentication is required and has failed or has not yet
     * been provided. The response must include a WWW-Authenticate header field containing a challenge applicable to the
     * requested resource. See Basic access authentication and Digest access authentication. 401 semantically means
     * "unauthenticated",i.e. the user does not have the necessary credentials.
     */
    HttpStatusCode[HttpStatusCode["Unauthorized"] = 401] = "Unauthorized";
    /**
     * Reserved for future use. The original intention was that this code might be used as part of some form of digital
     * cash or micro payment scheme, but that has not happened, and this code is not usually used.
     * Google Developers API uses this status if a particular developer has exceeded the daily limit on requests.
     */
    HttpStatusCode[HttpStatusCode["PaymentRequired"] = 402] = "PaymentRequired";
    /**
     * The request was valid, but the server is refusing action.
     * The user might not have the necessary permissions for a resource.
     */
    HttpStatusCode[HttpStatusCode["Forbidden"] = 403] = "Forbidden";
    /**
     * The requested resource could not be found but may be available in the future.
     * Subsequent requests by the client are permissible.
     */
    HttpStatusCode[HttpStatusCode["NotFound"] = 404] = "NotFound";
    /**
     * A request method is not supported for the requested resource;
     * for example, a GET request on a form that requires data to be presented via POST, or a PUT request on a read-only resource.
     */
    HttpStatusCode[HttpStatusCode["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    /**
     * The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.
     */
    HttpStatusCode[HttpStatusCode["NotAcceptable"] = 406] = "NotAcceptable";
    /**
     * The client must first authenticate itself with the proxy.
     */
    HttpStatusCode[HttpStatusCode["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
    /**
     * The server timed out waiting for the request.
     * According to HTTP specifications:
     * "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time."
     */
    HttpStatusCode[HttpStatusCode["RequestTimeout"] = 408] = "RequestTimeout";
    /**
     * Indicates that the request could not be processed because of conflict in the request,
     * such as an edit conflict between multiple simultaneous updates.
     */
    HttpStatusCode[HttpStatusCode["Conflict"] = 409] = "Conflict";
    /**
     * Indicates that the resource requested is no longer available and will not be available again.
     * This should be used when a resource has been intentionally removed and the resource should be purged.
     * Upon receiving a 410 status code, the client should not request the resource in the future.
     * Clients such as search engines should remove the resource from their indices.
     * Most use cases do not require clients and search engines to purge the resource, and a "404 Not Found" may be used instead.
     */
    HttpStatusCode[HttpStatusCode["Gone"] = 410] = "Gone";
    /**
     * The request did not specify the length of its content, which is required by the requested resource.
     */
    HttpStatusCode[HttpStatusCode["LengthRequired"] = 411] = "LengthRequired";
    /**
     * The server does not meet one of the preconditions that the requester put on the request.
     */
    HttpStatusCode[HttpStatusCode["PreconditionFailed"] = 412] = "PreconditionFailed";
    /**
     * The request is larger than the server is willing or able to process. Previously called "Request Entity Too Large".
     */
    HttpStatusCode[HttpStatusCode["PayloadTooLarge"] = 413] = "PayloadTooLarge";
    /**
     * The URI provided was too long for the server to process. Often the result of too much data being encoded as a query-string of a GET request,
     * in which case it should be converted to a POST request.
     * Called "Request-URI Too Long" previously.
     */
    HttpStatusCode[HttpStatusCode["UriTooLong"] = 414] = "UriTooLong";
    /**
     * The request entity has a media type which the server or resource does not support.
     * For example, the client uploads an image as image/svg+xml, but the server requires that images use a different format.
     */
    HttpStatusCode[HttpStatusCode["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    /**
     * The client has asked for a portion of the file (byte serving), but the server cannot supply that portion.
     * For example, if the client asked for a part of the file that lies beyond the end of the file.
     * Called "Requested Range Not Satisfiable" previously.
     */
    HttpStatusCode[HttpStatusCode["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
    /**
     * The server cannot meet the requirements of the Expect request-header field.
     */
    HttpStatusCode[HttpStatusCode["ExpectationFailed"] = 417] = "ExpectationFailed";
    /**
     * This code was defined in 1998 as one of the traditional IETF April Fools' jokes, in RFC 2324, Hyper Text Coffee Pot Control Protocol,
     * and is not expected to be implemented by actual HTTP servers. The RFC specifies this code should be returned by
     * teapots requested to brew coffee. This HTTP status is used as an Easter egg in some websites, including Google.com.
     */
    HttpStatusCode[HttpStatusCode["IAmATeapot"] = 418] = "IAmATeapot";
    /**
     * The request was directed at a server that is not able to produce a response (for example because a connection reuse).
     */
    HttpStatusCode[HttpStatusCode["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    /**
     * The request was well-formed but was unable to be followed due to semantic errors.
     */
    HttpStatusCode[HttpStatusCode["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    /**
     * The resource that is being accessed is locked.
     */
    HttpStatusCode[HttpStatusCode["Locked"] = 423] = "Locked";
    /**
     * The request failed due to failure of a previous request (e.g., a PROPPATCH).
     */
    HttpStatusCode[HttpStatusCode["FailedDependency"] = 424] = "FailedDependency";
    /**
     * The client should switch to a different protocol such as TLS/1.0, given in the Upgrade header field.
     */
    HttpStatusCode[HttpStatusCode["UpgradeRequired"] = 426] = "UpgradeRequired";
    /**
     * The origin server requires the request to be conditional.
     * Intended to prevent "the 'lost update' problem, where a client
     * GETs a resource's state, modifies it, and PUTs it back to the server,
     * when meanwhile a third party has modified the state on the server, leading to a conflict."
     */
    HttpStatusCode[HttpStatusCode["PreconditionRequired"] = 428] = "PreconditionRequired";
    /**
     * The user has sent too many requests in a given amount of time. Intended for use with rate-limiting schemes.
     */
    HttpStatusCode[HttpStatusCode["TooManyRequests"] = 429] = "TooManyRequests";
    /**
     * The server is unwilling to process the request because either an individual header field,
     * or all the header fields collectively, are too large.
     */
    HttpStatusCode[HttpStatusCode["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    /**
     * A server operator has received a legal demand to deny access to a resource or to a set of resources
     * that includes the requested resource. The code 451 was chosen as a reference to the novel Fahrenheit 451.
     */
    HttpStatusCode[HttpStatusCode["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    // **********************************************************************************************************
    // 500s - Server messed up
    // **********************************************************************************************************
    /**
     * A generic error message, given when an unexpected condition was encountered and no more specific message is suitable.
     */
    HttpStatusCode[HttpStatusCode["InternalServerError"] = 500] = "InternalServerError";
    /**
     * The server either does not recognize the request method, or it lacks the ability to fulfill the request.
     * Usually this implies future availability (e.g., a new feature of a web-service API).
     */
    HttpStatusCode[HttpStatusCode["NotImplemented"] = 501] = "NotImplemented";
    /**
     * The server was acting as a gateway or proxy and received an invalid response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["BadGateway"] = 502] = "BadGateway";
    /**
     * The server is currently unavailable (because it is overloaded or down for maintenance).
     * Generally, this is a temporary state.
     */
    HttpStatusCode[HttpStatusCode["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    /**
     * The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["GatewayTimeout"] = 504] = "GatewayTimeout";
    /**
     * The server does not support the HTTP protocol version used in the request
     */
    HttpStatusCode[HttpStatusCode["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
    /**
     * Transparent content negotiation for the request results in a circular reference.
     */
    HttpStatusCode[HttpStatusCode["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    /**
     * The server is unable to store the representation needed to complete the request.
     */
    HttpStatusCode[HttpStatusCode["InsufficientStorage"] = 507] = "InsufficientStorage";
    /**
     * The server detected an infinite loop while processing the request.
     */
    HttpStatusCode[HttpStatusCode["LoopDetected"] = 508] = "LoopDetected";
    /**
     * Further extensions to the request are required for the server to fulfill it.
     */
    HttpStatusCode[HttpStatusCode["NotExtended"] = 510] = "NotExtended";
    /**
     * The client needs to authenticate to gain network access.
     * Intended for use by intercepting proxies used to control access to the network (e.g., "captive portals" used
     * to require agreement to Terms of Service before granting full Internet access via a Wi-Fi hotspot).
     */
    HttpStatusCode[HttpStatusCode["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

;// ../../libs/common/src/enums/integration-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var IntegrationType;
(function (IntegrationType) {
    IntegrationType["Integration"] = "integration";
    IntegrationType["SDK"] = "sdk";
    IntegrationType["SSO"] = "sso";
    IntegrationType["SCIM"] = "scim";
    IntegrationType["BWDC"] = "bwdc";
    IntegrationType["EVENT"] = "event";
    IntegrationType["DEVICE"] = "device";
})(IntegrationType || (IntegrationType = {}));

;// ../../libs/common/src/enums/native-messaging-version.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var NativeMessagingVersion;
(function (NativeMessagingVersion) {
    NativeMessagingVersion[NativeMessagingVersion["One"] = 1] = "One";
    NativeMessagingVersion[NativeMessagingVersion["Latest"] = 1] = "Latest";
})(NativeMessagingVersion || (NativeMessagingVersion = {}));

;// ../../libs/common/src/enums/notification-type.enum.ts
// FIXME: update to use a const object instead of a typescript enum
// eslint-disable-next-line @bitwarden/platform/no-enums
var NotificationType;
(function (NotificationType) {
    NotificationType[NotificationType["SyncCipherUpdate"] = 0] = "SyncCipherUpdate";
    NotificationType[NotificationType["SyncCipherCreate"] = 1] = "SyncCipherCreate";
    NotificationType[NotificationType["SyncLoginDelete"] = 2] = "SyncLoginDelete";
    NotificationType[NotificationType["SyncFolderDelete"] = 3] = "SyncFolderDelete";
    NotificationType[NotificationType["SyncCiphers"] = 4] = "SyncCiphers";
    NotificationType[NotificationType["SyncVault"] = 5] = "SyncVault";
    NotificationType[NotificationType["SyncOrgKeys"] = 6] = "SyncOrgKeys";
    NotificationType[NotificationType["SyncFolderCreate"] = 7] = "SyncFolderCreate";
    NotificationType[NotificationType["SyncFolderUpdate"] = 8] = "SyncFolderUpdate";
    NotificationType[NotificationType["SyncCipherDelete"] = 9] = "SyncCipherDelete";
    NotificationType[NotificationType["SyncSettings"] = 10] = "SyncSettings";
    NotificationType[NotificationType["LogOut"] = 11] = "LogOut";
    NotificationType[NotificationType["SyncSendCreate"] = 12] = "SyncSendCreate";
    NotificationType[NotificationType["SyncSendUpdate"] = 13] = "SyncSendUpdate";
    NotificationType[NotificationType["SyncSendDelete"] = 14] = "SyncSendDelete";
    NotificationType[NotificationType["AuthRequest"] = 15] = "AuthRequest";
    NotificationType[NotificationType["AuthRequestResponse"] = 16] = "AuthRequestResponse";
    NotificationType[NotificationType["SyncOrganizations"] = 17] = "SyncOrganizations";
    NotificationType[NotificationType["SyncOrganizationStatusChanged"] = 18] = "SyncOrganizationStatusChanged";
    NotificationType[NotificationType["SyncOrganizationCollectionSettingChanged"] = 19] = "SyncOrganizationCollectionSettingChanged";
    NotificationType[NotificationType["Notification"] = 20] = "Notification";
    NotificationType[NotificationType["NotificationStatus"] = 21] = "NotificationStatus";
    NotificationType[NotificationType["RefreshSecurityTasks"] = 22] = "RefreshSecurityTasks";
})(NotificationType || (NotificationType = {}));

;// ../../libs/common/src/enums/index.ts









;// ../../libs/auth/src/common/login-strategies/sso-login.strategy.ts
var sso_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore






class SsoLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new SsoLoginStrategyData(), obj, {
            tokenRequest: SsoTokenRequest.fromJSON(obj.tokenRequest),
        });
    }
}
class SsoLoginStrategy extends LoginStrategy {
    constructor(data, keyConnectorService, deviceTrustService, authRequestService, i18nService, ...sharedDeps) {
        super(...sharedDeps);
        this.keyConnectorService = keyConnectorService;
        this.deviceTrustService = deviceTrustService;
        this.authRequestService = authRequestService;
        this.i18nService = i18nService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
        this.email$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.email));
        this.orgId$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.orgId));
        this.ssoEmail2FaSessionToken$ = this.cache.pipe((0,external_rxjs_namespaceObject.map)((state) => state.ssoEmail2FaSessionToken));
    }
    logIn(credentials) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new SsoLoginStrategyData();
            data.orgId = credentials.orgId;
            data.userEnteredEmail = credentials.email;
            const deviceRequest = yield this.buildDeviceRequest();
            this.logService.info("Logging in with appId %s.", deviceRequest.identifier);
            data.tokenRequest = new SsoTokenRequest(credentials.code, credentials.codeVerifier, credentials.redirectUrl, yield this.buildTwoFactor(credentials.twoFactor, credentials.email), deviceRequest);
            this.cache.next(data);
            const [ssoAuthResult] = yield this.startLogIn();
            const email = ssoAuthResult.email;
            const ssoEmail2FaSessionToken = ssoAuthResult.ssoEmail2FaSessionToken;
            this.cache.next(Object.assign(Object.assign({}, this.cache.value), { email,
                ssoEmail2FaSessionToken }));
            return ssoAuthResult;
        });
    }
    setMasterKey(tokenResponse, userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // The only way we can be setting a master key at this point is if we are using Key Connector.
            // First, check to make sure that we should do so based on the token response.
            if (this.shouldSetMasterKeyFromKeyConnector(tokenResponse)) {
                // If we're here, we know that the user should use Key Connector (they have a KeyConnectorUrl) and does not have a master password.
                // We can now check the key on the token response to see whether they are a brand new user or an existing user.
                // The presence of a masterKeyEncryptedUserKey indicates that the user has already been provisioned in Key Connector.
                const newSsoUser = tokenResponse.key == null;
                if (newSsoUser) {
                    // Store Key Connector domain confirmation data in state instead of AuthResult
                    yield this.keyConnectorService.setNewSsoUserKeyConnectorConversionData({
                        kdfConfig: tokenResponse.kdfConfig,
                        keyConnectorUrl: this.getKeyConnectorUrl(tokenResponse),
                        organizationId: this.cache.value.orgId,
                    }, userId);
                }
                else {
                    const keyConnectorUrl = this.getKeyConnectorUrl(tokenResponse);
                    yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl, userId);
                }
            }
        });
    }
    /**
     * Determines if it is possible set the `masterKey` from Key Connector.
     * @param tokenResponse
     * @returns `true` if the master key can be set from Key Connector, `false` otherwise
     */
    shouldSetMasterKeyFromKeyConnector(tokenResponse) {
        var _a;
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        if (userDecryptionOptions != null) {
            const userHasMasterPassword = userDecryptionOptions.hasMasterPassword;
            const userHasKeyConnectorUrl = ((_a = userDecryptionOptions.keyConnectorOption) === null || _a === void 0 ? void 0 : _a.keyConnectorUrl) != null;
            // In order for us to set the master key from Key Connector, we need to have a Key Connector URL
            // and the user must not have a master password.
            return userHasKeyConnectorUrl && !userHasMasterPassword;
        }
        else {
            // In pre-TDE versions of the server, the userDecryptionOptions will not be present.
            // In this case, we can determine if the user has a master password and has a Key Connector URL by
            // just checking the keyConnectorUrl property. This is because the server short-circuits on the response
            // and will not pass back the URL in the response if the user has a master password.
            // TODO: remove compatibility check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            return tokenResponse.keyConnectorUrl != null;
        }
    }
    getKeyConnectorUrl(tokenResponse) {
        var _a, _b;
        // TODO: remove tokenResponse.keyConnectorUrl reference after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        return ((_a = tokenResponse.keyConnectorUrl) !== null && _a !== void 0 ? _a : (_b = userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.keyConnectorOption) === null || _b === void 0 ? void 0 : _b.keyConnectorUrl);
    }
    // TODO: future passkey login strategy will need to support setting user key (decrypting via TDE or admin approval request)
    // so might be worth moving this logic to a common place (base login strategy or a separate service?)
    setUserKey(tokenResponse, userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKeyEncryptedUserKey = tokenResponse.key;
            // Note: masterKeyEncryptedUserKey is undefined for SSO JIT provisioned users
            // on account creation and subsequent logins (confirmed or unconfirmed)
            // but that is fine for TDE so we cannot return if it is undefined
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.masterPasswordService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey, userId);
            }
            const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
            // Note: TDE and key connector are mutually exclusive
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.trustedDeviceOption) {
                this.logService.info("Attempting to set user key with approved admin auth request.");
                // Try to use the user key from an approved admin request if it exists.
                // Using it will clear it from state and future requests will use the device key.
                yield this.trySetUserKeyWithApprovedAdminRequestIfExists(userId);
                const hasUserKey = yield this.keyService.hasUserKey(userId);
                // Only try to set user key with device key if admin approval request was not successful.
                if (!hasUserKey) {
                    this.logService.info("Attempting to set user key with device key.");
                    yield this.trySetUserKeyWithDeviceKey(tokenResponse, userId);
                }
            }
            else if (masterKeyEncryptedUserKey != null &&
                this.getKeyConnectorUrl(tokenResponse) != null) {
                // Key connector enabled for user
                yield this.trySetUserKeyWithMasterKey(userId);
            }
            // Note: In the traditional SSO flow with MP without key connector, the lock component
            // is responsible for deriving master key from MP entry and then decrypting the user key
        });
    }
    trySetUserKeyWithApprovedAdminRequestIfExists(userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // At this point a user could have an admin auth request that has been approved
            const adminAuthReqStorable = yield this.authRequestService.getAdminAuthRequest(userId);
            if (!adminAuthReqStorable) {
                return;
            }
            // Call server to see if admin auth request has been approved
            let adminAuthReqResponse;
            try {
                adminAuthReqResponse = yield this.apiService.getAuthRequest(adminAuthReqStorable.id);
            }
            catch (error) {
                if (error instanceof ErrorResponse && error.statusCode === HttpStatusCode.NotFound) {
                    // if we get a 404, it means the auth request has been deleted so clear it from storage
                    yield this.authRequestService.clearAdminAuthRequest(userId);
                }
                // Always return on an error here as we don't want to block the user from logging in
                return;
            }
            if (adminAuthReqResponse === null || adminAuthReqResponse === void 0 ? void 0 : adminAuthReqResponse.requestApproved) {
                // if masterPasswordHash has a value, we will always receive authReqResponse.key
                // as authRequestPublicKey(masterKey) + authRequestPublicKey(masterPasswordHash)
                if (adminAuthReqResponse.masterPasswordHash) {
                    yield this.authRequestService.setKeysAfterDecryptingSharedMasterKeyAndHash(adminAuthReqResponse, adminAuthReqStorable.privateKey, userId);
                }
                else {
                    // if masterPasswordHash is null, we will always receive authReqResponse.key
                    // as authRequestPublicKey(userKey)
                    yield this.authRequestService.setUserKeyAfterDecryptingSharedUserKey(adminAuthReqResponse, adminAuthReqStorable.privateKey, userId);
                }
                if (yield this.keyService.hasUserKey(userId)) {
                    // Now that we have a decrypted user key in memory, we can check if we
                    // need to establish trust on the current device
                    yield this.deviceTrustService.trustDeviceIfRequired(userId);
                    // if we successfully decrypted the user key, we can delete the admin auth request out of state
                    // TODO: eventually we post and clean up DB as well once consumed on client
                    yield this.authRequestService.clearAdminAuthRequest(userId);
                    // This notification will be picked up by the SsoComponent to handle displaying a toast to the user
                    this.authRequestService.emitAdminLoginApproved();
                }
            }
        });
    }
    trySetUserKeyWithDeviceKey(tokenResponse, userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            const trustedDeviceOption = (_a = tokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.trustedDeviceOption;
            if (!trustedDeviceOption) {
                this.logService.error("Unable to set user key due to missing trustedDeviceOption.");
                return;
            }
            const deviceKey = yield this.deviceTrustService.getDeviceKey(userId);
            const encDevicePrivateKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedPrivateKey;
            const encUserKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedUserKey;
            if (!deviceKey || !encDevicePrivateKey || !encUserKey) {
                if (!deviceKey) {
                    this.logService.warning("Unable to set user key due to missing device key.");
                }
                else if (!encDevicePrivateKey || !encUserKey) {
                    // Tell the server that we have a device key, but received no decryption keys
                    yield this.deviceTrustService.recordDeviceTrustLoss();
                }
                if (!encDevicePrivateKey) {
                    this.logService.warning("Unable to set user key due to missing encrypted device private key.");
                }
                if (!encUserKey) {
                    this.logService.warning("Unable to set user key due to missing encrypted user key.");
                }
                return;
            }
            const userKey = yield this.deviceTrustService.decryptUserKeyWithDeviceKey(userId, encDevicePrivateKey, encUserKey, deviceKey);
            if (userKey) {
                yield this.keyService.setUserKey(userKey, userId);
            }
        });
    }
    trySetUserKeyWithMasterKey(userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
            // There are two scenarios in which the master key is not set here:
            // 1. If the user has a master password and is using Key Connector. In that case, we cannot set the master key
            // because the user hasn't entered their master password yet.
            // 2. For new users with Key Connector, we will not have a master key yet, since Key Connector domain
            // has to be confirmed first.
            // In both cases, we'll return here and let the migration to Key Connector handle setting the master key.
            if (!masterKey) {
                return;
            }
            const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey, userId);
            yield this.keyService.setUserKey(userKey, userId);
        });
    }
    setPrivateKey(tokenResponse, userId) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            if (tokenResponse.hasMasterKeyEncryptedUserKey()) {
                // User has masterKeyEncryptedUserKey, so set the userKeyEncryptedPrivateKey
                // Note: new JIT provisioned SSO users will not yet have a user asymmetric key pair
                // and so we don't want them falling into the createKeyPairForOldAccount flow
                yield this.keyService.setPrivateKey((_a = tokenResponse.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
            }
            else if (tokenResponse.privateKey) {
                // User doesn't have masterKeyEncryptedUserKey but they do have a userKeyEncryptedPrivateKey
                // This is just existing TDE users or a TDE offboarder on an untrusted device
                yield this.keyService.setPrivateKey(tokenResponse.privateKey, userId);
            }
        });
    }
    exportCache() {
        return {
            sso: this.cache.value,
        };
    }
    /**
     * Override to handle SSO-specific ForceSetPasswordReason flags,including TdeOffboarding,
     * TdeUserWithoutPasswordHasPasswordResetPermission, and SsoNewJitProvisionedUser cases.
     * @param authResult - The authentication result
     * @param userId - The user ID
     */
    processForceSetPasswordReason(adminForcePasswordReset, userId) {
        const _super = Object.create(null, {
            processForceSetPasswordReason: { get: () => super.processForceSetPasswordReason }
        });
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c, _d;
            // handle any existing reasons
            const adminForcePasswordResetFlagSet = yield _super.processForceSetPasswordReason.call(this, adminForcePasswordReset, userId);
            // If we are already processing an admin force password reset, don't process other reasons
            if (adminForcePasswordResetFlagSet) {
                return false;
            }
            // Check for TDE-related conditions
            const userDecryptionOptions = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.userDecryptionOptionsService.userDecryptionOptions$);
            if (!userDecryptionOptions) {
                return false;
            }
            // Check for TDE offboarding - user is being offboarded from TDE and needs to set a password on a trusted device
            if ((_a = userDecryptionOptions.trustedDeviceOption) === null || _a === void 0 ? void 0 : _a.isTdeOffboarding) {
                yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.TdeOffboarding, userId);
                return true;
            }
            // If a TDE org user in an offboarding state logs in on an untrusted device, then they will receive their existing userKeyEncryptedPrivateKey from the server, but
            // TDE would not have been able to decrypt their user key b/c we don't send down TDE as a valid decryption option, so the user key will be unavilable here for TDE org users on untrusted devices.
            // - UserDecryptionOptions.trustedDeviceOption is undefined -- device isn't trusted.
            // - UserDecryptionOptions.hasMasterPassword is false -- user doesn't have a master password.
            // - UserDecryptionOptions.UsesKeyConnector is undefined. -- they aren't using key connector
            // - UserKey is not set after successful login -- because automatic decryption is not available
            // - userKeyEncryptedPrivateKey is set after successful login -- this is the key differentiator between a TDE org user logging into an untrusted device and MP encryption JIT provisioned user logging in for the first time.
            //     Why is that the case?  Because we set the userKeyEncryptedPrivateKey when we create the userKey, and this is serving as a proxy to tell us that the userKey has been created already (when enrolling in TDE).
            const hasUserKeyEncryptedPrivateKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.keyService.userEncryptedPrivateKey$(userId));
            const hasUserKey = yield this.keyService.hasUserKey(userId);
            // TODO: PM-23491 we should explore consolidating this logic into a flag on the server. It could be set when an org is switched from TDE to MP encryption for each org user.
            if (!userDecryptionOptions.trustedDeviceOption &&
                !userDecryptionOptions.hasMasterPassword &&
                !((_b = userDecryptionOptions.keyConnectorOption) === null || _b === void 0 ? void 0 : _b.keyConnectorUrl) &&
                hasUserKeyEncryptedPrivateKey &&
                !hasUserKey) {
                yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.TdeOffboardingUntrustedDevice, userId);
                return true;
            }
            // Check if user has permission to set password but hasn't yet
            if (!userDecryptionOptions.hasMasterPassword &&
                ((_c = userDecryptionOptions.trustedDeviceOption) === null || _c === void 0 ? void 0 : _c.hasManageResetPasswordPermission)) {
                yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.TdeUserWithoutPasswordHasPasswordResetPermission, userId);
                return true;
            }
            // Check for new SSO JIT provisioned user
            // If a user logs in via SSO but has no master password and no alternative encryption methods
            // Then they must be a newly provisioned user who needs to set up their encryption
            if (!userDecryptionOptions.hasMasterPassword &&
                !((_d = userDecryptionOptions.keyConnectorOption) === null || _d === void 0 ? void 0 : _d.keyConnectorUrl) &&
                !userDecryptionOptions.trustedDeviceOption) {
                yield this.masterPasswordService.setForceSetPasswordReason(ForceSetPasswordReason.SsoNewJitProvisionedUser, userId);
                return true;
            }
            // If none of the conditions are met, return false
            return false;
        });
    }
}

;// ../../libs/common/src/auth/models/request/identity-token/user-api-token.request.ts



class UserApiTokenRequest extends TokenRequest {
    constructor(clientId, clientSecret, twoFactor, device) {
        super(twoFactor, device);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.twoFactor = twoFactor;
    }
    toIdentityToken() {
        const obj = super.toIdentityToken(this.clientId);
        obj.scope = this.clientId.startsWith("organization") ? "api.organization" : "api";
        obj.grant_type = "client_credentials";
        obj.client_secret = this.clientSecret;
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(UserApiTokenRequest.prototype), json, {
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// ../../libs/auth/src/common/login-strategies/user-api-login.strategy.ts
var user_api_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



class UserApiLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new UserApiLoginStrategyData(), obj, {
            tokenRequest: UserApiTokenRequest.fromJSON(obj.tokenRequest),
        });
    }
}
class UserApiLoginStrategy extends LoginStrategy {
    constructor(data, keyConnectorService, ...sharedDeps) {
        super(...sharedDeps);
        this.keyConnectorService = keyConnectorService;
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
    }
    logIn(credentials) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new UserApiLoginStrategyData();
            data.tokenRequest = new UserApiTokenRequest(credentials.clientId, credentials.clientSecret, yield this.buildTwoFactor(), yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    setMasterKey(response, userId) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            if (response.apiUseKeyConnector) {
                const env = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.environmentService.environment$);
                const keyConnectorUrl = env.getKeyConnectorUrl();
                yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl, userId);
            }
        });
    }
    setUserKey(response, userId) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            if (response.key) {
                yield this.masterPasswordService.setMasterKeyEncryptedUserKey(response.key, userId);
            }
            if (response.apiUseKeyConnector) {
                const masterKey = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.masterPasswordService.masterKey$(userId));
                if (masterKey) {
                    const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey, userId);
                    yield this.keyService.setUserKey(userKey, userId);
                }
            }
        });
    }
    setPrivateKey(response, userId) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            yield this.keyService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    // Overridden to save client ID and secret to token service
    saveAccountInformation(tokenResponse) {
        const _super = Object.create(null, {
            saveAccountInformation: { get: () => super.saveAccountInformation }
        });
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            const userId = yield _super.saveAccountInformation.call(this, tokenResponse);
            const vaultTimeoutAction = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutActionByUserId$(userId));
            const vaultTimeout = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.getVaultTimeoutByUserId$(userId));
            const tokenRequest = this.cache.value.tokenRequest;
            yield this.tokenService.setClientId(tokenRequest.clientId, vaultTimeoutAction, vaultTimeout);
            yield this.tokenService.setClientSecret(tokenRequest.clientSecret, vaultTimeoutAction, vaultTimeout);
            return userId;
        });
    }
    exportCache() {
        return {
            userApiKey: this.cache.value,
        };
    }
}

;// ../../libs/common/src/auth/models/request/identity-token/webauthn-login-token.request.ts




class WebAuthnLoginTokenRequest extends TokenRequest {
    constructor(token, deviceResponse, device) {
        super(undefined, device);
        this.token = token;
        this.deviceResponse = deviceResponse;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "webauthn";
        obj.token = this.token;
        // must be a string b/c sending as form encoded data
        obj.deviceResponse = JSON.stringify(this.deviceResponse);
        return obj;
    }
    static fromJSON(json) {
        return Object.assign(Object.create(WebAuthnLoginTokenRequest.prototype), json, {
            deviceResponse: WebAuthnLoginAssertionResponseRequest.fromJSON(json.deviceResponse),
            device: json.device ? DeviceRequest.fromJSON(json.device) : undefined,
            twoFactor: json.twoFactor
                ? Object.assign(new TokenTwoFactorRequest(), json.twoFactor)
                : undefined,
        });
    }
}

;// ../../libs/auth/src/common/login-strategies/webauthn-login.strategy.ts
var webauthn_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore





class WebAuthnLoginStrategyData {
    static fromJSON(obj) {
        return Object.assign(new WebAuthnLoginStrategyData(), obj, {
            tokenRequest: WebAuthnLoginTokenRequest.fromJSON(obj.tokenRequest),
            credentials: WebAuthnLoginCredentials.fromJSON(obj.credentials),
        });
    }
}
class WebAuthnLoginStrategy extends LoginStrategy {
    constructor(data, ...sharedDeps) {
        super(...sharedDeps);
        this.cache = new external_rxjs_namespaceObject.BehaviorSubject(data);
    }
    logIn(credentials) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            const data = new WebAuthnLoginStrategyData();
            data.credentials = credentials;
            data.tokenRequest = new WebAuthnLoginTokenRequest(credentials.token, credentials.deviceResponse, yield this.buildDeviceRequest());
            this.cache.next(data);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    logInTwoFactor() {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            throw new Error("2FA not supported yet for WebAuthn Login.");
        });
    }
    setMasterKey(response, userId) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () { });
    }
    setUserKey(idTokenResponse, userId) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            const masterKeyEncryptedUserKey = idTokenResponse.key;
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.masterPasswordService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey, userId);
            }
            const userDecryptionOptions = idTokenResponse === null || idTokenResponse === void 0 ? void 0 : idTokenResponse.userDecryptionOptions;
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.webAuthnPrfOption) {
                const webAuthnPrfOption = (_a = idTokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.webAuthnPrfOption;
                const credentials = this.cache.value.credentials;
                // confirm we still have the prf key
                if (!credentials.prfKey) {
                    return;
                }
                // decrypt prf encrypted private key
                const privateKey = yield this.encryptService.unwrapDecapsulationKey(webAuthnPrfOption.encryptedPrivateKey, credentials.prfKey);
                // decrypt user key with private key
                const userKey = yield this.encryptService.decapsulateKeyUnsigned(new enc_string_EncString(webAuthnPrfOption.encryptedUserKey.encryptedString), privateKey);
                if (userKey) {
                    yield this.keyService.setUserKey(userKey, userId);
                }
            }
        });
    }
    setPrivateKey(response, userId) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            var _a;
            yield this.keyService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount(userId)), userId);
        });
    }
    exportCache() {
        return {
            webAuthn: this.cache.value,
        };
    }
}

;// ../../libs/auth/src/common/services/login-strategies/login-strategy.state.ts






/**
 * The current login strategy in use.
 */
const CURRENT_LOGIN_STRATEGY_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "currentLoginStrategy", {
    deserializer: (data) => data,
});
/**
 * The expiration date for the login strategy cache.
 * Used as a backup to the timer set on the service.
 */
const CACHE_EXPIRATION_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "loginStrategyCacheExpiration", {
    deserializer: (data) => (data ? null : new Date(data)),
});
/**
 * Auth Request notification for all instances of the login strategy service.
 * Note: this isn't an ideal approach, but allows both a background and
 * foreground instance to send out the notification.
 * TODO: Move to Auth Request service.
 */
const AUTH_REQUEST_PUSH_NOTIFICATION_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "authRequestPushNotification", {
    deserializer: (data) => data,
});
/**
 * A cache for login strategies to use for data persistence through
 * the login process.
 */
const CACHE_KEY = new KeyDefinition(LOGIN_STRATEGY_MEMORY, "loginStrategyCache", {
    deserializer: (data) => {
        if (data == null) {
            return null;
        }
        return {
            password: data.password ? PasswordLoginStrategyData.fromJSON(data.password) : undefined,
            sso: data.sso ? SsoLoginStrategyData.fromJSON(data.sso) : undefined,
            userApiKey: data.userApiKey
                ? UserApiLoginStrategyData.fromJSON(data.userApiKey)
                : undefined,
            authRequest: data.authRequest
                ? AuthRequestLoginStrategyData.fromJSON(data.authRequest)
                : undefined,
            webAuthn: data.webAuthn ? WebAuthnLoginStrategyData.fromJSON(data.webAuthn) : undefined,
        };
    },
});

;// ../../libs/auth/src/common/services/login-strategies/login-strategy.service.ts
var login_strategy_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












const sessionTimeoutLength = 5 * 60 * 1000; // 5 minutes
class LoginStrategyService {
    constructor(accountService, masterPasswordService, keyService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, keyConnectorService, environmentService, stateService, twoFactorService, i18nService, encryptService, passwordStrengthService, policyService, deviceTrustService, authRequestService, userDecryptionOptionsService, stateProvider, billingAccountProfileStateService, vaultTimeoutSettingsService, kdfConfigService, taskSchedulerService, configService) {
        this.accountService = accountService;
        this.masterPasswordService = masterPasswordService;
        this.keyService = keyService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.i18nService = i18nService;
        this.encryptService = encryptService;
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.deviceTrustService = deviceTrustService;
        this.authRequestService = authRequestService;
        this.userDecryptionOptionsService = userDecryptionOptionsService;
        this.stateProvider = stateProvider;
        this.billingAccountProfileStateService = billingAccountProfileStateService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.kdfConfigService = kdfConfigService;
        this.taskSchedulerService = taskSchedulerService;
        this.configService = configService;
        this.authenticationTimeoutSubject = new external_rxjs_namespaceObject.BehaviorSubject(false);
        this.authenticationSessionTimeout$ = this.authenticationTimeoutSubject.asObservable();
        this.currentAuthnTypeState = this.stateProvider.get(CURRENT_LOGIN_STRATEGY_KEY);
        this.loginStrategyCacheState = this.stateProvider.get(CACHE_KEY);
        this.loginStrategyCacheExpirationState = this.stateProvider.get(CACHE_EXPIRATION_KEY);
        this.authRequestPushNotificationState = this.stateProvider.get(AUTH_REQUEST_PUSH_NOTIFICATION_KEY);
        this.taskSchedulerService.registerTaskHandler(ScheduledTaskNames.loginStrategySessionTimeout, () => login_strategy_service_awaiter(this, void 0, void 0, function* () {
            this.authenticationTimeoutSubject.next(true);
            try {
                yield this.clearCache();
            }
            catch (e) {
                this.logService.error("Failed to clear cache during session timeout", e);
            }
        }));
        this.currentAuthType$ = this.currentAuthnTypeState.state$;
        this.loginStrategy$ = this.currentAuthnTypeState.state$.pipe((0,external_rxjs_namespaceObject.distinctUntilChanged)(), (0,external_rxjs_namespaceObject.combineLatestWith)(this.loginStrategyCacheState.state$), this.initializeLoginStrategy.bind(this), (0,external_rxjs_namespaceObject.shareReplay)({ refCount: true, bufferSize: 1 }));
    }
    getEmail() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy && "email$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.email$);
            }
            return null;
        });
    }
    getMasterPasswordHash() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy && "serverMasterKeyHash$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.serverMasterKeyHash$);
            }
            return null;
        });
    }
    getSsoEmail2FaSessionToken() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy && "ssoEmail2FaSessionToken$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.ssoEmail2FaSessionToken$);
            }
            return null;
        });
    }
    getAccessCode() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy && "accessCode$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.accessCode$);
            }
            return null;
        });
    }
    getAuthRequestId() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy && "authRequestId$" in strategy) {
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(strategy.authRequestId$);
            }
            return null;
        });
    }
    logIn(credentials) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearCache();
            this.authenticationTimeoutSubject.next(false);
            yield this.currentAuthnTypeState.update((_) => credentials.type);
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            // Note: We aren't passing the credentials directly to the strategy since they are
            // created in the popup and can cause DeadObject references on Firefox.
            // This is a shallow copy, but use deep copy in future if objects are added to credentials
            // that were created in popup.
            // If the popup uses its own instance of this service, this can be removed.
            const ownedCredentials = Object.assign({}, credentials);
            const result = yield (strategy === null || strategy === void 0 ? void 0 : strategy.logIn(ownedCredentials));
            if (result != null && !result.requiresTwoFactor && !result.requiresDeviceVerification) {
                yield this.clearCache();
            }
            else {
                // Cache the strategy data so we can attempt again later with 2fa or device verification
                yield this.loginStrategyCacheState.update((_) => { var _a; return (_a = strategy === null || strategy === void 0 ? void 0 : strategy.exportCache()) !== null && _a !== void 0 ? _a : null; });
                yield this.startSessionTimeout();
            }
            if (!result) {
                throw new Error("No auth result returned");
            }
            return result;
        });
    }
    logInTwoFactor(twoFactor) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            if (!(yield this.isSessionValid())) {
                throw new Error(this.i18nService.t("sessionTimeout"));
            }
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy == null) {
                throw new Error("No login strategy found.");
            }
            try {
                const result = yield strategy.logInTwoFactor(twoFactor);
                // Only clear cache if 2FA token has been accepted, otherwise we need to be able to try again
                if (result != null && !result.requiresTwoFactor) {
                    yield this.clearCache();
                }
                return result;
            }
            catch (e) {
                // API exceptions are okay, but if there are any unhandled client-side errors then clear cache to be safe
                if (!(e instanceof ErrorResponse)) {
                    yield this.clearCache();
                }
                throw e;
            }
        });
    }
    /**
     * Sends a token request to the server with the provided device verification OTP.
     * Returns an error if no session data is found or if the current login strategy does not support device verification.
     * @param deviceVerificationOtp The OTP to send to the server for device verification.
     * @returns The result of the token request.
     */
    logInNewDeviceVerification(deviceVerificationOtp) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            if (!(yield this.isSessionValid())) {
                throw new Error(this.i18nService.t("sessionTimeout"));
            }
            const strategy = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategy$);
            if (strategy == null) {
                throw new Error("No login strategy found.");
            }
            if (!("logInNewDeviceVerification" in strategy)) {
                throw new Error("Current login strategy does not support device verification.");
            }
            try {
                const result = yield strategy.logInNewDeviceVerification(deviceVerificationOtp);
                // Only clear cache if device verification succeeds
                if (result !== null && !result.requiresDeviceVerification) {
                    yield this.clearCache();
                }
                return result;
            }
            catch (e) {
                // Clear the cache if there is an unhandled client-side error
                if (!(e instanceof ErrorResponse)) {
                    yield this.clearCache();
                }
                throw e;
            }
        });
    }
    makePreloginKey(masterPassword, email) {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            email = email.trim().toLowerCase();
            let kdfConfig;
            try {
                const preloginResponse = yield this.apiService.postPrelogin(new PreloginRequest(email));
                if (preloginResponse != null) {
                    kdfConfig =
                        preloginResponse.kdf === kdf_type_enum_KdfType.PBKDF2_SHA256
                            ? new PBKDF2KdfConfig(preloginResponse.kdfIterations)
                            : new Argon2KdfConfig(preloginResponse.kdfIterations, preloginResponse.kdfMemory, preloginResponse.kdfParallelism);
                }
            }
            catch (e) {
                if (e == null || e.statusCode !== 404) {
                    throw e;
                }
            }
            if (!kdfConfig) {
                throw new Error("KDF config is required");
            }
            kdfConfig.validateKdfConfigForPrelogin();
            return yield this.keyService.makeMasterKey(masterPassword, email, kdfConfig);
        });
    }
    clearCache() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.currentAuthnTypeState.update((_) => null);
            yield this.loginStrategyCacheState.update((_) => null);
            this.authenticationTimeoutSubject.next(false);
            yield this.clearSessionTimeout();
        });
    }
    startSessionTimeout() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearSessionTimeout();
            // This Login Strategy Cache Expiration State value set here is used to clear the cache on re-init
            // of the application in the case where the timeout is terminated due to a closure of the application
            // window. The browser extension popup in particular is susceptible to this concern, as the user
            // is almost always likely to close the popup window before the session timeout is reached.
            yield this.loginStrategyCacheExpirationState.update((_) => new Date(Date.now() + sessionTimeoutLength));
            this.sessionTimeoutSubscription = this.taskSchedulerService.setTimeout(ScheduledTaskNames.loginStrategySessionTimeout, sessionTimeoutLength);
        });
    }
    clearSessionTimeout() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            var _a;
            yield this.loginStrategyCacheExpirationState.update((_) => null);
            (_a = this.sessionTimeoutSubscription) === null || _a === void 0 ? void 0 : _a.unsubscribe();
        });
    }
    isSessionValid() {
        return login_strategy_service_awaiter(this, void 0, void 0, function* () {
            const cache = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategyCacheState.state$);
            if (cache == null) {
                return false;
            }
            // If the Login Strategy Cache Expiration State value is less than the current
            // datetime stamp, then the cache is invalid and should be cleared.
            const expiration = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.loginStrategyCacheExpirationState.state$);
            if (expiration != null && expiration < new Date()) {
                yield this.clearCache();
                return false;
            }
            return true;
        });
    }
    initializeLoginStrategy(source) {
        const sharedDeps = [
            this.accountService,
            this.masterPasswordService,
            this.keyService,
            this.encryptService,
            this.apiService,
            this.tokenService,
            this.appIdService,
            this.platformUtilsService,
            this.messagingService,
            this.logService,
            this.stateService,
            this.twoFactorService,
            this.userDecryptionOptionsService,
            this.billingAccountProfileStateService,
            this.vaultTimeoutSettingsService,
            this.kdfConfigService,
            this.environmentService,
            this.configService,
        ];
        return source.pipe((0,external_rxjs_namespaceObject.map)(([strategy, data]) => {
            var _a, _b, _c, _d, _e;
            if (strategy == null) {
                return null;
            }
            switch (strategy) {
                case AuthenticationType.Password:
                    return new PasswordLoginStrategy((_a = data === null || data === void 0 ? void 0 : data.password) !== null && _a !== void 0 ? _a : new PasswordLoginStrategyData(), this.passwordStrengthService, this.policyService, this, ...sharedDeps);
                case AuthenticationType.Sso:
                    return new SsoLoginStrategy((_b = data === null || data === void 0 ? void 0 : data.sso) !== null && _b !== void 0 ? _b : new SsoLoginStrategyData(), this.keyConnectorService, this.deviceTrustService, this.authRequestService, this.i18nService, ...sharedDeps);
                case AuthenticationType.UserApiKey:
                    return new UserApiLoginStrategy((_c = data === null || data === void 0 ? void 0 : data.userApiKey) !== null && _c !== void 0 ? _c : new UserApiLoginStrategyData(), this.keyConnectorService, ...sharedDeps);
                case AuthenticationType.AuthRequest:
                    return new AuthRequestLoginStrategy((_d = data === null || data === void 0 ? void 0 : data.authRequest) !== null && _d !== void 0 ? _d : new AuthRequestLoginStrategyData(), this.deviceTrustService, ...sharedDeps);
                case AuthenticationType.WebAuthn:
                    return new WebAuthnLoginStrategy((_e = data === null || data === void 0 ? void 0 : data.webAuthn) !== null && _e !== void 0 ? _e : new WebAuthnLoginStrategyData(), ...sharedDeps);
            }
        }));
    }
}

;// ../../libs/auth/src/common/services/user-decryption-options/user-decryption-options.service.ts
var user_decryption_options_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore



const user_decryption_options_service_USER_DECRYPTION_OPTIONS = new UserKeyDefinition(USER_DECRYPTION_OPTIONS_DISK, "decryptionOptions", {
    deserializer: (decryptionOptions) => UserDecryptionOptions.fromJSON(decryptionOptions),
    clearOn: ["logout"],
});
class UserDecryptionOptionsService {
    constructor(stateProvider) {
        this.stateProvider = stateProvider;
        this.userDecryptionOptionsState = this.stateProvider.getActive(user_decryption_options_service_USER_DECRYPTION_OPTIONS);
        this.userDecryptionOptions$ = this.userDecryptionOptionsState.state$;
        this.hasMasterPassword$ = this.userDecryptionOptions$.pipe((0,external_rxjs_namespaceObject.map)((options) => { var _a; return (_a = options === null || options === void 0 ? void 0 : options.hasMasterPassword) !== null && _a !== void 0 ? _a : false; }));
    }
    userDecryptionOptionsById$(userId) {
        return this.stateProvider.getUser(userId, user_decryption_options_service_USER_DECRYPTION_OPTIONS).state$;
    }
    setUserDecryptionOptions(userDecryptionOptions) {
        return user_decryption_options_service_awaiter(this, void 0, void 0, function* () {
            yield this.userDecryptionOptionsState.update((_) => userDecryptionOptions);
        });
    }
}

;// ../../libs/common/src/auth/models/domain/admin-auth-req-storable.ts

class AdminAuthRequestStorable {
    constructor(init) {
        if (init) {
            Object.assign(this, init);
        }
    }
    toJSON() {
        return {
            id: this.id,
            privateKey: utils_Utils.fromBufferToByteString(this.privateKey),
        };
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        let privateKeyBuffer = null;
        if (obj.privateKey) {
            privateKeyBuffer = utils_Utils.fromByteStringToArray(obj.privateKey);
        }
        return new AdminAuthRequestStorable({
            id: obj.id,
            privateKey: privateKeyBuffer,
        });
    }
}

;// ../../libs/common/src/auth/models/request/passwordless-auth.request.ts
class PasswordlessAuthRequest {
    constructor(key, masterPasswordHash, deviceIdentifier, requestApproved) {
        this.key = key;
        this.masterPasswordHash = masterPasswordHash;
        this.deviceIdentifier = deviceIdentifier;
        this.requestApproved = requestApproved;
    }
}

;// ../../libs/common/src/auth/models/response/auth-request.response.ts

const RequestTimeOut = 60000 * 15; //15 Minutes
class AuthRequestResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.publicKey = this.getResponseProperty("PublicKey");
        this.requestDeviceType = this.getResponseProperty("RequestDeviceType");
        this.requestDeviceTypeValue = this.getResponseProperty("RequestDeviceTypeValue");
        this.requestDeviceIdentifier = this.getResponseProperty("RequestDeviceIdentifier");
        this.requestIpAddress = this.getResponseProperty("RequestIpAddress");
        this.requestCountryName = this.getResponseProperty("RequestCountryName");
        this.key = this.getResponseProperty("Key");
        this.masterPasswordHash = this.getResponseProperty("MasterPasswordHash");
        this.creationDate = this.getResponseProperty("CreationDate");
        this.requestApproved = this.getResponseProperty("RequestApproved");
        this.responseDate = this.getResponseProperty("ResponseDate");
        this.deviceId = this.getResponseProperty("RequestDeviceId");
        const requestDate = new Date(this.creationDate);
        const requestDateUTC = Date.UTC(requestDate.getUTCFullYear(), requestDate.getUTCMonth(), requestDate.getDate(), requestDate.getUTCHours(), requestDate.getUTCMinutes(), requestDate.getUTCSeconds(), requestDate.getUTCMilliseconds());
        const dateNow = new Date(Date.now());
        const dateNowUTC = Date.UTC(dateNow.getUTCFullYear(), dateNow.getUTCMonth(), dateNow.getDate(), dateNow.getUTCHours(), dateNow.getUTCMinutes(), dateNow.getUTCSeconds(), dateNow.getUTCMilliseconds());
        this.isExpired = dateNowUTC - requestDateUTC >= RequestTimeOut;
        this.isAnswered = this.requestApproved != null && this.responseDate != null;
    }
}

;// ../../libs/auth/src/common/services/auth-request/auth-request.service.ts
var auth_request_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore








/**
 * Disk-local to maintain consistency between tabs. We don't want to
 * clear this on logout since admin auth requests are long-lived.
 */
const auth_request_service_ADMIN_AUTH_REQUEST_KEY = new UserKeyDefinition(AUTH_REQUEST_DISK_LOCAL, "adminAuthRequest", {
    deserializer: (value) => value,
    clearOn: [],
});
class AuthRequestService {
    constructor(appIdService, masterPasswordService, keyService, encryptService, apiService, stateProvider, authRequestApiService) {
        this.appIdService = appIdService;
        this.masterPasswordService = masterPasswordService;
        this.keyService = keyService;
        this.encryptService = encryptService;
        this.apiService = apiService;
        this.stateProvider = stateProvider;
        this.authRequestApiService = authRequestApiService;
        this.authRequestPushNotificationSubject = new external_rxjs_namespaceObject.Subject();
        // Observable emission is used to trigger a toast in consuming components
        this.adminLoginApprovedSubject = new external_rxjs_namespaceObject.Subject();
        this.authRequestPushNotification$ = this.authRequestPushNotificationSubject.asObservable();
        this.adminLoginApproved$ = this.adminLoginApprovedSubject.asObservable();
    }
    getAdminAuthRequest(userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            const authRequestSerialized = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, auth_request_service_ADMIN_AUTH_REQUEST_KEY).state$);
            const adminAuthRequestStorable = AdminAuthRequestStorable.fromJSON(authRequestSerialized);
            return adminAuthRequestStorable;
        });
    }
    setAdminAuthRequest(authRequest, userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            if (authRequest == null) {
                throw new Error("Auth request is required");
            }
            yield this.stateProvider.setUserState(auth_request_service_ADMIN_AUTH_REQUEST_KEY, authRequest.toJSON(), userId);
        });
    }
    clearAdminAuthRequest(userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                throw new Error("User ID is required");
            }
            yield this.stateProvider.setUserState(auth_request_service_ADMIN_AUTH_REQUEST_KEY, null, userId);
        });
    }
    /**
     * @description Gets the list of all standard (not admin approval) pending AuthRequests.
     */
    getPendingAuthRequests$() {
        return (0,external_rxjs_namespaceObject.defer)(() => this.authRequestApiService.getPendingAuthRequests()).pipe((0,external_rxjs_namespaceObject.map)((authRequestResponses) => {
            return authRequestResponses.data.map((authRequestResponse) => {
                return new AuthRequestResponse(authRequestResponse);
            });
        }));
    }
    getLatestPendingAuthRequest$() {
        return this.getPendingAuthRequests$().pipe((0,external_rxjs_namespaceObject.map)((authRequests) => {
            if (authRequests.length === 0) {
                return null;
            }
            return authRequests.sort((a, b) => {
                const dateA = new Date(a.creationDate).getTime();
                const dateB = new Date(b.creationDate).getTime();
                return dateB - dateA; // Sort in descending order
            })[0];
        }));
    }
    approveOrDenyAuthRequest(approve, authRequest) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            if (!authRequest.id) {
                throw new Error("Auth request has no id");
            }
            if (!authRequest.publicKey) {
                throw new Error("Auth request has no public key");
            }
            const pubKey = utils_Utils.fromB64ToArray(authRequest.publicKey);
            const keyToEncrypt = yield this.keyService.getUserKey();
            const encryptedKey = yield this.encryptService.encapsulateKeyUnsigned(keyToEncrypt, pubKey);
            const response = new PasswordlessAuthRequest(encryptedKey.encryptedString, undefined, yield this.appIdService.getAppId(), approve);
            return yield this.apiService.putAuthRequest(authRequest.id, response);
        });
    }
    setUserKeyAfterDecryptingSharedUserKey(authReqResponse, authReqPrivateKey, userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.decryptPubKeyEncryptedUserKey(authReqResponse.key, authReqPrivateKey);
            yield this.keyService.setUserKey(userKey, userId);
        });
    }
    setKeysAfterDecryptingSharedMasterKeyAndHash(authReqResponse, authReqPrivateKey, userId) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const { masterKey, masterKeyHash } = yield this.decryptPubKeyEncryptedMasterKeyAndHash(authReqResponse.key, authReqResponse.masterPasswordHash, authReqPrivateKey);
            // Decrypt and set user key in state
            const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey, userId);
            // Set masterKey + masterKeyHash in state after decryption (in case decryption fails)
            yield this.masterPasswordService.setMasterKey(masterKey, userId);
            yield this.masterPasswordService.setMasterKeyHash(masterKeyHash, userId);
            yield this.keyService.setUserKey(userKey, userId);
        });
    }
    // Decryption helpers
    decryptPubKeyEncryptedUserKey(pubKeyEncryptedUserKey, privateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const decryptedUserKey = yield this.encryptService.decapsulateKeyUnsigned(new enc_string_EncString(pubKeyEncryptedUserKey), privateKey);
            return decryptedUserKey;
        });
    }
    decryptPubKeyEncryptedMasterKeyAndHash(pubKeyEncryptedMasterKey, pubKeyEncryptedMasterKeyHash, privateKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            const decryptedMasterKeyArrayBuffer = yield this.encryptService.rsaDecrypt(new enc_string_EncString(pubKeyEncryptedMasterKey), privateKey);
            const decryptedMasterKeyHashArrayBuffer = yield this.encryptService.rsaDecrypt(new enc_string_EncString(pubKeyEncryptedMasterKeyHash), privateKey);
            const masterKey = new SymmetricCryptoKey(decryptedMasterKeyArrayBuffer);
            const masterKeyHash = utils_Utils.fromBufferToUtf8(decryptedMasterKeyHashArrayBuffer);
            return {
                masterKey,
                masterKeyHash,
            };
        });
    }
    sendAuthRequestPushNotification(notification) {
        if (notification.id != null) {
            this.authRequestPushNotificationSubject.next(notification.id);
        }
    }
    getFingerprintPhrase(email, publicKey) {
        return auth_request_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.keyService.getFingerprint(email.toLowerCase(), publicKey)).join("-");
        });
    }
    emitAdminLoginApproved() {
        this.adminLoginApprovedSubject.next();
    }
}

;// ../../libs/common/src/models/response/list.response.ts

class ListResponse extends BaseResponse {
    constructor(response, t) {
        super(response);
        const data = this.getResponseProperty("Data");
        this.data = data == null ? [] : data.map((dr) => new t(dr));
        this.continuationToken = this.getResponseProperty("ContinuationToken");
    }
}

;// ../../libs/auth/src/common/services/auth-request/auth-request-api.service.ts
var auth_request_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class DefaultAuthRequestApiService {
    constructor(apiService, logService) {
        this.apiService = apiService;
        this.logService = logService;
    }
    getPendingAuthRequests() {
        return auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            const path = `/auth-requests/pending`;
            const r = yield this.apiService.send("GET", path, null, true, true);
            return new ListResponse(r, AuthRequestResponse);
        });
    }
    getAuthRequest(requestId) {
        return auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            try {
                const path = `/auth-requests/${requestId}`;
                const response = yield this.apiService.send("GET", path, null, true, true);
                return new AuthRequestResponse(response);
            }
            catch (e) {
                this.logService.error(e);
                throw e;
            }
        });
    }
    getAuthResponse(requestId, accessCode) {
        return auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            try {
                const path = `/auth-requests/${requestId}/response?code=${accessCode}`;
                const response = yield this.apiService.send("GET", path, null, false, true);
                return new AuthRequestResponse(response);
            }
            catch (e) {
                this.logService.error(e);
                throw e;
            }
        });
    }
    postAdminAuthRequest(request) {
        return auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield this.apiService.send("POST", "/auth-requests/admin-request", request, true, true);
                return new AuthRequestResponse(response);
            }
            catch (e) {
                this.logService.error(e);
                throw e;
            }
        });
    }
    postAuthRequest(request) {
        return auth_request_api_service_awaiter(this, void 0, void 0, function* () {
            try {
                // Submit the current device identifier in the header as well as in the POST body.
                // The value in the header will be used to build the request context and ensure that the resulting
                // server notifications have the current device as a source.
                const response = yield this.apiService.send("POST", "/auth-requests/", request, false, true, null, (headers) => {
                    headers.set("Device-Identifier", request.deviceIdentifier);
                });
                return new AuthRequestResponse(response);
            }
            catch (e) {
                this.logService.error(e);
                throw e;
            }
        });
    }
}

;// ../../libs/auth/src/common/services/accounts/lock.service.ts
var lock_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class LockService {
}
class DefaultLockService {
    constructor(accountService, vaultTimeoutService) {
        this.accountService = accountService;
        this.vaultTimeoutService = vaultTimeoutService;
    }
    lockAll() {
        return lock_service_awaiter(this, void 0, void 0, function* () {
            const accounts = yield firstValueFrom(combineLatest([this.accountService.activeAccount$, this.accountService.accounts$]).pipe(map(([activeAccount, accounts]) => {
                const otherAccounts = Object.keys(accounts);
                if (activeAccount == null) {
                    return { activeAccount: null, otherAccounts: otherAccounts };
                }
                return {
                    activeAccount: activeAccount.id,
                    otherAccounts: otherAccounts.filter((accountId) => accountId !== activeAccount.id),
                };
            })));
            for (const otherAccount of accounts.otherAccounts) {
                yield this.vaultTimeoutService.lock(otherAccount);
            }
            // Do the active account last in case we ever try to route the user on lock
            // that way this whole operation will be complete before that routing
            // could take place.
            if (accounts.activeAccount != null) {
                yield this.vaultTimeoutService.lock(accounts.activeAccount);
            }
        });
    }
}

;// ../../libs/auth/src/common/services/login-success-handler/default-login-success-handler.service.ts
var default_login_success_handler_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class DefaultLoginSuccessHandlerService {
    constructor(syncService, userAsymmetricKeysRegenerationService, loginEmailService) {
        this.syncService = syncService;
        this.userAsymmetricKeysRegenerationService = userAsymmetricKeysRegenerationService;
        this.loginEmailService = loginEmailService;
    }
    run(userId) {
        return default_login_success_handler_service_awaiter(this, void 0, void 0, function* () {
            yield this.syncService.fullSync(true, { skipTokenRefresh: true });
            yield this.userAsymmetricKeysRegenerationService.regenerateIfNeeded(userId);
            yield this.loginEmailService.clearLoginEmail();
        });
    }
}

;// ../../libs/auth/src/common/services/sso-redirect/sso-url.service.ts
const DESKTOP_SSO_CALLBACK = "bitwarden://sso-callback";
class SsoUrlService {
    /**
     * Builds a URL for redirecting users to the web app SSO component to complete SSO
     * @param webAppUrl The URL of the web app
     * @param clientType The client type that is initiating SSO, which will drive how the response is handled
     * @param redirectUri The redirect URI or callback that will receive the SSO code after authentication
     * @param state A state value that will be peristed through the SSO flow
     * @param codeChallenge A challenge value that will be used to verify the SSO code after authentication
     * @param email The optional email adddress of the user initiating SSO, which will be used to look up the org SSO identifier
     * @param orgSsoIdentifier The optional SSO identifier of the org that is initiating SSO
     * @returns The URL for redirecting users to the web app SSO component
     */
    buildSsoUrl(webAppUrl, clientType, redirectUri, state, codeChallenge, email, orgSsoIdentifier) {
        let url = webAppUrl +
            "/#/sso?clientId=" +
            clientType +
            "&redirectUri=" +
            encodeURIComponent(redirectUri) +
            "&state=" +
            state +
            "&codeChallenge=" +
            codeChallenge;
        if (email) {
            url += "&email=" + encodeURIComponent(email);
        }
        if (orgSsoIdentifier) {
            url += "&identifier=" + encodeURIComponent(orgSsoIdentifier);
        }
        return url;
    }
}

;// ../../libs/auth/src/common/services/logout/default-logout.service.ts
var default_logout_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class DefaultLogoutService {
    constructor(messagingService) {
        this.messagingService = messagingService;
    }
    logout(userId, logoutReason) {
        return default_logout_service_awaiter(this, void 0, void 0, function* () {
            this.messagingService.send("logout", { userId, logoutReason });
            return undefined;
        });
    }
}

;// ../../libs/auth/src/common/services/index.ts










;// ../../libs/auth/src/common/utilities/decode-jwt-token-to-json.utility.ts

function decodeJwtTokenToJson(jwtToken) {
    if (jwtToken == null) {
        throw new Error("JWT token not found");
    }
    const parts = jwtToken.split(".");
    if (parts.length !== 3) {
        throw new Error("JWT must have 3 parts");
    }
    // JWT has 3 parts: header, payload, signature separated by '.'
    // So, grab the payload to decode
    const encodedPayload = parts[1];
    let decodedPayloadJSON;
    try {
        // Attempt to decode from URL-safe Base64 to UTF-8
        decodedPayloadJSON = utils_Utils.fromUrlB64ToUtf8(encodedPayload);
        // FIXME: Remove when updating file. Eslint update
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
    }
    catch (decodingError) {
        throw new Error("Cannot decode the token");
    }
    try {
        // Attempt to parse the JSON payload
        const decodedToken = JSON.parse(decodedPayloadJSON);
        return decodedToken;
        // FIXME: Remove when updating file. Eslint update
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
    }
    catch (jsonError) {
        throw new Error("Cannot parse the token's payload into JSON");
    }
}

;// ../../libs/auth/src/common/utilities/index.ts


;// ../../libs/auth/src/common/login-strategies/index.ts


;// ../../libs/auth/src/common/index.ts
/**
 * This barrel file should only contain non-Angular exports
 */







;// ../../libs/common/src/auth/models/request/secret-verification.request.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore
class SecretVerificationRequest {
}

;// ../../libs/common/src/auth/models/request/password.request.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class PasswordRequest extends SecretVerificationRequest {
}

;// ../../libs/common/src/auth/models/request/two-factor-email.request.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class TwoFactorEmailRequest extends SecretVerificationRequest {
}

;// ../../libs/admin-console/src/common/organization-user/models/requests/organization-user-bulk.request.ts
class OrganizationUserBulkRequest {
    constructor(ids) {
        this.ids = ids == null ? [] : ids;
    }
}

;// ../../libs/common/src/admin-console/models/api/permissions.api.ts
// FIXME: Update this file to be type safe and remove this and next line
// @ts-strict-ignore

class PermissionsApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return this;
        }
        this.accessEventLogs = this.getResponseProperty("AccessEventLogs");
        this.accessImportExport = this.getResponseProperty("AccessImportExport");
        this.accessReports = this.getResponseProperty("AccessReports");
        this.createNewCollections = this.getResponseProperty("CreateNewCollections");
        this.editAnyCollection = this.getResponseProperty("EditAnyCollection");
        this.deleteAnyCollection = this.getResponseProperty("DeleteAnyCollection");
        this.manageCiphers = this.getResponseProperty("ManageCiphers");
        this.manageGroups = this.getResponseProperty("ManageGroups");
        this.manageSso = this.getResponseProperty("ManageSso");
        this.managePolicies = this.getResponseProperty("ManagePolicies");
        this.manageUsers = this.getResponseProperty("ManageUsers");
        this.manageResetPassword = this.getResponseProperty("ManageResetPassword");
        this.manageScim = this.getResponseProperty("ManageScim");
    }
}

;// ../../libs/common/src/admin-console/models/response/selection-read-only.response.ts

class SelectionReadOnlyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.readOnly = this.getResponseProperty("ReadOnly");
        this.hidePasswords = this.getResponseProperty("HidePasswords");
        this.manage = this.getResponseProperty("Manage");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user.response.ts



class OrganizationUserResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.collections = [];
        this.groups = [];
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.type = this.getResponseProperty("Type");
        this.status = this.getResponseProperty("Status");
        this.permissions = new PermissionsApi(this.getResponseProperty("Permissions"));
        this.externalId = this.getResponseProperty("ExternalId");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        const collections = this.getResponseProperty("Collections");
        if (collections != null) {
            this.collections = collections.map((c) => new SelectionReadOnlyResponse(c));
        }
        const groups = this.getResponseProperty("Groups");
        if (groups != null) {
            this.groups = groups;
        }
    }
}
class OrganizationUserUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        var _a, _b;
        super(response);
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.usesKeyConnector = (_a = this.getResponseProperty("UsesKeyConnector")) !== null && _a !== void 0 ? _a : false;
        this.managedByOrganization = (_b = this.getResponseProperty("ManagedByOrganization")) !== null && _b !== void 0 ? _b : false;
    }
}
class OrganizationUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        var _a;
        super(response);
        this.managedByOrganization = (_a = this.getResponseProperty("ManagedByOrganization")) !== null && _a !== void 0 ? _a : false;
        this.ssoExternalId = this.getResponseProperty("SsoExternalId");
    }
}
class OrganizationUserResetPasswordDetailsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.organizationUserId = this.getResponseProperty("OrganizationUserId");
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.resetPasswordKey = this.getResponseProperty("ResetPasswordKey");
        this.encryptedPrivateKey = this.getResponseProperty("EncryptedPrivateKey");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user-bulk.response.ts

class OrganizationUserBulkResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.error = this.getResponseProperty("Error");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user-bulk-public-key.response.ts

class OrganizationUserBulkPublicKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.key = this.getResponseProperty("Key");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/organization-user-mini.response.ts

class OrganizationUserUserMiniResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.email = this.getResponseProperty("Email");
        this.name = this.getResponseProperty("Name");
        this.type = this.getResponseProperty("Type");
        this.status = this.getResponseProperty("Status");
    }
}

;// ../../libs/admin-console/src/common/organization-user/models/responses/index.ts





;// ../../libs/admin-console/src/common/organization-user/services/default-organization-user-api.service.ts
var default_organization_user_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class DefaultOrganizationUserApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    getOrganizationUser(organizationId, id, options) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users/${id}?${params.toString()}`, null, true, true);
            return new OrganizationUserDetailsResponse(r);
        });
    }
    getAllUsers(organizationId, options) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeCollections) {
                params.set("includeCollections", "true");
            }
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users?${params.toString()}`, null, true, true);
            return new ListResponse(r, OrganizationUserUserDetailsResponse);
        });
    }
    getAllMiniUserDetails(organizationId) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users/mini-details`, null, true, true);
            return new ListResponse(r, OrganizationUserUserMiniResponse);
        });
    }
    getOrganizationUserResetPasswordDetails(organizationId, id) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/reset-password-details", null, true, true);
            return new OrganizationUserResetPasswordDetailsResponse(r);
        });
    }
    getManyOrganizationUserAccountRecoveryDetails(organizationId, ids) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/account-recovery-details", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserResetPasswordDetailsResponse);
        });
    }
    postOrganizationUserInvite(organizationId, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/invite", request, true, false);
    }
    postOrganizationUserReinvite(organizationId, id) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/reinvite", null, true, false);
    }
    postManyOrganizationUserReinvite(organizationId, ids) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/reinvite", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    postOrganizationUserAcceptInit(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept-init", request, true, false);
    }
    postOrganizationUserAccept(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept", request, true, false);
    }
    postOrganizationUserConfirm(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/confirm", request, true, false);
    }
    postOrganizationUsersPublicKey(organizationId, ids) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/public-keys", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkPublicKeyResponse);
        });
    }
    postOrganizationUserBulkConfirm(organizationId, request) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/confirm", request, true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    putOrganizationUserBulkEnableSecretsManager(organizationId, ids) {
        return default_organization_user_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/enable-secrets-manager", new OrganizationUserBulkRequest(ids), true, false);
        });
    }
    putOrganizationUser(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id, request, true, false);
    }
    putOrganizationUserResetPasswordEnrollment(organizationId, userId, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + userId + "/reset-password-enrollment", request, true, false);
    }
    putOrganizationUserResetPassword(organizationId, id, request) {
        return this.apiService.send("PUT", "/organiza