/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTxt;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

final class JsonMLConverter
extends JsonXmlConverter {
    private final TokenSet atts = new TokenSet();

    JsonMLConverter(JsonParserOptions opts) throws QueryException {
        super(opts);
    }

    @Override
    protected FNode finish() {
        return this.doc.add((FBuilder)this.stack.pop()).finish();
    }

    @Override
    protected void openObject() throws QueryException {
        if (this.curr == null || this.name != null || this.stack.peek() != null) {
            throw JsonMLConverter.error("No object allowed at this stage", new Object[0]);
        }
    }

    @Override
    protected void closeObject() {
        this.stack.pop();
        this.stack.push(this.curr);
        this.reset();
    }

    @Override
    protected void openPair(byte[] key, boolean add) throws QueryException {
        this.name = this.shared.token(JsonMLConverter.check(key));
        if (!this.atts.add(this.name)) {
            throw JsonMLConverter.error("Duplicate attribute found", new Object[0]);
        }
    }

    @Override
    protected void closePair(boolean add) {
    }

    @Override
    protected void openArray() throws QueryException {
        if (!this.stack.isEmpty()) {
            if (this.name == null && this.curr != null && this.stack.peek() == null) {
                this.stack.pop();
                this.stack.push(this.curr);
            } else if (this.name != null || this.curr != null || this.stack.peek() == null) {
                throw JsonMLConverter.error("No array allowed at this stage", new Object[0]);
            }
        }
        this.stack.push(null);
        this.reset();
    }

    @Override
    protected void closeArray() throws QueryException {
        FBuilder value = (FBuilder)this.stack.pop();
        if (value == null) {
            value = this.curr;
            this.reset();
        }
        if (value == null) {
            throw JsonMLConverter.error("Missing element name", new Object[0]);
        }
        if (this.stack.isEmpty()) {
            this.stack.push(value);
        } else {
            ((FBuilder)this.stack.peek()).add(value);
        }
    }

    @Override
    protected void openItem() {
    }

    @Override
    protected void closeItem() {
    }

    @Override
    void addValue(byte[] type, byte[] value) throws QueryException {
        if (this.name == null && this.curr != null && this.stack.peek() == null) {
            this.stack.pop();
            this.stack.push(this.curr);
            this.reset();
        }
        byte[] val = this.shared.token(value);
        if (this.curr == null) {
            FBuilder elem;
            FBuilder fBuilder = elem = this.stack.isEmpty() ? null : (FBuilder)this.stack.peek();
            if (elem == null) {
                this.curr = FElem.build(this.shared.qName(JsonMLConverter.check(val)));
            } else {
                elem.add(new FTxt(val));
            }
        } else if (this.name != null) {
            this.curr.add(this.shared.qName(this.name), val);
            this.name = null;
        } else {
            throw JsonMLConverter.error("No value allowed at this stage", new Object[0]);
        }
    }

    @Override
    protected void stringLit(byte[] value) throws QueryException {
        this.addValue(JsonConstants.STRING, value);
    }

    @Override
    protected void numberLit(byte[] value) throws QueryException {
        throw JsonMLConverter.error("No numbers allowed", new Object[0]);
    }

    @Override
    protected void nullLit() throws QueryException {
        throw JsonMLConverter.error("No 'null' allowed", new Object[0]);
    }

    @Override
    protected void booleanLit(byte[] value) throws QueryException {
        throw JsonMLConverter.error("No booleans allowed", new Object[0]);
    }

    private void reset() {
        this.curr = null;
        this.atts.clear();
    }

    private static QueryException error(String msg, Object ... ext) {
        return QueryError.JSON_PARSE_X.get(null, Util.info(msg, ext) + ".");
    }

    private static byte[] check(byte[] name) throws QueryException {
        if (!XMLToken.isNCName(name)) {
            throw JsonMLConverter.error("Invalid name: \"%\"", new Object[]{name});
        }
        return name;
    }
}

