/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.io.random.DataAccess;
import org.basex.util.Token;

final class FTList {
    private static final int[] NOINTS = new int[0];
    private final DataAccess dat;
    private final IOFile files;
    private final IOFile filed;
    private boolean wasted;
    private final IOFile sizes;
    private final int[] tp;
    private int ctl;
    private int ntl;
    private int ptok;
    private final DataAccess str;
    int size;
    byte[] token;
    int[] prv;
    int[] pov;

    FTList(Data data, int prefix) throws IOException {
        this.files = data.meta.dbFile("ftx" + prefix + "y");
        this.filed = data.meta.dbFile("ftx" + prefix + "z");
        this.str = new DataAccess(this.files);
        this.dat = new DataAccess(this.filed);
        this.tp = new int[data.meta.maxlen + 3];
        int tl = this.tp.length;
        for (int t = 0; t < tl; ++t) {
            this.tp[t] = -1;
        }
        this.sizes = data.meta.dbFile("ftx" + prefix + "x");
        try (DataAccess li = new DataAccess(this.sizes);){
            int is = li.readNum();
            while (--is >= 0) {
                int p = li.readNum();
                this.tp[p] = li.read4();
            }
            this.tp[tl - 1] = (int)this.str.length();
        }
        this.next();
    }

    void next() {
        if (this.wasted) {
            return;
        }
        this.token = this.token();
        if (this.token.length == 0) {
            this.wasted = true;
            this.prv = NOINTS;
            this.pov = NOINTS;
            this.close();
        } else {
            this.prv = new int[this.size];
            this.pov = new int[this.size];
            for (int j = 0; j < this.size; ++j) {
                this.prv[j] = this.dat.readNum();
                this.pov[j] = this.dat.readNum();
            }
        }
    }

    private void close() {
        this.str.close();
        this.dat.close();
        this.files.delete();
        this.filed.delete();
        this.sizes.delete();
    }

    private byte[] token() {
        if (this.tp[this.tp.length - 1] == this.ptok) {
            return Token.EMPTY;
        }
        if (this.tp[this.ntl] == this.ptok || this.ntl == 0) {
            do {
                ++this.ctl;
            } while (this.tp[this.ctl] == -1);
            this.ntl = this.ctl + 1;
            while (this.tp[this.ntl] == -1) {
                ++this.ntl;
            }
        }
        if (this.ctl == this.tp.length) {
            return Token.EMPTY;
        }
        byte[] t = this.str.readBytes(this.ptok, this.ctl);
        this.size = this.str.read4(this.str.cursor() + 5L);
        this.ptok = (int)this.str.cursor();
        return t;
    }
}

