/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.gui.view.map.MapAlgo;
import org.basex.gui.view.map.MapList;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;

final class SplitAlgo
extends MapAlgo {
    SplitAlgo() {
    }

    @Override
    MapRects calcMap(MapRect r, MapList ml, int ns, int ne) {
        return SplitAlgo.calcMap(r, ml, ns, ne, 1.0);
    }

    private static MapRects calcMap(MapRect r, MapList ml, int ns, int ne, double sw) {
        int hh;
        if (ne - ns == 0) {
            MapRects rects = new MapRects();
            rects.add(new MapRect(r, ml.get(ns)));
            return rects;
        }
        MapRects rects = new MapRects();
        int ni = ns - 1;
        double w = 0.0;
        while (ni < ne && !((w += ml.weight[++ni]) >= sw / 2.0) && ni != ne - 1) {
        }
        int xx = r.x;
        int yy = r.y;
        int ww = r.w > r.h ? (int)((double)r.w / sw * w) : r.w;
        int n = hh = r.w > r.h ? r.h : (int)((double)r.h / sw * w);
        if (ww > 0 && hh > 0 && w > 0.0) {
            rects.add(SplitAlgo.calcMap(new MapRect(xx, yy, ww, hh, 0, r.level), ml, ns, ni, w));
        }
        if (r.w > r.h) {
            xx += ww;
            ww = r.w - ww;
        } else {
            yy += hh;
            hh = r.h - hh;
        }
        if (ww > 0 && hh > 0 && sw - w > 0.0 && ni + 1 <= ne) {
            rects.add(SplitAlgo.calcMap(new MapRect(xx, yy, ww, hh, 0, r.level), ml, ni + 1, ne, sw - w));
        }
        return rects;
    }
}

