/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import org.basex.data.Data;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.layout.ResourceLeaf;
import org.basex.gui.layout.ResourceNode;
import org.basex.index.resource.ResourceType;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.TokenList;

public class ResourceFolder
extends ResourceNode {
    private static final Comparator<byte[]> CMP = (o1, o2) -> Prop.CASE ? Token.compare(o1, o2) : Token.compare(Token.lc(o1), Token.lc(o2));
    private boolean loaded;
    public static final int MAXC = 10000;

    public ResourceFolder(byte[] name, byte[] path, BaseXTree tree, Data data) {
        super(name, path, tree, data);
    }

    @Override
    void load() {
        if (this.loaded || this.updating) {
            return;
        }
        this.updating = true;
        int cmax = 10000;
        byte[] sub = this.subfolder();
        TokenObjectMap<ResourceType> set = this.data.resources.children(Token.string(sub), true);
        for (byte[] f : new TokenList(set).sort(Prop.CASE)) {
            this.add(new ResourceFolder(f, sub, this.tree, this.data));
            if (--cmax != 0) continue;
            break;
        }
        if ((cmax = this.addLeaves(Token.EMPTY, cmax, this)) <= 0) {
            this.add(new ResourceLeaf(Token.token("..."), sub, ResourceType.XML, true, this.tree, this.data));
        }
        this.loaded = true;
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this);
        this.updating = false;
    }

    public final int addLeaves(byte[] filter, int cmax, ResourceFolder target) {
        TokenObjectMap<ResourceType> map = this.data.resources.children(Token.string(this.subfolder()), false);
        ArrayList<byte[]> keys = new ArrayList<byte[]>(map.size());
        for (byte[] b : map) {
            if (filter.length != 0 && !Token.eq(b, filter)) continue;
            keys.add(b);
        }
        keys.sort(CMP);
        byte[] sub = this.subfolder();
        int k = 0;
        int m = cmax;
        int ks = keys.size();
        while (k < ks && m-- > 0) {
            byte[] nm = (byte[])keys.get(k++);
            target.add(new ResourceLeaf(nm, sub, map.get(nm), false, this.tree, this.data));
        }
        return m;
    }

    byte[] subfolder() {
        return Token.concat(this.path.length > 1 ? Token.concat(this.path, Token.cpToken(47)) : this.path, this.name);
    }

    public static byte[] name(byte[] path) {
        byte[][] s = Token.split(path, 47);
        if (s.length == 0) {
            return Token.EMPTY;
        }
        return s[s.length - 1];
    }

    public static byte[] path(byte[] path) {
        if (path.length == 0) {
            return path;
        }
        byte[] r = Token.substring(path, 0, Token.lastIndexOf(path, 47));
        return r.length == 0 ? Token.cpToken(47) : r;
    }

    public final void removeChildren() {
        this.removeAllChildren();
        this.loaded = false;
    }

    public final void reload() {
        this.removeChildren();
        this.load();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

