/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.util.HashSet;
import java.util.Set;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQMetaData;

public class XQMetaDataImpl
implements XQMetaData {
    private boolean readOnly = false;
    private String user = null;
    private boolean isClosed = false;
    private String productName = "XQJ Driver";
    private boolean XQXSupported = false;
    private boolean transactionSupported = true;
    private boolean staticTypingFeatureSupported = false;
    private boolean schemaImportFeatureSupported = false;
    private boolean schemaValidationFeatureSupported = false;
    private boolean fullAxisFeatureSupported = true;
    private boolean moduleFeatureSupported = true;
    private boolean serializationFeatureSupported = true;
    private boolean staticTypingExtensionsSupported = false;
    private int maxExpressionLength = 0;
    private int maxUserNameLength = 0;
    private boolean XQueryEncodingDeclSupported = false;
    private boolean userDefinedXMLSchemaTypeSupported = false;
    private XQConnection parentConnection = null;

    public XQMetaDataImpl(XQConnection parentConnection) {
        this.parentConnection = parentConnection;
    }

    public int getProductMajorVersion() throws XQException {
        this.checkClosed();
        return 1;
    }

    public int getProductMinorVersion() throws XQException {
        this.checkClosed();
        return 0;
    }

    public String getProductName() throws XQException {
        this.checkClosed();
        return this.productName;
    }

    public String getProductVersion() throws XQException {
        this.checkClosed();
        return this.getProductName() + "/" + 1 + "." + 0 + "-" + 0 + "-rc2";
    }

    public int getXQJMajorVersion() throws XQException {
        this.checkClosed();
        return 1;
    }

    public int getXQJMinorVersion() throws XQException {
        this.checkClosed();
        return 0;
    }

    public String getXQJVersion() throws XQException {
        this.checkClosed();
        return "XQJ 1.0";
    }

    public boolean isReadOnly() throws XQException {
        this.checkClosed();
        return this.readOnly;
    }

    public boolean isXQueryXSupported() throws XQException {
        this.checkClosed();
        return this.XQXSupported;
    }

    public boolean isTransactionSupported() throws XQException {
        this.checkClosed();
        return this.transactionSupported;
    }

    public boolean isStaticTypingFeatureSupported() throws XQException {
        this.checkClosed();
        return this.staticTypingFeatureSupported;
    }

    public boolean isSchemaImportFeatureSupported() throws XQException {
        this.checkClosed();
        return this.schemaImportFeatureSupported;
    }

    public boolean isSchemaValidationFeatureSupported() throws XQException {
        this.checkClosed();
        return this.schemaValidationFeatureSupported;
    }

    public boolean isFullAxisFeatureSupported() throws XQException {
        this.checkClosed();
        return this.fullAxisFeatureSupported;
    }

    public boolean isModuleFeatureSupported() throws XQException {
        this.checkClosed();
        return this.moduleFeatureSupported;
    }

    public boolean isSerializationFeatureSupported() throws XQException {
        this.checkClosed();
        return this.serializationFeatureSupported;
    }

    public boolean isStaticTypingExtensionsSupported() throws XQException {
        this.checkClosed();
        return this.staticTypingExtensionsSupported;
    }

    public String getUserName() throws XQException {
        this.checkClosed();
        return this.user;
    }

    public int getMaxExpressionLength() throws XQException {
        this.checkClosed();
        return this.maxExpressionLength;
    }

    public int getMaxUserNameLength() throws XQException {
        this.checkClosed();
        return this.maxUserNameLength;
    }

    public boolean wasCreatedFromJDBCConnection() throws XQException {
        this.checkClosed();
        return false;
    }

    public boolean isXQueryEncodingDeclSupported() throws XQException {
        this.checkClosed();
        return this.XQueryEncodingDeclSupported;
    }

    public Set getSupportedXQueryEncodings() throws XQException {
        this.checkClosed();
        HashSet<String> set = new HashSet<String>();
        set.add("UTF-8");
        set.add("UTF-16");
        return set;
    }

    public boolean isXQueryEncodingSupported(String encoding) throws XQException {
        this.checkClosed();
        return encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF-16");
    }

    public boolean isUserDefinedXMLSchemaTypeSupported() throws XQException {
        this.checkClosed();
        return this.userDefinedXMLSchemaTypeSupported;
    }

    public void checkClosed() throws XQException {
        if (this.parentConnection.isClosed()) {
            throw new XQException("Database Connection is closed.");
        }
    }

    public void setProductName(String prodName) {
        this.productName = prodName;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public void setXQueryXSupported(boolean b) {
        this.XQXSupported = b;
    }

    public void setTransactionSupported(boolean b) {
        this.transactionSupported = b;
    }

    public void setStaticTypingFeatureSupported(boolean b) {
        this.staticTypingFeatureSupported = b;
    }

    public void setSchemaImportFeatureSupported(boolean b) {
        this.schemaImportFeatureSupported = b;
    }

    public void setSchemaValidationFeatureSupported(boolean b) {
        this.schemaValidationFeatureSupported = b;
    }

    public void setFullAxisFeatureSupported(boolean b) {
        this.fullAxisFeatureSupported = b;
    }

    public void setModuleFeatureSupported(boolean b) {
        this.moduleFeatureSupported = b;
    }

    public void setSerializationFeatureSupported(boolean b) {
        this.serializationFeatureSupported = b;
    }

    public void setStaticTypingExtensionsSupported(boolean b) {
        this.staticTypingExtensionsSupported = b;
    }

    public void setUserName(String userId) {
        this.user = userId;
    }

    public void setMaxExpressionLength(int maxLength) {
        this.maxExpressionLength = maxLength;
    }

    public void setMaxUserNameLength(int maxLength) {
        this.maxUserNameLength = maxLength;
    }

    public void setXQueryEncodingDeclSupported(boolean b) {
        this.XQueryEncodingDeclSupported = b;
    }

    public void setUserDefinedXMLSchemaTypeSupported(boolean b) {
        this.userDefinedXMLSchemaTypeSupported = b;
    }
}

