# ===========================================================================
# File: default.tcl
# Target: mediawiki
#                        Created: 2010-08-29 09:51:41
#              Last modification: 2011-05-27 11:51:45
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# (c) Copyright: Bernard Desgraupes 2010-2011
# All rights reserved.
# Description: default settings for target mediawiki
# ===========================================================================

namespace eval mediawiki {
	variable aida_head
	
	# Prefix of index marks
	set aida_head(IndexMark)		"AIDAIDX"
	
	# Prefix of section marks
	set aida_head(SectionMark)		"AIDASEC"

	# Enable sections numbering
	set aida_head(NumberSections)	0
	set aida_head(SectionDepth)		4
	
	set aida_head(TocDepth)			4
	
	# The mediawiki engine builds a TOC automatically as soon as there are
	# more than three headers. It has two limitations:
	#    - one cannot control the depth
	#    - the sections are numbered (which causes duplicate numbering if
	#    NumberSections parameter is on)
	# If the NativeToc option is set to 0, aida builds its own toc instead
	# of the automatic one.
	set aida_head(NativeToc)		1

	# By default, enable the navigation bar in split files
	set aida_head(NavBar)			1

	# Define the extension of the split files in the navigation bar
	set aida_head(NavExtension)		""

}

