
#ifndef ITKFEM_EXPORT_H
#define ITKFEM_EXPORT_H

#ifdef ITK_STATIC
#  define ITKFEM_EXPORT
#  define ITKFEM_HIDDEN
#else
#  ifndef ITKFEM_EXPORT
#    ifdef ITKFEM_EXPORTS
        /* We are building this library */
#      define ITKFEM_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define ITKFEM_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef ITKFEM_HIDDEN
#    define ITKFEM_HIDDEN __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef ITKFEM_DEPRECATED
#  define ITKFEM_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef ITKFEM_DEPRECATED_EXPORT
#  define ITKFEM_DEPRECATED_EXPORT ITKFEM_EXPORT ITKFEM_DEPRECATED
#endif

#ifndef ITKFEM_DEPRECATED_NO_EXPORT
#  define ITKFEM_DEPRECATED_NO_EXPORT ITKFEM_HIDDEN ITKFEM_DEPRECATED
#endif

#define DEFINE_NO_DEPRECATED 0
#if DEFINE_NO_DEPRECATED
# define ITKFEM_NO_DEPRECATED
#endif

#endif
